/*
 * Decompiled with CFR 0.152.
 */
package com.novell.sql;

import com.novell.sql.Errors;
import com.novell.sql.LDAPSQLExceptionCodes;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;

class TypeChar
implements LDAPSQLExceptionCodes {
    TypeChar() {
    }

    protected static byte getByte(String string) throws SQLException {
        try {
            return Byte.parseByte(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw Errors.sqlException(25, string, "byte");
        }
    }

    protected static short getShort(String string) throws SQLException {
        try {
            return Short.parseShort(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw Errors.sqlException(25, string, "short");
        }
    }

    protected static int getInt(String string) throws SQLException {
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw Errors.sqlException(25, string, "int");
        }
    }

    protected static long getLong(String string) throws SQLException {
        try {
            return Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw Errors.sqlException(25, string, "long");
        }
    }

    protected static float getFloat(String string) throws SQLException {
        try {
            return Float.valueOf(string).floatValue();
        }
        catch (NumberFormatException numberFormatException) {
            throw Errors.sqlException(25, string, "float");
        }
    }

    protected static double getDouble(String string) throws SQLException {
        try {
            return Double.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw Errors.sqlException(25, string, "double");
        }
    }

    protected static BigDecimal getBigDecimal(String string) throws SQLException {
        return new BigDecimal(string);
    }

    protected static boolean getBoolean(String string) throws SQLException {
        if (string.equalsIgnoreCase("0")) {
            return false;
        }
        if (string.equalsIgnoreCase("1")) {
            return true;
        }
        throw Errors.sqlException(25, string, "boolean");
    }

    protected static String getString(String string) throws SQLException {
        return string;
    }

    protected static Object getObject(String string) throws SQLException {
        return string;
    }

    protected static Date getDate(String string) throws SQLException {
        try {
            return Date.valueOf(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw Errors.sqlException(25, string, "Date");
        }
    }

    protected static Time getTime(String string) throws SQLException {
        try {
            return Time.valueOf(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw Errors.sqlException(25, string, "Time");
        }
    }

    protected static Timestamp getTimestamp(String string) throws SQLException {
        try {
            return Timestamp.valueOf(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw Errors.sqlException(25, string, "Timestamp");
        }
    }

    protected static InputStream getAsciiStream(String string) throws SQLException {
        throw Errors.sqlException(9, "CHAR", "Ascii Stream");
    }

    protected static InputStream getUnicodeStream(String string) throws SQLException {
        throw Errors.sqlException(9, "CHAR", "Unicode Stream");
    }
}

