/*
 * Decompiled with CFR 0.152.
 */
package com.novell.sql;

import com.novell.sql.Errors;
import com.novell.sql.LDAPSQLExceptionCodes;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;

abstract class Value
implements LDAPSQLExceptionCodes {
    protected int m_javaType;

    protected Value(int n) {
        this.m_javaType = n;
    }

    protected int getType() {
        return this.m_javaType;
    }

    protected static String getTypeName(int n) {
        switch (n) {
            case -5: {
                return "BIGINT";
            }
            case -2: {
                return "BINARY";
            }
            case -7: {
                return "BIT";
            }
            case 1: {
                return "CHAR";
            }
            case 91: {
                return "DATE";
            }
            case 3: {
                return "DECIMAL";
            }
            case 8: {
                return "DOUBLE";
            }
            case 6: {
                return "FLOAT";
            }
            case 4: {
                return "INTEGER";
            }
            case -4: {
                return "LONGVARBINARY";
            }
            case -1: {
                return "LONGVARCHAR";
            }
            case 0: {
                return "NULL";
            }
            case 2: {
                return "NUMERIC";
            }
            case 1111: {
                return "OTHER";
            }
            case 7: {
                return "REAL";
            }
            case 5: {
                return "SMALLINT";
            }
            case 92: {
                return "TIME";
            }
            case 93: {
                return "TIMESTAMP";
            }
            case -6: {
                return "TINYINT";
            }
            case -3: {
                return "VARBINARY";
            }
            case 12: {
                return "VARCHAR";
            }
        }
        return "unknow type";
    }

    public Object getObject() throws SQLException {
        throw Errors.sqlException(9, Value.getTypeName(this.m_javaType), "Object");
    }

    public byte getByte() throws SQLException {
        throw Errors.sqlException(9, Value.getTypeName(this.m_javaType), "byte");
    }

    public short getShort() throws SQLException {
        throw Errors.sqlException(9, Value.getTypeName(this.m_javaType), "short");
    }

    public int getInt() throws SQLException {
        throw Errors.sqlException(9, Value.getTypeName(this.m_javaType), "int");
    }

    public long getLong() throws SQLException {
        throw Errors.sqlException(9, Value.getTypeName(this.m_javaType), "long");
    }

    public float getFloat() throws SQLException {
        throw Errors.sqlException(9, Value.getTypeName(this.m_javaType), "long");
    }

    public double getDouble() throws SQLException {
        throw Errors.sqlException(9, Value.getTypeName(this.m_javaType), "double");
    }

    public BigDecimal getBigDecimal() throws SQLException {
        throw Errors.sqlException(9, Value.getTypeName(this.m_javaType), "bigDecimal");
    }

    public boolean getBoolean() throws SQLException {
        throw Errors.sqlException(9, Value.getTypeName(this.m_javaType), "boolean");
    }

    public String getString() throws SQLException {
        throw Errors.sqlException(9, Value.getTypeName(this.m_javaType), "String");
    }

    public byte[] getBytes() throws SQLException {
        throw Errors.sqlException(9, Value.getTypeName(this.m_javaType), "byte array");
    }

    public Date getDate() throws SQLException {
        throw Errors.sqlException(9, Value.getTypeName(this.m_javaType), "Date");
    }

    public Time getTime() throws SQLException {
        throw Errors.sqlException(9, Value.getTypeName(this.m_javaType), "Time");
    }

    public Timestamp getTimestamp() throws SQLException {
        throw Errors.sqlException(9, Value.getTypeName(this.m_javaType), "Timestamp");
    }

    public InputStream getAsciiStream() throws SQLException {
        throw Errors.sqlException(9, Value.getTypeName(this.m_javaType), "Ascii stream");
    }

    public InputStream getUnicodeStream() throws SQLException {
        throw Errors.sqlException(9, Value.getTypeName(this.m_javaType), "Unicode stream");
    }

    public InputStream getBinaryStream() throws SQLException {
        throw Errors.sqlException(9, Value.getTypeName(this.m_javaType), "Binary stream");
    }

    public void setValue(byte by) throws SQLException {
        throw Errors.sqlException(23, Value.getTypeName(this.m_javaType), "byte");
    }

    public void setValue(short s) throws SQLException {
        throw Errors.sqlException(23, Value.getTypeName(this.m_javaType), "short");
    }

    public void setValue(int n) throws SQLException {
        throw Errors.sqlException(23, Value.getTypeName(this.m_javaType), "int");
    }

    public void setValue(long l) throws SQLException {
        throw Errors.sqlException(23, Value.getTypeName(this.m_javaType), "long");
    }

    public void setValue(float f) throws SQLException {
        throw Errors.sqlException(23, Value.getTypeName(this.m_javaType), "float");
    }

    public void setValue(double d) throws SQLException {
        throw Errors.sqlException(23, Value.getTypeName(this.m_javaType), "double");
    }

    public void setValue(BigDecimal bigDecimal) throws SQLException {
        throw Errors.sqlException(23, Value.getTypeName(this.m_javaType), "BigDecimal");
    }

    public void setValue(boolean bl) throws SQLException {
        throw Errors.sqlException(23, Value.getTypeName(this.m_javaType), "boolean");
    }

    public void setValue(String string) throws SQLException {
        throw Errors.sqlException(23, Value.getTypeName(this.m_javaType), "String");
    }

    public void setValue(byte[] byArray) throws SQLException {
        throw Errors.sqlException(23, Value.getTypeName(this.m_javaType), "byte array");
    }

    public void setValue(Date date) throws SQLException {
        throw Errors.sqlException(23, Value.getTypeName(this.m_javaType), "Date");
    }

    public void setValue(Time time) throws SQLException {
        throw Errors.sqlException(23, Value.getTypeName(this.m_javaType), "Time");
    }

    public void setValue(Timestamp timestamp) throws SQLException {
        throw Errors.sqlException(23, Value.getTypeName(this.m_javaType), "Timestamp");
    }

    public void setValue(Value value) throws SQLException {
        throw Errors.sqlException(23, Value.getTypeName(this.m_javaType), "Value");
    }

    public abstract int compare(Value var1) throws SQLException;

    public void negate() {
    }
}

