/*
 * Decompiled with CFR 0.152.
 */
package com.novell.sql;

import com.novell.sql.Errors;
import com.novell.sql.LDAPSQLExceptionCodes;
import com.novell.sql.Value;
import java.math.BigDecimal;
import java.sql.SQLException;

class ValueBit
extends Value
implements LDAPSQLExceptionCodes {
    byte m_value;

    ValueBit(int n) {
        super(-7);
        this.m_value = (byte)((byte)n & 1);
    }

    public void setValue(Value value) throws SQLException {
        this.m_value = (byte)(value.getByte() & 1);
    }

    public void negate() {
    }

    public int compare(Value value) throws SQLException {
        if (value.m_javaType != -7) {
            throw Errors.sqlException(22);
        }
        return this.m_value - ((ValueBit)value).m_value;
    }

    public byte getByte() throws SQLException {
        return this.m_value;
    }

    public short getShort() {
        return this.m_value;
    }

    public int getInt() {
        return this.m_value;
    }

    public long getLong() {
        return this.m_value;
    }

    public float getFloat() {
        return this.m_value;
    }

    public double getDouble() {
        return this.m_value;
    }

    public BigDecimal getBigDecimal() {
        return new BigDecimal((double)this.m_value);
    }

    public boolean getBoolean() {
        return this.m_value != 0;
    }

    public String getString() {
        return String.valueOf(this.m_value);
    }

    public Object getObject() {
        return new Byte(this.m_value);
    }
}

