/*
 * Decompiled with CFR 0.152.
 */
package com.novell.sql;

import com.novell.sql.ColumnInfo;
import com.novell.sql.DataAttributeFactory;
import com.novell.sql.Errors;
import com.novell.sql.LDAPSQLExceptionCodes;
import com.novell.sql.LdapIsam;
import java.sql.SQLException;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;

class AttributeInfo
implements LDAPSQLExceptionCodes {
    private static final String SYNTAX_BINARY = "1.3.6.1.4.1.1466.115.121.1.5";
    private static final String SYNTAX_PHOTO = "0.9.2342.19200300.100.1.7";
    private static final String SYNTAX_PERSONALSIGNATURE = "0.9.2342.19200300.100.1.53";
    private static final String SYNTAX_AUDIO = "0.9.2342.19200300.100.1.55";
    private static final String SYNTAX_JPEGPHOTO = "0.9.2342.19200300.100.1.60";
    private static final String SYNTAX_JAVASERIALIZEDDATA = "1.3.6.1.4.1.42.2.27.4.1.7";
    private static final String SYNTAX_THUMBNAILPHOTO = "2.16.128.113533.1.1400.1";
    private static final String SYNTAX_THUMBNAILLOGO = "2.16.128.113533.1.1400.2";
    private static final String SYNTAX_USERPASSWORD = "2.5.4.35";
    private static final String SYNTAX_USERCERTIFICATE = "2.5.4.36";
    private static final String SYNTAX_CACERTIFICATE = "2.5.4.37";
    private static final String SYNTAX_AUTHORITYREVOCATIONLIST = "2.5.4.38";
    private static final String SYNTAX_CERTIFICATEREVOCATIONLIST = "2.5.4.39";
    private static final String SYNTAX_CROSSCERTIFICATEPAIR = "2.5.4.40";
    private static final String SYNTAX_X500UNIQUEIDENTIFIER = "2.5.4.45";
    private static final String SYNTAX_OCTET_LIST = "2.16.840.1.113719.1.1.5.1.13";
    private static final String SYNTAX_INTEGER = "1.3.6.1.4.1.1466.115.121.1.27";
    private static final String SYNTAX_COUNTER = "2.16.840.1.113719.1.1.5.1.22";
    private static final String SYNTAX_GENERALIZEDTIME = "1.3.6.1.4.1.1466.115.121.1.24";
    private static final String SYNTAX_FACSIMILE_TELEPHONE_NUMBER = "1.3.6.1.4.1.1466.115.121.1.22";
    private static final String SYNTAX_TAGGED_DATA = "2.16.840.1.113719.1.1.5.1.12";
    private static final String SYNTAX_TAGGED_NAME_AND_STRING = "2.16.840.1.113719.1.1.5.1.15";
    private static final String SYNTAX_OBJECT_ACL = "2.16.840.1.113719.1.1.5.1.17";
    private static final String SYNTAX_POSTAL_ADDRESS = "1.3.6.1.4.1.1466.115.121.1.41";
    private static final String SYNTAX_TYPED_NAME = "2.16.840.1.113719.1.1.5.1.25";
    private static final String SYNTAX_UNKNOWN = "2.16.840.1.113719.1.1.5.1.0";
    private static final String SYNTAX_CASE_IGNORE_LIST = "2.16.840.1.113719.1.1.5.1.6";
    private static final String SYNTAX_TAGGED_STRING = "2.16.840.1.113719.1.1.5.1.14";
    private static final String SYNTAX_REPLICA_POINTER = "2.16.840.1.113719.1.1.5.1.16";
    private static final String SYNTAX_NDSTIMESTAMP = "2.16.840.1.113719.1.1.5.1.19";
    private static final String SYNTAX_TAGGED_NAME = "2.16.840.1.113719.1.1.5.1.23";
    String m_name;
    String m_ldapName;
    String m_oid;
    boolean m_bSingleValued;
    String m_syntaxOid;
    ColumnInfo[] m_columns;
    DataAttributeFactory m_factory;
    int m_syntaxSize;

    protected AttributeInfo(DirContext dirContext) throws SQLException {
        try {
            Attributes attributes = dirContext.getAttributes("");
            Attribute attribute = attributes.get("NAME");
            this.m_ldapName = attribute != null ? this.removeOptions((String)attribute.get()) : null;
            this.m_name = this.m_ldapName;
            attribute = attributes.get("NUMERICOID");
            this.m_oid = attribute != null ? (String)attribute.get() : null;
            attribute = attributes.get("SYNTAX");
            if (attribute != null) {
                this.m_syntaxOid = (String)attribute.get();
                int n = this.m_syntaxOid.indexOf(123);
                if (n != -1) {
                    int n2 = this.m_syntaxOid.indexOf(125, n + 1);
                    try {
                        this.m_syntaxSize = Integer.parseInt(this.m_syntaxOid.substring(n + 1, n2));
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.m_syntaxSize = 0;
                    }
                    this.m_syntaxOid = this.m_syntaxOid.substring(0, n);
                } else {
                    this.m_syntaxSize = 0;
                }
            } else {
                attribute = attributes.get("SUP");
                if (attribute != null) {
                    this.m_syntaxOid = (String)attribute.get();
                    int n = this.m_syntaxOid.indexOf(123);
                    if (n != -1) {
                        int n3 = this.m_syntaxOid.indexOf(125, n + 1);
                        try {
                            this.m_syntaxSize = Integer.parseInt(this.m_syntaxOid.substring(n + 1, n3));
                        }
                        catch (NumberFormatException numberFormatException) {
                            this.m_syntaxSize = 0;
                        }
                        this.m_syntaxOid = this.m_syntaxOid.substring(0, n);
                    } else {
                        this.m_syntaxSize = 0;
                    }
                } else {
                    this.m_syntaxOid = null;
                }
            }
            if (this.m_ldapName == null && this.m_oid != null) {
                this.m_name = this.m_ldapName = this.m_oid;
            }
            if (this.m_ldapName == null || this.m_syntaxOid == null || this.m_oid == null) {
                throw Errors.sqlException(16);
            }
            this.m_bSingleValued = null != attributes.get("SINGLE_VALUE");
        }
        catch (NamingException namingException) {
            throw Errors.NamingtoSQLException(namingException, 16);
        }
        this.getDataAttributeFactory();
        this.m_columns = this.m_factory.createColumnInfo(this);
    }

    protected AttributeInfo(String string, boolean bl, LdapIsam ldapIsam) {
        this.m_ldapName = null;
        this.m_name = string;
        this.m_bSingleValued = bl;
        this.m_oid = "";
        this.m_syntaxOid = "";
        this.getDataAttributeFactory();
        this.m_columns = this.m_factory.createColumnInfo(this);
    }

    protected AttributeInfo(AttributeInfo attributeInfo) throws SQLException {
        this.m_name = attributeInfo.m_name + "_s";
        this.m_ldapName = attributeInfo.m_ldapName;
        this.m_oid = attributeInfo.m_oid;
        this.m_bSingleValued = attributeInfo.m_bSingleValued;
        this.m_syntaxOid = attributeInfo.m_syntaxOid;
        this.m_syntaxSize = attributeInfo.m_syntaxSize;
        try {
            Class<?> clazz = Class.forName("com.novell.sql.DataAttr_String_S_Factory");
            this.m_factory = (DataAttributeFactory)clazz.newInstance();
            this.m_columns = this.m_factory.createColumnInfo(this);
        }
        catch (Exception exception) {
            this.m_factory = null;
        }
    }

    private String removeOptions(String string) {
        int n = string.indexOf(59);
        if (n != -1) {
            return string.substring(0, n);
        }
        return string;
    }

    protected void setFactoryInfo(Object object) {
        this.m_factory.setFactoryInfo(object);
    }

    public String getLdapName() {
        return this.m_ldapName;
    }

    public String getName() {
        return this.m_name;
    }

    public DataAttributeFactory getFactory() {
        return this.m_factory;
    }

    public int getSyntaxSize() {
        return this.m_syntaxSize;
    }

    public int getColumnCount() {
        return this.m_columns.length;
    }

    public ColumnInfo getColumnInfo(int n) {
        return this.m_columns[n];
    }

    protected boolean canConcatenateValues() {
        Class<?> clazz = this.m_factory.getClass();
        return clazz.getName().equals("com.novell.sql.DataAttr_String_Factory") && !this.m_bSingleValued;
    }

    public boolean isSingleValued() {
        return this.m_bSingleValued;
    }

    public void getDataAttributeFactory() {
        Class<?> clazz;
        String string = "com.novell.sql.DataAttr_" + this.m_name + "_Factory";
        try {
            clazz = Class.forName(string);
            this.m_factory = (DataAttributeFactory)clazz.newInstance();
        }
        catch (Throwable throwable) {
            this.m_factory = null;
        }
        if (this.m_factory == null) {
            try {
                string = this.m_syntaxOid.equals(SYNTAX_FACSIMILE_TELEPHONE_NUMBER) ? "com.novell.sql.DataAttr_FaxTelephoneNumber_Factory" : (this.m_syntaxOid.equals(SYNTAX_INTEGER) ? "com.novell.sql.DataAttr_Integer_Factory" : (this.m_syntaxOid.equals(SYNTAX_TAGGED_DATA) ? "com.novell.sql.DataAttr_TaggedData_Factory" : (this.m_syntaxOid.equals(SYNTAX_TAGGED_NAME_AND_STRING) ? "com.novell.sql.DataAttr_TaggedNameString_Factory" : (this.m_syntaxOid.equals(SYNTAX_OBJECT_ACL) ? "com.novell.sql.DataAttr_ObjectAcl_Factory" : (this.m_syntaxOid.equals(SYNTAX_POSTAL_ADDRESS) ? "com.novell.sql.DataAttr_PostalAddress_Factory" : (this.m_syntaxOid.equals(SYNTAX_BINARY) ? "com.novell.sql.DataAttr_Binary_Factory" : (this.m_syntaxOid.equals(SYNTAX_COUNTER) ? "com.novell.sql.DataAttr_Integer_Factory" : (this.m_syntaxOid.equals(SYNTAX_GENERALIZEDTIME) ? "com.novell.sql.DataAttr_NDSTime_Factory" : (this.m_syntaxOid.equals(SYNTAX_TYPED_NAME) ? "com.novell.sql.DataAttr_TypedName_Factory" : (this.m_syntaxOid.equals(SYNTAX_UNKNOWN) ? "com.novell.sql.DataAttr_Unknown_Factory" : (this.m_syntaxOid.equals(SYNTAX_CASE_IGNORE_LIST) ? "com.novell.sql.DataAttr_CaseIgnoreList_Factory" : (this.m_syntaxOid.equals(SYNTAX_OCTET_LIST) ? "com.novell.sql.DataAttr_OctetList_Factory" : (this.m_syntaxOid.equals(SYNTAX_TAGGED_STRING) ? "com.novell.sql.DataAttr_TaggedString_Factory" : (this.m_syntaxOid.equals(SYNTAX_REPLICA_POINTER) ? "com.novell.sql.DataAttr_ReplicatPointer_Factory" : (this.m_syntaxOid.equals(SYNTAX_NDSTIMESTAMP) ? "com.novell.sql.DataAttr_NDSTimestamp_Factory" : (this.m_syntaxOid.equals(SYNTAX_TAGGED_NAME) ? "com.novell.sql.DataAttr_TaggedName_Factory" : (this.m_syntaxOid.equals(SYNTAX_OCTET_LIST) || this.m_syntaxOid.equals(SYNTAX_BINARY) || this.m_syntaxOid.equals(SYNTAX_PHOTO) || this.m_syntaxOid.equals(SYNTAX_PERSONALSIGNATURE) || this.m_syntaxOid.equals(SYNTAX_AUDIO) || this.m_syntaxOid.equals(SYNTAX_JPEGPHOTO) || this.m_syntaxOid.equals(SYNTAX_JAVASERIALIZEDDATA) || this.m_syntaxOid.equals(SYNTAX_THUMBNAILPHOTO) || this.m_syntaxOid.equals(SYNTAX_THUMBNAILLOGO) || this.m_syntaxOid.equals(SYNTAX_USERPASSWORD) || this.m_syntaxOid.equals(SYNTAX_USERCERTIFICATE) || this.m_syntaxOid.equals(SYNTAX_CACERTIFICATE) || this.m_syntaxOid.equals(SYNTAX_AUTHORITYREVOCATIONLIST) || this.m_syntaxOid.equals(SYNTAX_CERTIFICATEREVOCATIONLIST) || this.m_syntaxOid.equals(SYNTAX_CROSSCERTIFICATEPAIR) || this.m_syntaxOid.equals(SYNTAX_X500UNIQUEIDENTIFIER) ? "com.novell.sql.DataAttr_Binary_Factory" : "com.novell.sql.DataAttr_String_Factory")))))))))))))))));
                clazz = Class.forName(string);
                this.m_factory = (DataAttributeFactory)clazz.newInstance();
            }
            catch (Throwable throwable) {
                this.m_factory = null;
            }
        }
        if (this.m_factory == null) {
            string = "com.novell.sql.DataAttr_String_Factory";
            try {
                clazz = Class.forName(string);
                this.m_factory = (DataAttributeFactory)clazz.newInstance();
            }
            catch (Throwable throwable) {
                this.m_factory = null;
            }
        }
    }
}

