/*
 * Decompiled with CFR 0.152.
 */
package com.novell.sql;

import com.novell.sql.BaseResultSet;
import com.novell.sql.Errors;
import com.novell.sql.LDAPSQLExceptionCodes;
import com.novell.sql.MetaDataResultSetColumnDef;
import com.novell.sql.MetaDataResultSetMetaData;
import com.novell.sql.SQLErrorCodes;
import com.novell.sql.Value;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Time;
import java.sql.Timestamp;

public abstract class BaseMetaDataResultSet
extends BaseResultSet
implements ResultSet,
LDAPSQLExceptionCodes,
SQLErrorCodes {
    private SQLWarning m_firstWarning = null;
    private SQLWarning m_lastWarning = null;
    private MetaDataResultSetColumnDef[] m_columns = this.getColumns();
    protected boolean m_wasNull;

    protected BaseMetaDataResultSet() {
    }

    public abstract MetaDataResultSetColumnDef[] getColumns();

    public int findColumn(String string) throws SQLException {
        if (this.m_columns == null) {
            throw Errors.sqlException(1021, string);
        }
        int n = 0;
        while (n < this.m_columns.length) {
            if (this.m_columns[n].name.equalsIgnoreCase(string)) {
                return this.m_columns[n].id;
            }
            ++n;
        }
        throw Errors.sqlException(1021, string);
    }

    public abstract boolean next() throws SQLException;

    public void close() throws SQLException {
    }

    public boolean wasNull() throws SQLException {
        return false;
    }

    protected abstract Value getColumnValue(int var1) throws SQLException;

    public String getString(int n) throws SQLException {
        Value value = this.getColumnValue(n);
        if (this.m_wasNull) {
            return null;
        }
        return value.getString();
    }

    public boolean getBoolean(int n) throws SQLException {
        Value value = this.getColumnValue(n);
        if (!this.m_wasNull) {
            return value.getBoolean();
        }
        return false;
    }

    public byte getByte(int n) throws SQLException {
        Value value = this.getColumnValue(n);
        if (!this.m_wasNull) {
            return value.getByte();
        }
        return 0;
    }

    public short getShort(int n) throws SQLException {
        Value value = this.getColumnValue(n);
        if (!this.m_wasNull) {
            return value.getShort();
        }
        return 0;
    }

    public int getInt(int n) throws SQLException {
        Value value = this.getColumnValue(n);
        if (!this.m_wasNull) {
            return value.getInt();
        }
        return 0;
    }

    public long getLong(int n) throws SQLException {
        Value value = this.getColumnValue(n);
        if (!this.m_wasNull) {
            return value.getLong();
        }
        return 0L;
    }

    public float getFloat(int n) throws SQLException {
        Value value = this.getColumnValue(n);
        if (!this.m_wasNull) {
            return value.getFloat();
        }
        return 0.0f;
    }

    public double getDouble(int n) throws SQLException {
        Value value = this.getColumnValue(n);
        if (!this.m_wasNull) {
            return value.getDouble();
        }
        return 0.0;
    }

    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        Value value = this.getColumnValue(n);
        if (!this.m_wasNull) {
            return value.getBigDecimal();
        }
        return null;
    }

    public Date getDate(int n) throws SQLException {
        Value value = this.getColumnValue(n);
        if (!this.m_wasNull) {
            return value.getDate();
        }
        return null;
    }

    public Time getTime(int n) throws SQLException {
        Value value = this.getColumnValue(n);
        if (!this.m_wasNull) {
            return value.getTime();
        }
        return null;
    }

    public Timestamp getTimestamp(int n) throws SQLException {
        Value value = this.getColumnValue(n);
        if (!this.m_wasNull) {
            return value.getTimestamp();
        }
        return null;
    }

    public InputStream getAsciiStream(int n) throws SQLException {
        Value value = this.getColumnValue(n);
        if (!this.m_wasNull) {
            return value.getAsciiStream();
        }
        return null;
    }

    public InputStream getUnicodeStream(int n) throws SQLException {
        Value value = this.getColumnValue(n);
        if (!this.m_wasNull) {
            return value.getUnicodeStream();
        }
        return null;
    }

    public String getString(String string) throws SQLException {
        return this.getString(this.findColumn(string));
    }

    public boolean getBoolean(String string) throws SQLException {
        return this.getBoolean(this.findColumn(string));
    }

    public byte getByte(String string) throws SQLException {
        return this.getByte(this.findColumn(string));
    }

    public short getShort(String string) throws SQLException {
        return this.getShort(this.findColumn(string));
    }

    public int getInt(String string) throws SQLException {
        return this.getInt(this.findColumn(string));
    }

    public long getLong(String string) throws SQLException {
        return this.getLong(this.findColumn(string));
    }

    public float getFloat(String string) throws SQLException {
        return this.getFloat(this.findColumn(string));
    }

    public double getDouble(String string) throws SQLException {
        return this.getDouble(this.findColumn(string));
    }

    public BigDecimal getBigDecimal(String string, int n) throws SQLException {
        return this.getBigDecimal(this.findColumn(string), n);
    }

    public byte[] getBytes(String string) throws SQLException {
        return this.getBytes(this.findColumn(string));
    }

    public Date getDate(String string) throws SQLException {
        return this.getDate(this.findColumn(string));
    }

    public Time getTime(String string) throws SQLException {
        return this.getTime(this.findColumn(string));
    }

    public Timestamp getTimestamp(String string) throws SQLException {
        return this.getTimestamp(this.findColumn(string));
    }

    public InputStream getAsciiStream(String string) throws SQLException {
        return this.getAsciiStream(this.findColumn(string));
    }

    public InputStream getUnicodeStream(String string) throws SQLException {
        return this.getUnicodeStream(this.findColumn(string));
    }

    public InputStream getBinaryStream(String string) throws SQLException {
        return this.getBinaryStream(this.findColumn(string));
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.m_firstWarning;
    }

    public void clearWarnings() throws SQLException {
        this.m_lastWarning = null;
        this.m_firstWarning = null;
    }

    public String getCursorName() throws SQLException {
        throw Errors.sqlException(1, "Positioned update");
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        return new MetaDataResultSetMetaData(this.m_columns);
    }

    public Object getObject(int n) throws SQLException {
        Value value = this.getColumnValue(n);
        if (!this.m_wasNull) {
            return value.getObject();
        }
        return null;
    }

    public Object getObject(String string) throws SQLException {
        return this.getObject(this.findColumn(string));
    }
}

