/*
 * Decompiled with CFR 0.152.
 */
package com.novell.sql;

import com.novell.sql.AttributeInfo;
import com.novell.sql.ColumnRef;
import com.novell.sql.DataAttribute;
import com.novell.sql.DataAttributeInfo;
import com.novell.sql.DataColumn;
import com.novell.sql.DataEntry;
import com.novell.sql.Errors;
import com.novell.sql.LDAPSQLExceptionCodes;
import com.novell.sql.LdapIsam;
import com.novell.sql.TableInfo;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Vector;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;

class DataTable
implements LDAPSQLExceptionCodes {
    String m_name;
    TableInfo m_tableInfo;
    Vector m_dataColumns;
    DataAttributeInfo[] m_dataAttrInfo;
    String[] m_attrNames;
    int m_dataAttrInfoCount;
    DataEntry m_dataEntriesHead;
    DataEntry m_dataEntriesTail;
    DataEntry m_currentEntry;
    int m_currentPosition;
    int m_rowCount;

    protected DataTable(String string, TableInfo tableInfo) {
        this.m_name = string;
        this.m_tableInfo = tableInfo;
        this.m_dataColumns = new Vector(10);
        this.m_dataAttrInfo = null;
        this.m_dataAttrInfoCount = 0;
        this.m_dataEntriesHead = null;
        this.m_dataEntriesTail = null;
        this.m_attrNames = null;
        this.m_currentEntry = null;
        this.m_rowCount = 0;
        this.m_currentPosition = -1;
    }

    protected void rewind() {
        this.m_currentEntry = null;
        this.m_currentPosition = -1;
    }

    protected DataEntry firstDataEntry() {
        return this.m_dataEntriesHead;
    }

    protected boolean nextRecord() {
        boolean bl = true;
        if (this.m_currentEntry == null) {
            this.m_currentEntry = this.m_dataEntriesHead;
            if (this.m_currentEntry == null) {
                bl = false;
            } else {
                this.m_currentEntry.resetRowCounters();
            }
        } else if (!this.m_currentEntry.incrementRowCounters()) {
            this.m_currentEntry = this.m_currentEntry.getNext();
            if (this.m_currentEntry == null) {
                bl = false;
            } else {
                this.m_currentEntry.resetRowCounters();
            }
        }
        this.m_currentPosition = bl ? ++this.m_currentPosition : -1;
        return bl;
    }

    protected Object getData(DataColumn dataColumn) {
        DataAttribute dataAttribute = this.m_currentEntry.getDataAttribute(dataColumn.getDataAttributeIndex());
        if (dataAttribute != null) {
            return dataAttribute.getData(dataColumn.getSplitIndex());
        }
        return null;
    }

    protected String getName() {
        return this.m_name;
    }

    public String getLDAPClass() {
        return this.m_tableInfo.getLDAPClass();
    }

    protected DataEntry getDataEntries() {
        return this.m_dataEntriesHead;
    }

    protected void addDataColumn(ColumnRef columnRef) {
        DataColumn dataColumn = new DataColumn(columnRef.getColumnInfo(), this.m_dataColumns.size());
        columnRef.setDataColumn(dataColumn);
        this.m_dataColumns.addElement(dataColumn);
    }

    protected void createDataAttributeInfo() {
        this.m_dataAttrInfo = new DataAttributeInfo[this.m_dataColumns.size()];
        this.m_dataAttrInfoCount = 0;
        Enumeration enumeration = this.m_dataColumns.elements();
        while (enumeration.hasMoreElements()) {
            DataColumn dataColumn = (DataColumn)enumeration.nextElement();
            AttributeInfo attributeInfo = dataColumn.getAttributeInfo();
            int n = 0;
            while (n < this.m_dataAttrInfoCount) {
                if (attributeInfo == this.m_dataAttrInfo[n].getAttributeInfo()) {
                    this.m_dataAttrInfo[n].incrementDataColumnCount();
                    break;
                }
                ++n;
            }
            if (n == this.m_dataAttrInfoCount) {
                this.m_dataAttrInfo[n] = new DataAttributeInfo(attributeInfo);
                ++this.m_dataAttrInfoCount;
            }
            dataColumn.setDataAttributeIndex(n);
        }
    }

    protected String[] getAttributeNames() {
        if (this.m_attrNames == null) {
            this.m_attrNames = new String[this.m_dataAttrInfoCount];
            int n = 0;
            while (n < this.m_dataAttrInfoCount) {
                this.m_attrNames[n] = this.m_dataAttrInfo[n].getLdapAttributeName();
                ++n;
            }
        }
        return this.m_attrNames;
    }

    protected void createDataEntries(LdapIsam ldapIsam) throws SQLException {
        if (this.getDataEntries() == null) {
            this.createDataAttributeInfo();
            this.m_rowCount = 0;
            SearchControls searchControls = new SearchControls();
            searchControls.setSearchScope(2);
            searchControls.setCountLimit(0L);
            String string = "objectClass=" + this.getLDAPClass();
            searchControls.setReturningAttributes(this.getAttributeNames());
            try {
                SearchResult searchResult;
                NamingEnumeration<SearchResult> namingEnumeration = ldapIsam.getBaseContext().search("", string, searchControls);
                if (namingEnumeration.hasMore()) {
                    searchResult = namingEnumeration.next();
                    this.m_dataEntriesHead = this.m_dataEntriesTail = new DataEntry(searchResult, this.m_dataAttrInfo, this.m_dataAttrInfoCount);
                    this.m_rowCount += this.m_dataEntriesTail.getRowCount();
                }
                while (namingEnumeration.hasMoreElements()) {
                    searchResult = namingEnumeration.next();
                    this.m_dataEntriesTail.setNext(new DataEntry(searchResult, this.m_dataAttrInfo, this.m_dataAttrInfoCount));
                    this.m_dataEntriesTail = this.m_dataEntriesTail.getNext();
                    this.m_rowCount += this.m_dataEntriesTail.getRowCount();
                }
            }
            catch (NamingException namingException) {
                throw Errors.NamingtoSQLException(namingException, 21);
            }
        }
    }

    protected int getDataColumnCount() {
        return this.m_dataColumns.size();
    }

    protected DataColumn getDataColumn(int n) {
        return (DataColumn)this.m_dataColumns.elementAt(n);
    }

    protected int getRowCount() {
        return this.m_rowCount;
    }

    public boolean position(int n) {
        this.m_currentPosition = n;
        for (DataEntry dataEntry = this.m_dataEntriesHead; dataEntry != null; dataEntry = dataEntry.getNext()) {
            int n2 = dataEntry.getRowCount();
            if (n >= n2) {
                n -= n2;
                continue;
            }
            dataEntry.setRowCounters(n);
            this.m_currentEntry = dataEntry;
            return true;
        }
        this.m_currentPosition = -1;
        return false;
    }

    public int getPosition() {
        return this.m_currentPosition;
    }

    public TableInfo getTableInfo() {
        return this.m_tableInfo;
    }

    private String createFilter(LdapIsam ldapIsam) {
        String string;
        String string2 = string = "(objectClass=" + this.getLDAPClass() + ")";
        return string2;
    }
}

