/*
 * Decompiled with CFR 0.152.
 */
package com.novell.sql;

import com.novell.sql.DRDBConstants;
import com.novell.sql.EmptyResultSet;
import com.novell.sql.Errors;
import com.novell.sql.Evaluate;
import com.novell.sql.ISAM;
import com.novell.sql.ISAMStatement;
import com.novell.sql.LDAPResultSet;
import com.novell.sql.LDAPSQLConnection;
import com.novell.sql.LDAPSQLExceptionCodes;
import com.novell.sql.Optimize;
import com.novell.sql.SQLErrorCodes;
import com.novell.sql.SQLNode;
import com.novell.sql.SQLNodeRoot;
import com.novell.sql.SQLNodeSelect;
import com.novell.sql.SQLNodeValues;
import com.novell.sql.SQLParser;
import com.novell.sql.Semantic;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;

public class LDAPStatement
implements Statement,
LDAPSQLExceptionCodes,
SQLErrorCodes,
DRDBConstants {
    private ISAM m_isam;
    private LDAPSQLConnection m_conn;
    private int m_errorCode;
    private String m_errorMsg;
    private boolean m_fISAMTransactionStarted;
    private SQLParser m_parser;
    private int m_rowCount;
    private ISAMStatement m_isamStatement;
    private boolean m_fDMLTransaction;
    private int m_statementType;
    private int m_statementSubtype;
    private int m_lastColumnRead;
    private int m_offset;

    protected LDAPStatement(ISAM iSAM, LDAPSQLConnection lDAPSQLConnection) {
        this.m_isam = iSAM;
        this.m_conn = lDAPSQLConnection;
        this.m_fISAMTransactionStarted = false;
        this.m_parser = null;
        this.m_errorMsg = "";
        this.m_rowCount = -1;
        this.m_isamStatement = null;
        this.m_statementType = 0;
        this.m_statementSubtype = 0;
    }

    protected SQLNodeRoot getRootNode() {
        if (this.m_parser != null) {
            return this.m_parser.getRootNode();
        }
        return null;
    }

    protected int getColumnCount() {
        int n;
        SQLNode sQLNode = this.getRootNode().sql;
        if (this.m_statementType == 8 || this.m_statementType == 0 && sQLNode.sqlNodeType == 4) {
            SQLNodeValues sQLNodeValues = ((SQLNodeSelect)sQLNode).Values;
            n = 0;
            while (sQLNodeValues != null) {
                ++n;
                sQLNodeValues = sQLNodeValues.Next;
            }
        } else {
            n = 0;
        }
        return n;
    }

    protected SQLNodeValues[] getColumns(int n) {
        SQLNodeValues[] sQLNodeValuesArray = new SQLNodeValues[n];
        SQLNode sQLNode = this.getRootNode().sql;
        if (this.m_statementType == 8 || this.m_statementType == 0 && sQLNode.sqlNodeType == 4) {
            SQLNodeValues sQLNodeValues = ((SQLNodeSelect)sQLNode).Values;
            int n2 = 0;
            while (sQLNodeValues != null && n2 < n) {
                sQLNodeValuesArray[n2] = sQLNodeValues;
                ++n2;
                sQLNodeValues = sQLNodeValues.Next;
            }
        }
        return sQLNodeValuesArray;
    }

    protected void setErrorMsg(String string) {
        this.m_errorMsg = string;
    }

    protected String getErrorMsg() {
        return this.m_errorMsg;
    }

    protected ISAMStatement getISAMStatement() {
        return this.m_isamStatement;
    }

    protected ISAM getISAM() {
        return this.m_isam;
    }

    protected int getLastColumnRead() {
        return this.m_lastColumnRead;
    }

    protected void setLastColumnRead(int n) {
        this.m_lastColumnRead = n;
    }

    protected int getType() {
        return this.m_statementType;
    }

    protected void setType(int n) {
        this.m_statementType = n;
    }

    protected int getSubtype() {
        return this.m_statementSubtype;
    }

    protected void setSubtype(int n) {
        this.m_statementSubtype = n;
    }

    protected int getErrorCode() {
        return this.m_errorCode;
    }

    protected void setErrorCode(int n) {
        this.m_errorCode = n;
    }

    protected int getOffset() {
        return this.m_offset;
    }

    protected void setOffset(int n) {
        this.m_offset = n;
    }

    protected int getRowCount() {
        return this.m_rowCount;
    }

    protected void setRowCount(int n) {
        this.m_rowCount = n;
    }

    public void setISAMTxnStarted(boolean bl) {
        this.m_fISAMTransactionStarted = bl;
    }

    public void setDMLTransaction(boolean bl) {
        this.m_fDMLTransaction = bl;
    }

    public ResultSet executeQuery(String string) throws SQLException {
        this.m_parser = new SQLParser(string, this.m_isam);
        this.m_errorCode = Semantic.SemanticCheck(this, this.m_parser.getRootNode(), false, false, null, null);
        if (this.m_errorCode != 0) {
            throw Errors.sqlException(this.m_errorCode, this.m_errorMsg);
        }
        this.m_errorCode = Optimize.Optimize(this, this.m_parser.getRootNode().sql, false);
        if (this.m_errorCode != 0) {
            throw Errors.sqlException(this.m_errorCode, this.m_errorMsg);
        }
        this.m_errorCode = Evaluate.ExecuteQuery(this, null);
        if (this.m_errorCode != 0) {
            throw Errors.sqlException(this.m_errorCode, this.m_errorMsg);
        }
        return new LDAPResultSet(this);
    }

    public int executeUpdate(String string) throws SQLException {
        throw Errors.sqlException(1, "LDAPStatement.executeUpdate()");
    }

    public void close() throws SQLException {
    }

    public int getMaxFieldSize() throws SQLException {
        throw Errors.sqlException(1, "LDAPStatement.getMaxFieldSize()");
    }

    public void setMaxFieldSize(int n) throws SQLException {
        throw Errors.sqlException(1, "LDAPStatement.setMaxFieldSize()");
    }

    public int getMaxRows() throws SQLException {
        return 0;
    }

    public void setMaxRows(int n) throws SQLException {
        throw Errors.sqlException(1, "LDAPStatement.setMaxRows()");
    }

    public void setEscapeProcessing(boolean bl) throws SQLException {
        throw Errors.sqlException(1, "LDAPStatement.setEscapeProcessing");
    }

    public int getQueryTimeout() throws SQLException {
        throw Errors.sqlException(1, "LDAPStatement.getQueryTimeout");
    }

    public void setQueryTimeout(int n) throws SQLException {
        throw Errors.sqlException(1, "LDAPStatement.setQueryTimeout()");
    }

    public void cancel() throws SQLException {
        throw Errors.sqlException(1, "LDAPStatement.cancel");
    }

    public SQLWarning getWarnings() throws SQLException {
        throw Errors.sqlException(1, "LDAPStatement.getWarnings()");
    }

    public void clearWarnings() throws SQLException {
        throw Errors.sqlException(1, "LDAPStatement.clearWarnings()");
    }

    public void setCursorName(String string) throws SQLException {
    }

    public boolean execute(String string) throws SQLException {
        throw Errors.sqlException(1, "Statement.execute()");
    }

    public ResultSet getResultSet() throws SQLException {
        throw Errors.sqlException(1, "LDAPStatement.getResultSet()");
    }

    public int getUpdateCount() throws SQLException {
        return -1;
    }

    public boolean getMoreResults() throws SQLException {
        throw Errors.sqlException(1, "Statement.getMoreResults()");
    }

    public void addBatch(String string) throws SQLException {
        throw Errors.sqlException(1, "LDAPStatement.addBatch()");
    }

    public void clearBatch() throws SQLException {
    }

    public boolean execute(String string, int n) throws SQLException {
        return this.execute(string);
    }

    public boolean execute(String string, int[] nArray) throws SQLException {
        return this.execute(string);
    }

    public boolean execute(String string, String[] stringArray) throws SQLException {
        return this.execute(string);
    }

    public int getResultSetHoldability() throws SQLException {
        throw Errors.sqlException(1, "LDAPStatement.getResultSetHoldability()");
    }

    public int[] executeBatch() throws SQLException {
        throw Errors.sqlException(1, "LDAPStatement.executeBatch()");
    }

    public int executeUpdate(String string, int n) throws SQLException {
        return this.executeUpdate(string);
    }

    public int executeUpdate(String string, int[] nArray) throws SQLException {
        return this.executeUpdate(string);
    }

    public int executeUpdate(String string, String[] stringArray) throws SQLException {
        return this.executeUpdate(string);
    }

    public Connection getConnection() throws SQLException {
        return this.m_conn;
    }

    public int getFetchDirection() throws SQLException {
        throw Errors.sqlException(1, "LDAPStatement.getFetchDirection()");
    }

    public int getFetchSize() throws SQLException {
        return 0;
    }

    public ResultSet getGeneratedKeys() throws SQLException {
        return new EmptyResultSet();
    }

    public boolean getMoreResults(int n) throws SQLException {
        throw Errors.sqlException(1, "LDAPStatement.getMoreResults()");
    }

    public int getResultSetConcurrency() throws SQLException {
        throw Errors.sqlException(1, "LDAPStatement.getMoreResults()");
    }

    public int getResultSetType() throws SQLException {
        return 1004;
    }

    public void setFetchDirection(int n) throws SQLException {
        throw Errors.sqlException(1, "LDAPStatement.setFetchDirection()");
    }

    public void setFetchSize(int n) throws SQLException {
        throw Errors.sqlException(1, "LDAPStatement.setFetchSize()");
    }
}

