/*
 * Decompiled with CFR 0.152.
 */
package com.novell.sql;

import com.novell.sql.DRDBConstants;
import com.novell.sql.ISAMColumnDef;
import com.novell.sql.IntRef;
import com.novell.sql.LDAPSQLExceptionCodes;
import com.novell.sql.LDAPStatement;
import com.novell.sql.NDSRestriction;
import com.novell.sql.SQLErrorCodes;
import com.novell.sql.SQLNode;
import com.novell.sql.SQLNodeBoolean;
import com.novell.sql.SQLNodeColumn;
import com.novell.sql.SQLNodeComparison;
import com.novell.sql.SQLNodeDelete;
import com.novell.sql.SQLNodeInsert;
import com.novell.sql.SQLNodeRef;
import com.novell.sql.SQLNodeSelect;
import com.novell.sql.SQLNodeSortColumns;
import com.novell.sql.SQLNodeString;
import com.novell.sql.SQLNodeTable;
import com.novell.sql.SQLNodeTables;
import com.novell.sql.SQLNodeUpdate;
import com.novell.sql.SQLNodeValues;

class Optimize
implements SQLErrorCodes,
LDAPSQLExceptionCodes,
DRDBConstants {
    Optimize() {
    }

    static int FindEffectiveRightsRestriction(boolean bl, SQLNodeTable sQLNodeTable, SQLNode sQLNode, SQLNode sQLNode2) {
        if (sQLNode == null) {
            return 0;
        }
        if (sQLNode.sqlNodeType == 16) {
            while (true) {
                int n;
                if ((n = ((SQLNodeBoolean)sQLNode).Operator) != 17 && n != 18) {
                    return 0;
                }
                if (!Optimize.FindNDSComparisonRestriction(bl, sQLNodeTable, ((SQLNodeBoolean)sQLNode).Left, sQLNode2, n)) {
                    return 0;
                }
                SQLNode sQLNode3 = ((SQLNodeBoolean)sQLNode).Right;
                if (sQLNode3.sqlNodeType != 16) {
                    Optimize.FindNDSComparisonRestriction(bl, sQLNodeTable, sQLNode3, sQLNode2, n);
                    return 0;
                }
                sQLNode = sQLNode3;
            }
        }
        if (sQLNode.sqlNodeType == 17) {
            Optimize.FindNDSComparisonRestriction(bl, sQLNodeTable, sQLNode, sQLNode2, 0);
        }
        return 0;
    }

    static boolean CheckBasicModel(SQLNode sQLNode) {
        if (sQLNode == null || sQLNode.sqlNodeType != 17) {
            return false;
        }
        SQLNodeComparison sQLNodeComparison = (SQLNodeComparison)sQLNode;
        if (sQLNodeComparison.Operator != 1) {
            return false;
        }
        SQLNode sQLNode2 = sQLNodeComparison.Left;
        if (sQLNode2.sqlNodeType != 21) {
            return false;
        }
        SQLNode sQLNode3 = sQLNodeComparison.Right;
        return sQLNode3.sqlNodeType == 24;
    }

    static boolean CheckModel(SQLNode sQLNode, int n) {
        if (n > 6) {
            return false;
        }
        if (sQLNode.sqlNodeType == 17) {
            return Optimize.CheckBasicModel(sQLNode);
        }
        if (sQLNode.sqlNodeType != 16) {
            return false;
        }
        if (((SQLNodeBoolean)sQLNode).Operator != 17) {
            return false;
        }
        if (!Optimize.CheckBasicModel(((SQLNodeBoolean)sQLNode).Left)) {
            return false;
        }
        return Optimize.CheckModel(((SQLNodeBoolean)sQLNode).Right, n + 1);
    }

    static SQLNode FindModel(SQLNode sQLNode, int n) {
        if (sQLNode == null) {
            return null;
        }
        if (sQLNode.sqlNodeType != 16) {
            return null;
        }
        if (((SQLNodeBoolean)sQLNode).Operator != 18) {
            return null;
        }
        if (n < 9) {
            return Optimize.FindModel(((SQLNodeBoolean)sQLNode).Right, n + 1);
        }
        if (!Optimize.CheckModel(((SQLNodeBoolean)sQLNode).Right, 1)) {
            return null;
        }
        return ((SQLNodeBoolean)sQLNode).Right;
    }

    static boolean CompareTree(SQLNode sQLNode, SQLNode sQLNode2) {
        if (sQLNode == null) {
            return false;
        }
        if (sQLNode.sqlNodeType != sQLNode2.sqlNodeType) {
            return false;
        }
        switch (sQLNode2.sqlNodeType) {
            case 16: {
                if (((SQLNodeBoolean)sQLNode).Operator != ((SQLNodeBoolean)sQLNode2).Operator) {
                    return false;
                }
                if (!Optimize.CompareTree(((SQLNodeBoolean)sQLNode).Left, ((SQLNodeBoolean)sQLNode2).Left)) {
                    return false;
                }
                if (Optimize.CompareTree(((SQLNodeBoolean)sQLNode).Right, ((SQLNodeBoolean)sQLNode2).Right)) break;
                return false;
            }
            case 17: {
                if (((SQLNodeComparison)sQLNode).Operator != ((SQLNodeComparison)sQLNode2).Operator) {
                    return false;
                }
                if (!Optimize.CompareTree(((SQLNodeComparison)sQLNode).Left, ((SQLNodeComparison)sQLNode2).Left)) {
                    return false;
                }
                if (Optimize.CompareTree(((SQLNodeComparison)sQLNode).Right, ((SQLNodeComparison)sQLNode2).Right)) break;
                return false;
            }
            case 21: {
                if (((SQLNodeColumn)sQLNode).Id == ((SQLNodeColumn)sQLNode2).Id) break;
                return false;
            }
            case 24: {
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    static boolean CheckMSAccessPredicate(SQLNode sQLNode) {
        SQLNode sQLNode2 = Optimize.FindModel(sQLNode, 1);
        if (sQLNode2 == null) {
            return false;
        }
        SQLNodeBoolean sQLNodeBoolean = (SQLNodeBoolean)sQLNode;
        int n = 1;
        while (n < 10) {
            if (!Optimize.CompareTree(sQLNodeBoolean.Left, sQLNode2)) {
                return false;
            }
            sQLNodeBoolean = (SQLNodeBoolean)sQLNodeBoolean.Right;
            ++n;
        }
        return true;
    }

    static boolean FindNDSComparisonRestriction(boolean bl, SQLNodeTable sQLNodeTable, SQLNode sQLNode, SQLNode sQLNode2, int n) {
        SQLNode sQLNode3;
        boolean bl2;
        if (sQLNode == null) {
            return false;
        }
        if (sQLNode.sqlNodeType != 17) {
            return false;
        }
        SQLNodeComparison sQLNodeComparison = (SQLNodeComparison)sQLNode;
        switch (sQLNodeComparison.Operator) {
            case 1: 
            case 7: 
            case 9: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 19: {
                return false;
            }
            default: {
                return false;
            }
        }
        SQLNode sQLNode4 = sQLNodeComparison.Left;
        if (sQLNode4.sqlNodeType != 21) {
            bl2 = true;
            sQLNode3 = sQLNode4;
            sQLNode4 = sQLNodeComparison.Right;
            if (sQLNode4.sqlNodeType != 21) {
                return false;
            }
        } else {
            bl2 = false;
            sQLNode3 = sQLNodeComparison.Right;
        }
        switch (sQLNode3.sqlNodeType) {
            case 10: 
            case 22: {
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                return false;
            }
            default: {
                return false;
            }
        }
        String string = ((SQLNodeColumn)sQLNode4).Column;
        if (bl ? !string.equals("ObjectName") && !string.equals("ObjectContext") && !string.equals("ObjectClass") && !string.equals("TrusteeName") && !string.equals("TrusteeContext") && !string.equals("TrusteeClass") && !string.equals("Attribute") : !string.equalsIgnoreCase("ObjectName") && !string.equalsIgnoreCase("ObjectContext") && !string.equalsIgnoreCase("ObjectClass") && !string.equalsIgnoreCase("TrusteeName") && !string.equalsIgnoreCase("TrusteeContext") && !string.equalsIgnoreCase("TrusteeClass") && !string.equalsIgnoreCase("Attribute")) {
            return false;
        }
        ISAMColumnDef iSAMColumnDef = sQLNodeTable.Handle.getColumnDef(((SQLNodeColumn)sQLNode4).Id);
        if (n == 17 && sQLNodeComparison.Operator == 1 && iSAMColumnDef.getRestrictions().size() != 0) {
            return false;
        }
        if (sQLNodeComparison.Operator == 7) {
            SQLNodeValues sQLNodeValues = (SQLNodeValues)sQLNode3;
            while (sQLNodeValues != null) {
                sQLNode3 = sQLNodeValues.Value;
                if (sQLNode3.sqlNodeType == 22) {
                    String string2 = ((SQLNodeString)sQLNode3).Value;
                    iSAMColumnDef.getRestrictions().addElement(new NDSRestriction(string, 1, sQLNode3.sqlNodeType, string2));
                }
                sQLNodeValues = sQLNodeValues.Next != null ? sQLNodeValues.Next : null;
            }
        } else {
            String string3 = ((SQLNodeString)sQLNode3).Value;
            iSAMColumnDef.getRestrictions().addElement(new NDSRestriction(string, sQLNodeComparison.Operator, sQLNode3.sqlNodeType, string3));
        }
        return true;
    }

    protected static int FindRestriction(LDAPStatement lDAPStatement, boolean bl, SQLNodeTable sQLNodeTable, SQLNode sQLNode, SQLNode sQLNode2, IntRef intRef, SQLNodeRef sQLNodeRef) {
        if (sQLNode == null) {
            return 0;
        }
        switch (sQLNode.sqlNodeType) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 30: 
            case 31: {
                return 1019;
            }
            case 16: {
                while (true) {
                    if (((SQLNodeBoolean)sQLNode).Operator != 17) {
                        return 0;
                    }
                    Optimize.FindRestriction(lDAPStatement, bl, sQLNodeTable, ((SQLNodeBoolean)sQLNode).Left, sQLNode2, intRef, sQLNodeRef);
                    SQLNode sQLNode3 = ((SQLNodeBoolean)sQLNode).Right;
                    if (sQLNode3.sqlNodeType != 16) {
                        Optimize.FindRestriction(lDAPStatement, bl, sQLNodeTable, ((SQLNodeBoolean)sQLNode).Right, sQLNode2, intRef, sQLNodeRef);
                        return 0;
                    }
                    sQLNode = sQLNode3;
                }
            }
            case 17: {
                String string;
                String string2;
                SQLNodeColumn sQLNodeColumn;
                SQLNode sQLNode4;
                boolean bl2;
                switch (((SQLNodeComparison)sQLNode).Operator) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        break;
                    }
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 19: {
                        return 0;
                    }
                    default: {
                        return 1019;
                    }
                }
                SQLNode sQLNode5 = ((SQLNodeComparison)sQLNode).Left;
                if (sQLNode5.sqlNodeType != 21) {
                    bl2 = true;
                    sQLNode4 = sQLNode5;
                    sQLNode5 = ((SQLNodeComparison)sQLNode).Right;
                    if (sQLNode5.sqlNodeType != 21) {
                        return 0;
                    }
                    sQLNodeColumn = (SQLNodeColumn)sQLNode5;
                } else {
                    sQLNodeColumn = (SQLNodeColumn)sQLNode5;
                    bl2 = false;
                    sQLNode4 = ((SQLNodeComparison)sQLNode).Right;
                    if (sQLNode4.sqlNodeType == 21) {
                        return 0;
                    }
                    if (sQLNode4.sqlNodeType == 21) {
                        if (sQLNode2.sqlNodeType != 4) {
                            return 0;
                        }
                        SQLNodeTables sQLNodeTables = ((SQLNodeSelect)sQLNode2).Tables;
                        string2 = sQLNodeTable.Alias;
                        string = ((SQLNodeColumn)sQLNode4).Tablealias;
                        if (bl) {
                            if (string2.equals(string)) {
                                bl2 = true;
                                sQLNode4 = sQLNodeColumn;
                                sQLNodeColumn = (SQLNodeColumn)((SQLNodeComparison)sQLNode).Right;
                            }
                        } else if (string2.equalsIgnoreCase(string)) {
                            bl2 = true;
                            sQLNode4 = sQLNodeColumn;
                            sQLNodeColumn = (SQLNodeColumn)((SQLNodeComparison)sQLNode).Right;
                        }
                        boolean bl3 = true;
                        while (true) {
                            SQLNodeTable sQLNodeTable2 = sQLNodeTables.Table;
                            string2 = sQLNodeTable2.Alias;
                            string = sQLNodeColumn.Tablealias;
                            if (bl) {
                                if (string2.equals(string)) {
                                    bl3 = false;
                                }
                            } else if (string2.equalsIgnoreCase(string)) {
                                bl3 = false;
                            }
                            string = ((SQLNodeColumn)sQLNode4).Tablealias;
                            if (bl) {
                                if (string2.equals(string)) {
                                    if (bl3) break;
                                    return 0;
                                }
                            } else if (string2.equalsIgnoreCase(string)) {
                                if (bl3) break;
                                return 0;
                            }
                            if (sQLNodeTables.Next == null) break;
                            sQLNodeTables = sQLNodeTables.Next;
                        }
                    }
                }
                switch (sQLNode4.sqlNodeType) {
                    case 2: 
                    case 3: {
                        return 1019;
                    }
                    case 4: {
                        return 0;
                    }
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 13: 
                    case 14: 
                    case 15: 
                    case 16: 
                    case 17: 
                    case 30: 
                    case 31: {
                        return 1019;
                    }
                    case 18: 
                    case 19: 
                    case 32: {
                        return 0;
                    }
                    case 20: {
                        return 1019;
                    }
                    case 21: 
                    case 22: 
                    case 23: 
                    case 24: 
                    case 25: 
                    case 26: 
                    case 27: 
                    case 28: 
                    case 29: {
                        break;
                    }
                    default: {
                        return 1019;
                    }
                }
                string2 = sQLNodeTable.Alias;
                string = sQLNodeColumn.Tablealias;
                if (bl ? !string2.equals(string) : !string2.equalsIgnoreCase(string)) {
                    return 0;
                }
                if (bl2) {
                    SQLNode sQLNode6 = ((SQLNodeComparison)sQLNode).Left;
                    ((SQLNodeComparison)sQLNode).Left = ((SQLNodeComparison)sQLNode).Right;
                    ((SQLNodeComparison)sQLNode).Right = sQLNode6;
                    switch (((SQLNodeComparison)sQLNode).Operator) {
                        case 1: 
                        case 2: {
                            break;
                        }
                        case 3: {
                            ((SQLNodeComparison)sQLNode).Operator = 5;
                            break;
                        }
                        case 4: {
                            ((SQLNodeComparison)sQLNode).Operator = 6;
                            break;
                        }
                        case 5: {
                            ((SQLNodeComparison)sQLNode).Operator = 3;
                            break;
                        }
                        case 6: {
                            ((SQLNodeComparison)sQLNode).Operator = 4;
                            break;
                        }
                        default: {
                            return 1019;
                        }
                    }
                }
                ((SQLNodeComparison)sQLNode).fSelectivity = sQLNodeTable.Handle.getColumnDef(sQLNodeColumn.Id).getSelectivity();
                SQLNodeComparison sQLNodeComparison = null;
                SQLNodeComparison sQLNodeComparison2 = (SQLNodeComparison)sQLNodeRef.node;
                while (sQLNodeComparison2 != null) {
                    if (sQLNodeComparison2.fSelectivity < ((SQLNodeComparison)sQLNode).fSelectivity) break;
                    sQLNodeComparison = sQLNodeComparison2;
                    sQLNodeComparison2 = sQLNodeComparison2.NextRestrict;
                }
                ((SQLNodeComparison)sQLNode).NextRestrict = sQLNodeComparison2;
                if (sQLNodeComparison != null) {
                    sQLNodeComparison.NextRestrict = (SQLNodeComparison)sQLNode;
                } else {
                    sQLNodeRef.node = sQLNode;
                }
                ++intRef.value;
                return 0;
            }
        }
        return 1019;
    }

    static int Optimize(LDAPStatement lDAPStatement, SQLNode sQLNode, boolean bl) {
        String string;
        SQLNodeTable sQLNodeTable;
        SQLNodeTables sQLNodeTables;
        SQLNode sQLNode2 = null;
        if (sQLNode == null) {
            return 0;
        }
        SQLNodeTables sQLNodeTables2 = null;
        SQLNodeTable sQLNodeTable2 = null;
        block0 : switch (sQLNode.sqlNodeType) {
            case 2: {
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                int n = Optimize.Optimize(lDAPStatement, ((SQLNodeSelect)sQLNode).Tables, bl);
                if (n != 0) {
                    return n;
                }
                n = Optimize.Optimize(lDAPStatement, ((SQLNodeSelect)sQLNode).Predicate, bl);
                if (n != 0) {
                    return n;
                }
                n = Optimize.Optimize(lDAPStatement, ((SQLNodeSelect)sQLNode).Having, bl);
                if (n != 0) {
                    return n;
                }
                sQLNodeTables2 = ((SQLNodeSelect)sQLNode).Tables;
                sQLNodeTable2 = sQLNodeTables2.Table;
                sQLNode2 = ((SQLNodeSelect)sQLNode).Predicate;
                break;
            }
            case 5: {
                int n = Optimize.Optimize(lDAPStatement, ((SQLNodeInsert)sQLNode).Values, bl);
                if (n == 0) break;
                return n;
            }
            case 6: {
                int n = Optimize.Optimize(lDAPStatement, ((SQLNodeDelete)sQLNode).Predicate, bl);
                if (n != 0) {
                    return n;
                }
                sQLNodeTables2 = null;
                sQLNodeTable2 = ((SQLNodeDelete)sQLNode).Table;
                sQLNode2 = ((SQLNodeDelete)sQLNode).Predicate;
                break;
            }
            case 7: {
                int n = Optimize.Optimize(lDAPStatement, ((SQLNodeUpdate)sQLNode).Predicate, bl);
                if (n != 0) {
                    return n;
                }
                sQLNodeTables2 = null;
                sQLNodeTable2 = ((SQLNodeUpdate)sQLNode).Table;
                sQLNode2 = ((SQLNodeUpdate)sQLNode).Predicate;
                break;
            }
            case 30: {
                break;
            }
            case 31: {
                break;
            }
            case 8: {
                break;
            }
            case 9: {
                int n = Optimize.Optimize(lDAPStatement, ((SQLNodeTables)sQLNode).Table, bl);
                if (n != 0) {
                    return n;
                }
                n = Optimize.Optimize(lDAPStatement, ((SQLNodeTables)sQLNode).Next, bl);
                if (n == 0) break;
                return n;
            }
            case 10: {
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                return 1019;
            }
            case 16: {
                int n;
                while (true) {
                    if ((n = Optimize.Optimize(lDAPStatement, ((SQLNodeBoolean)sQLNode).Left, bl)) != 0) {
                        return n;
                    }
                    if (((SQLNodeBoolean)sQLNode).Right == null) break block0;
                    if (((SQLNodeBoolean)sQLNode).Right.sqlNodeType != 16) {
                        n = Optimize.Optimize(lDAPStatement, ((SQLNodeBoolean)sQLNode).Right, bl);
                        if (n == 0) break block0;
                        return n;
                    }
                    sQLNode = ((SQLNodeBoolean)sQLNode).Right;
                }
            }
            case 17: {
                int n;
                if (!(((SQLNodeComparison)sQLNode).Operator == 19 ? (n = Optimize.Optimize(lDAPStatement, ((SQLNodeComparison)sQLNode).Left, bl)) != 0 : ((SQLNodeComparison)sQLNode).SelectModifier != 0 && (n = Optimize.Optimize(lDAPStatement, ((SQLNodeComparison)sQLNode).Right, bl)) != 0)) break;
                return n;
            }
            case 18: 
            case 19: 
            case 32: {
                return 1019;
            }
            case 20: {
                int n = Optimize.Optimize(lDAPStatement, ((SQLNodeTable)sQLNode).OuterJoinPredicate, bl);
                if (n == 0) break;
                return n;
            }
            default: {
                return 1019;
            }
        }
        if (sQLNode.sqlNodeType == 4) {
            SQLNodeSortColumns sQLNodeSortColumns = ((SQLNodeSelect)sQLNode).Sortcolumns;
            int n = 0;
            while (sQLNodeSortColumns != null && ((SQLNodeSelect)sQLNode).Groupbycolumns == null && !((SQLNodeSelect)sQLNode).ImplicitGroupby && !((SQLNodeSelect)sQLNode).Distinct) {
                SQLNodeColumn sQLNodeColumn = sQLNodeSortColumns.Column;
                if (sQLNodeColumn.sqlNodeType != 21) break;
                String string2 = sQLNodeColumn.Tablealias;
                sQLNodeTables = sQLNodeTables2;
                sQLNodeTable = sQLNodeTable2;
                while (true) {
                    string = sQLNodeTable.Alias;
                    if (!bl ? string.equalsIgnoreCase(string2) : string.equals(string2)) break;
                    if (sQLNodeTables == null) {
                        return 1019;
                    }
                    if (sQLNodeTables.Next == null) {
                        return 1019;
                    }
                    sQLNodeTables = sQLNodeTables.Next;
                    sQLNodeTable = sQLNodeTables.Table;
                }
                if (sQLNodeTable.OuterJoinPredicate != null) break;
                if (sQLNodeTable.Sortsequence == 0) {
                    sQLNodeTable.Sortsequence = ++n;
                    sQLNodeTable.Sortcount = 1;
                    sQLNodeTable.Sortcolumns = sQLNodeSortColumns;
                } else {
                    if (sQLNodeTable.Sortsequence != n) break;
                    ++sQLNodeTable.Sortcount;
                }
                sQLNodeSortColumns = sQLNodeSortColumns.Next;
            }
            if (sQLNodeSortColumns == null && ((SQLNodeSelect)sQLNode).Groupbycolumns == null && !((SQLNodeSelect)sQLNode).ImplicitGroupby && !((SQLNodeSelect)sQLNode).Distinct) {
                int n2 = 0;
                while (n2 < n) {
                    SQLNodeTables sQLNodeTables3 = ((SQLNodeSelect)sQLNode).Tables;
                    sQLNodeTables = sQLNodeTables2;
                    sQLNodeTable = sQLNodeTable2;
                    SQLNodeTables sQLNodeTables4 = null;
                    while (sQLNodeTable.Sortsequence != n2 + 1) {
                        if (sQLNodeTables == null) {
                            return 1019;
                        }
                        if (sQLNodeTables.Next == null) {
                            return 1019;
                        }
                        sQLNodeTables4 = sQLNodeTables;
                        sQLNodeTables3 = sQLNodeTables.Next;
                        sQLNodeTables = sQLNodeTables.Next;
                        sQLNodeTable = sQLNodeTables.Table;
                    }
                    if (sQLNodeTables4 == null) {
                        ((SQLNodeSelect)sQLNode).Tables = sQLNodeTables.Next;
                    } else {
                        sQLNodeTables4.Next = sQLNodeTables.Next;
                    }
                    sQLNodeTables4 = null;
                    int n3 = 0;
                    while (n3 < n2) {
                        sQLNodeTables4 = sQLNodeTables4 == null ? ((SQLNodeSelect)sQLNode).Tables : sQLNodeTables4.Next;
                        ++n3;
                    }
                    if (sQLNodeTables4 == null) {
                        sQLNodeTables.Next = ((SQLNodeSelect)sQLNode).Tables;
                        ((SQLNodeSelect)sQLNode).Tables = sQLNodeTables3;
                    } else {
                        sQLNodeTables.Next = sQLNodeTables4.Next;
                        sQLNodeTables4.Next = sQLNodeTables3;
                    }
                    sQLNodeTables2 = ((SQLNodeSelect)sQLNode).Tables;
                    sQLNodeTable2 = sQLNodeTables2.Table;
                    ++n2;
                }
                ((SQLNodeSelect)sQLNode).fPushdownSort = true;
            } else {
                sQLNodeTables = sQLNodeTables2;
                sQLNodeTable = sQLNodeTable2;
                while (true) {
                    sQLNodeTable.Sortsequence = 0;
                    sQLNodeTable.Sortcount = 0;
                    sQLNodeTable.Sortcolumns = null;
                    if (sQLNodeTables == null || sQLNodeTables.Next == null) break;
                    sQLNodeTables = sQLNodeTables.Next;
                    sQLNodeTable = sQLNodeTables.Table;
                }
            }
        }
        sQLNodeTables = sQLNodeTables2;
        sQLNodeTable = sQLNodeTable2;
        while (sQLNodeTable != null) {
            sQLNodeTable.cRestrict = 0;
            sQLNodeTable.Restrict = null;
            IntRef intRef = new IntRef();
            SQLNodeRef sQLNodeRef = new SQLNodeRef();
            if (sQLNodeTable.OuterJoinPredicate == null) {
                Optimize.FindRestriction(lDAPStatement, bl, sQLNodeTable, sQLNode2, sQLNode, intRef, sQLNodeRef);
                sQLNodeTable.cRestrict = intRef.value;
                sQLNodeTable.Restrict = (SQLNodeComparison)sQLNodeRef.node;
                string = sQLNodeTable.Alias;
                if (bl) {
                    if (string.equals("EffectiveRights")) {
                        Optimize.FindEffectiveRightsRestriction(bl, sQLNodeTable, sQLNode2, sQLNode);
                    }
                } else if (string.equalsIgnoreCase("EffectiveRights")) {
                    Optimize.FindEffectiveRightsRestriction(bl, sQLNodeTable, sQLNode2, sQLNode);
                }
            } else {
                Optimize.FindRestriction(lDAPStatement, bl, sQLNodeTable, sQLNodeTable.OuterJoinPredicate, sQLNode, intRef, sQLNodeRef);
                sQLNodeTable.cRestrict = intRef.value;
                sQLNodeTable.Restrict = (SQLNodeComparison)sQLNodeRef.node;
            }
            if (sQLNodeTables == null || sQLNodeTables.Next == null) break;
            sQLNodeTables = sQLNodeTables.Next;
            sQLNodeTable = sQLNodeTables.Table;
        }
        if (sQLNode.sqlNodeType == 4 && !((SQLNodeSelect)sQLNode).Distinct && sQLNodeTables2.Next == null && ((SQLNodeSelect)sQLNode).Groupbycolumns == null && ((SQLNodeSelect)sQLNode).Having == null && ((SQLNodeSelect)sQLNode).Sortcolumns == null && lDAPStatement.getRootNode().sql == sQLNode && Optimize.CheckMSAccessPredicate(((SQLNodeSelect)sQLNode).Predicate)) {
            ((SQLNodeSelect)sQLNode).fMSAccess = true;
        }
        return 0;
    }
}

