/*
 * Decompiled with CFR 0.152.
 */
package com.novell.sql;

import com.novell.sql.BCD;
import com.novell.sql.BooleanRef;
import com.novell.sql.DRDBConstants;
import com.novell.sql.DoubleRef;
import com.novell.sql.Errors;
import com.novell.sql.ISAM;
import com.novell.sql.IntRef;
import com.novell.sql.LDAPSQLExceptionCodes;
import com.novell.sql.NotConvertableException;
import com.novell.sql.SQLErrorCodes;
import com.novell.sql.SQLNode;
import com.novell.sql.SQLNodeAggregate;
import com.novell.sql.SQLNodeAlgebraic;
import com.novell.sql.SQLNodeBoolean;
import com.novell.sql.SQLNodeColumn;
import com.novell.sql.SQLNodeComparison;
import com.novell.sql.SQLNodeDate;
import com.novell.sql.SQLNodeGroupByColumns;
import com.novell.sql.SQLNodeNull;
import com.novell.sql.SQLNodeNumeric;
import com.novell.sql.SQLNodeParameter;
import com.novell.sql.SQLNodeRef;
import com.novell.sql.SQLNodeRoot;
import com.novell.sql.SQLNodeScalar;
import com.novell.sql.SQLNodeSelect;
import com.novell.sql.SQLNodeSortColumns;
import com.novell.sql.SQLNodeString;
import com.novell.sql.SQLNodeTable;
import com.novell.sql.SQLNodeTables;
import com.novell.sql.SQLNodeTime;
import com.novell.sql.SQLNodeTimestamp;
import com.novell.sql.SQLNodeUser;
import com.novell.sql.SQLNodeValues;
import com.novell.sql.StringRef;
import com.novell.sql.ValueDouble;
import com.novell.sql.ValueInteger;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;

class SQLParser
implements SQLErrorCodes,
LDAPSQLExceptionCodes,
DRDBConstants {
    private static final int TOKEN_TYPE_NONE = 0;
    private static final int TOKEN_TYPE_SYMBOL = 1;
    private static final int TOKEN_TYPE_NUMBER = 2;
    private static final int TOKEN_TYPE_STRING = 3;
    private static final int TOKEN_TYPE_IDENTIFIER = 4;
    private static final int TOKEN_TYPE_KEYWORD = 5;
    private static final int TOKEN_TYPE_ESCAPE = 6;
    private static final int MAX_TOKEN_SIZE = 255;
    private static final int MAX_SUB_QUERY = 10;
    private static final int TIME_STRING_LENGTH = 8;
    private static final int DATE_STRING_LENGTH = 10;
    private static final int TIMESTAMP_STRING_LENGTH = 19;
    private static String[] s_keyWords = new String[]{"ALL", "AND", "ANY", "AS", "ASC", "AVG", "BY", "COUNT", "CREATE", "DELETE", "DESC", "DISTINCT", "DROP", "EXISTS", "FROM", "GROUP", "HAVING", "IN", "INDEX", "INSERT", "INTO", "IS", "JOIN", "LEFT", "LIKE", "MAX", "MIN", "NOT", "NULL", "ON", "OR", "ORDER", "OUTER", "SELECT", "SET", "SQL", "SUM", "TABLE", "UNIQUE", "UPDATE", "USER", "VALUES", "WHERE"};
    String m_sql;
    String m_errorMsg;
    SQLNodeRoot m_parseTree;
    char[] m_sqlBuf;
    String m_currentToken;
    int m_idxSqlStr;
    int m_cntSqlStr;
    int m_tokenType;
    int m_SubSelectCount;
    SQLNodeSelect[] m_selectNodeSub;

    SQLParser(String string, ISAM iSAM) throws SQLException {
        this.m_sql = string;
        this.m_errorMsg = "";
        this.m_sqlBuf = new char[string.length()];
        string.getChars(0, string.length(), this.m_sqlBuf, 0);
        this.m_currentToken = null;
        this.m_idxSqlStr = 0;
        this.m_SubSelectCount = 0;
        this.m_selectNodeSub = new SQLNodeSelect[10];
        this.m_cntSqlStr = string.length();
        this.m_tokenType = 0;
        int n = this.GetKeyword(null);
        if (n != 0) {
            throw Errors.sqlException(n, this.m_errorMsg);
        }
        this.m_parseTree = new SQLNodeRoot();
        if (this.m_currentToken.equalsIgnoreCase("create") || this.m_currentToken.equalsIgnoreCase("drop") || this.m_currentToken.equalsIgnoreCase("insert") || this.m_currentToken.equalsIgnoreCase("delete") || this.m_currentToken.equalsIgnoreCase("update")) {
            throw Errors.sqlException(1, this.m_currentToken);
        }
        if (this.m_currentToken.equalsIgnoreCase("select")) {
            SQLNodeRef sQLNodeRef = new SQLNodeRef();
            n = this.ParseSelect(sQLNodeRef);
            if (n != 0) {
                throw Errors.sqlException(n, this.m_errorMsg);
            }
            this.m_parseTree.sql = sQLNodeRef.node;
            SQLNodeRef sQLNodeRef2 = new SQLNodeRef();
            n = this.ParseOrderby(sQLNodeRef2);
            if (sQLNodeRef2.node != null) {
                ((SQLNodeSelect)sQLNodeRef.node).Sortcolumns = (SQLNodeSortColumns)sQLNodeRef2.node;
            }
        } else {
            throw Errors.sqlException(17);
        }
        n = this.GetToken();
        if (n != 0) {
            throw Errors.sqlException(n, this.m_errorMsg);
        }
        if (this.m_tokenType != 0) {
            this.m_errorMsg = this.m_currentToken;
            throw Errors.sqlException(17);
        }
    }

    private int GetInteger(IntRef intRef) {
        int n = this.GetToken();
        if (n != 0) {
            return n;
        }
        if (this.m_tokenType != 2) {
            this.m_errorMsg = this.m_currentToken;
            return 1016;
        }
        intRef.value = 0;
        int n2 = 0;
        while (n2 < this.m_currentToken.length()) {
            switch (this.m_currentToken.charAt(n2)) {
                case '0': {
                    intRef.value *= 10;
                    break;
                }
                case '1': {
                    intRef.value = intRef.value * 10 + 1;
                    break;
                }
                case '2': {
                    intRef.value = intRef.value * 10 + 2;
                    break;
                }
                case '3': {
                    intRef.value = intRef.value * 10 + 3;
                    break;
                }
                case '4': {
                    intRef.value = intRef.value * 10 + 4;
                    break;
                }
                case '5': {
                    intRef.value = intRef.value * 10 + 5;
                    break;
                }
                case '6': {
                    intRef.value = intRef.value * 10 + 6;
                    break;
                }
                case '7': {
                    intRef.value = intRef.value * 10 + 7;
                    break;
                }
                case '8': {
                    intRef.value = intRef.value * 10 + 8;
                    break;
                }
                case '9': {
                    intRef.value = intRef.value * 10 + 9;
                    break;
                }
                default: {
                    this.m_errorMsg = this.m_currentToken;
                    return 1016;
                }
            }
            ++n2;
        }
        return 0;
    }

    int GetIdentifier(StringRef stringRef) {
        int n = this.GetToken();
        if (n != 0) {
            return n;
        }
        if (this.m_tokenType != 4) {
            this.m_errorMsg = "<identifier>";
            return 1015;
        }
        stringRef.value = this.m_currentToken;
        return 0;
    }

    int GetSymbol(String string) {
        int n = this.GetToken();
        if (n != 0) {
            return n;
        }
        if (this.m_tokenType != 1) {
            this.m_errorMsg = string != null ? string : "<symbol>";
            return 1015;
        }
        if (string != null && !this.m_currentToken.equalsIgnoreCase(string)) {
            this.m_errorMsg = string;
            return 1015;
        }
        return 0;
    }

    int GetString(StringRef stringRef) {
        int n = this.GetToken();
        if (n != 0) {
            return n;
        }
        if (this.m_tokenType != 3) {
            this.m_errorMsg = "<string>";
            return 1015;
        }
        stringRef.value = this.m_currentToken;
        return 0;
    }

    int GetIdent(String string) {
        int n = this.m_idxSqlStr;
        int n2 = this.m_cntSqlStr;
        while (n2 != 0 && (this.m_sqlBuf[n] == ' ' || this.m_sqlBuf[n] == '\n' || this.m_sqlBuf[n] == '\r' || this.m_sqlBuf[n] == '\t')) {
            ++n;
            --n2;
        }
        if (n2 == 0) {
            return 1013;
        }
        if (this.m_sqlBuf[n] == '\"') {
            this.m_errorMsg = string != null ? string : "<keyword>";
            return 1015;
        }
        int n3 = this.GetToken();
        if (n3 != 0) {
            return n3;
        }
        if (this.m_tokenType != 4 && this.m_tokenType != 5) {
            this.m_errorMsg = string != null ? string : "<identifier>";
            return 1015;
        }
        return 0;
    }

    int ParseScalar(SQLNodeRef sQLNodeRef) {
        boolean bl;
        SQLNodeRef sQLNodeRef2 = new SQLNodeRef();
        int n = this.GetSymbol(null);
        if (n != 0) {
            return n;
        }
        if (!this.m_currentToken.equalsIgnoreCase("{")) {
            bl = false;
            if (!this.m_currentToken.equalsIgnoreCase("--")) {
                this.m_errorMsg = "--";
                return 1015;
            }
            n = this.GetSymbol("(");
            if (n != 0) {
                return n;
            }
            n = this.GetSymbol("*");
            if (n != 0) {
                return n;
            }
            n = this.GetIdent("vendor");
            if (n != 0) {
                return n;
            }
            n = this.GetSymbol("(");
            if (n != 0) {
                return n;
            }
            n = this.GetIdent("Microsoft");
            if (n != 0) {
                return n;
            }
            n = this.GetSymbol(")");
            if (n != 0) {
                return n;
            }
            n = this.GetSymbol(",");
            if (n != 0) {
                return n;
            }
            n = this.GetIdent("product");
            if (n != 0) {
                return n;
            }
            n = this.GetSymbol("(");
            if (n != 0) {
                return n;
            }
            n = this.GetIdent("ODBC");
            if (n != 0) {
                return n;
            }
            n = this.GetSymbol(")");
            if (n != 0) {
                return n;
            }
        } else {
            bl = true;
        }
        if ((n = this.GetIdent("fn")) != 0) {
            return n;
        }
        n = this.GetIdent(null);
        if (n != 0) {
            return n;
        }
        String string = this.m_currentToken;
        n = this.GetSymbol("(");
        if (n != 0) {
            return n;
        }
        int n2 = this.m_idxSqlStr;
        int n3 = this.m_cntSqlStr;
        n = this.ParseValuelist(sQLNodeRef2);
        if (n != 0) {
            this.m_idxSqlStr = n2;
            this.m_cntSqlStr = n3;
            sQLNodeRef2.node = null;
        }
        if ((n = this.GetSymbol(")")) != 0) {
            return n;
        }
        if (!bl) {
            n = this.GetSymbol("*");
            if (n != 0) {
                return n;
            }
            n = this.GetSymbol(")");
            if (n != 0) {
                return n;
            }
            n = this.GetSymbol("--");
            if (n != 0) {
                return n;
            }
        } else {
            n = this.GetSymbol("}");
            if (n != 0) {
                return n;
            }
        }
        SQLNodeScalar sQLNodeScalar = new SQLNodeScalar();
        sQLNodeRef.node = sQLNodeScalar;
        sQLNodeScalar.Function = string;
        sQLNodeScalar.Arguments = (SQLNodeValues)sQLNodeRef2.node;
        return 0;
    }

    static int checkForSubstring(String string, char[] cArray, int n) throws NotConvertableException {
        int n2 = string.length();
        try {
            int n3 = 0;
            while (n3 < n2) {
                if (Character.toUpperCase(string.charAt(n3)) != Character.toUpperCase(cArray[n + n3])) {
                    throw new NotConvertableException();
                }
                ++n3;
            }
        }
        catch (Exception exception) {
            throw new NotConvertableException();
        }
        return n + n2;
    }

    static int skipWhiteSpace(char[] cArray, int n) throws NotConvertableException {
        try {
            while (Character.isWhitespace(cArray[n])) {
                ++n;
            }
        }
        catch (Exception exception) {
            throw new NotConvertableException();
        }
        return n;
    }

    Date CharToDate(String string) {
        Date date;
        char[] cArray = string.toCharArray();
        int n = 0;
        try {
            boolean bl;
            boolean bl2;
            n = SQLParser.skipWhiteSpace(cArray, n);
            if (cArray[n] == '-') {
                bl2 = true;
                bl = false;
                ++n;
                n = SQLParser.checkForSubstring("-(*", cArray, n);
                n = SQLParser.skipWhiteSpace(cArray, n);
                n = SQLParser.checkForSubstring("vendor", cArray, n);
                n = SQLParser.skipWhiteSpace(cArray, n);
                n = SQLParser.checkForSubstring("(", cArray, n);
                n = SQLParser.skipWhiteSpace(cArray, n);
                n = SQLParser.checkForSubstring("Microsoft", cArray, n);
                n = SQLParser.skipWhiteSpace(cArray, n);
                n = SQLParser.checkForSubstring(")", cArray, n);
                n = SQLParser.skipWhiteSpace(cArray, n);
                n = SQLParser.checkForSubstring(",", cArray, n);
                n = SQLParser.skipWhiteSpace(cArray, n);
                n = SQLParser.checkForSubstring("product", cArray, n);
                n = SQLParser.skipWhiteSpace(cArray, n);
                n = SQLParser.checkForSubstring("(", cArray, n);
                n = SQLParser.skipWhiteSpace(cArray, n);
                n = SQLParser.checkForSubstring("odbc", cArray, n);
                n = SQLParser.skipWhiteSpace(cArray, n);
                n = SQLParser.checkForSubstring(")", cArray, n);
                n = SQLParser.skipWhiteSpace(cArray, n);
                n = SQLParser.checkForSubstring("d", cArray, n);
                n = SQLParser.skipWhiteSpace(cArray, n);
                n = SQLParser.checkForSubstring("'", cArray, n);
            } else if (cArray[n] == '{') {
                bl2 = false;
                bl = true;
                ++n;
                n = SQLParser.skipWhiteSpace(cArray, n);
                n = SQLParser.checkForSubstring("d", cArray, n);
                n = SQLParser.skipWhiteSpace(cArray, n);
                n = SQLParser.checkForSubstring("'", cArray, n);
            } else {
                bl2 = false;
                bl = false;
            }
            String string2 = new String(cArray, n, 10);
            date = Date.valueOf(string2);
            n += 10;
            if (bl2) {
                n = SQLParser.checkForSubstring("'", cArray, n);
                n = SQLParser.skipWhiteSpace(cArray, n);
                n = SQLParser.checkForSubstring("*)--", cArray, n);
            }
            if (bl) {
                n = SQLParser.checkForSubstring("'", cArray, n);
                n = SQLParser.skipWhiteSpace(cArray, n);
                n = SQLParser.checkForSubstring("}", cArray, n);
            }
        }
        catch (NotConvertableException notConvertableException) {
            date = null;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            date = null;
        }
        try {
            n = SQLParser.skipWhiteSpace(cArray, n);
            date = null;
        }
        catch (NotConvertableException notConvertableException) {
            // empty catch block
        }
        return date;
    }

    Timestamp CharToTimestamp(String string) {
        char[] cArray = string.toCharArray();
        int n = 0;
        Timestamp timestamp = null;
        try {
            boolean bl;
            boolean bl2;
            n = SQLParser.skipWhiteSpace(cArray, n);
            if (cArray[n] == '-') {
                bl2 = true;
                bl = false;
                ++n;
                n = SQLParser.checkForSubstring("-(*", cArray, n);
                n = SQLParser.skipWhiteSpace(cArray, n);
                n = SQLParser.checkForSubstring("vendor", cArray, n);
                n = SQLParser.skipWhiteSpace(cArray, n);
                n = SQLParser.checkForSubstring("(", cArray, n);
                n = SQLParser.skipWhiteSpace(cArray, n);
                n = SQLParser.checkForSubstring("Microsoft", cArray, n);
                n = SQLParser.skipWhiteSpace(cArray, n);
                n = SQLParser.checkForSubstring(")", cArray, n);
                n = SQLParser.skipWhiteSpace(cArray, n);
                n = SQLParser.checkForSubstring(",", cArray, n);
                n = SQLParser.skipWhiteSpace(cArray, n);
                n = SQLParser.checkForSubstring("product", cArray, n);
                n = SQLParser.skipWhiteSpace(cArray, n);
                n = SQLParser.checkForSubstring("(", cArray, n);
                n = SQLParser.skipWhiteSpace(cArray, n);
                n = SQLParser.checkForSubstring("odbc", cArray, n);
                n = SQLParser.skipWhiteSpace(cArray, n);
                n = SQLParser.checkForSubstring(")", cArray, n);
                n = SQLParser.skipWhiteSpace(cArray, n);
                n = SQLParser.checkForSubstring("t", cArray, n);
                n = SQLParser.skipWhiteSpace(cArray, n);
                n = SQLParser.checkForSubstring("'", cArray, n);
            } else if (cArray[n] == '{') {
                bl2 = false;
                bl = true;
                ++n;
                n = SQLParser.skipWhiteSpace(cArray, n);
                n = SQLParser.checkForSubstring("ts", cArray, n);
                n = SQLParser.skipWhiteSpace(cArray, n);
                n = SQLParser.checkForSubstring("'", cArray, n);
            } else {
                bl2 = false;
                bl = false;
            }
            String string2 = new String(cArray, n, 19);
            timestamp = Timestamp.valueOf(string2);
            n += 22;
            if (bl2) {
                n = SQLParser.checkForSubstring("'", cArray, n);
                n = SQLParser.skipWhiteSpace(cArray, n);
                n = SQLParser.checkForSubstring("*)--", cArray, n);
            }
            if (bl) {
                n = SQLParser.checkForSubstring("'", cArray, n);
                n = SQLParser.skipWhiteSpace(cArray, n);
                n = SQLParser.checkForSubstring("}", cArray, n);
            }
        }
        catch (NotConvertableException notConvertableException) {
            timestamp = null;
        }
        try {
            n = SQLParser.skipWhiteSpace(cArray, n);
            timestamp = null;
        }
        catch (NotConvertableException notConvertableException) {
            // empty catch block
        }
        return timestamp;
    }

    Time CharToTime(String string) {
        Time time;
        char[] cArray = string.toCharArray();
        int n = 0;
        try {
            boolean bl;
            boolean bl2;
            n = SQLParser.skipWhiteSpace(cArray, n);
            if (cArray[n] == '-') {
                bl2 = true;
                bl = false;
                ++n;
                n = SQLParser.checkForSubstring("-(*", cArray, n);
                n = SQLParser.skipWhiteSpace(cArray, n);
                n = SQLParser.checkForSubstring("vendor", cArray, n);
                n = SQLParser.skipWhiteSpace(cArray, n);
                n = SQLParser.checkForSubstring("(", cArray, n);
                n = SQLParser.skipWhiteSpace(cArray, n);
                n = SQLParser.checkForSubstring("Microsoft", cArray, n);
                n = SQLParser.skipWhiteSpace(cArray, n);
                n = SQLParser.checkForSubstring(")", cArray, n);
                n = SQLParser.skipWhiteSpace(cArray, n);
                n = SQLParser.checkForSubstring(",", cArray, n);
                n = SQLParser.skipWhiteSpace(cArray, n);
                n = SQLParser.checkForSubstring("product", cArray, n);
                n = SQLParser.skipWhiteSpace(cArray, n);
                n = SQLParser.checkForSubstring("(", cArray, n);
                n = SQLParser.skipWhiteSpace(cArray, n);
                n = SQLParser.checkForSubstring("odbc", cArray, n);
                n = SQLParser.skipWhiteSpace(cArray, n);
                n = SQLParser.checkForSubstring(")", cArray, n);
                n = SQLParser.skipWhiteSpace(cArray, n);
                n = SQLParser.checkForSubstring("t", cArray, n);
                n = SQLParser.skipWhiteSpace(cArray, n);
                n = SQLParser.checkForSubstring("'", cArray, n);
            } else if (cArray[n] == '{') {
                bl2 = false;
                bl = true;
                ++n;
                n = SQLParser.skipWhiteSpace(cArray, n);
                n = SQLParser.checkForSubstring("t", cArray, n);
                n = SQLParser.skipWhiteSpace(cArray, n);
                n = SQLParser.checkForSubstring("'", cArray, n);
            } else {
                bl2 = false;
                bl = false;
            }
            String string2 = new String(cArray, n, 8);
            time = Time.valueOf(string2);
            n += 8;
            if (bl2) {
                n = SQLParser.checkForSubstring("'", cArray, n);
                n = SQLParser.skipWhiteSpace(cArray, n);
                n = SQLParser.checkForSubstring("*)--", cArray, n);
            }
            if (bl) {
                n = SQLParser.checkForSubstring("'", cArray, n);
                n = SQLParser.skipWhiteSpace(cArray, n);
                n = SQLParser.checkForSubstring("}", cArray, n);
            }
        }
        catch (NotConvertableException notConvertableException) {
            time = null;
        }
        try {
            n = SQLParser.skipWhiteSpace(cArray, n);
            time = null;
        }
        catch (NotConvertableException notConvertableException) {
            // empty catch block
        }
        return time;
    }

    int ParsePattern(SQLNodeRef sQLNodeRef) {
        StringRef stringRef = new StringRef();
        int n = this.m_idxSqlStr;
        int n2 = this.m_cntSqlStr;
        int n3 = this.GetString(stringRef);
        if (n3 != 0) {
            this.m_idxSqlStr = n;
            this.m_cntSqlStr = n2;
            n3 = this.GetSymbol("?");
            if (n3 != 0) {
                this.m_idxSqlStr = n;
                this.m_cntSqlStr = n2;
                n3 = this.GetKeyword("USER");
                if (n3 != 0) {
                    return n3;
                }
                sQLNodeRef.node = new SQLNodeUser();
            } else {
                sQLNodeRef.node = new SQLNodeParameter();
                SQLNodeParameter sQLNodeParameter = this.m_parseTree.parameters;
                if (sQLNodeParameter == null) {
                    this.m_parseTree.parameters = (SQLNodeParameter)sQLNodeRef.node;
                    ((SQLNodeParameter)sQLNodeRef.node).Id = 1;
                } else {
                    while (sQLNodeParameter.Next != null) {
                        sQLNodeParameter = sQLNodeParameter.Next;
                    }
                    sQLNodeParameter.Next = (SQLNodeParameter)sQLNodeRef.node;
                    sQLNodeParameter.Next.Id = sQLNodeParameter.Id + 1;
                }
            }
        } else {
            SQLNodeString sQLNodeString = new SQLNodeString();
            sQLNodeRef.node = sQLNodeString;
            sQLNodeString.Value = stringRef.value;
        }
        return 0;
    }

    int digitToInt(char c) {
        int n;
        switch (c) {
            case '0': {
                n = 0;
                break;
            }
            case '1': {
                n = 1;
                break;
            }
            case '2': {
                n = 2;
                break;
            }
            case '3': {
                n = 3;
                break;
            }
            case '4': {
                n = 4;
                break;
            }
            case '5': {
                n = 5;
                break;
            }
            case '6': {
                n = 6;
                break;
            }
            case '7': {
                n = 7;
                break;
            }
            case '8': {
                n = 8;
                break;
            }
            case '9': {
                n = 9;
                break;
            }
            default: {
                n = 0;
            }
        }
        return n;
    }

    double digitToDouble(char c) {
        double d;
        switch (c) {
            case '0': {
                d = 0.0;
                break;
            }
            case '1': {
                d = 1.0;
                break;
            }
            case '2': {
                d = 2.0;
                break;
            }
            case '3': {
                d = 3.0;
                break;
            }
            case '4': {
                d = 4.0;
                break;
            }
            case '5': {
                d = 5.0;
                break;
            }
            case '6': {
                d = 6.0;
                break;
            }
            case '7': {
                d = 7.0;
                break;
            }
            case '8': {
                d = 8.0;
                break;
            }
            case '9': {
                d = 9.0;
                break;
            }
            default: {
                d = 0.0;
            }
        }
        return d;
    }

    int GetNumber(DoubleRef doubleRef, IntRef intRef, IntRef intRef2) {
        boolean bl;
        int n = this.GetToken();
        if (n != 0) {
            return n;
        }
        if (this.m_tokenType == 1 && this.m_currentToken.equalsIgnoreCase("-")) {
            bl = true;
            n = this.GetToken();
            if (n != 0) {
                return n;
            }
        } else if (this.m_tokenType == 1 && this.m_currentToken.equalsIgnoreCase("+")) {
            bl = false;
            n = this.GetToken();
            if (n != 0) {
                return n;
            }
        } else {
            bl = false;
        }
        if (this.m_tokenType != 2) {
            this.m_errorMsg = "<number>";
            return 1015;
        }
        int n2 = this.m_currentToken.length();
        if (n2 >= 255) {
            this.m_errorMsg = this.m_currentToken;
            return 1016;
        }
        boolean bl2 = false;
        int n3 = 0;
        doubleRef.value = 0.0;
        char[] cArray = new char[n2];
        int n4 = 0;
        this.m_currentToken.getChars(0, n2, cArray, 0);
        intRef.value = 3;
        intRef2.value = 0;
        while (n4 < n2) {
            block0 : switch (cArray[n4]) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    switch (intRef.value) {
                        case 6: {
                            n3 = n3 * 10 + this.digitToInt(cArray[n4]);
                            break block0;
                        }
                        case 7: {
                            doubleRef.value = doubleRef.value * 10.0 + this.digitToDouble(cArray[n4]);
                            ++intRef2.value;
                            break block0;
                        }
                        case 3: {
                            doubleRef.value = doubleRef.value * 10.0 + this.digitToDouble(cArray[n4]);
                            break block0;
                        }
                    }
                    return 1019;
                }
                case '.': {
                    if (intRef.value != 3) {
                        this.m_errorMsg = this.m_currentToken;
                        return 1016;
                    }
                    intRef.value = 7;
                    break;
                }
                case 'E': 
                case 'e': {
                    intRef.value = 6;
                    if (cArray[n4 + 1] == '-') {
                        bl2 = true;
                        ++n4;
                        break;
                    }
                    if (cArray[n4 + 1] != '+') break;
                    ++n4;
                    break;
                }
                default: {
                    this.m_errorMsg = this.m_currentToken;
                    return 1016;
                }
            }
            ++n4;
        }
        if (intRef.value == 7 && intRef2.value == 0) {
            this.m_currentToken = this.m_currentToken.substring(0, n2 - 1);
            intRef.value = 3;
        }
        if (bl) {
            this.m_currentToken = "-" + this.m_currentToken;
        }
        int n5 = -intRef2.value;
        n5 = bl2 ? (n5 -= n3) : (n5 += n3);
        double d = 1.0;
        while (n5 > 0) {
            d *= 10.0;
            --n5;
        }
        doubleRef.value *= d;
        d = 1.0;
        while (n5 < 0) {
            d *= 10.0;
            ++n5;
        }
        doubleRef.value /= d;
        if (bl) {
            doubleRef.value = -doubleRef.value;
        }
        if (intRef.value == 6) {
            intRef2.value = -1;
        }
        return 0;
    }

    int ParseHaving(SQLNodeRef sQLNodeRef) {
        int n = this.m_idxSqlStr;
        int n2 = this.m_cntSqlStr;
        int n3 = this.GetKeyword("HAVING");
        if (n3 != 0) {
            this.m_idxSqlStr = n;
            this.m_cntSqlStr = n2;
            sQLNodeRef.node = null;
        } else {
            n3 = this.ParseBoolean(sQLNodeRef);
            if (n3 != 0) {
                return n3;
            }
        }
        return 0;
    }

    int ParseColref(SQLNodeRef sQLNodeRef) {
        String string;
        StringRef stringRef = new StringRef();
        int n = this.GetIdentifier(stringRef);
        if (n != 0) {
            return n;
        }
        int n2 = this.m_idxSqlStr;
        int n3 = this.m_cntSqlStr;
        n = this.GetSymbol(".");
        if (n != 0) {
            this.m_idxSqlStr = n2;
            this.m_cntSqlStr = n3;
            string = null;
        } else {
            string = stringRef.value;
            n = this.GetIdentifier(stringRef);
            if (n != 0) {
                this.m_idxSqlStr = n2;
                this.m_cntSqlStr = n3;
                stringRef.value = string;
                string = null;
            }
        }
        SQLNodeColumn sQLNodeColumn = new SQLNodeColumn();
        sQLNodeRef.node = sQLNodeColumn;
        sQLNodeColumn.Tablealias = string;
        sQLNodeColumn.Column = stringRef.value;
        return 0;
    }

    int ParseGroupbyterms(SQLNodeRef sQLNodeRef) {
        int n;
        int n2;
        int n3;
        SQLNodeRef sQLNodeRef2 = new SQLNodeRef();
        SQLNodeGroupByColumns sQLNodeGroupByColumns = null;
        do {
            if ((n3 = this.ParseColref(sQLNodeRef2)) != 0) {
                return n3;
            }
            SQLNodeGroupByColumns sQLNodeGroupByColumns2 = new SQLNodeGroupByColumns();
            sQLNodeGroupByColumns2.Column = (SQLNodeColumn)sQLNodeRef2.node;
            sQLNodeGroupByColumns2.Next = null;
            if (sQLNodeGroupByColumns != null) {
                sQLNodeGroupByColumns.Next = sQLNodeGroupByColumns2;
            } else {
                sQLNodeRef.node = sQLNodeGroupByColumns2;
            }
            sQLNodeGroupByColumns = sQLNodeGroupByColumns2;
            n2 = this.m_idxSqlStr;
            n = this.m_cntSqlStr;
        } while ((n3 = this.GetSymbol(",")) == 0);
        this.m_idxSqlStr = n2;
        this.m_cntSqlStr = n;
        return 0;
    }

    int ParseWhere(SQLNodeRef sQLNodeRef) {
        int n = this.m_idxSqlStr;
        int n2 = this.m_cntSqlStr;
        int n3 = this.GetKeyword("WHERE");
        if (n3 != 0) {
            this.m_idxSqlStr = n;
            this.m_cntSqlStr = n2;
            sQLNodeRef.node = null;
        } else {
            n3 = this.ParseBoolean(sQLNodeRef);
            if (n3 != 0) {
                return n3;
            }
        }
        return 0;
    }

    int ParseAggterm(SQLNodeRef sQLNodeRef) {
        int n;
        SQLNodeRef sQLNodeRef2 = new SQLNodeRef();
        int n2 = this.GetKeyword(null);
        if (n2 != 0) {
            return n2;
        }
        if (this.m_currentToken.equalsIgnoreCase("COUNT")) {
            n = 2;
        } else if (this.m_currentToken.equalsIgnoreCase("AVG")) {
            n = 1;
        } else if (this.m_currentToken.equalsIgnoreCase("MAX")) {
            n = 3;
        } else if (this.m_currentToken.equalsIgnoreCase("MIN")) {
            n = 4;
        } else if (this.m_currentToken.equalsIgnoreCase("SUM")) {
            n = 5;
        } else {
            this.m_errorMsg = "COUNT, AVG, MAX, MIN, or SUM";
            return 1015;
        }
        n2 = this.GetSymbol("(");
        if (n2 != 0) {
            return n2;
        }
        switch (n) {
            case 2: {
                n2 = this.GetSymbol("*");
                if (n2 != 0) {
                    return n2;
                }
                sQLNodeRef2.node = null;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                n2 = this.ParseExpression(sQLNodeRef2);
                if (n2 == 0) break;
                return n2;
            }
            default: {
                return 1019;
            }
        }
        n2 = this.GetSymbol(")");
        if (n2 != 0) {
            return n2;
        }
        SQLNodeAggregate sQLNodeAggregate = new SQLNodeAggregate();
        sQLNodeRef.node = sQLNodeAggregate;
        sQLNodeAggregate.Operator = n;
        sQLNodeAggregate.Expression = sQLNodeRef2.node;
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    int ParseSimpleterm(SQLNodeRef sQLNodeRef) {
        StringRef stringRef = new StringRef();
        DoubleRef doubleRef = new DoubleRef();
        IntRef intRef = new IntRef();
        IntRef intRef2 = new IntRef();
        int n = this.m_idxSqlStr;
        int n2 = this.m_cntSqlStr;
        int n3 = this.GetString(stringRef);
        if (n3 == 0) {
            sQLNodeRef.node = new SQLNodeString();
            ((SQLNodeString)sQLNodeRef.node).Value = stringRef.value;
            return 0;
        }
        this.m_idxSqlStr = n;
        this.m_cntSqlStr = n2;
        n3 = this.GetSymbol("?");
        if (n3 != 0) {
            this.m_idxSqlStr = n;
            this.m_cntSqlStr = n2;
            n3 = this.GetKeyword("USER");
            if (n3 == 0) {
                sQLNodeRef.node = new SQLNodeUser();
                return 0;
            }
            this.m_idxSqlStr = n;
            this.m_cntSqlStr = n2;
            n3 = this.GetNumber(doubleRef, intRef, intRef2);
            if (n3 != 0) {
                this.m_idxSqlStr = n;
                this.m_cntSqlStr = n2;
                n3 = this.GetEscape();
                if (n3 != 0) {
                    if (n3 != 1015) return n3;
                    this.m_errorMsg = "<simpleterm>";
                    return n3;
                }
                Date date = this.CharToDate(this.m_currentToken);
                if (null != date) {
                    SQLNodeDate sQLNodeDate = new SQLNodeDate();
                    sQLNodeRef.node = sQLNodeDate;
                    sQLNodeDate.Value = date;
                    return 0;
                }
                Time time = this.CharToTime(this.m_currentToken);
                if (null != time) {
                    SQLNodeDate sQLNodeDate = new SQLNodeDate();
                    sQLNodeRef.node = sQLNodeDate;
                    ((SQLNodeTime)((Object)sQLNodeDate)).Value = time;
                    return 0;
                }
                Timestamp timestamp = this.CharToTimestamp(this.m_currentToken);
                if (null != timestamp) {
                    SQLNodeTimestamp sQLNodeTimestamp = new SQLNodeTimestamp();
                    sQLNodeRef.node = sQLNodeTimestamp;
                    sQLNodeTimestamp.Value = timestamp;
                    return 0;
                }
                this.m_errorMsg = this.m_currentToken;
                return 1018;
            }
            SQLNodeNumeric sQLNodeNumeric = new SQLNodeNumeric();
            sQLNodeRef.node = sQLNodeNumeric;
            if (this.m_currentToken.length() >= 10 && intRef.value == 3) {
                intRef.value = 8;
                intRef2.value = -1;
            }
            switch (intRef.value) {
                case 6: {
                    sQLNodeNumeric.sqlDataType = 6;
                    sQLNodeNumeric.sqlSqlType = 8;
                    sQLNodeNumeric.sqlPrecision = 15;
                    sQLNodeNumeric.sqlScale = -1;
                    break;
                }
                case 3: {
                    sQLNodeNumeric.sqlDataType = 3;
                    sQLNodeNumeric.sqlSqlType = 4;
                    sQLNodeNumeric.sqlPrecision = 10;
                    sQLNodeNumeric.sqlScale = 0;
                    break;
                }
                case 7: {
                    sQLNodeNumeric.sqlDataType = 7;
                    sQLNodeNumeric.sqlSqlType = 3;
                    sQLNodeNumeric.sqlPrecision = this.m_currentToken.charAt(0) != '-' ? this.m_currentToken.length() - 1 : this.m_currentToken.length() - 2;
                    sQLNodeNumeric.sqlScale = intRef2.value;
                    BCD.BCDNormalize(this.m_currentToken, stringRef, sQLNodeNumeric.sqlPrecision, sQLNodeNumeric.sqlScale);
                    break;
                }
                default: {
                    return 1019;
                }
            }
            sQLNodeNumeric.Numeric = stringRef.value;
            sQLNodeNumeric.Value = new ValueDouble(doubleRef.value);
            return 0;
        }
        SQLNodeParameter sQLNodeParameter = new SQLNodeParameter();
        sQLNodeRef.node = sQLNodeParameter;
        SQLNodeParameter sQLNodeParameter2 = this.m_parseTree.parameters;
        if (sQLNodeParameter2 == null) {
            this.m_parseTree.parameters = sQLNodeParameter;
            sQLNodeParameter.Id = 1;
            return 0;
        }
        do {
            sQLNodeParameter2 = sQLNodeParameter2.Next;
        } while (sQLNodeParameter2.Next != null);
        sQLNodeParameter2.Next = sQLNodeParameter;
        sQLNodeParameter.Id = sQLNodeParameter2.Id + 1;
        return 0;
    }

    int ParseTerm(SQLNodeRef sQLNodeRef) {
        int n = this.m_idxSqlStr;
        int n2 = this.m_cntSqlStr;
        int n3 = this.ParseSimpleterm(sQLNodeRef);
        if (n3 != 0) {
            this.m_idxSqlStr = n;
            this.m_cntSqlStr = n2;
            n3 = this.ParseAggterm(sQLNodeRef);
            if (n3 != 0) {
                this.m_idxSqlStr = n;
                this.m_cntSqlStr = n2;
                n3 = this.GetSymbol("(");
                if (n3 != 0) {
                    this.m_idxSqlStr = n;
                    this.m_cntSqlStr = n2;
                    n3 = this.ParseColref(sQLNodeRef);
                    if (n3 != 0) {
                        this.m_idxSqlStr = n;
                        this.m_cntSqlStr = n2;
                        n3 = this.ParseScalar(sQLNodeRef);
                        if (n3 != 0) {
                            this.m_errorMsg = "<identifier>";
                            return 1015;
                        }
                    }
                } else {
                    n3 = this.ParseExpression(sQLNodeRef);
                    if (n3 != 0) {
                        return n3;
                    }
                    n3 = this.GetSymbol(")");
                    if (n3 != 0) {
                        return n3;
                    }
                }
            }
        }
        return 0;
    }

    int ParseNeg(SQLNodeRef sQLNodeRef) {
        int n;
        SQLNodeRef sQLNodeRef2 = new SQLNodeRef();
        int n2 = this.m_idxSqlStr;
        int n3 = this.m_cntSqlStr;
        int n4 = this.GetSymbol(null);
        if (n4 != 0) {
            this.m_idxSqlStr = n2;
            this.m_cntSqlStr = n3;
            n = 0;
        } else if (this.m_currentToken.equalsIgnoreCase("-")) {
            n = 11;
        } else if (this.m_currentToken.equalsIgnoreCase("+")) {
            n = 0;
        } else {
            this.m_idxSqlStr = n2;
            this.m_cntSqlStr = n3;
            n = 0;
        }
        n4 = this.ParseTerm(sQLNodeRef2);
        if (n4 != 0) {
            return n4;
        }
        if (n == 0) {
            sQLNodeRef.node = sQLNodeRef2.node;
        } else {
            SQLNodeAlgebraic sQLNodeAlgebraic = new SQLNodeAlgebraic();
            sQLNodeRef.node = sQLNodeAlgebraic;
            sQLNodeAlgebraic.Operator = 11;
            sQLNodeAlgebraic.Left = sQLNodeRef2.node;
        }
        return 0;
    }

    int ParseTimes(SQLNodeRef sQLNodeRef) {
        SQLNodeRef sQLNodeRef2 = new SQLNodeRef();
        SQLNodeRef sQLNodeRef3 = new SQLNodeRef();
        int n = this.ParseNeg(sQLNodeRef2);
        if (n != 0) {
            return n;
        }
        while (true) {
            int n2;
            int n3 = this.m_idxSqlStr;
            int n4 = this.m_cntSqlStr;
            n = this.GetSymbol(null);
            if (n != 0) {
                this.m_idxSqlStr = n3;
                this.m_cntSqlStr = n4;
                sQLNodeRef.node = sQLNodeRef2.node;
                break;
            }
            if (this.m_currentToken.equalsIgnoreCase("*")) {
                n2 = 14;
            } else if (this.m_currentToken.equalsIgnoreCase("/")) {
                n2 = 15;
            } else {
                this.m_idxSqlStr = n3;
                this.m_cntSqlStr = n4;
                sQLNodeRef.node = sQLNodeRef2.node;
                break;
            }
            n = this.ParseNeg(sQLNodeRef3);
            if (n != 0) {
                return n;
            }
            SQLNodeAlgebraic sQLNodeAlgebraic = new SQLNodeAlgebraic();
            sQLNodeAlgebraic.Operator = n2;
            sQLNodeAlgebraic.Left = sQLNodeRef2.node;
            sQLNodeAlgebraic.Right = sQLNodeRef3.node;
            sQLNodeRef2.node = sQLNodeAlgebraic;
        }
        return 0;
    }

    int ParseExpression(SQLNodeRef sQLNodeRef) {
        SQLNodeRef sQLNodeRef2 = new SQLNodeRef();
        SQLNodeRef sQLNodeRef3 = new SQLNodeRef();
        int n = this.ParseTimes(sQLNodeRef2);
        if (n != 0) {
            return n;
        }
        while (true) {
            int n2;
            int n3 = this.m_idxSqlStr;
            int n4 = this.m_cntSqlStr;
            n = this.GetSymbol(null);
            if (n != 0) {
                this.m_idxSqlStr = n3;
                this.m_cntSqlStr = n4;
                sQLNodeRef.node = sQLNodeRef2.node;
                break;
            }
            if (this.m_currentToken.equalsIgnoreCase("-")) {
                n2 = 13;
            } else if (this.m_currentToken.equalsIgnoreCase("+")) {
                n2 = 12;
            } else {
                this.m_idxSqlStr = n3;
                this.m_cntSqlStr = n4;
                sQLNodeRef.node = sQLNodeRef2.node;
                break;
            }
            n = this.ParseTimes(sQLNodeRef3);
            if (n != 0) {
                return n;
            }
            SQLNodeAlgebraic sQLNodeAlgebraic = new SQLNodeAlgebraic();
            sQLNodeAlgebraic.Operator = n2;
            sQLNodeAlgebraic.Left = sQLNodeRef2.node;
            sQLNodeAlgebraic.Right = sQLNodeRef3.node;
            sQLNodeAlgebraic.WorkBuffer1 = null;
            sQLNodeAlgebraic.WorkBuffer2 = null;
            sQLNodeAlgebraic.WorkBuffer3 = null;
            sQLNodeAlgebraic.EnclosingStatement = null;
            sQLNodeRef2.node = sQLNodeAlgebraic;
        }
        return 0;
    }

    int ParseSelectlist(SQLNodeRef sQLNodeRef) {
        int n;
        int n2;
        int n3;
        SQLNodeRef sQLNodeRef2 = new SQLNodeRef();
        StringRef stringRef = new StringRef();
        SQLNodeValues sQLNodeValues = null;
        do {
            if ((n3 = this.ParseExpression(sQLNodeRef2)) != 0) {
                return n3;
            }
            n2 = this.m_idxSqlStr;
            n = this.m_cntSqlStr;
            n3 = this.GetKeyword("AS");
            if (n3 != 0) {
                this.m_idxSqlStr = n2;
                this.m_cntSqlStr = n;
                n3 = this.GetIdentifier(stringRef);
                if (n3 != 0) {
                    this.m_idxSqlStr = n2;
                    this.m_cntSqlStr = n;
                    stringRef.value = null;
                }
            } else {
                n3 = this.GetIdentifier(stringRef);
                if (n3 != 0) {
                    return n3;
                }
            }
            SQLNodeValues sQLNodeValues2 = new SQLNodeValues();
            sQLNodeValues2.Value = sQLNodeRef2.node;
            sQLNodeValues2.Alias = stringRef.value;
            sQLNodeValues2.Next = null;
            if (sQLNodeValues != null) {
                sQLNodeValues.Next = sQLNodeValues2;
            } else {
                sQLNodeRef.node = sQLNodeValues2;
            }
            sQLNodeValues = sQLNodeValues2;
            n2 = this.m_idxSqlStr;
            n = this.m_cntSqlStr;
        } while ((n3 = this.GetSymbol(",")) == 0);
        this.m_idxSqlStr = n2;
        this.m_cntSqlStr = n;
        return 0;
    }

    int ParseValuelist(SQLNodeRef sQLNodeRef) {
        int n;
        int n2;
        int n3;
        SQLNodeRef sQLNodeRef2 = new SQLNodeRef();
        SQLNodeValues sQLNodeValues = null;
        do {
            n2 = this.m_idxSqlStr;
            n = this.m_cntSqlStr;
            n3 = this.GetKeyword("NULL");
            if (n3 != 0) {
                this.m_idxSqlStr = n2;
                this.m_cntSqlStr = n;
                n3 = this.ParseExpression(sQLNodeRef2);
                if (n3 != 0) {
                    return n3;
                }
            } else {
                sQLNodeRef2.node = new SQLNodeNull();
            }
            SQLNodeValues sQLNodeValues2 = new SQLNodeValues();
            sQLNodeValues2.Value = sQLNodeRef2.node;
            sQLNodeValues2.Alias = null;
            sQLNodeValues2.Next = null;
            if (sQLNodeValues != null) {
                sQLNodeValues.Next = sQLNodeValues2;
            } else {
                sQLNodeRef.node = sQLNodeValues2;
            }
            sQLNodeValues = sQLNodeValues2;
            n2 = this.m_idxSqlStr;
            n = this.m_cntSqlStr;
        } while ((n3 = this.GetSymbol(",")) == 0);
        this.m_idxSqlStr = n2;
        this.m_cntSqlStr = n;
        return 0;
    }

    int ParseSelectcols(SQLNodeRef sQLNodeRef, BooleanRef booleanRef) {
        int n = this.m_idxSqlStr;
        int n2 = this.m_cntSqlStr;
        int n3 = this.GetKeyword(null);
        if (n3 == 0) {
            if (this.m_currentToken.equalsIgnoreCase("ALL")) {
                booleanRef.value = false;
            } else if (this.m_currentToken.equalsIgnoreCase("DISTINCT")) {
                booleanRef.value = true;
            } else {
                booleanRef.value = false;
                this.m_idxSqlStr = n;
                this.m_cntSqlStr = n2;
            }
        } else {
            booleanRef.value = false;
            this.m_idxSqlStr = n;
            this.m_cntSqlStr = n2;
        }
        n = this.m_idxSqlStr;
        n2 = this.m_cntSqlStr;
        n3 = this.GetSymbol("*");
        if (n3 != 0) {
            this.m_idxSqlStr = n;
            this.m_cntSqlStr = n2;
            n3 = this.ParseSelectlist(sQLNodeRef);
            if (n3 != 0) {
                return n3;
            }
        } else {
            sQLNodeRef.node = null;
        }
        return 0;
    }

    int ParseTable(SQLNodeRef sQLNodeRef) {
        StringRef stringRef = new StringRef();
        int n = this.GetIdentifier(stringRef);
        if (n != 0) {
            return n;
        }
        SQLNodeTable sQLNodeTable = new SQLNodeTable();
        sQLNodeRef.node = sQLNodeTable;
        sQLNodeTable.Name = stringRef.value;
        return 0;
    }

    int ParseTableref(SQLNodeRef sQLNodeRef) {
        StringRef stringRef = new StringRef();
        int n = this.ParseTable(sQLNodeRef);
        if (n != 0) {
            return n;
        }
        int n2 = this.m_idxSqlStr;
        int n3 = this.m_cntSqlStr;
        n = this.GetIdentifier(stringRef);
        if (n != 0) {
            this.m_idxSqlStr = n2;
            this.m_cntSqlStr = n3;
            stringRef.value = null;
        } else {
            ((SQLNodeTable)sQLNodeRef.node).Alias = stringRef.value;
        }
        return 0;
    }

    int ParseOJ(SQLNodeRef sQLNodeRef, SQLNodeRef sQLNodeRef2) {
        SQLNodeRef sQLNodeRef3 = new SQLNodeRef();
        SQLNodeRef sQLNodeRef4 = new SQLNodeRef();
        SQLNodeRef sQLNodeRef5 = new SQLNodeRef();
        SQLNodeRef sQLNodeRef6 = new SQLNodeRef();
        int n = this.ParseTableref(sQLNodeRef3);
        if (n != 0) {
            return n;
        }
        n = this.GetKeyword("LEFT");
        if (n != 0) {
            return n;
        }
        n = this.GetKeyword("OUTER");
        if (n != 0) {
            return n;
        }
        n = this.GetKeyword("JOIN");
        if (n != 0) {
            return n;
        }
        int n2 = this.m_idxSqlStr;
        int n3 = this.m_cntSqlStr;
        n = this.ParseOJ(sQLNodeRef5, sQLNodeRef2);
        if (n == 0) {
            sQLNodeRef4.node = ((SQLNodeTables)sQLNodeRef5.node).Table;
        } else {
            this.m_idxSqlStr = n2;
            this.m_cntSqlStr = n3;
            n = this.ParseTableref(sQLNodeRef4);
            if (n != 0) {
                return n;
            }
            sQLNodeRef5.node = new SQLNodeTables();
            ((SQLNodeTables)sQLNodeRef5.node).Table = (SQLNodeTable)sQLNodeRef4.node;
            ((SQLNodeTables)sQLNodeRef5.node).Next = null;
            sQLNodeRef2.node = sQLNodeRef5.node;
        }
        n = this.GetKeyword("ON");
        if (n != 0) {
            return n;
        }
        n = this.ParseBoolean(sQLNodeRef6);
        if (n != 0) {
            return n;
        }
        sQLNodeRef.node = new SQLNodeTables();
        ((SQLNodeTables)sQLNodeRef.node).Table = (SQLNodeTable)sQLNodeRef3.node;
        ((SQLNodeTables)sQLNodeRef.node).Next = (SQLNodeTables)sQLNodeRef5.node;
        ((SQLNodeTable)sQLNodeRef4.node).OuterJoinFromTables = (SQLNodeTables)sQLNodeRef.node;
        ((SQLNodeTable)sQLNodeRef4.node).OuterJoinPredicate = sQLNodeRef6.node;
        return 0;
    }

    int ParseOuterJoin(SQLNodeRef sQLNodeRef, SQLNodeRef sQLNodeRef2) {
        boolean bl;
        int n = this.GetSymbol(null);
        if (n != 0) {
            return n;
        }
        if (!this.m_currentToken.equalsIgnoreCase("{")) {
            bl = false;
            if (!this.m_currentToken.equalsIgnoreCase("--")) {
                this.m_errorMsg = "--";
                return 1015;
            }
            n = this.GetSymbol("(");
            if (n != 0) {
                return n;
            }
            n = this.GetSymbol("*");
            if (n != 0) {
                return n;
            }
            n = this.GetIdent("vendor");
            if (n != 0) {
                return n;
            }
            n = this.GetSymbol("(");
            if (n != 0) {
                return n;
            }
            n = this.GetIdent("Microsoft");
            if (n != 0) {
                return n;
            }
            n = this.GetSymbol(")");
            if (n != 0) {
                return n;
            }
            n = this.GetSymbol(",");
            if (n != 0) {
                return n;
            }
            n = this.GetIdent("product");
            if (n != 0) {
                return n;
            }
            n = this.GetSymbol("(");
            if (n != 0) {
                return n;
            }
            n = this.GetIdent("ODBC");
            if (n != 0) {
                return n;
            }
            n = this.GetSymbol(")");
            if (n != 0) {
                return n;
            }
        } else {
            bl = true;
        }
        if ((n = this.GetIdent("oj")) != 0) {
            return n;
        }
        n = this.ParseOJ(sQLNodeRef, sQLNodeRef2);
        if (n != 0) {
            return n;
        }
        if (!bl) {
            n = this.GetSymbol("*");
            if (n != 0) {
                return n;
            }
            n = this.GetSymbol(")");
            if (n != 0) {
                return n;
            }
            n = this.GetSymbol("--");
            if (n != 0) {
                return n;
            }
        } else {
            n = this.GetSymbol("}");
            if (n != 0) {
                return n;
            }
        }
        return 0;
    }

    int ParseNot(SQLNodeRef sQLNodeRef) {
        SQLNodeRef sQLNodeRef2 = new SQLNodeRef();
        int n = this.m_idxSqlStr;
        int n2 = this.m_cntSqlStr;
        int n3 = this.GetKeyword("NOT");
        if (n3 != 0) {
            this.m_idxSqlStr = n;
            this.m_cntSqlStr = n2;
            n3 = this.ParseComparison(sQLNodeRef);
            if (n3 != 0) {
                return n3;
            }
        } else {
            n3 = this.ParseComparison(sQLNodeRef2);
            if (n3 != 0) {
                return n3;
            }
            SQLNodeBoolean sQLNodeBoolean = new SQLNodeBoolean();
            sQLNodeRef.node = sQLNodeBoolean;
            sQLNodeBoolean.Operator = 16;
            sQLNodeBoolean.Left = sQLNodeRef2.node;
            sQLNodeBoolean.Right = null;
        }
        return 0;
    }

    int ParseComparison(SQLNodeRef sQLNodeRef) {
        SQLNodeRef sQLNodeRef2 = new SQLNodeRef();
        SQLNodeRef sQLNodeRef3 = new SQLNodeRef();
        int n = this.m_idxSqlStr;
        int n2 = this.m_cntSqlStr;
        int n3 = this.GetSymbol("(");
        if (n3 == 0 && (n3 = this.ParseBoolean(sQLNodeRef)) == 0) {
            n3 = this.GetSymbol(")");
        }
        if (n3 != 0) {
            int n4;
            int n5;
            this.m_idxSqlStr = n;
            this.m_cntSqlStr = n2;
            n3 = this.GetKeyword("EXISTS");
            if (n3 == 0) {
                n3 = this.GetSymbol("(");
                if (n3 != 0) {
                    return n3;
                }
                n3 = this.GetKeyword("SELECT");
                if (n3 != 0) {
                    return n3;
                }
                n3 = this.ParseSelect(sQLNodeRef2);
                if (n3 != 0) {
                    return n3;
                }
                n3 = this.GetSymbol(")");
                if (n3 != 0) {
                    return n3;
                }
                n5 = 19;
                sQLNodeRef3.node = null;
                n4 = 4;
            } else {
                n4 = 0;
                this.m_idxSqlStr = n;
                this.m_cntSqlStr = n2;
                n3 = this.ParseExpression(sQLNodeRef2);
                if (n3 != 0) {
                    return n3;
                }
                SQLNode sQLNode = sQLNodeRef2.node;
                if (sQLNode.sqlNodeType == 21) {
                    n = this.m_idxSqlStr;
                    n2 = this.m_cntSqlStr;
                    n3 = this.GetKeyword("IS");
                    if (n3 == 0) {
                        n3 = this.GetKeyword(null);
                        if (n3 != 0) {
                            return n3;
                        }
                        if (this.m_currentToken.equalsIgnoreCase("NOT")) {
                            n5 = 2;
                            n3 = this.GetKeyword(null);
                            if (n3 != 0) {
                                return n3;
                            }
                        } else {
                            n5 = 1;
                        }
                        if (!this.m_currentToken.equalsIgnoreCase("NULL")) {
                            this.m_errorMsg = "NULL";
                            return 1015;
                        }
                        sQLNodeRef3.node = new SQLNodeNull();
                    } else {
                        this.m_idxSqlStr = n;
                        this.m_cntSqlStr = n2;
                        n5 = 0;
                    }
                } else {
                    n5 = 0;
                }
                if (n5 == 0) {
                    n = this.m_idxSqlStr;
                    n2 = this.m_cntSqlStr;
                    n3 = this.GetSymbol(null);
                    if (n3 == 0) {
                        if (this.m_currentToken.equalsIgnoreCase(">")) {
                            n5 = 6;
                        } else if (this.m_currentToken.equalsIgnoreCase(">=")) {
                            n5 = 5;
                        } else if (this.m_currentToken.equalsIgnoreCase("<")) {
                            n5 = 4;
                        } else if (this.m_currentToken.equalsIgnoreCase("<=")) {
                            n5 = 3;
                        } else if (this.m_currentToken.equalsIgnoreCase("=")) {
                            n5 = 1;
                        } else if (this.m_currentToken.equalsIgnoreCase("<>")) {
                            n5 = 2;
                        } else {
                            this.m_errorMsg = "=, <>, <, <=, >, or >=";
                            return 1015;
                        }
                        n = this.m_idxSqlStr;
                        n2 = this.m_cntSqlStr;
                        n3 = this.GetKeyword("ALL");
                        if (n3 != 0) {
                            this.m_idxSqlStr = n;
                            this.m_cntSqlStr = n2;
                            n3 = this.GetKeyword("ANY");
                            if (n3 != 0) {
                                this.m_idxSqlStr = n;
                                this.m_cntSqlStr = n2;
                            } else {
                                n4 = 2;
                            }
                        } else {
                            n4 = 1;
                        }
                        n = this.m_idxSqlStr;
                        n2 = this.m_cntSqlStr;
                        n3 = this.GetSymbol("(");
                        if (n3 == 0) {
                            n3 = this.GetKeyword("SELECT");
                            if (n3 == 0) {
                                ++this.m_SubSelectCount;
                                n3 = this.ParseSelect(sQLNodeRef3);
                                if (n3 != 0) {
                                    return n3;
                                }
                                n3 = this.GetSymbol(")");
                                if (n3 != 0) {
                                    return n3;
                                }
                                if (n4 == 0) {
                                    n4 = 3;
                                }
                            } else {
                                this.m_idxSqlStr = n;
                                this.m_cntSqlStr = n2;
                            }
                        } else {
                            this.m_idxSqlStr = n;
                            this.m_cntSqlStr = n2;
                        }
                        if (n4 == 0 && n3 != 0 && (n3 = this.ParseExpression(sQLNodeRef3)) != 0) {
                            return n3;
                        }
                    } else {
                        this.m_idxSqlStr = n;
                        this.m_cntSqlStr = n2;
                        n3 = this.GetKeyword(null);
                        if (n3 != 0) {
                            return n3;
                        }
                        if (this.m_currentToken.equalsIgnoreCase("NOT")) {
                            n = this.m_idxSqlStr;
                            n2 = this.m_cntSqlStr;
                            n3 = this.GetKeyword("LIKE");
                            if (n3 != 0) {
                                this.m_idxSqlStr = n;
                                this.m_cntSqlStr = n2;
                                n3 = this.GetKeyword("IN");
                                if (n3 != 0) {
                                    return n3;
                                }
                                n5 = 8;
                            } else {
                                n5 = 10;
                            }
                        } else if (this.m_currentToken.equalsIgnoreCase("LIKE")) {
                            n5 = 9;
                        } else if (this.m_currentToken.equalsIgnoreCase("IN")) {
                            n5 = 7;
                        } else {
                            this.m_errorMsg = "IN, NOT IN, LIKE, or NOT LIKE";
                            return 1015;
                        }
                        switch (n5) {
                            case 7: 
                            case 8: {
                                n3 = this.GetSymbol("(");
                                if (n3 != 0) {
                                    return n3;
                                }
                                n = this.m_idxSqlStr;
                                n2 = this.m_cntSqlStr;
                                n3 = this.GetKeyword("SELECT");
                                if (n3 == 0) {
                                    ++this.m_SubSelectCount;
                                    n3 = this.ParseSelect(sQLNodeRef3);
                                    if (n3 != 0) {
                                        return n3;
                                    }
                                } else {
                                    this.m_idxSqlStr = n;
                                    this.m_cntSqlStr = n2;
                                    n3 = this.ParseValuelist(sQLNodeRef3);
                                    if (n3 != 0) {
                                        return n3;
                                    }
                                }
                                if ((n3 = this.GetSymbol(")")) == 0) break;
                                return n3;
                            }
                            case 9: 
                            case 10: {
                                n3 = this.ParsePattern(sQLNodeRef3);
                                if (n3 == 0) break;
                                return n3;
                            }
                            default: {
                                return 1019;
                            }
                        }
                    }
                }
            }
            sQLNodeRef.node = new SQLNodeComparison();
            ((SQLNodeComparison)sQLNodeRef.node).Operator = n5;
            ((SQLNodeComparison)sQLNodeRef.node).SelectModifier = n4;
            ((SQLNodeComparison)sQLNodeRef.node).Left = sQLNodeRef2.node;
            ((SQLNodeComparison)sQLNodeRef.node).Right = sQLNodeRef3.node;
        }
        return 0;
    }

    int ParseAnd(SQLNodeRef sQLNodeRef) {
        SQLNodeRef sQLNodeRef2 = new SQLNodeRef();
        SQLNodeRef sQLNodeRef3 = new SQLNodeRef();
        int n = this.ParseNot(sQLNodeRef2);
        if (n != 0) {
            return n;
        }
        int n2 = this.m_idxSqlStr;
        int n3 = this.m_cntSqlStr;
        n = this.GetKeyword("AND");
        if (n != 0) {
            this.m_idxSqlStr = n2;
            this.m_cntSqlStr = n3;
            sQLNodeRef.node = sQLNodeRef2.node;
        } else {
            n = this.ParseAnd(sQLNodeRef3);
            if (n != 0) {
                return n;
            }
            SQLNodeBoolean sQLNodeBoolean = new SQLNodeBoolean();
            sQLNodeRef.node = sQLNodeBoolean;
            sQLNodeBoolean.Operator = 17;
            sQLNodeBoolean.Left = sQLNodeRef2.node;
            sQLNodeBoolean.Right = sQLNodeRef3.node;
        }
        return 0;
    }

    int ParseGroupBy(SQLNodeRef sQLNodeRef) {
        int n = this.m_idxSqlStr;
        int n2 = this.m_cntSqlStr;
        int n3 = this.GetKeyword("GROUP");
        if (n3 == 0) {
            n3 = this.GetKeyword("BY");
            if (n3 != 0) {
                return n3;
            }
            this.m_errorMsg = "\"Group By\"";
            return 1;
        }
        this.m_idxSqlStr = n;
        this.m_cntSqlStr = n2;
        sQLNodeRef.node = null;
        return 0;
    }

    int ParseBoolean(SQLNodeRef sQLNodeRef) {
        SQLNodeRef sQLNodeRef2 = new SQLNodeRef();
        SQLNodeRef sQLNodeRef3 = new SQLNodeRef();
        int n = this.ParseAnd(sQLNodeRef2);
        if (n != 0) {
            return n;
        }
        int n2 = this.m_idxSqlStr;
        int n3 = this.m_cntSqlStr;
        n = this.GetKeyword("OR");
        if (n != 0) {
            this.m_idxSqlStr = n2;
            this.m_cntSqlStr = n3;
            sQLNodeRef.node = sQLNodeRef2.node;
        } else {
            n = this.ParseBoolean(sQLNodeRef3);
            if (n != 0) {
                return n;
            }
            SQLNodeBoolean sQLNodeBoolean = new SQLNodeBoolean();
            sQLNodeRef.node = sQLNodeBoolean;
            sQLNodeBoolean.Operator = 18;
            sQLNodeBoolean.Left = sQLNodeRef2.node;
            sQLNodeBoolean.Right = sQLNodeRef3.node;
        }
        return 0;
    }

    int ParseTablelist(SQLNodeRef sQLNodeRef) {
        boolean bl;
        SQLNodeRef sQLNodeRef2 = new SQLNodeRef();
        SQLNodeRef sQLNodeRef3 = new SQLNodeRef();
        SQLNodeRef sQLNodeRef4 = new SQLNodeRef();
        int n = this.m_idxSqlStr;
        int n2 = this.m_cntSqlStr;
        int n3 = this.ParseOuterJoin(sQLNodeRef, sQLNodeRef4);
        if (n3 != 0) {
            this.m_idxSqlStr = n;
            this.m_cntSqlStr = n2;
            n3 = this.ParseTableref(sQLNodeRef3);
            if (n3 != 0) {
                return n3;
            }
            bl = false;
        } else {
            bl = true;
        }
        n = this.m_idxSqlStr;
        n2 = this.m_cntSqlStr;
        n3 = this.GetSymbol(",");
        if (n3 != 0) {
            this.m_idxSqlStr = n;
            this.m_cntSqlStr = n2;
            sQLNodeRef2.node = null;
        } else {
            n3 = this.ParseTablelist(sQLNodeRef2);
            if (n3 != 0) {
                return n3;
            }
        }
        if (!bl) {
            SQLNodeTables sQLNodeTables = new SQLNodeTables();
            sQLNodeRef.node = sQLNodeTables;
            sQLNodeTables.Table = (SQLNodeTable)sQLNodeRef3.node;
            sQLNodeTables.Next = (SQLNodeTables)sQLNodeRef2.node;
        } else if (sQLNodeRef2.node != null) {
            ((SQLNodeTables)sQLNodeRef4.node).Next = (SQLNodeTables)sQLNodeRef2.node;
        }
        return 0;
    }

    int ParseSelect(SQLNodeRef sQLNodeRef) {
        BooleanRef booleanRef = new BooleanRef();
        SQLNodeRef sQLNodeRef2 = new SQLNodeRef();
        SQLNodeRef sQLNodeRef3 = new SQLNodeRef();
        SQLNodeRef sQLNodeRef4 = new SQLNodeRef();
        SQLNodeRef sQLNodeRef5 = new SQLNodeRef();
        SQLNodeRef sQLNodeRef6 = new SQLNodeRef();
        int n = this.ParseSelectcols(sQLNodeRef2, booleanRef);
        if (n != 0) {
            return n;
        }
        n = this.GetKeyword("FROM");
        if (n != 0) {
            return n;
        }
        n = this.ParseTablelist(sQLNodeRef3);
        if (n != 0) {
            return n;
        }
        this.m_selectNodeSub[this.m_SubSelectCount] = new SQLNodeSelect();
        this.m_selectNodeSub[this.m_SubSelectCount].Tables = (SQLNodeTables)sQLNodeRef3.node;
        SQLNodeTables sQLNodeTables = null;
        SQLNodeTables sQLNodeTables2 = null;
        sQLNodeTables = this.m_selectNodeSub[this.m_SubSelectCount].Tables;
        while (sQLNodeTables.Table.Name != null) {
            int n2 = this.m_SubSelectCount;
            while (n2 > 0) {
                sQLNodeTables2 = this.m_selectNodeSub[--n2].Tables;
                while (sQLNodeTables2.Table.Name != null) {
                    if (sQLNodeTables.Table.Name.equalsIgnoreCase(sQLNodeTables2.Table.Name)) {
                        n = 1003;
                        return n;
                    }
                    if (sQLNodeTables2.Next == null) break;
                    sQLNodeTables2 = sQLNodeTables2.Next;
                }
                sQLNodeTables2 = null;
            }
            if (sQLNodeTables.Next == null) break;
            sQLNodeTables = sQLNodeTables.Next;
        }
        sQLNodeTables = null;
        n = this.ParseWhere(sQLNodeRef4);
        if (n != 0) {
            return n;
        }
        n = this.ParseGroupBy(sQLNodeRef5);
        if (n != 0) {
            return n;
        }
        n = this.ParseHaving(sQLNodeRef6);
        if (n != 0) {
            return n;
        }
        SQLNodeSelect sQLNodeSelect = new SQLNodeSelect();
        sQLNodeRef.node = sQLNodeSelect;
        sQLNodeSelect.Distinct = booleanRef.value;
        sQLNodeSelect.Values = (SQLNodeValues)sQLNodeRef2.node;
        sQLNodeSelect.Tables = (SQLNodeTables)sQLNodeRef3.node;
        sQLNodeSelect.Predicate = sQLNodeRef4.node;
        sQLNodeSelect.Groupbycolumns = (SQLNodeGroupByColumns)sQLNodeRef5.node;
        sQLNodeSelect.Having = sQLNodeRef6.node;
        return 0;
    }

    private int ParseOrderbyterm(SQLNodeRef sQLNodeRef, BooleanRef booleanRef) {
        IntRef intRef = new IntRef();
        int n = this.m_idxSqlStr;
        int n2 = this.m_cntSqlStr;
        int n3 = this.GetInteger(intRef);
        if (n3 != 0) {
            this.m_idxSqlStr = n;
            this.m_cntSqlStr = n2;
            n3 = this.ParseColref(sQLNodeRef);
            if (n3 != 0) {
                return n3;
            }
        } else {
            SQLNodeNumeric sQLNodeNumeric = new SQLNodeNumeric();
            sQLNodeRef.node = sQLNodeNumeric;
            sQLNodeNumeric.sqlDataType = 3;
            sQLNodeNumeric.sqlSqlType = 4;
            sQLNodeNumeric.sqlPrecision = 10;
            sQLNodeNumeric.sqlScale = 0;
            sQLNodeNumeric.Value = new ValueInteger(intRef.value);
            sQLNodeNumeric.Numeric = this.m_currentToken;
        }
        n = this.m_idxSqlStr;
        n2 = this.m_cntSqlStr;
        n3 = this.GetKeyword(null);
        if (n3 != 0) {
            this.m_idxSqlStr = n;
            this.m_cntSqlStr = n2;
            booleanRef.value = false;
        } else if (this.m_currentToken.equalsIgnoreCase("ASC")) {
            booleanRef.value = false;
        } else if (this.m_currentToken.equalsIgnoreCase("DESC")) {
            booleanRef.value = true;
        } else {
            this.m_idxSqlStr = n;
            this.m_cntSqlStr = n2;
            booleanRef.value = false;
        }
        return 0;
    }

    private int ParseOrderbyterms(SQLNodeRef sQLNodeRef) {
        int n;
        int n2;
        int n3;
        BooleanRef booleanRef = new BooleanRef();
        SQLNodeRef sQLNodeRef2 = new SQLNodeRef();
        SQLNodeSortColumns sQLNodeSortColumns = null;
        do {
            if ((n3 = this.ParseOrderbyterm(sQLNodeRef2, booleanRef)) != 0) {
                return n3;
            }
            SQLNodeSortColumns sQLNodeSortColumns2 = new SQLNodeSortColumns();
            sQLNodeSortColumns2.Column = (SQLNodeColumn)sQLNodeRef2.node;
            sQLNodeSortColumns2.Descending = booleanRef.value;
            sQLNodeSortColumns2.Next = null;
            if (sQLNodeSortColumns != null) {
                sQLNodeSortColumns.Next = sQLNodeSortColumns2;
            } else {
                sQLNodeRef.node = sQLNodeSortColumns2;
            }
            sQLNodeSortColumns = sQLNodeSortColumns2;
            n2 = this.m_idxSqlStr;
            n = this.m_cntSqlStr;
        } while ((n3 = this.GetSymbol(",")) == 0);
        this.m_idxSqlStr = n2;
        this.m_cntSqlStr = n;
        return 0;
    }

    private int ParseOrderby(SQLNodeRef sQLNodeRef) {
        int n = this.m_idxSqlStr;
        int n2 = this.m_cntSqlStr;
        int n3 = this.GetKeyword("ORDER");
        if (n3 != 0) {
            this.m_idxSqlStr = n;
            this.m_cntSqlStr = n2;
            sQLNodeRef.node = null;
        } else {
            n3 = this.GetKeyword("BY");
            if (n3 != 0) {
                return n3;
            }
            n3 = this.ParseOrderbyterms(sQLNodeRef);
            if (n3 != 0) {
                return n3;
            }
        }
        return 0;
    }

    int KeywordOrIdentifier(String string) {
        int n = 0;
        while (n < s_keyWords.length) {
            if (string.equalsIgnoreCase(s_keyWords[n])) {
                return 5;
            }
            ++n;
        }
        return 4;
    }

    int GetEscape() {
        int n = this.m_cntSqlStr;
        int n2 = this.m_idxSqlStr;
        while (n != 0 && (this.m_sqlBuf[n2] == ' ' || this.m_sqlBuf[n2] == '\n' || this.m_sqlBuf[n2] == '\r' || this.m_sqlBuf[n2] == '\t')) {
            ++n2;
            --n;
        }
        if (n == 0) {
            this.m_currentToken = "";
            this.m_idxSqlStr = n2;
            this.m_cntSqlStr = n;
            return 1013;
        }
        int n3 = n2;
        int n4 = 0;
        int n5 = 1;
        switch (this.m_sqlBuf[n2]) {
            case '{': {
                while (true) {
                    if (n == 0) {
                        return 1013;
                    }
                    if (this.m_sqlBuf[n2] == '}') {
                        this.m_currentToken = new String(this.m_sqlBuf, n3, ++n4);
                        this.m_idxSqlStr = ++n2;
                        this.m_cntSqlStr = --n;
                        return 0;
                    }
                    if (n5 >= 255) {
                        this.m_errorMsg = this.m_currentToken = new String(this.m_sqlBuf, n3, n4);
                        return 1014;
                    }
                    ++n5;
                    ++n4;
                    ++n2;
                    --n;
                }
            }
            case '-': {
                if (n > 1 && this.m_sqlBuf[n2 + 1] == '-') {
                    ++n4;
                    ++n2;
                    --n;
                    n5 = 0;
                    while (true) {
                        if (n == 0) {
                            return 1013;
                        }
                        if (this.m_sqlBuf[n2] == '-' && n > 1 && this.m_sqlBuf[n2 + 1] == '-') {
                            this.m_currentToken = new String(this.m_sqlBuf, n3, n4 += 2);
                            this.m_idxSqlStr = n2 -= 2;
                            this.m_cntSqlStr = n -= 2;
                            return 0;
                        }
                        if (n5 >= 254) {
                            this.m_errorMsg = this.m_currentToken = new String(this.m_sqlBuf, n3, n4);
                            return 1014;
                        }
                        ++n5;
                        ++n4;
                        ++n2;
                        --n;
                    }
                }
                return 1013;
            }
        }
        this.m_errorMsg = "<escape-sequence>";
        return 1015;
    }

    String removeAdjacentSingleQuotes(String string) {
        int n = 0;
        int n2 = 0;
        int n3 = string.indexOf("''");
        if (n3 == -1) {
            return string;
        }
        char[] cArray = new char[string.length()];
        while (n3 != -1) {
            string.getChars(n, n3 + 1, cArray, n2);
            n2 += n3 + 1 - n;
            n = n3 + 2;
            n3 = string.indexOf("''", n);
        }
        string.getChars(n, string.length(), cArray, n2);
        return new String(cArray, 0, n2 + (string.length() - n));
    }

    int GetToken() {
        int n = 0;
        int n2 = this.m_cntSqlStr;
        int n3 = this.m_idxSqlStr;
        while (n2 != 0 && Character.isWhitespace(this.m_sqlBuf[n3])) {
            ++n3;
            --n2;
        }
        if (n2 == 0) {
            this.m_cntSqlStr = n2;
            this.m_idxSqlStr = n3;
            this.m_tokenType = 0;
            this.m_currentToken = "";
            return 0;
        }
        switch (this.m_sqlBuf[n3]) {
            case '(': 
            case ')': 
            case '*': 
            case '+': 
            case ',': 
            case '/': 
            case '=': 
            case '?': 
            case '{': 
            case '}': {
                this.m_currentToken = new String(this.m_sqlBuf, n3, 1);
                this.m_cntSqlStr = --n2;
                this.m_idxSqlStr = ++n3;
                this.m_tokenType = 1;
                return 0;
            }
            case '-': {
                int n4 = n3++;
                n = 1;
                if (--n2 != 0 && this.m_sqlBuf[n3] == '-') {
                    ++n;
                    ++n3;
                    --n2;
                }
                this.m_currentToken = new String(this.m_sqlBuf, n4, n);
                this.m_idxSqlStr = n3;
                this.m_cntSqlStr = n2;
                this.m_tokenType = 1;
                return 0;
            }
            case '<': {
                int n5 = n3++;
                n = 1;
                if (--n2 != 0 && (this.m_sqlBuf[n3] == '=' || this.m_sqlBuf[n3] == '>')) {
                    ++n;
                    ++n3;
                    --n2;
                }
                this.m_currentToken = new String(this.m_sqlBuf, n5, n);
                this.m_idxSqlStr = n3;
                this.m_cntSqlStr = n2;
                this.m_tokenType = 1;
                return 0;
            }
            case '>': {
                int n6 = n3++;
                n = 1;
                if (--n2 != 0 && this.m_sqlBuf[n3] == '=') {
                    ++n;
                    ++n3;
                    --n2;
                }
                this.m_currentToken = new String(this.m_sqlBuf, n6, n);
                this.m_idxSqlStr = n3;
                this.m_cntSqlStr = n2;
                this.m_tokenType = 1;
                return 0;
            }
            case '.': {
                if (n2 == 1) {
                    this.m_currentToken = new String(this.m_sqlBuf, n3, 1);
                    ++this.m_idxSqlStr;
                    --this.m_cntSqlStr;
                    this.m_tokenType = 1;
                    return 0;
                }
                switch (this.m_sqlBuf[n3 + 1]) {
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        break;
                    }
                    default: {
                        this.m_currentToken = new String(this.m_sqlBuf, n3, 1);
                        ++this.m_idxSqlStr;
                        --this.m_cntSqlStr;
                        this.m_tokenType = 1;
                        return 0;
                    }
                }
            }
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                int n7 = n3;
                int n8 = 0;
                n = 0;
                boolean bl = false;
                boolean bl2 = false;
                while (true) {
                    if (n2 == 0) {
                        this.m_currentToken = new String(this.m_sqlBuf, n7, n);
                        this.m_idxSqlStr = n3;
                        this.m_cntSqlStr = n2;
                        this.m_tokenType = 2;
                        return 0;
                    }
                    switch (this.m_sqlBuf[n3]) {
                        case '.': {
                            if (bl || bl2) {
                                this.m_errorMsg = this.m_currentToken = new String(this.m_sqlBuf, n7, n);
                                return 1016;
                            }
                            bl = true;
                        }
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': {
                            break;
                        }
                        case 'E': 
                        case 'e': {
                            if (bl2) {
                                this.m_errorMsg = this.m_currentToken = new String(this.m_sqlBuf, n7, n);
                                return 1016;
                            }
                            bl2 = true;
                            if (n2 > 1 && (this.m_sqlBuf[n2 + 1] == '+' || this.m_sqlBuf[n2 + 1] == '-')) {
                                if (n8 >= 255) {
                                    this.m_errorMsg = this.m_currentToken = new String(this.m_sqlBuf, n7, n);
                                    return 1014;
                                }
                                ++n8;
                                ++n;
                                --n2;
                                ++n3;
                            }
                            if (n2 >= 2) break;
                            this.m_errorMsg = this.m_currentToken = new String(this.m_sqlBuf, n7, n);
                            return 1016;
                        }
                        default: {
                            this.m_currentToken = new String(this.m_sqlBuf, n7, n);
                            this.m_idxSqlStr = n3;
                            this.m_cntSqlStr = n2;
                            this.m_tokenType = 2;
                            return 0;
                        }
                    }
                    if (n8 >= 255) {
                        this.m_errorMsg = this.m_currentToken = new String(this.m_sqlBuf, n7, n);
                        return 1014;
                    }
                    ++n8;
                    ++n;
                    ++n3;
                    --n2;
                }
            }
            case '\'': {
                --n2;
                int n9 = ++n3;
                n = 0;
                int n10 = 0;
                while (true) {
                    if (n2 == 0) {
                        return 1013;
                    }
                    switch (this.m_sqlBuf[n3]) {
                        case '\u0000': {
                            return 1013;
                        }
                        case '\'': {
                            if (--n2 != 0 && this.m_sqlBuf[++n3] == '\'') {
                                ++n;
                            }
                            if (n2 != 0 && this.m_sqlBuf[n3] == '\'') break;
                            this.m_currentToken = new String(this.m_sqlBuf, n9, n);
                            this.m_currentToken = this.removeAdjacentSingleQuotes(this.m_currentToken);
                            this.m_idxSqlStr = n3;
                            this.m_cntSqlStr = n2;
                            this.m_tokenType = 3;
                            return 0;
                        }
                    }
                    if (n10 >= 255) {
                        this.m_errorMsg = this.m_currentToken = new String(this.m_sqlBuf, n9, n);
                        return 1014;
                    }
                    ++n10;
                    ++n;
                    ++n3;
                    --n2;
                }
            }
            case '\"': {
                --n2;
                int n11 = ++n3;
                n = 0;
                int n12 = 0;
                while (n2 != 0) {
                    switch (this.m_sqlBuf[n3]) {
                        case '\"': {
                            this.m_currentToken = new String(this.m_sqlBuf, n11, n);
                            this.m_idxSqlStr = ++n3;
                            this.m_cntSqlStr = --n2;
                            this.m_tokenType = 4;
                            return 0;
                        }
                    }
                    if (n12 >= 255) {
                        this.m_errorMsg = this.m_currentToken = new String(this.m_sqlBuf, n11, n);
                        return 1014;
                    }
                    ++n12;
                    ++n;
                    ++n3;
                    --n2;
                }
                return 1013;
            }
        }
        int n13 = n3;
        n = 0;
        int n14 = 0;
        while (true) {
            if (n2 == 0) {
                this.m_currentToken = new String(this.m_sqlBuf, n13, n);
                this.m_idxSqlStr = n3;
                this.m_cntSqlStr = n2;
                this.m_tokenType = this.KeywordOrIdentifier(this.m_currentToken);
                return 0;
            }
            switch (this.m_sqlBuf[n3]) {
                case '\u0000': 
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case ',': 
                case '-': 
                case '.': 
                case '/': 
                case '<': 
                case '=': 
                case '>': 
                case '?': 
                case '{': 
                case '}': {
                    this.m_currentToken = new String(this.m_sqlBuf, n13, n);
                    this.m_idxSqlStr = n3;
                    this.m_cntSqlStr = n2;
                    this.m_tokenType = this.KeywordOrIdentifier(this.m_currentToken);
                    return 0;
                }
            }
            if (n14 >= 255) {
                this.m_errorMsg = this.m_currentToken = new String(this.m_sqlBuf, n13, n);
                return 1014;
            }
            ++n14;
            ++n;
            ++n3;
            --n2;
        }
    }

    int GetKeyword(String string) {
        int n = this.m_cntSqlStr;
        int n2 = this.m_idxSqlStr;
        while (n != 0 && Character.isWhitespace(this.m_sqlBuf[n2])) {
            ++n2;
            --n;
        }
        if (n == 0) {
            return 1013;
        }
        if (this.m_sqlBuf[n2] == '\"') {
            this.m_errorMsg = string == null ? "<keyword>" : string;
            return 1015;
        }
        int n3 = this.GetToken();
        if (n3 != 0) {
            return n3;
        }
        if (this.m_tokenType != 5) {
            this.m_errorMsg = string == null ? "<keyword>" : string;
            return 1015;
        }
        if (string != null && !string.equalsIgnoreCase(this.m_currentToken)) {
            this.m_errorMsg = string;
            return 1015;
        }
        return 0;
    }

    public SQLNodeRoot getRootNode() {
        return this.m_parseTree;
    }
}

