/*
 * Decompiled with CFR 0.152.
 */
package com.novell.sql;

import com.novell.sql.DRDBConstants;
import com.novell.sql.Evaluate;
import com.novell.sql.LDAPSQLExceptionCodes;
import com.novell.sql.LDAPStatement;
import com.novell.sql.LdapIsam;
import com.novell.sql.SQLErrorCodes;
import com.novell.sql.SQLNode;
import com.novell.sql.SQLNodeColumn;
import com.novell.sql.SQLNodeScalar;
import com.novell.sql.SQLNodeValues;
import com.novell.sql.ScalarFunc;
import com.novell.sql.Semantic;
import com.novell.sql.ValueBinary;
import com.novell.sql.ValueChar;
import com.novell.sql.ValueDate;
import com.novell.sql.ValueDecimal;
import com.novell.sql.ValueDouble;
import com.novell.sql.ValueInteger;
import com.novell.sql.ValueTime;
import com.novell.sql.ValueTimestamp;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;

class Scalar
implements SQLErrorCodes,
LDAPSQLExceptionCodes,
DRDBConstants {
    public static final int MAX_SCALAR_ARGS = 4;
    public static final int SCALAR_ASCII = 0;
    public static final int SCALAR_CHAR = 1;
    public static final int SCALAR_CONCAT = 2;
    public static final int SCALAR_DIFFERENCE = 3;
    public static final int SCALAR_INSERT = 4;
    public static final int SCALAR_LCASE = 5;
    public static final int SCALAR_LEFT = 6;
    public static final int SCALAR_LENGTH = 7;
    public static final int SCALAR_LOCATE = 8;
    public static final int SCALAR_LOCATE_START = 9;
    public static final int SCALAR_LTRIM = 10;
    public static final int SCALAR_REPEAT = 11;
    public static final int SCALAR_REPLACE = 12;
    public static final int SCALAR_RIGHT = 13;
    public static final int SCALAR_RTRIM = 14;
    public static final int SCALAR_SOUNDEX = 15;
    public static final int SCALAR_SPACE = 16;
    public static final int SCALAR_SUBSTRING = 17;
    public static final int SCALAR_UCASE = 18;
    public static final int SCALAR_ABS_DOUBLE = 19;
    public static final int SCALAR_ABS_NUMERIC = 20;
    public static final int SCALAR_ABS_INTEGER = 21;
    public static final int SCALAR_ACOS = 22;
    public static final int SCALAR_ASIN = 23;
    public static final int SCALAR_ATAN = 24;
    public static final int SCALAR_ATAN2 = 25;
    public static final int SCALAR_CEILING_DOUBLE = 26;
    public static final int SCALAR_CEILING_NUMERIC = 27;
    public static final int SCALAR_CEILING_INTEGER = 28;
    public static final int SCALAR_COS = 29;
    public static final int SCALAR_COT = 30;
    public static final int SCALAR_DEGREES_DOUBLE = 31;
    public static final int SCALAR_DEGREES_NUMERIC = 32;
    public static final int SCALAR_DEGREES_INTEGER = 33;
    public static final int SCALAR_EXP = 34;
    public static final int SCALAR_FLOOR_DOUBLE = 35;
    public static final int SCALAR_FLOOR_NUMERIC = 36;
    public static final int SCALAR_FLOOR_INTEGER = 37;
    public static final int SCALAR_LOG = 38;
    public static final int SCALAR_LOG10 = 39;
    public static final int SCALAR_MOD = 40;
    public static final int SCALAR_PI = 41;
    public static final int SCALAR_POWER_DOUBLE = 42;
    public static final int SCALAR_POWER_NUMERIC = 43;
    public static final int SCALAR_POWER_INTEGER = 44;
    public static final int SCALAR_RADIANS_DOUBLE = 45;
    public static final int SCALAR_RADIANS_NUMERIC = 46;
    public static final int SCALAR_RADIANS_INTEGER = 47;
    public static final int SCALAR_RAND = 48;
    public static final int SCALAR_RAND_SEED_DOUBLE = 49;
    public static final int SCALAR_RAND_SEED_NUMERIC = 50;
    public static final int SCALAR_RAND_SEED_INTEGER = 51;
    public static final int SCALAR_ROUND_DOUBLE = 52;
    public static final int SCALAR_ROUND_NUMERIC = 53;
    public static final int SCALAR_ROUND_INTEGER = 54;
    public static final int SCALAR_SIGN_DOUBLE = 55;
    public static final int SCALAR_SIGN_NUMERIC = 56;
    public static final int SCALAR_SIGN_INTEGER = 57;
    public static final int SCALAR_SIN = 58;
    public static final int SCALAR_SQRT = 59;
    public static final int SCALAR_TAN = 60;
    public static final int SCALAR_TRUNCATE_DOUBLE = 61;
    public static final int SCALAR_TRUNCATE_NUMERIC = 62;
    public static final int SCALAR_TRUNCATE_INTEGER = 63;
    public static final int SCALAR_CURDATE = 64;
    public static final int SCALAR_CURTIME = 65;
    public static final int SCALAR_DAYNAME = 66;
    public static final int SCALAR_DAYOFMONTH_CHAR = 67;
    public static final int SCALAR_DAYOFMONTH_DATE = 68;
    public static final int SCALAR_DAYOFMONTH_TIMESTAMP = 69;
    public static final int SCALAR_DAYOFWEEK = 70;
    public static final int SCALAR_DAYOFYEAR = 71;
    public static final int SCALAR_HOUR_CHAR = 72;
    public static final int SCALAR_HOUR_TIME = 73;
    public static final int SCALAR_HOUR_TIMESTAMP = 74;
    public static final int SCALAR_MINUTE_CHAR = 75;
    public static final int SCALAR_MINUTE_TIME = 76;
    public static final int SCALAR_MINUTE_TIMESTAMP = 77;
    public static final int SCALAR_MONTH_CHAR = 78;
    public static final int SCALAR_MONTH_DATE = 79;
    public static final int SCALAR_MONTH_TIMESTAMP = 80;
    public static final int SCALAR_MONTHNAME_CHAR = 81;
    public static final int SCALAR_MONTHNAME_DATE = 82;
    public static final int SCALAR_MONTHNAME_TIMESTAMP = 83;
    public static final int SCALAR_NOW = 84;
    public static final int SCALAR_QUARTER_CHAR = 85;
    public static final int SCALAR_QUARTER_DATE = 86;
    public static final int SCALAR_QUARTER_TIMESTAMP = 87;
    public static final int SCALAR_SECOND_CHAR = 88;
    public static final int SCALAR_SECOND_TIME = 89;
    public static final int SCALAR_SECOND_TIMESTAMP = 90;
    public static final int SCALAR_TIMESTAMPADD = 91;
    public static final int SCALAR_TIMESTAMPDIFF = 92;
    public static final int SCALAR_WEEK = 93;
    public static final int SCALAR_YEAR_CHAR = 94;
    public static final int SCALAR_YEAR_DATE = 95;
    public static final int SCALAR_YEAR_TIMESTAMP = 96;
    public static final int SCALAR_DATABASE = 97;
    public static final int SCALAR_IFNULL = 98;
    public static final int SCALAR_USER = 99;
    public static final int SCALAR_CONVERT = 100;
    public static final int SCALAR_GETSEPARATOR = 101;
    public static final int SCALAR_SETSEPARATOR = 102;
    public static final int SCALAR_GETCONTEXT = 103;
    static ScalarFunc[] scalarFuncs = new ScalarFunc[]{new ScalarFunc("ASCII", 3, -6, 3, 0, 1, 8), new ScalarFunc("CHAR", 8, 1, 1, 0, 1, 3), new ScalarFunc("CONCAT", 8, 12, 0, 0, 2, 8, 8), new ScalarFunc("DIFFERENCE", 3, 4, 10, 0, 2, 8, 8), new ScalarFunc("INSERT", 8, 12, 255, 0, 4, 8, 3, 3, 8), new ScalarFunc("LCASE", 8, 0, 0, 0, 1, 8), new ScalarFunc("LEFT", 8, 12, 0, 0, 2, 8, 3), new ScalarFunc("LENGTH", 3, 5, 5, 0, 1, 8), new ScalarFunc("LOCATE", 3, 5, 5, 0, 2, 8, 8), new ScalarFunc("LOCATE", 3, 5, 5, 0, 3, 8, 8, 3), new ScalarFunc("LTRIM", 8, 12, 0, 0, 1, 8), new ScalarFunc("REPEAT", 8, 12, 255, 0, 2, 8, 3), new ScalarFunc("REPLACE", 8, 12, 255, 0, 3, 8, 8, 8), new ScalarFunc("RIGHT", 8, 12, 0, 0, 2, 8, 3), new ScalarFunc("RTRIM", 8, 12, 0, 0, 1, 8), new ScalarFunc("SOUNDEX", 8, 12, 255, 0, 1, 8), new ScalarFunc("SPACE", 8, 12, 255, 0, 1, 3), new ScalarFunc("SUBSTRING", 8, 12, 0, 0, 3, 8, 3, 3), new ScalarFunc("UCASE", 8, 0, 0, 0, 1, 8), new ScalarFunc("ABS", 6, 0, 0, 0, 1, 6), new ScalarFunc("ABS", 7, 0, 0, 0, 1, 7), new ScalarFunc("ABS", 3, 0, 0, 0, 1, 3), new ScalarFunc("ACOS", 6, 6, 15, -1, 1, 6), new ScalarFunc("ASIN", 6, 6, 15, -1, 1, 6), new ScalarFunc("ATAN", 6, 6, 15, -1, 1, 6), new ScalarFunc("ATAN2", 6, 6, 15, -1, 2, 6, 6), new ScalarFunc("CEILING", 6, 0, 0, 0, 1, 6), new ScalarFunc("CEILING", 7, 0, 0, 0, 1, 7), new ScalarFunc("CEILING", 3, 0, 0, 0, 1, 3), new ScalarFunc("COS", 6, 6, 15, -1, 1, 6), new ScalarFunc("COT", 6, 6, 15, -1, 1, 6), new ScalarFunc("DEGREES", 6, 6, 15, -1, 1, 6), new ScalarFunc("DEGREES", 6, 6, 15, -1, 1, 7), new ScalarFunc("DEGREES", 6, 6, 15, -1, 1, 3), new ScalarFunc("EXP", 6, 6, 15, -1, 1, 6), new ScalarFunc("FLOOR", 6, 0, 0, 0, 1, 6), new ScalarFunc("FLOOR", 7, 0, 0, 0, 1, 7), new ScalarFunc("FLOOR", 3, 0, 0, 0, 1, 3), new ScalarFunc("LOG", 6, 6, 15, -1, 1, 6), new ScalarFunc("LOG10", 6, 6, 15, -1, 1, 6), new ScalarFunc("MOD", 3, 0, 0, 0, 2, 3, 3), new ScalarFunc("PI", 6, 6, 15, -1, 0), new ScalarFunc("POWER", 6, 6, 15, -1, 2, 6, 3), new ScalarFunc("POWER", 6, 6, 15, -1, 2, 7, 3), new ScalarFunc("POWER", 6, 6, 15, -1, 2, 3, 3), new ScalarFunc("RADIANS", 6, 6, 15, -1, 1, 6), new ScalarFunc("RADIANS", 6, 6, 15, -1, 1, 7), new ScalarFunc("RADIANS", 6, 6, 15, -1, 1, 3), new ScalarFunc("RAND", 6, 6, 15, -1, 0), new ScalarFunc("RAND", 6, 6, 15, -1, 1, 6), new ScalarFunc("RAND", 6, 6, 15, -1, 1, 7), new ScalarFunc("RAND", 6, 6, 15, -1, 1, 3), new ScalarFunc("ROUND", 6, 0, 0, 0, 2, 6, 3), new ScalarFunc("ROUND", 7, 0, 0, 0, 2, 7, 3), new ScalarFunc("ROUND", 3, 0, 0, 0, 2, 3, 3), new ScalarFunc("SIGN", 3, -6, 3, 0, 1, 6), new ScalarFunc("SIGN", 3, -6, 3, 0, 1, 7), new ScalarFunc("SIGN", 3, -6, 3, 0, 1, 3), new ScalarFunc("SIN", 6, 6, 15, -1, 1, 6), new ScalarFunc("SQRT", 6, 6, 15, -1, 1, 6), new ScalarFunc("TAN", 6, 6, 15, -1, 1, 6), new ScalarFunc("TRUNCATE", 6, 0, 0, 0, 2, 6, 3), new ScalarFunc("TRUNCATE", 7, 0, 0, 0, 2, 7, 3), new ScalarFunc("TRUNCATE", 3, 0, 0, 0, 2, 3, 3), new ScalarFunc("CURDATE", 9, 91, 10, -1, 0), new ScalarFunc("CURTIME", 10, 92, 8, -1, 0), new ScalarFunc("DAYNAME", 8, 12, 255, 0, 1, 1), new ScalarFunc("DAYOFMONTH", 3, -6, 3, 0, 1, 8), new ScalarFunc("DAYOFMONTH", 3, -6, 3, 0, 1, 9), new ScalarFunc("DAYOFMONTH", 3, -6, 3, 0, 1, 11), new ScalarFunc("DAYOFWEEK", 3, -6, 3, 0, 1, 1), new ScalarFunc("DAYOFYEAR", 3, 5, 5, 0, 1, 1), new ScalarFunc("HOUR", 3, -6, 3, 0, 1, 8), new ScalarFunc("HOUR", 3, -6, 3, 0, 1, 10), new ScalarFunc("HOUR", 3, -6, 3, 0, 1, 11), new ScalarFunc("MINUTE", 3, -6, 3, 0, 1, 8), new ScalarFunc("MINUTE", 3, -6, 3, 0, 1, 10), new ScalarFunc("MINUTE", 3, -6, 3, 0, 1, 11), new ScalarFunc("MONTH", 3, -6, 3, 0, 1, 8), new ScalarFunc("MONTH", 3, -6, 3, 0, 1, 9), new ScalarFunc("MONTH", 3, -6, 3, 0, 1, 11), new ScalarFunc("MONTHNAME", 8, 12, 255, 0, 1, 8), new ScalarFunc("MONTHNAME", 8, 12, 255, 0, 1, 9), new ScalarFunc("MONTHNAME", 8, 12, 255, 0, 1, 11), new ScalarFunc("NOW", 11, 93, 23, 3, 0), new ScalarFunc("QUARTER", 3, -6, 3, 0, 1, 8), new ScalarFunc("QUARTER", 3, -6, 3, 0, 1, 9), new ScalarFunc("QUARTER", 3, -6, 3, 0, 1, 11), new ScalarFunc("SECOND", 3, -6, 3, 0, 1, 8), new ScalarFunc("SECOND", 3, -6, 3, 0, 1, 10), new ScalarFunc("SECOND", 3, -6, 3, 0, 1, 11), new ScalarFunc("TIMESTAMPADD", 11, 93, 23, 3, 2, 3, 1), new ScalarFunc("TIMESTAMPDIFF", 3, 4, 10, 0, 2, 1, 1), new ScalarFunc("WEEK", 3, -6, 3, 0, 1, 1), new ScalarFunc("YEAR", 3, 4, 10, 0, 1, 8), new ScalarFunc("YEAR", 3, 4, 10, 0, 1, 9), new ScalarFunc("YEAR", 3, 4, 10, 0, 1, 11), new ScalarFunc("DATABASE", 8, 12, 127, 0, 0), new ScalarFunc("IFNULL", 8, 0, 0, 0, 2, 1, 1), new ScalarFunc("USER", 8, 12, 63, 0, 0), new ScalarFunc("CONVERT", 1, 0, 0, 0, 1, 1), new ScalarFunc("GetSeparator", 8, 1, 2, 0, 0), new ScalarFunc("SetSeparator", 8, 1, 2, 0, 1, 8), new ScalarFunc("GetContext", 8, 1, 256, 0, 0)};
    public static final int SQL_TSI_SECOND = 1;
    public static final int SQL_TSI_MINUTE = 2;
    public static final int SQL_TSI_HOUR = 3;
    public static final int SQL_TSI_DAY = 4;
    public static final int SQL_TSI_WEEK = 5;
    public static final int SQL_TSI_MONTH = 6;
    public static final int SQL_TSI_QUARTER = 7;
    public static final int SQL_TSI_YEAR = 8;
    public static final int SECONDS_PER_MINUTE = 60;
    public static final int SECONDS_PER_HOUR = 3600;
    public static final int SECONDS_PER_DAY = 86400;
    public static final int SECONDS_PER_WEEK = 604800;
    public static final int MONTHS_PER_YEAR = 12;
    public static final double PI = Math.PI;
    public static final double BIT_LOW_D = 0.0;
    public static final double BIT_HIGH_D = 1.0;
    public static final double STINY_LOW_D = -128.0;
    public static final double STINY_HIGH_D = 127.0;
    public static final double UTINY_LOW_D = 0.0;
    public static final double UTINY_HIGH_D = 255.0;
    public static final double SSHORT_LOW_D = -32768.0;
    public static final double SSHORT_HIGH_D = 32767.0;
    public static final double USHORT_LOW_D = 0.0;
    public static final double USHORT_HIGH_D = 65535.0;
    public static final double SLONG_LOW_D = -2.147483648E9;
    public static final double SLONG_HIGH_D = 2.147483647E9;
    public static final double ULONG_LOW_D = 0.0;
    public static final double ULONG_HIGH_D = 4.294967296E9;
    public static final double FLOAT_LOW_D = -3.4E38;
    public static final double FLOAT_HIGH_D = 3.4E38;
    public static final double DOUBLE_LOW_D = -1.7E308;
    public static final double DOUBLE_HIGH_D = 1.7E308;

    Scalar() {
    }

    static int MAX(int n, int n2) {
        if (n > n2) {
            return n;
        }
        return n2;
    }

    static int ScalarIfNullType(SQLNode sQLNode, SQLNode sQLNode2, SQLNode sQLNode3) {
        if (!(sQLNode.sqlDataType == sQLNode2.sqlDataType || sQLNode.sqlDataType == 6 && sQLNode2.sqlDataType == 7 || sQLNode.sqlDataType == 6 && sQLNode2.sqlDataType == 3 || sQLNode.sqlDataType == 7 && sQLNode2.sqlDataType == 6 || sQLNode.sqlDataType == 7 && sQLNode2.sqlDataType == 3 || sQLNode.sqlDataType == 3 && sQLNode2.sqlDataType == 6 || sQLNode.sqlDataType == 3 && sQLNode2.sqlDataType == 7)) {
            return 1058;
        }
        sQLNode3.sqlDataType = sQLNode.sqlDataType == 7 && sQLNode2.sqlDataType == 6 ? 6 : (sQLNode.sqlDataType == 3 && sQLNode2.sqlDataType == 6 ? 6 : (sQLNode.sqlDataType == 3 && sQLNode2.sqlDataType == 7 ? 7 : sQLNode.sqlDataType));
        block0 : switch (sQLNode.sqlSqlType) {
            case 8: {
                sQLNode3.sqlSqlType = 8;
                sQLNode3.sqlPrecision = 15;
                sQLNode3.sqlScale = -1;
                break;
            }
            case 6: {
                sQLNode3.sqlSqlType = sQLNode2.sqlSqlType == 8 ? 8 : 6;
                sQLNode3.sqlPrecision = 15;
                sQLNode3.sqlScale = -1;
                break;
            }
            case 7: {
                if (sQLNode2.sqlSqlType == 8) {
                    sQLNode3.sqlSqlType = 8;
                    sQLNode3.sqlPrecision = 15;
                } else if (sQLNode2.sqlSqlType == 6) {
                    sQLNode3.sqlSqlType = 6;
                    sQLNode3.sqlPrecision = 15;
                } else {
                    sQLNode3.sqlSqlType = 7;
                    sQLNode3.sqlPrecision = 7;
                }
                sQLNode3.sqlScale = -1;
                break;
            }
            case -7: 
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                switch (sQLNode2.sqlSqlType) {
                    case 6: 
                    case 7: 
                    case 8: {
                        sQLNode3.sqlSqlType = sQLNode2.sqlSqlType;
                        sQLNode3.sqlPrecision = sQLNode2.sqlPrecision;
                        sQLNode3.sqlScale = -1;
                        break block0;
                    }
                    case -7: 
                    case -6: 
                    case -5: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        sQLNode3.sqlSqlType = sQLNode2.sqlSqlType == 3 || sQLNode.sqlSqlType == 3 ? 3 : (sQLNode2.sqlSqlType == 2 || sQLNode.sqlSqlType == 2 ? 2 : (sQLNode2.sqlSqlType == -5 || sQLNode.sqlSqlType == -5 ? -5 : (sQLNode2.sqlSqlType == 4 || sQLNode.sqlSqlType == 4 ? 4 : (sQLNode2.sqlSqlType == 5 || sQLNode.sqlSqlType == 5 ? 5 : (sQLNode2.sqlSqlType == -6 || sQLNode.sqlSqlType == -6 ? -6 : -7)))));
                        sQLNode3.sqlScale = Scalar.MAX(sQLNode2.sqlScale, sQLNode.sqlScale);
                        sQLNode3.sqlPrecision = sQLNode3.sqlScale + Scalar.MAX(sQLNode2.sqlPrecision - sQLNode2.sqlScale, sQLNode.sqlPrecision - sQLNode.sqlScale);
                        break block0;
                    }
                    case -4: 
                    case -3: 
                    case -2: 
                    case -1: 
                    case 1: 
                    case 12: 
                    case 91: 
                    case 92: 
                    case 93: {
                        return 1019;
                    }
                }
                return 1003;
            }
            case -1: {
                return 1019;
            }
            case 1: 
            case 12: {
                sQLNode3.sqlSqlType = sQLNode2.sqlSqlType == 12 || sQLNode.sqlSqlType == 12 ? 12 : 1;
                sQLNode3.sqlPrecision = Scalar.MAX(sQLNode2.sqlPrecision, sQLNode.sqlPrecision);
                sQLNode3.sqlScale = -1;
                break;
            }
            case -4: {
                return 1019;
            }
            case -3: 
            case -2: {
                sQLNode3.sqlSqlType = sQLNode2.sqlSqlType == -3 || sQLNode.sqlSqlType == -3 ? -3 : -2;
                sQLNode3.sqlPrecision = Scalar.MAX(sQLNode2.sqlPrecision, sQLNode.sqlPrecision);
                sQLNode3.sqlScale = -1;
                break;
            }
            case 91: 
            case 92: 
            case 93: {
                sQLNode3.sqlSqlType = sQLNode.sqlSqlType;
                sQLNode3.sqlPrecision = sQLNode.sqlPrecision;
                sQLNode3.sqlScale = sQLNode.sqlScale;
                break;
            }
            default: {
                return 1003;
            }
        }
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    static int ScalarCheck(LDAPStatement lDAPStatement, SQLNodeScalar sQLNodeScalar, boolean bl, boolean bl2, SQLNode sQLNode, SQLNode sQLNode2) {
        int n;
        SQLNode sQLNode3;
        SQLNodeValues sQLNodeValues;
        String string;
        block149: {
            String string2;
            block159: {
                block158: {
                    block157: {
                        block156: {
                            block155: {
                                block154: {
                                    block153: {
                                        block152: {
                                            block151: {
                                                block150: {
                                                    block148: {
                                                        ScalarFunc scalarFunc;
                                                        block147: {
                                                            block139: {
                                                                block140: {
                                                                    int n2;
                                                                    block138: {
                                                                        block141: {
                                                                            String string3;
                                                                            block146: {
                                                                                block145: {
                                                                                    block144: {
                                                                                        block143: {
                                                                                            block142: {
                                                                                                scalarFunc = null;
                                                                                                string3 = "";
                                                                                                string2 = "";
                                                                                                sQLNodeScalar.Id = 0;
                                                                                                string = sQLNodeScalar.Function;
                                                                                                n2 = 0;
                                                                                                while (n2 < scalarFuncs.length) {
                                                                                                    scalarFunc = scalarFuncs[n2];
                                                                                                    if (string.equalsIgnoreCase(scalarFunc.m_name)) break;
                                                                                                    ++n2;
                                                                                                }
                                                                                                if (n2 >= scalarFuncs.length) {
                                                                                                    lDAPStatement.setErrorMsg(string);
                                                                                                    return 1057;
                                                                                                }
                                                                                                sQLNodeScalar.Id = n2;
                                                                                                if (sQLNodeScalar.Id != 91 && sQLNodeScalar.Id != 92) break block141;
                                                                                                sQLNodeValues = sQLNodeScalar.Arguments;
                                                                                                if (sQLNodeValues == null) {
                                                                                                    lDAPStatement.setErrorMsg(string);
                                                                                                    return 1058;
                                                                                                }
                                                                                                sQLNodeScalar.Arguments = sQLNodeValues.Next;
                                                                                                sQLNode3 = sQLNodeValues.Value;
                                                                                                if (sQLNode3.sqlNodeType != 21) {
                                                                                                    lDAPStatement.setErrorMsg(string);
                                                                                                    return 1058;
                                                                                                }
                                                                                                if (((SQLNodeColumn)sQLNode3).Tablealias != null) {
                                                                                                    lDAPStatement.setErrorMsg(string);
                                                                                                    return 1058;
                                                                                                }
                                                                                                string3 = ((SQLNodeColumn)sQLNode3).Column;
                                                                                                if (string3.equalsIgnoreCase("SQL_TSI_FRAC_SECOND")) {
                                                                                                    return 1003;
                                                                                                }
                                                                                                if (!string3.equalsIgnoreCase("SQL_TSI_SECOND")) break block142;
                                                                                                sQLNodeScalar.Interval = 1;
                                                                                                break block138;
                                                                                            }
                                                                                            if (!string3.equalsIgnoreCase("SQL_TSI_MINUTE")) break block143;
                                                                                            sQLNodeScalar.Interval = 2;
                                                                                            break block138;
                                                                                        }
                                                                                        if (!string3.equalsIgnoreCase("SQL_TSI_HOUR")) break block144;
                                                                                        sQLNodeScalar.Interval = 3;
                                                                                        break block138;
                                                                                    }
                                                                                    if (!string3.equalsIgnoreCase("SQL_TSI_DAY")) break block145;
                                                                                    sQLNodeScalar.Interval = 4;
                                                                                    break block138;
                                                                                }
                                                                                if (!string3.equalsIgnoreCase("SQL_TSI_WEEK")) break block146;
                                                                                sQLNodeScalar.Interval = 5;
                                                                                break block138;
                                                                            }
                                                                            if (string3.equalsIgnoreCase("SQL_TSI_MONTH")) {
                                                                                sQLNodeScalar.Interval = 6;
                                                                                break block138;
                                                                            } else if (string3.equalsIgnoreCase("SQL_TSI_QUARTER")) {
                                                                                sQLNodeScalar.Interval = 7;
                                                                                break block138;
                                                                            } else {
                                                                                if (!string3.equalsIgnoreCase("SQL_TSI_YEAR")) {
                                                                                    lDAPStatement.setErrorMsg(string);
                                                                                    return 1058;
                                                                                }
                                                                                sQLNodeScalar.Interval = 8;
                                                                            }
                                                                            break block138;
                                                                        }
                                                                        if (sQLNodeScalar.Id == 100) {
                                                                            sQLNodeValues = sQLNodeScalar.Arguments;
                                                                            if (sQLNodeValues == null) {
                                                                                lDAPStatement.setErrorMsg(string);
                                                                                return 1058;
                                                                            }
                                                                            SQLNodeValues sQLNodeValues2 = sQLNodeValues.Next;
                                                                            if (sQLNodeValues2 == null) {
                                                                                lDAPStatement.setErrorMsg(string);
                                                                                return 1058;
                                                                            }
                                                                            sQLNodeValues.Next = null;
                                                                            sQLNodeValues = sQLNodeValues2;
                                                                            if (sQLNodeValues.Next != null) {
                                                                                lDAPStatement.setErrorMsg(string);
                                                                                return 1058;
                                                                            }
                                                                            sQLNode3 = sQLNodeValues.Value;
                                                                            if (sQLNode3.sqlNodeType != 21) {
                                                                                lDAPStatement.setErrorMsg(string);
                                                                                return 1058;
                                                                            }
                                                                            if (((SQLNodeColumn)sQLNode3).Tablealias != null) {
                                                                                lDAPStatement.setErrorMsg(string);
                                                                                return 1058;
                                                                            }
                                                                            string2 = ((SQLNodeColumn)sQLNode3).Column;
                                                                        }
                                                                    }
                                                                    n = Semantic.SemanticCheck(lDAPStatement, sQLNodeScalar.Arguments, bl, bl2, sQLNode, sQLNode2);
                                                                    if (n != 0) {
                                                                        return n;
                                                                    }
                                                                    do {
                                                                        sQLNodeValues = sQLNodeScalar.Arguments;
                                                                        n = 0;
                                                                        n2 = 0;
                                                                        while (n2 < scalarFunc.m_argCount) {
                                                                            if (sQLNodeValues == null) {
                                                                                n = 1058;
                                                                                break;
                                                                            }
                                                                            sQLNode3 = sQLNodeValues.Value;
                                                                            if (sQLNode3.sqlNodeType == 24) {
                                                                                return 1022;
                                                                            }
                                                                            if (sQLNode3.sqlNodeType == 26) {
                                                                                lDAPStatement.setErrorMsg(string);
                                                                                return 1058;
                                                                            }
                                                                            if (sQLNode3.sqlSqlType == -1 || sQLNode3.sqlSqlType == -4) {
                                                                                lDAPStatement.setErrorMsg(string);
                                                                                return 1058;
                                                                            }
                                                                            if (scalarFunc.m_argType[n2] != 1 && sQLNode3.sqlDataType != scalarFunc.m_argType[n2]) {
                                                                                n = 1058;
                                                                                break;
                                                                            }
                                                                            sQLNodeValues = sQLNodeValues.Next;
                                                                            ++n2;
                                                                        }
                                                                        if (sQLNodeValues == null && n == 0) {
                                                                            if (scalarFunc.m_argCount <= 0) break block139;
                                                                            break block140;
                                                                        }
                                                                        ++sQLNodeScalar.Id;
                                                                        scalarFunc = scalarFuncs[sQLNodeScalar.Id];
                                                                    } while (scalarFunc.m_name.equalsIgnoreCase(sQLNodeScalar.Function));
                                                                    lDAPStatement.setErrorMsg(string);
                                                                    return 1058;
                                                                }
                                                                sQLNodeValues = sQLNodeScalar.Arguments;
                                                                sQLNode3 = sQLNodeValues.Value;
                                                                break block147;
                                                            }
                                                            sQLNodeValues = null;
                                                            sQLNode3 = null;
                                                        }
                                                        if (sQLNodeScalar.Id == 100) break block148;
                                                        sQLNodeScalar.sqlDataType = scalarFunc.m_dataType;
                                                        sQLNodeScalar.sqlSqlType = scalarFunc.m_sqlType;
                                                        sQLNodeScalar.sqlPrecision = scalarFunc.m_precision;
                                                        sQLNodeScalar.sqlScale = scalarFunc.m_scale;
                                                        if (sQLNodeScalar.sqlSqlType == 0) {
                                                            sQLNodeScalar.sqlSqlType = sQLNode3.sqlSqlType;
                                                        }
                                                        if (sQLNodeScalar.sqlPrecision == 0) {
                                                            sQLNodeScalar.sqlPrecision = sQLNode3.sqlPrecision;
                                                            sQLNodeScalar.sqlScale = sQLNode3.sqlScale;
                                                        }
                                                        break block149;
                                                    }
                                                    if (!string2.equalsIgnoreCase("SQL_BIGINT")) break block150;
                                                    sQLNodeScalar.sqlDataType = 7;
                                                    sQLNodeScalar.sqlSqlType = -5;
                                                    switch (sQLNode3.sqlDataType) {
                                                        case 3: 
                                                        case 7: {
                                                            sQLNodeScalar.sqlPrecision = sQLNode3.sqlPrecision;
                                                            break;
                                                        }
                                                        case 6: {
                                                            sQLNodeScalar.sqlPrecision = sQLNode3.sqlPrecision;
                                                            break;
                                                        }
                                                        case 8: {
                                                            sQLNodeScalar.sqlPrecision = 20;
                                                            break;
                                                        }
                                                        case 12: {
                                                            sQLNodeScalar.sqlPrecision = sQLNode3.sqlPrecision;
                                                            break;
                                                        }
                                                        case 9: 
                                                        case 10: 
                                                        case 11: {
                                                            return 1009;
                                                        }
                                                        default: {
                                                            return 1003;
                                                        }
                                                    }
                                                    sQLNodeScalar.sqlScale = 0;
                                                    break block149;
                                                }
                                                if (!string2.equalsIgnoreCase("SQL_BINARY") && !string2.equalsIgnoreCase("SQL_VARBINARY")) break block151;
                                                sQLNodeScalar.sqlDataType = 12;
                                                sQLNodeScalar.sqlSqlType = string2.equalsIgnoreCase("SQL_BINARY") ? -2 : -3;
                                                switch (sQLNode3.sqlSqlType) {
                                                    case -5: 
                                                    case 2: 
                                                    case 3: {
                                                        if (sQLNode3.sqlScale == 0) {
                                                            sQLNodeScalar.sqlPrecision = sQLNode3.sqlPrecision + 2;
                                                            break;
                                                        }
                                                        sQLNodeScalar.sqlPrecision = sQLNode3.sqlPrecision + 1;
                                                        break;
                                                    }
                                                    case -6: {
                                                        sQLNodeScalar.sqlPrecision = 2;
                                                        break;
                                                    }
                                                    case 5: {
                                                        sQLNodeScalar.sqlPrecision = 2;
                                                        break;
                                                    }
                                                    case 4: {
                                                        sQLNodeScalar.sqlPrecision = 4;
                                                        break;
                                                    }
                                                    case -7: {
                                                        sQLNodeScalar.sqlPrecision = 2;
                                                        break;
                                                    }
                                                    case 7: {
                                                        sQLNodeScalar.sqlPrecision = 4;
                                                        break;
                                                    }
                                                    case 6: 
                                                    case 8: {
                                                        sQLNodeScalar.sqlPrecision = 8;
                                                        break;
                                                    }
                                                    case 1: 
                                                    case 12: {
                                                        sQLNodeScalar.sqlPrecision = sQLNode3.sqlPrecision;
                                                        break;
                                                    }
                                                    case -1: {
                                                        return 1003;
                                                    }
                                                    case -3: 
                                                    case -2: {
                                                        sQLNodeScalar.sqlPrecision = sQLNode3.sqlPrecision;
                                                        break;
                                                    }
                                                    case -4: {
                                                        return 1003;
                                                    }
                                                    case 91: {
                                                        sQLNodeScalar.sqlPrecision = 0;
                                                        break;
                                                    }
                                                    case 92: {
                                                        sQLNodeScalar.sqlPrecision = 0;
                                                        break;
                                                    }
                                                    case 93: {
                                                        sQLNodeScalar.sqlPrecision = 0;
                                                        break;
                                                    }
                                                    default: {
                                                        return 1003;
                                                    }
                                                }
                                                sQLNodeScalar.sqlScale = -1;
                                                break block149;
                                            }
                                            if (!string2.equalsIgnoreCase("SQL_BIT")) break block152;
                                            sQLNodeScalar.sqlDataType = 3;
                                            sQLNodeScalar.sqlSqlType = -7;
                                            sQLNodeScalar.sqlPrecision = 1;
                                            sQLNodeScalar.sqlScale = 0;
                                            break block149;
                                        }
                                        if (!string2.equalsIgnoreCase("SQL_CHAR") && !string2.equalsIgnoreCase("SQL_VARCHAR")) break block153;
                                        sQLNodeScalar.sqlDataType = 8;
                                        sQLNodeScalar.sqlSqlType = string2.equalsIgnoreCase("SQL_CHAR") ? 1 : 12;
                                        switch (sQLNode3.sqlSqlType) {
                                            case -5: 
                                            case 2: 
                                            case 3: {
                                                if (sQLNode3.sqlScale == 0) {
                                                    sQLNodeScalar.sqlPrecision = sQLNode3.sqlPrecision + 2;
                                                    break;
                                                }
                                                sQLNodeScalar.sqlPrecision = sQLNode3.sqlPrecision + 1;
                                                break;
                                            }
                                            case -6: {
                                                sQLNodeScalar.sqlPrecision = 4;
                                                break;
                                            }
                                            case 5: {
                                                sQLNodeScalar.sqlPrecision = 6;
                                                break;
                                            }
                                            case 4: {
                                                sQLNodeScalar.sqlPrecision = 11;
                                                break;
                                            }
                                            case -7: {
                                                sQLNodeScalar.sqlPrecision = 1;
                                                break;
                                            }
                                            case 7: {
                                                sQLNodeScalar.sqlPrecision = 13;
                                                break;
                                            }
                                            case 6: 
                                            case 8: {
                                                sQLNodeScalar.sqlPrecision = 22;
                                                break;
                                            }
                                            case 1: 
                                            case 12: {
                                                sQLNodeScalar.sqlPrecision = sQLNode3.sqlPrecision;
                                                break;
                                            }
                                            case -1: {
                                                return 1003;
                                            }
                                            case -3: 
                                            case -2: {
                                                sQLNodeScalar.sqlPrecision = sQLNode3.sqlPrecision * 2;
                                                if (sQLNodeScalar.sqlPrecision < 255) break;
                                                sQLNodeScalar.sqlPrecision = 255;
                                                break;
                                            }
                                            case -4: {
                                                return 1003;
                                            }
                                            case 91: {
                                                sQLNodeScalar.sqlPrecision = 10;
                                                break;
                                            }
                                            case 92: {
                                                sQLNodeScalar.sqlPrecision = 8;
                                                break;
                                            }
                                            case 93: {
                                                sQLNodeScalar.sqlPrecision = 23;
                                                break;
                                            }
                                            default: {
                                                return 1003;
                                            }
                                        }
                                        sQLNodeScalar.sqlScale = -1;
                                        break block149;
                                    }
                                    if (!string2.equalsIgnoreCase("SQL_DATE")) break block154;
                                    sQLNodeScalar.sqlDataType = 9;
                                    sQLNodeScalar.sqlSqlType = 91;
                                    sQLNodeScalar.sqlPrecision = 10;
                                    sQLNodeScalar.sqlScale = -1;
                                    break block149;
                                }
                                if (!string2.equalsIgnoreCase("SQL_DECIMAL")) break block155;
                                sQLNodeScalar.sqlDataType = 7;
                                sQLNodeScalar.sqlSqlType = 3;
                                switch (sQLNode3.sqlDataType) {
                                    case 3: 
                                    case 7: {
                                        sQLNodeScalar.sqlPrecision = sQLNode3.sqlPrecision;
                                        sQLNodeScalar.sqlScale = sQLNode3.sqlScale;
                                        break block149;
                                    }
                                    case 6: {
                                        sQLNodeScalar.sqlPrecision = sQLNode3.sqlPrecision;
                                        sQLNodeScalar.sqlScale = 3;
                                        break block149;
                                    }
                                    case 8: {
                                        sQLNodeScalar.sqlPrecision = 15;
                                        sQLNodeScalar.sqlScale = 3;
                                        break block149;
                                    }
                                    case 12: {
                                        sQLNodeScalar.sqlPrecision = sQLNode3.sqlPrecision;
                                        sQLNodeScalar.sqlScale = 3;
                                        break block149;
                                    }
                                    case 9: 
                                    case 10: 
                                    case 11: {
                                        return 1009;
                                    }
                                    default: {
                                        return 1003;
                                    }
                                }
                            }
                            if (!string2.equalsIgnoreCase("SQL_DOUBLE")) break block156;
                            sQLNodeScalar.sqlDataType = 6;
                            sQLNodeScalar.sqlSqlType = 8;
                            sQLNodeScalar.sqlPrecision = 15;
                            sQLNodeScalar.sqlScale = -1;
                            break block149;
                        }
                        if (!string2.equalsIgnoreCase("SQL_FLOAT")) break block157;
                        sQLNodeScalar.sqlDataType = 6;
                        sQLNodeScalar.sqlSqlType = 6;
                        sQLNodeScalar.sqlPrecision = 15;
                        sQLNodeScalar.sqlScale = -1;
                        break block149;
                    }
                    if (!string2.equalsIgnoreCase("SQL_INTEGER")) break block158;
                    sQLNodeScalar.sqlDataType = 3;
                    sQLNodeScalar.sqlSqlType = 4;
                    sQLNodeScalar.sqlPrecision = 10;
                    sQLNodeScalar.sqlScale = 0;
                    break block149;
                }
                if (string2.equalsIgnoreCase("SQL_LONGVARBINARY")) {
                    return 1003;
                }
                if (string2.equalsIgnoreCase("SQL_LONGVARCHAR")) {
                    return 1003;
                }
                if (!string2.equalsIgnoreCase("SQL_NUMERIC")) break block159;
                sQLNodeScalar.sqlDataType = 7;
                sQLNodeScalar.sqlSqlType = 2;
                switch (sQLNode3.sqlDataType) {
                    case 3: 
                    case 7: {
                        sQLNodeScalar.sqlPrecision = sQLNode3.sqlPrecision;
                        sQLNodeScalar.sqlScale = sQLNode3.sqlScale;
                        break block149;
                    }
                    case 6: {
                        sQLNodeScalar.sqlPrecision = sQLNode3.sqlPrecision;
                        sQLNodeScalar.sqlScale = 3;
                        break block149;
                    }
                    case 8: {
                        sQLNodeScalar.sqlPrecision = 15;
                        sQLNodeScalar.sqlScale = 3;
                        break block149;
                    }
                    case 12: {
                        sQLNodeScalar.sqlPrecision = sQLNode3.sqlPrecision;
                        sQLNodeScalar.sqlScale = 3;
                        break block149;
                    }
                    case 9: 
                    case 10: 
                    case 11: {
                        return 1009;
                    }
                    default: {
                        return 1003;
                    }
                }
            }
            if (string2.equalsIgnoreCase("SQL_REAL")) {
                sQLNodeScalar.sqlDataType = 6;
                sQLNodeScalar.sqlSqlType = 7;
                sQLNodeScalar.sqlPrecision = 7;
                sQLNodeScalar.sqlScale = -1;
            } else if (string2.equalsIgnoreCase("SQL_SMALLINT")) {
                sQLNodeScalar.sqlDataType = 3;
                sQLNodeScalar.sqlSqlType = 5;
                sQLNodeScalar.sqlPrecision = 5;
                sQLNodeScalar.sqlScale = 0;
            } else if (string2.equalsIgnoreCase("SQL_TIME")) {
                sQLNodeScalar.sqlDataType = 10;
                sQLNodeScalar.sqlSqlType = 92;
                sQLNodeScalar.sqlPrecision = 6;
                sQLNodeScalar.sqlScale = -1;
            } else if (string2.equalsIgnoreCase("SQL_TIMESTAMP")) {
                sQLNodeScalar.sqlDataType = 11;
                sQLNodeScalar.sqlSqlType = 93;
                sQLNodeScalar.sqlPrecision = 23;
                sQLNodeScalar.sqlScale = 3;
            } else {
                if (!string2.equalsIgnoreCase("SQL_TINYINT")) {
                    lDAPStatement.setErrorMsg(string);
                    return 1058;
                }
                sQLNodeScalar.sqlDataType = 3;
                sQLNodeScalar.sqlSqlType = -6;
                sQLNodeScalar.sqlPrecision = 3;
                sQLNodeScalar.sqlScale = 0;
            }
        }
        switch (sQLNodeScalar.Id) {
            case 0: 
            case 1: {
                return 0;
            }
            case 2: {
                sQLNodeValues = sQLNodeValues.Next;
                sQLNode3 = sQLNodeValues.Value;
                sQLNodeScalar.sqlPrecision += sQLNode3.sqlPrecision;
                if (sQLNodeScalar.sqlPrecision <= 255) return 0;
                sQLNodeScalar.sqlPrecision = 255;
                return 0;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: {
                return 0;
            }
            case 66: {
                switch (sQLNode3.sqlDataType) {
                    case 8: 
                    case 9: 
                    case 11: {
                        return 0;
                    }
                    case 3: 
                    case 6: 
                    case 7: 
                    case 10: 
                    case 12: {
                        lDAPStatement.setErrorMsg(string);
                        return 1058;
                    }
                }
                return 1003;
            }
            case 67: 
            case 68: 
            case 69: {
                return 0;
            }
            case 70: {
                switch (sQLNode3.sqlDataType) {
                    case 8: 
                    case 9: 
                    case 11: {
                        return 0;
                    }
                    case 3: 
                    case 6: 
                    case 7: 
                    case 10: 
                    case 12: {
                        lDAPStatement.setErrorMsg(string);
                        return 1058;
                    }
                }
                return 1003;
            }
            case 71: {
                switch (sQLNode3.sqlDataType) {
                    case 8: 
                    case 9: 
                    case 11: {
                        return 0;
                    }
                    case 3: 
                    case 6: 
                    case 7: 
                    case 10: 
                    case 12: {
                        lDAPStatement.setErrorMsg(string);
                        return 1058;
                    }
                }
                return 1003;
            }
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: {
                return 0;
            }
            case 91: {
                sQLNodeValues = sQLNodeValues.Next;
                SQLNode sQLNode4 = sQLNodeValues.Value;
                switch (sQLNode4.sqlDataType) {
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: {
                        return 0;
                    }
                    case 3: 
                    case 6: 
                    case 7: 
                    case 12: {
                        lDAPStatement.setErrorMsg(string);
                        return 1058;
                    }
                }
                return 1003;
            }
            case 92: {
                switch (sQLNode3.sqlDataType) {
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: {
                        break;
                    }
                    case 3: 
                    case 6: 
                    case 7: 
                    case 12: {
                        lDAPStatement.setErrorMsg(string);
                        return 1058;
                    }
                    default: {
                        return 1003;
                    }
                }
                sQLNodeValues = sQLNodeValues.Next;
                SQLNode sQLNode5 = sQLNodeValues.Value;
                switch (sQLNode5.sqlDataType) {
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: {
                        return 0;
                    }
                    case 3: 
                    case 6: 
                    case 7: 
                    case 12: {
                        lDAPStatement.setErrorMsg(string);
                        return 1058;
                    }
                }
                return 1003;
            }
            case 93: {
                switch (sQLNode3.sqlDataType) {
                    case 8: 
                    case 9: 
                    case 11: {
                        return 0;
                    }
                    case 3: 
                    case 6: 
                    case 7: 
                    case 10: 
                    case 12: {
                        lDAPStatement.setErrorMsg(string);
                        return 1058;
                    }
                }
                return 1003;
            }
            case 94: 
            case 95: 
            case 96: 
            case 97: {
                return 0;
            }
            case 98: {
                sQLNodeValues = sQLNodeValues.Next;
                SQLNode sQLNode6 = sQLNodeValues.Value;
                n = Scalar.ScalarIfNullType(sQLNode3, sQLNode6, sQLNodeScalar);
                if (n == 0) return 0;
                if (n != 1058) return n;
                lDAPStatement.setErrorMsg(string);
                return n;
            }
            case 99: {
                return 0;
            }
        }
        return 0;
    }

    protected static int EvaluateScalar(LDAPStatement lDAPStatement, SQLNodeScalar sQLNodeScalar) {
        SQLNode[] sQLNodeArray = new SQLNode[4];
        ScalarFunc scalarFunc = scalarFuncs[sQLNodeScalar.Id];
        SQLNodeValues sQLNodeValues = sQLNodeScalar.Arguments;
        int n = 0;
        while (n < scalarFunc.getArgCount()) {
            sQLNodeArray[n] = sQLNodeValues.Value;
            int n2 = Evaluate.EvaluateExpression(lDAPStatement, sQLNodeArray[n]);
            if (n2 != 0) {
                return n2;
            }
            if (sQLNodeScalar.Id != 98 && sQLNodeArray[n].sqlIsNull) {
                sQLNodeScalar.sqlIsNull = true;
                switch (sQLNodeScalar.sqlDataType) {
                    case 6: {
                        sQLNodeScalar.value = new ValueDouble(0.0);
                        break;
                    }
                    case 7: {
                        sQLNodeScalar.value = new ValueDecimal(new BigDecimal(0.0));
                        break;
                    }
                    case 3: {
                        sQLNodeScalar.value = new ValueInteger(0);
                        break;
                    }
                    case 8: {
                        sQLNodeScalar.value = new ValueChar("");
                        break;
                    }
                    case 12: {
                        sQLNodeScalar.value = new ValueBinary(new byte[0]);
                        break;
                    }
                    case 9: {
                        sQLNodeScalar.value = new ValueDate(new Date(0L));
                        break;
                    }
                    case 10: {
                        sQLNodeScalar.value = new ValueTime(new Time(0L));
                        break;
                    }
                    case 11: {
                        sQLNodeScalar.value = new ValueTimestamp(new Timestamp(0L));
                    }
                }
                return 0;
            }
            sQLNodeValues = sQLNodeValues.Next;
            ++n;
        }
        sQLNodeScalar.sqlIsNull = false;
        switch (sQLNodeScalar.Id) {
            case 101: {
                sQLNodeScalar.value = new ValueChar(((LdapIsam)lDAPStatement.getISAM()).getSeparator());
                break;
            }
            case 102: {
                try {
                    ((LdapIsam)lDAPStatement.getISAM()).setSeparator(Scalar.parseSeparator(sQLNodeArray[0].value.getString()));
                    sQLNodeScalar.value = new ValueChar(((LdapIsam)lDAPStatement.getISAM()).getSeparator());
                }
                catch (SQLException sQLException) {
                    sQLNodeScalar.value = new ValueChar(((LdapIsam)lDAPStatement.getISAM()).getSeparator());
                }
                break;
            }
            case 103: {
                sQLNodeScalar.value = new ValueChar(((LdapIsam)lDAPStatement.getISAM()).getBaseDN());
                break;
            }
            default: {
                return 1003;
            }
        }
        return 0;
    }

    private static String parseSeparator(String string) {
        if (string.length() <= 1) {
            return string;
        }
        if (string.charAt(0) == '\\') {
            switch (string.charAt(1)) {
                case 'n': {
                    return "\n";
                }
                case 'b': {
                    return "\b";
                }
                case 'r': {
                    return "\r";
                }
                case 't': {
                    return "\t";
                }
                case 'f': {
                    return "\f";
                }
            }
            return string;
        }
        return string;
    }
}

