/*
 * Decompiled with CFR 0.152.
 */
package com.novell.sql;

import com.novell.sql.DRDBConstants;
import com.novell.sql.LDAPSQLExceptionCodes;
import com.novell.sql.SQLErrorCodes;
import com.novell.sql.SQLNode;
import com.novell.sql.SQLNodeAggregate;
import com.novell.sql.SQLNodeAlgebraic;
import com.novell.sql.SQLNodeBoolean;
import com.novell.sql.SQLNodeColumn;
import com.novell.sql.SQLNodeColumns;
import com.novell.sql.SQLNodeComparison;
import com.novell.sql.SQLNodeCreate;
import com.novell.sql.SQLNodeCreateColumns;
import com.novell.sql.SQLNodeCreateIndex;
import com.novell.sql.SQLNodeDate;
import com.novell.sql.SQLNodeDelete;
import com.novell.sql.SQLNodeDrop;
import com.novell.sql.SQLNodeDropIndex;
import com.novell.sql.SQLNodeGroupByColumns;
import com.novell.sql.SQLNodeInsert;
import com.novell.sql.SQLNodeNumeric;
import com.novell.sql.SQLNodeParameter;
import com.novell.sql.SQLNodeRoot;
import com.novell.sql.SQLNodeScalar;
import com.novell.sql.SQLNodeSelect;
import com.novell.sql.SQLNodeSortColumns;
import com.novell.sql.SQLNodeString;
import com.novell.sql.SQLNodeTable;
import com.novell.sql.SQLNodeTables;
import com.novell.sql.SQLNodeTime;
import com.novell.sql.SQLNodeTimestamp;
import com.novell.sql.SQLNodeUpdate;
import com.novell.sql.SQLNodeUpdateValues;
import com.novell.sql.SQLNodeValues;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;

class Trace
implements SQLErrorCodes,
LDAPSQLExceptionCodes,
DRDBConstants {
    static StringBuffer lineBuf = new StringBuffer(256);

    Trace() {
    }

    static void ShowString(String string, int n) {
        lineBuf.setLength(0);
        while (n > 0) {
            lineBuf.append("    ");
            --n;
        }
        if (string == null) {
            lineBuf.append("<< NULL >>");
        } else {
            lineBuf.append(string);
        }
        System.out.println(lineBuf);
    }

    static void ShowDataType(int n, int n2) {
        switch (n) {
            case 1: {
                Trace.ShowString("Data Type: TYPE_JAVA_UNKNOWN", n2);
                break;
            }
            case 8: {
                Trace.ShowString("Data Type: TYPE_JAVA_STRING", n2);
                break;
            }
            case 6: {
                Trace.ShowString("Data Type: TYPE_JAVA_DOUBLE", n2);
                break;
            }
            case 7: {
                Trace.ShowString("Data Type: TYPE_JAVA_BIGDECIMAL", n2);
                break;
            }
            case 3: {
                Trace.ShowString("Data Type: TYPE_JAVA_INTEGER", n2);
                break;
            }
            case 9: {
                Trace.ShowString("Data Type: TYPE_JAVA_DATE", n2);
                break;
            }
            case 10: {
                Trace.ShowString("Data Type: TYPE_JAVA_TIME", n2);
                break;
            }
            case 11: {
                Trace.ShowString("Data Type: TYPE_JAVA_TIMESTAMP", n2);
                break;
            }
            case 12: {
                Trace.ShowString("Data Type: TYPE_JAVA_BINARY", n2);
                break;
            }
            default: {
                Trace.ShowString("Data Type: TYPE_JAVA_???", n2);
            }
        }
    }

    static void ShowPrecision(int n, int n2) {
        lineBuf.setLength(0);
        lineBuf.append("Precision: ");
        lineBuf.append(String.valueOf(n));
        Trace.ShowString(lineBuf.toString(), n2);
    }

    static void ShowUnsignedInteger(int n, int n2) {
        Trace.ShowString(String.valueOf(n), n2);
    }

    static void ShowBoolean(boolean bl, int n) {
        if (bl) {
            Trace.ShowString("TRUE", n);
        } else {
            Trace.ShowString("FALSE", n);
        }
    }

    static void ShowScale(int n, int n2) {
        if (n == -1) {
            Trace.ShowString("Scale: NO_SCALE", n2);
        } else {
            lineBuf.setLength(0);
            lineBuf.append("Scale: ");
            lineBuf.append(String.valueOf(n));
            Trace.ShowString(lineBuf.toString(), n2);
        }
    }

    static void ShowDate(Date date, int n) {
        Trace.ShowString(date.toString(), n);
    }

    static void ShowTime(Time time, int n) {
        Trace.ShowString(time.toString(), n);
    }

    static void ShowTimeStamp(Timestamp timestamp, int n) {
        Trace.ShowString(timestamp.toString(), n);
    }

    static void ShowSqlType(int n, boolean bl, int n2) {
        switch (n) {
            case 1: {
                if (bl) {
                    Trace.ShowString("SQL Type: Types.CHAR", n2);
                    break;
                }
                Trace.ShowString("SQL_CHAR", n2);
                break;
            }
            case 12: {
                if (bl) {
                    Trace.ShowString("SQL Type: Types.VARCHAR", n2);
                    break;
                }
                Trace.ShowString("SQL_VARCHAR", n2);
                break;
            }
            case -1: {
                if (bl) {
                    Trace.ShowString("SQL Type: Types.LONGVARCHAR", n2);
                    break;
                }
                Trace.ShowString("SQL_LONGVARCHAR", n2);
                break;
            }
            case 3: {
                if (bl) {
                    Trace.ShowString("SQL Type: Types.DECIMAL", n2);
                    break;
                }
                Trace.ShowString("SQL_DECIMAL", n2);
                break;
            }
            case 2: {
                if (bl) {
                    Trace.ShowString("SQL Type: Types.NUMERIC", n2);
                    break;
                }
                Trace.ShowString("SQL_NUMERIC", n2);
                break;
            }
            case 5: {
                if (bl) {
                    Trace.ShowString("SQL Type: Types.SMALLINT", n2);
                    break;
                }
                Trace.ShowString("SQL_SMALLINT", n2);
                break;
            }
            case 4: {
                if (bl) {
                    Trace.ShowString("SQL Type: Types.INTEGER", n2);
                    break;
                }
                Trace.ShowString("SQL_INTEGER", n2);
                break;
            }
            case 7: {
                if (bl) {
                    Trace.ShowString("SQL Type: Types.REAL", n2);
                    break;
                }
                Trace.ShowString("SQL_REAL", n2);
                break;
            }
            case 6: {
                if (bl) {
                    Trace.ShowString("SQL Type: Types.FLOAT", n2);
                    break;
                }
                Trace.ShowString("SQL_FLOAT", n2);
                break;
            }
            case 8: {
                if (bl) {
                    Trace.ShowString("SQL Type: Types.DOUBLE", n2);
                    break;
                }
                Trace.ShowString("SQL_DOUBLE", n2);
                break;
            }
            case -7: {
                if (bl) {
                    Trace.ShowString("SQL Type: Types.BIT", n2);
                    break;
                }
                Trace.ShowString("SQL_BIT", n2);
                break;
            }
            case -6: {
                if (bl) {
                    Trace.ShowString("SQL Type: Types.TINYINT", n2);
                    break;
                }
                Trace.ShowString("SQL_TINYINT", n2);
                break;
            }
            case -5: {
                if (bl) {
                    Trace.ShowString("SQL Type: Types.BIGINT", n2);
                    break;
                }
                Trace.ShowString("SQL_BIGINT", n2);
                break;
            }
            case -2: {
                if (bl) {
                    Trace.ShowString("SQL Type: Types.BINARY", n2);
                    break;
                }
                Trace.ShowString("SQL_BINARY", n2);
                break;
            }
            case -3: {
                if (bl) {
                    Trace.ShowString("SQL Type: Types.VARBINARY", n2);
                    break;
                }
                Trace.ShowString("SQL_VARBINARY", n2);
                break;
            }
            case -4: {
                if (bl) {
                    Trace.ShowString("SQL Type: Types.LONGVARBINARY", n2);
                    break;
                }
                Trace.ShowString("SQL_LONGVARBINARY", n2);
                break;
            }
            case 91: {
                if (bl) {
                    Trace.ShowString("SQL Type: Types.DATE", n2);
                    break;
                }
                Trace.ShowString("SQL_DATE", n2);
                break;
            }
            case 92: {
                if (bl) {
                    Trace.ShowString("SQL Type: Types.TIME", n2);
                    break;
                }
                Trace.ShowString("SQL_TIME", n2);
                break;
            }
            case 93: {
                if (bl) {
                    Trace.ShowString("SQL Type: Types.TIMESTAMP", n2);
                    break;
                }
                Trace.ShowString("SQL_TIMESTAMP", n2);
                break;
            }
            default: {
                if (bl) {
                    Trace.ShowString("SQL Type: Types.???", n2);
                    break;
                }
                Trace.ShowString("SQL_???", n2);
            }
        }
    }

    protected static void ShowSemantic(SQLNode sQLNode, int n) {
        if (sQLNode == null) {
            Trace.ShowString("<< NULL >>", n);
            return;
        }
        switch (sQLNode.sqlNodeType) {
            case 0: {
                Trace.ShowString("NODE_TYPE_NONE", n);
                break;
            }
            case 1: {
                Trace.ShowString("NODE_TYPE_ROOT", n);
                Trace.ShowSemantic(((SQLNodeRoot)sQLNode).sql, n + 1);
                break;
            }
            case 2: {
                Trace.ShowString("NODE_TYPE_CREATE", n);
                Trace.ShowString(((SQLNodeCreate)sQLNode).Table, n + 1);
                Trace.ShowSemantic(((SQLNodeCreate)sQLNode).Columns, n + 1);
                break;
            }
            case 3: {
                Trace.ShowString("NODE_TYPE_DROP", n);
                Trace.ShowString(((SQLNodeDrop)sQLNode).Table, n + 1);
                break;
            }
            case 4: {
                Trace.ShowString("NODE_TYPE_SELECT", n);
                if (((SQLNodeSelect)sQLNode).Distinct) {
                    Trace.ShowString("DISTINCT", n + 1);
                } else {
                    Trace.ShowString("ALL", n + 1);
                }
                Trace.ShowSemantic(((SQLNodeSelect)sQLNode).Values, n + 1);
                Trace.ShowSemantic(((SQLNodeSelect)sQLNode).Tables, n + 1);
                Trace.ShowSemantic(((SQLNodeSelect)sQLNode).Predicate, n + 1);
                Trace.ShowSemantic(((SQLNodeSelect)sQLNode).Groupbycolumns, n + 1);
                Trace.ShowSemantic(((SQLNodeSelect)sQLNode).Sortcolumns, n + 1);
                break;
            }
            case 5: {
                Trace.ShowString("NODE_TYPE_INSERT", n);
                Trace.ShowSemantic(((SQLNodeInsert)sQLNode).Table, n + 1);
                Trace.ShowSemantic(((SQLNodeInsert)sQLNode).Columns, n + 1);
                Trace.ShowSemantic(((SQLNodeInsert)sQLNode).Values, n + 1);
                break;
            }
            case 6: {
                Trace.ShowString("NODE_TYPE_DELETE", n);
                Trace.ShowSemantic(((SQLNodeDelete)sQLNode).Table, n + 1);
                Trace.ShowSemantic(((SQLNodeDelete)sQLNode).Predicate, n + 1);
                break;
            }
            case 7: {
                Trace.ShowString("NODE_TYPE_UPDATE", n);
                Trace.ShowSemantic(((SQLNodeUpdate)sQLNode).Table, n + 1);
                Trace.ShowSemantic(((SQLNodeUpdate)sQLNode).Updatevalues, n + 1);
                Trace.ShowSemantic(((SQLNodeUpdate)sQLNode).Predicate, n + 1);
                break;
            }
            case 30: {
                Trace.ShowString("NODE_TYPE_CREATEINDEX", n);
                Trace.ShowString(((SQLNodeCreateIndex)sQLNode).Index, n + 1);
                Trace.ShowBoolean(((SQLNodeCreateIndex)sQLNode).Unique, n + 1);
                Trace.ShowSemantic(((SQLNodeCreateIndex)sQLNode).Table, n + 1);
                Trace.ShowSemantic(((SQLNodeCreateIndex)sQLNode).Columns, n + 1);
                break;
            }
            case 31: {
                Trace.ShowString("NODE_TYPE_DROPINDEX", n);
                Trace.ShowString(((SQLNodeDropIndex)sQLNode).Index, n + 1);
                break;
            }
            case 8: {
                Trace.ShowString("NODE_TYPE_PASSTHROUGH", n);
                break;
            }
            case 9: {
                Trace.ShowString("NODE_TYPE_TABLES", n);
                Trace.ShowSemantic(((SQLNodeTables)sQLNode).Table, n + 1);
                Trace.ShowSemantic(((SQLNodeTables)sQLNode).Next, n + 1);
                break;
            }
            case 10: {
                Trace.ShowString("NODE_TYPE_VALUES", n);
                Trace.ShowSemantic(((SQLNodeValues)sQLNode).Value, n + 1);
                Trace.ShowSemantic(((SQLNodeValues)sQLNode).Next, n + 1);
                break;
            }
            case 11: {
                Trace.ShowString("NODE_TYPE_COLUMNS", n);
                Trace.ShowSemantic(((SQLNodeColumns)sQLNode).Column, n + 1);
                Trace.ShowSemantic(((SQLNodeColumns)sQLNode).Next, n + 1);
                break;
            }
            case 12: {
                Trace.ShowString("NODE_TYPE_SORTCOLUMNS", n);
                Trace.ShowSemantic(((SQLNodeSortColumns)sQLNode).Column, n + 1);
                if (((SQLNodeSortColumns)sQLNode).Descending) {
                    Trace.ShowString("DESC", n + 1);
                } else {
                    Trace.ShowString("ASC", n + 1);
                }
                Trace.ShowSemantic(((SQLNodeSortColumns)sQLNode).Next, n + 1);
                break;
            }
            case 13: {
                Trace.ShowString("NODE_TYPE_GROUPBYCOLUMNS", n);
                Trace.ShowSemantic(((SQLNodeGroupByColumns)sQLNode).Column, n + 1);
                Trace.ShowSemantic(((SQLNodeGroupByColumns)sQLNode).Next, n + 1);
                break;
            }
            case 14: {
                Trace.ShowString("NODE_TYPE_UPDATEVALUES", n);
                Trace.ShowSemantic(((SQLNodeUpdateValues)sQLNode).Column, n + 1);
                Trace.ShowSemantic(((SQLNodeUpdateValues)sQLNode).Value, n + 1);
                Trace.ShowSemantic(((SQLNodeUpdateValues)sQLNode).Next, n + 1);
                break;
            }
            case 15: {
                Trace.ShowString("NODE_TYPE_CREATECOLS", n);
                Trace.ShowString(((SQLNodeCreateColumns)sQLNode).Name, n + 1);
                Trace.ShowString(((SQLNodeCreateColumns)sQLNode).Type, n + 1);
                Trace.ShowUnsignedInteger(((SQLNodeCreateColumns)sQLNode).Params, n + 1);
                Trace.ShowSemantic(((SQLNodeCreateColumns)sQLNode).Next, n + 1);
                break;
            }
            case 16: {
                Trace.ShowString("NODE_TYPE_BOOLEAN", n);
                switch (((SQLNodeBoolean)sQLNode).Operator) {
                    case 16: {
                        Trace.ShowString("OP_NOT", n + 1);
                        break;
                    }
                    case 17: {
                        Trace.ShowString("OP_AND", n + 1);
                        break;
                    }
                    case 18: {
                        Trace.ShowString("OP_OR", n + 1);
                        break;
                    }
                    default: {
                        Trace.ShowString("OP_???", n + 1);
                    }
                }
                Trace.ShowSemantic(((SQLNodeBoolean)sQLNode).Left, n + 1);
                Trace.ShowSemantic(((SQLNodeBoolean)sQLNode).Right, n + 1);
                break;
            }
            case 17: {
                Trace.ShowString("NODE_TYPE_COMPARISON", n);
                switch (((SQLNodeComparison)sQLNode).Operator) {
                    case 1: {
                        Trace.ShowString("OP_EQ", n + 1);
                        break;
                    }
                    case 2: {
                        Trace.ShowString("OP_NE", n + 1);
                        break;
                    }
                    case 3: {
                        Trace.ShowString("OP_LE", n + 1);
                        break;
                    }
                    case 4: {
                        Trace.ShowString("OP_LT", n + 1);
                        break;
                    }
                    case 5: {
                        Trace.ShowString("OP_GE", n + 1);
                        break;
                    }
                    case 6: {
                        Trace.ShowString("OP_GT", n + 1);
                        break;
                    }
                    case 7: {
                        Trace.ShowString("OP_IN", n + 1);
                        break;
                    }
                    case 8: {
                        Trace.ShowString("OP_NOTIN", n + 1);
                        break;
                    }
                    case 9: {
                        Trace.ShowString("OP_LIKE", n + 1);
                        break;
                    }
                    case 10: {
                        Trace.ShowString("OP_NOTLIKE", n + 1);
                        break;
                    }
                    case 19: {
                        Trace.ShowString("OP_EXISTS", n + 1);
                        break;
                    }
                    default: {
                        Trace.ShowString("OP_???", n + 1);
                    }
                }
                switch (((SQLNodeComparison)sQLNode).SelectModifier) {
                    case 0: {
                        Trace.ShowString("SELECT_NOTSELECT", n + 1);
                        break;
                    }
                    case 1: {
                        Trace.ShowString("SELECT_ALL", n + 1);
                        break;
                    }
                    case 2: {
                        Trace.ShowString("SELECT_ANY", n + 1);
                        break;
                    }
                    case 3: {
                        Trace.ShowString("SELECT_ONE", n + 1);
                        break;
                    }
                    case 4: {
                        Trace.ShowString("SELECT_EXISTS", n + 1);
                        break;
                    }
                    default: {
                        Trace.ShowString("SELECT_???", n + 1);
                    }
                }
                Trace.ShowSemantic(((SQLNodeComparison)sQLNode).Left, n + 1);
                Trace.ShowSemantic(((SQLNodeComparison)sQLNode).Right, n + 1);
                break;
            }
            case 18: {
                Trace.ShowString("NODE_TYPE_ALGEBRAIC", n);
                Trace.ShowDataType(sQLNode.sqlDataType, n + 1);
                Trace.ShowSqlType(sQLNode.sqlSqlType, true, n + 1);
                Trace.ShowPrecision(sQLNode.sqlPrecision, n + 1);
                Trace.ShowScale(sQLNode.sqlScale, n + 1);
                switch (((SQLNodeAlgebraic)sQLNode).Operator) {
                    case 11: {
                        Trace.ShowString("OP_NEG", n + 1);
                        break;
                    }
                    case 12: {
                        Trace.ShowString("OP_PLUS", n + 1);
                        break;
                    }
                    case 13: {
                        Trace.ShowString("OP_MINUS", n + 1);
                        break;
                    }
                    case 14: {
                        Trace.ShowString("OP_TIMES", n + 1);
                        break;
                    }
                    case 15: {
                        Trace.ShowString("OP_DIVIDEDBY", n + 1);
                        break;
                    }
                    default: {
                        Trace.ShowString("OP_???", n + 1);
                    }
                }
                Trace.ShowSemantic(((SQLNodeAlgebraic)sQLNode).Left, n + 1);
                Trace.ShowSemantic(((SQLNodeAlgebraic)sQLNode).Right, n + 1);
                break;
            }
            case 32: {
                Trace.ShowString("NODE_TYPE_SCALAR", n);
                Trace.ShowDataType(sQLNode.sqlDataType, n + 1);
                Trace.ShowSqlType(sQLNode.sqlSqlType, true, n + 1);
                Trace.ShowPrecision(sQLNode.sqlPrecision, n + 1);
                Trace.ShowScale(sQLNode.sqlScale, n + 1);
                Trace.ShowString(((SQLNodeScalar)sQLNode).Function, n + 1);
                Trace.ShowSemantic(((SQLNodeScalar)sQLNode).Arguments, n + 1);
                break;
            }
            case 19: {
                Trace.ShowString("NODE_TYPE_AGGREGATE", n);
                Trace.ShowDataType(sQLNode.sqlDataType, n + 1);
                Trace.ShowSqlType(sQLNode.sqlSqlType, true, n + 1);
                Trace.ShowPrecision(sQLNode.sqlPrecision, n + 1);
                Trace.ShowScale(sQLNode.sqlScale, n + 1);
                switch (((SQLNodeAggregate)sQLNode).Operator) {
                    case 1: {
                        Trace.ShowString("AGG_AVG", n + 1);
                        break;
                    }
                    case 2: {
                        Trace.ShowString("AGG_COUNT", n + 1);
                        break;
                    }
                    case 3: {
                        Trace.ShowString("AGG_MAX", n + 1);
                        break;
                    }
                    case 4: {
                        Trace.ShowString("AGG_MIN", n + 1);
                        break;
                    }
                    case 5: {
                        Trace.ShowString("AGG_SUM", n + 1);
                        break;
                    }
                    default: {
                        Trace.ShowString("AGG_???", n + 1);
                    }
                }
                Trace.ShowSemantic(((SQLNodeAggregate)sQLNode).Expression, n + 1);
                break;
            }
            case 20: {
                Trace.ShowString("NODE_TYPE_TABLE", n);
                Trace.ShowString(((SQLNodeTable)sQLNode).Name, n + 1);
                Trace.ShowString(((SQLNodeTable)sQLNode).Alias, n + 1);
                Trace.ShowSemantic(((SQLNodeTable)sQLNode).OuterJoinPredicate, n + 1);
                break;
            }
            case 21: {
                Trace.ShowString("NODE_TYPE_COLUMN", n);
                Trace.ShowDataType(sQLNode.sqlDataType, n + 1);
                Trace.ShowSqlType(sQLNode.sqlSqlType, true, n + 1);
                Trace.ShowPrecision(sQLNode.sqlPrecision, n + 1);
                Trace.ShowScale(sQLNode.sqlScale, n + 1);
                Trace.ShowString(((SQLNodeColumn)sQLNode).Tablealias, n + 1);
                Trace.ShowString(((SQLNodeColumn)sQLNode).Column, n + 1);
                break;
            }
            case 22: {
                Trace.ShowString("NODE_TYPE_STRING", n);
                Trace.ShowDataType(sQLNode.sqlDataType, n + 1);
                Trace.ShowSqlType(sQLNode.sqlSqlType, true, n + 1);
                Trace.ShowPrecision(sQLNode.sqlPrecision, n + 1);
                Trace.ShowScale(sQLNode.sqlScale, n + 1);
                Trace.ShowString(((SQLNodeString)sQLNode).Value, n + 1);
                break;
            }
            case 23: {
                Trace.ShowString("NODE_TYPE_NUMERIC", n);
                Trace.ShowDataType(sQLNode.sqlDataType, n + 1);
                Trace.ShowSqlType(sQLNode.sqlSqlType, true, n + 1);
                Trace.ShowPrecision(sQLNode.sqlPrecision, n + 1);
                Trace.ShowScale(sQLNode.sqlScale, n + 1);
                Trace.ShowString(((SQLNodeNumeric)sQLNode).Numeric, n + 1);
                break;
            }
            case 24: {
                Trace.ShowString("NODE_TYPE_PARAMETER", n);
                Trace.ShowDataType(sQLNode.sqlDataType, n + 1);
                Trace.ShowSqlType(sQLNode.sqlSqlType, true, n + 1);
                Trace.ShowPrecision(sQLNode.sqlPrecision, n + 1);
                Trace.ShowScale(sQLNode.sqlScale, n + 1);
                Trace.ShowUnsignedInteger(((SQLNodeParameter)sQLNode).Id, n + 1);
                break;
            }
            case 25: {
                Trace.ShowString("NODE_TYPE_USER", n);
                break;
            }
            case 26: {
                Trace.ShowString("NODE_TYPE_NULL", n);
                Trace.ShowDataType(sQLNode.sqlDataType, n + 1);
                Trace.ShowSqlType(sQLNode.sqlSqlType, true, n + 1);
                Trace.ShowPrecision(sQLNode.sqlPrecision, n + 1);
                Trace.ShowScale(sQLNode.sqlScale, n + 1);
                break;
            }
            case 27: {
                Trace.ShowString("NODE_TYPE_DATE", n);
                Trace.ShowDataType(sQLNode.sqlDataType, n + 1);
                Trace.ShowSqlType(sQLNode.sqlSqlType, true, n + 1);
                Trace.ShowPrecision(sQLNode.sqlPrecision, n + 1);
                Trace.ShowScale(sQLNode.sqlScale, n + 1);
                Trace.ShowDate(((SQLNodeDate)sQLNode).Value, n + 1);
                break;
            }
            case 28: {
                Trace.ShowString("NODE_TYPE_TIME", n);
                Trace.ShowDataType(sQLNode.sqlDataType, n + 1);
                Trace.ShowSqlType(sQLNode.sqlSqlType, true, n + 1);
                Trace.ShowPrecision(sQLNode.sqlPrecision, n + 1);
                Trace.ShowScale(sQLNode.sqlScale, n + 1);
                Trace.ShowTime(((SQLNodeTime)sQLNode).Value, n + 1);
                break;
            }
            case 29: {
                Trace.ShowString("NODE_TYPE_TIMESTAMP", n);
                Trace.ShowDataType(sQLNode.sqlDataType, n + 1);
                Trace.ShowSqlType(sQLNode.sqlSqlType, true, n + 1);
                Trace.ShowPrecision(sQLNode.sqlPrecision, n + 1);
                Trace.ShowScale(sQLNode.sqlScale, n + 1);
                Trace.ShowTimeStamp(((SQLNodeTimestamp)sQLNode).Value, n + 1);
                break;
            }
            default: {
                Trace.ShowString("NODE_TYPE_???", n);
            }
        }
    }
}

