/*
 * Decompiled with CFR 0.152.
 */
package com.novell.sql;

import com.novell.sql.Errors;
import com.novell.sql.ISAMUtil;
import com.novell.sql.LDAPSQLExceptionCodes;
import com.novell.sql.Value;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;

class ValueChar
extends Value
implements LDAPSQLExceptionCodes {
    private String m_value;

    public ValueChar(String string) {
        super(1);
        this.m_value = string;
    }

    public void setValue(Value value) throws SQLException {
        this.m_value = value.getString();
    }

    public int compare(Value value) throws SQLException {
        if (value.m_javaType != 1) {
            throw Errors.sqlException(22);
        }
        return ISAMUtil.compareIgnoreCase(this.m_value, ((ValueChar)value).m_value);
    }

    public byte getByte() throws SQLException {
        try {
            return Byte.parseByte(this.m_value);
        }
        catch (NumberFormatException numberFormatException) {
            throw Errors.sqlException(25, this.m_value, "byte");
        }
    }

    public short getShort() throws SQLException {
        try {
            return Short.parseShort(this.m_value);
        }
        catch (NumberFormatException numberFormatException) {
            throw Errors.sqlException(25, this.m_value, "short");
        }
    }

    public int getInt() throws SQLException {
        try {
            return Integer.parseInt(this.m_value);
        }
        catch (NumberFormatException numberFormatException) {
            throw Errors.sqlException(25, this.m_value, "int");
        }
    }

    public long getLong() throws SQLException {
        try {
            return Long.parseLong(this.m_value);
        }
        catch (NumberFormatException numberFormatException) {
            throw Errors.sqlException(25, this.m_value, "Long");
        }
    }

    public float getFloat() throws SQLException {
        try {
            return Float.valueOf(this.m_value).floatValue();
        }
        catch (NumberFormatException numberFormatException) {
            throw Errors.sqlException(25, this.m_value, "float");
        }
    }

    public double getDouble() throws SQLException {
        try {
            return Double.valueOf(this.m_value);
        }
        catch (NumberFormatException numberFormatException) {
            throw Errors.sqlException(25, this.m_value, "double");
        }
    }

    public BigDecimal getBigDecimal() throws SQLException {
        return new BigDecimal(this.m_value);
    }

    public boolean getBoolean() throws SQLException {
        if (this.m_value.equalsIgnoreCase("false")) {
            return false;
        }
        if (this.m_value.equalsIgnoreCase("true")) {
            return true;
        }
        throw Errors.sqlException(25, this.m_value, "boolean");
    }

    public String getString() {
        return this.m_value;
    }

    public byte[] getBytes() {
        return this.m_value.getBytes();
    }

    public Date getDate() throws SQLException {
        try {
            return Date.valueOf(this.m_value);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw Errors.sqlException(25, this.m_value, "Date");
        }
    }

    public Time getTime() throws SQLException {
        try {
            return Time.valueOf(this.m_value);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw Errors.sqlException(25, this.m_value, "Time");
        }
    }

    public Timestamp getTimestamp() throws SQLException {
        try {
            return Timestamp.valueOf(this.m_value);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw Errors.sqlException(25, this.m_value, "Timestamp");
        }
    }

    public Object getObject() throws SQLException {
        return this.m_value;
    }

    public InputStream getAsciiStream() throws SQLException {
        return null;
    }

    public InputStream getUnicodeStream() throws SQLException {
        return null;
    }

    public InputStream getBinaryStream() throws SQLException {
        return null;
    }
}

