<!-------------------------------------------------------------------
$name: ExecuteQuery.jsp
$version: 1.0
$date_modified: 03/00/2001
$description: Executes an SQL query and presents the data in HTML
$owner: JDBC Driver Product Manager
$arguments: Get or Post method with SQL equal to an sql select statement.
Copyright (c) 2001 Novell, Inc. All Rights Reserved.

THIS WORK IS SUBJECT TO U.S. AND INTERNATIONAL COPYRIGHT LAWS AND TREATIES.
USE AND REDISTRIBUTION OF THIS WORK IS SUBJECT TO THE LICENSE AGREEMENT
ACCOMPANYING THE SOFTWARE DEVELOPMENT KIT (SDK) THAT CONTAINS THIS WORK.
PURSUANT TO THE SDK LICENSE AGREEMENT, NOVELL HEREBY GRANTS TO DEVELOPER A
ROYALTY-FREE, NON-EXCLUSIVE LICENSE TO INCLUDE NOVELL'S SAMPLE CODE IN ITS
PRODUCT. NOVELL GRANTS DEVELOPER WORLDWIDE DISTRIBUTION RIGHTS TO MARKET,
DISTRIBUTE, OR SELL NOVELL'S SAMPLE CODE AS A COMPONENT OF DEVELOPER'S
PRODUCTS. NOVELL SHALL HAVE NO OBLIGATIONS TO DEVELOPER OR DEVELOPER'S
CUSTOMERS WITH RESPECT TO THIS CODE.
---------------------------------------------------------------------->

<!-- This Java Server Page is a sample of how to execute an SQL query and
display results in HTML.  Also included in these samples is ExecuteQuery.java.
ExecuteQuery.java is very similar in functionality to this program.  This is
included to show how easy it is to display Directory content in a web page
using JDBC. -->

<%@ page
    errorPage="err.jsp"
    language="java"
    import="java.sql.*"
%>
<%-- All Exception Handling is done in err.jsp --%>

<html>
<Center>
<title>Sample jsp page for Novell's JDBC driver</title>
<h1>Novell's JDBC driver</h1>
<h2>Sample jsp page</h2>
</Center>

<%! Connection conn;
    Statement statement;
    ResultSet rs;
    ResultSetMetaData rsmd;
    String query, url, host, user, password, baseDN;
%>
<%	//Step #1: Load the JDBC:LDAP driver
    Class.forName("com.novell.sql.LDAPDriver");

        //Forming the URL
    host      = request.getParameter("HOST");     //assume localhost is null
    baseDN    = request.getParameter("BASEDN");   //assume root if null
    user      = request.getParameter("USER");     //assume anonymous bind if null
    password  = request.getParameter("PASSWORD");
    url = "JDBC:LDAP://";
    if (host == null)
      url += "localhost;";
    else
      url += host + ";";
    if (baseDN != null)
      url += "baseDN=" + baseDN + ";";
    url += "useCleartext=true";

    //Step #2: Connect to database
    conn = DriverManager.getConnection(url, user, password);

	//Step #3: Execute SQL statement
    query = request.getParameter("SQL");

	//Note: if no SQL statment is passed in then the following is a
	//default query:
    if (query == null)
		query = "Select cn, sn from inetOrgperson";
    statement = conn.createStatement();
    rs = statement.executeQuery(query);

	//Step #4: Extract Information
	// a) Table Rows:
    rsmd = rs.getMetaData();
%>


<body>
<Center>
<Table width="70%" Border="+5">
<TR>
    <TH colspan=<%= rsmd.getColumnCount() %>>
    <H1><Font color="red">Novell</font> eDirectory</H1>
<TR>
    <%
    for(int i=1; i <= rsmd.getColumnCount() ; i++){
    %>
        <TH><%= rsmd.getColumnLabel(i) %> </TH>
<%  }
	//Step #4
	//	b) Column Rows:

   	while(rs.next()) {
%>
    <TR>
        <% for(int i=1; i <=rsmd.getColumnCount() ; i++) { %>
              <TD>
                <%= rs.getString(i) %>
              </TD>
        <% } %>
    </TR>
<% } //end while %>

</table>
</center>
</body>
</html>
