/***************************************************************************
$name: TablesAndColumns.java 
$version: 1.0 
$date_modified: 020300 
$description: Writes a list of one or more table's column's to a text file
$owner: NJCL Product Manager 
Copyright (c) 1998 Novell, Inc. All Rights Reserved.

THIS WORK IS SUBJECT TO U.S. AND INTERNATIONAL COPYRIGHT LAWS AND TREATIES.
USE AND REDISTRIBUTION OF THIS WORK IS SUBJECT TO THE LICENSE AGREEMENT
ACCOMPANYING THE SOFTWARE DEVELOPMENT KIT (SDK) THAT CONTAINS THIS WORK.
PURSUANT TO THE SDK LICENSE AGREEMENT, NOVELL HEREBY GRANTS TO DEVELOPER A
ROYALTY-FREE, NON-EXCLUSIVE LICENSE TO INCLUDE NOVELL'S SAMPLE CODE IN ITS
PRODUCT. NOVELL GRANTS DEVELOPER WORLDWIDE DISTRIBUTION RIGHTS TO MARKET,
DISTRIBUTE, OR SELL NOVELL'S SAMPLE CODE AS A COMPONENT OF DEVELOPER'S
PRODUCTS. NOVELL SHALL HAVE NO OBLIGATIONS TO DEVELOPER OR DEVELOPER'S
CUSTOMERS WITH RESPECT TO THIS CODE.
****************************************************************************/
import java.util.*;
import java.sql.*;
import java.io.*;

    /**
     * The main method of this class will create a list of the all
     * of the tables and their columns available from a particular
     * LDAP server. The list is written to a text file named 
     * TablesAndColumns.txt. 
     *
     * The main method takes four command line arguments as listed below.
     *
     *   <server> - the IP address or domain name of the LDAP server.
     *      The default LDAP port is assumed.
     *   <user> - the complete distinguished name of the user to bind as.
     *   <password> - the password for the user.
     *   <table> - (optional) the name of the table whose columns will be
     *      listed. If this argument is omitted, then the columns for all
     *      tables are written to the file.
     */

class TablesAndColumns
{
   public static void main(
      String args[])
   {
      String      server;
      String      user;
      String      password;
      String      tableName = null;
      PrintWriter outFile;
      
      //get arguments
      if ((args.length != 3) &&
          (args.length != 4))
      {
         System.out.println(
          "Usage: java TablesAndColumns <server> <user> <password> [<table>]");
         System.out.println(
          "Example: java TablesAndColumns 139.48.122.134 " + 
           "cn=tjones,ou=sales,o=acme mypassword");
      }
      else
      {
         server = args[0];
         user = args[1];
         password = args[2];
         if (args.length == 4)
            tableName = args[3];
         
         try
         {
            //load the driver
            Class.forName("com.novell.sql.LDAPDriver");

            //get a driver instance
            Driver driver = DriverManager.getDriver("jdbc:ldap");

            Connection conn = 
             driver.connect("jdbc:ldap://" + server + ";user=" + user +
                            ";password=" + password + ";useCleartext=true", null); 

            DatabaseMetaData  metaData = conn.getMetaData();
            
            //open output file
            outFile = 
             new PrintWriter(new BufferedWriter(
              new FileWriter("TablesAndColumns.txt")));
            
            if (tableName == null)
            {
               //get a list of all tables
               ResultSet tables = metaData.getTables(null, null, "?", null);
               
               while (tables.next())
               {
                  tableName =  tables.getString("NAME"); //column 3 is tableName
                  outFile.println("Table name: " + tableName);

                  //get columns for this table            
                  ResultSet columns = 
                   metaData.getColumns(null, null, tableName, "?");
               
                  while (columns.next())
                  {
                     outFile.println("     column: " + columns.getString(4));
                     outFile.println("               Type: " + 
                                     columns.getString(6));
                  }
                  outFile.println("");
               }
            }
            else
            {
               // list columns for the specified table
               outFile.println("Table name: " + tableName);

               //get columns for this table            
               ResultSet columns = 
                metaData.getColumns(null, null, tableName, "?");
               
               while (columns.next())
               {
                  outFile.println("     column: " + columns.getString(4));
                  outFile.println("               Type: " + columns.getString(6));
               }
            }
            
            outFile.flush();
            outFile.close();
            //close the JDBC connection
            conn.close();
         }
         catch (SQLException e)
         {
            System.out.println(e.toString());
         }
         catch (ClassNotFoundException e)
         {
            System.out.println(
            "Could not find the Driver Class: com.novell.sql.LDAPDriver");
         }
         catch (IOException e)
         {
            System.out.println(e.toString());
         }
      }
        
   } //end method main
 
} //end class TablesAndColumns