/*
 * Decompiled with CFR 0.152.
 */
package com.novell.security.japi.pki;

import com.novell.security.japi.pki.NPKI_ASN1_Extensions;
import com.novell.security.japi.pki.NPKI_CertificateName;
import com.novell.security.japi.pki.NPKI_CertificateNamesList;
import com.novell.security.japi.pki.NPKI_Exception;
import com.novell.security.japi.pki.NPKI_ExtAltNames;
import com.novell.security.japi.pki.NPKI_Extension;
import com.novell.security.japi.pki.OSUtil;
import java.io.IOException;

public class NPKIAPI {
    private static final int ERR_NO_SUCH_ENTRY = -601;
    public static final int PKI_SUCCESS = 0;
    public static final int PKI_E_FILE_CREATE = -1201;
    public static final int PKI_E_FILE_OPEN = -1202;
    public static final int PKI_E_FILE_READ = -1203;
    public static final int PKI_E_FILE_WRITE = -1204;
    public static final int PKI_E_FILE_SEEK = -1205;
    public static final int PKI_E_CRYPT_INIT = -1206;
    public static final int PKI_E_NO_KEY_FILE = -1207;
    public static final int PKI_E_GENERATE_KEY = -1208;
    public static final int PKI_E_KEY_SIZE_NOT_SUPPORTED = -1209;
    public static final int PKI_E_KEYS_ALREADY_EXIST = -1210;
    public static final int PKI_E_UPDATE_KMO = -1211;
    public static final int PKI_E_INSUFFICIENT_MEMORY = -1212;
    public static final int PKI_E_BUFFER_OVERFLOW = -1213;
    public static final int PKI_E_BAD_REQUEST_SYNTAX = -1214;
    public static final int PKI_E_DSIO = -1215;
    public static final int PKI_E_CREATE_CERTIFICATE_OR_CSR = -1216;
    public static final int PKI_E_ALGORITHM_NOT_SUPPORTED = -1217;
    public static final int PKI_E_UNKNOWN_ATTRIBUTE = -1218;
    public static final int PKI_E_INVALID_NAME = -1219;
    public static final int PKI_E_INVALID_CREATE_CA_REQUEST = -1220;
    public static final int PKI_E_INVALID_OBJECT = -1221;
    public static final int PKI_E_NOT_SUPPORTED = -1222;
    public static final int PKI_E_ADD_TRUSTED_ROOT = -1223;
    public static final int PKI_E_ADD_KEYPAIR = -1224;
    public static final int PKI_E_ADD_CERTIFICATE = -1225;
    public static final int PKI_E_EXPECTING_CERTIFICATE = -1226;
    public static final int PKI_E_BROKEN_CHAIN = -1227;
    public static final int PKI_E_INIT_ERROR = -1228;
    public static final int PKI_E_WRONG_VERSION = -1229;
    public static final int PKI_E_ONLY_ONE_TREE_CA = -1230;
    public static final int PKI_E_BAD_ROOT_INDEX = -1231;
    public static final int PKI_E_SUBJECT_NAME_COMPARISON_FAILURE = -1232;
    public static final int PKI_E_PUBLIC_KEY_COMPARISON_FAILURE = -1233;
    public static final int PKI_E_NO_RIGHTS = -1234;
    public static final int PKI_TERISA_ESTABLISH_CONTEXT_ERROR = -1235;
    public static final int PKI_TERISA_ADD_ROOT_ERROR = -1236;
    public static final int PKI_TERISA_ADD_KEYS_ERROR = -1237;
    public static final int PKI_TERISA_ADD_CERTIFICATE_ERROR = -1238;
    public static final int PKI_E_SYSTEM_RESOURCES = -1239;
    public static final int PKI_E_PARSE_CERTIFICATE = -1240;
    public static final int PKI_E_NO_TREE_CA = -1241;
    public static final int PKI_E_INVALID_NICKNAME = -1242;
    public static final int PKI_E_USER_ALREADY_IN_LIST = -1243;
    public static final int PKI_E_USER_NOT_FOUND_IN_LIST = -1244;
    public static final int PKI_E_USER_CERT_NOT_FOUND = -1246;
    public static final int PKI_E_INVALID_ALGORITHM = -1247;
    public static final int PKI_E_INVALID_OPERATION = -1248;
    public static final int PKI_E_INVALID_DIGEST = -1249;
    public static final int PKI_E_DATA_NOT_READY = -1251;
    public static final int PKI_E_INVALID_KDK_ID = -1252;
    public static final int PKI_E_INTERNAL_ERROR = -1253;
    public static final int PKI_E_INVALID_CERTIFICATE_TIME = -1254;
    public static final int PKI_E_EXPIRED_CERTIFICATE = -1255;
    public static final int PKI_E_INVALID_SIGNATURE = -1256;
    public static final int PKI_E_KDK_TABLE_FULL = -1257;
    public static final int PKI_E_CERT_INVALID = -1258;
    public static final int PKI_E_CA_ALREADY_INSTALLED = -1259;
    public static final int PKI_E_CA_NOT_OPERATIONAL = -1260;
    public static final int PKI_E_KEY_FAILURE = -1261;
    public static final int PKI_E_INVALID_KEY_ID = -1262;
    public static final int PKI_E_ACCESS_DENIED = -1263;
    public static final int PKI_E_NICI_OUTOF_SYNC = -1264;
    public static final int PKI_E_NO_SECURITY_CONTAINER = -1265;
    public static final int PKI_E_NO_IP_ADDRESSES = -1266;
    public static final int PKI_E_NICKNAME_IN_USE = -1267;
    public static final int PKI_E_NOT_CONNECTED_TO_SERVICE = -1268;
    public static final int PKI_E_DUPLICATE = -1269;
    public static final int PKI_E_CRL_INVALID = -1270;
    public static final int PKI_E_CERT_NOT_FOUND = -1271;
    public static final int PKI_E_INVALID_CONTEXT = -1272;
    public static final int PKI_E_SERVICE_NOT_AVAILABLE = -1273;
    public static final int NPKI_INVALID_CONTEXT = -1;
    public static final int PKI_DEFAULT_CONFIGURATION = 0;
    public static final int PUBLIC_KEY_ORGANIZATIONAL_CA = 35;
    public static final int PKI_EXTENSION_INCLUDE = 0;
    public static final int PKI_EXTENSION_DONT_INCLUDE = 1;
    public static final int PKI_EXTENSION_NON_CRITICAL = 0;
    public static final int PKI_EXTENSION_CRITICAL = 2;
    public static final int X509_BASIC_CONSTRAINTS_CA = 256;
    public static final int NOVELL_EXTENSION_SERVER_DEFAULT = 256;
    public static final int NOVELL_EXTENSION_USER_DEFAULT = 512;
    public static final int NOVELL_EXTENSION_ORGCA_DEFAULT = 1024;
    public static final int NOVELL_EXTENSION_EXTRACTABLE_KEY = 65536;
    public static final int X509_KEY_USAGE_DIGITAL_SIGNATURE = 32768;
    public static final int X509_KEY_USAGE_NON_REPUDIATION = 16384;
    public static final int X509_KEY_USAGE_KEY_ENCIPHERMENT = 8192;
    public static final int X509_KEY_USAGE_DATA_ENCIPHERMENT = 4096;
    public static final int X509_KEY_USAGE_KEY_AGREEMENT = 2048;
    public static final int X509_KEY_USAGE_KEY_CERT_SIGN = 1024;
    public static final int X509_KEY_USAGE_CRL_SIGN = 512;
    public static final int X509_KEY_USAGE_ENCIPHER_ONLY = 256;
    public static final int X509_KEY_USAGE_DECIPHER_ONLY = 128;
    public static final int X509_GENERAL_NAME_OTHER_NAME = 0;
    public static final int X509_GENERAL_NAME_RFC822_NAME = 1;
    public static final int X509_GENERAL_NAME_DNS_NAME = 2;
    public static final int X509_GENERAL_NAME_X400_ADDRESS = 3;
    public static final int X509_GENERAL_NAME_DIRECTORY_NAME = 4;
    public static final int X509_GENERAL_NAME_EDI_PARTY_NAME = 5;
    public static final int X509_GENERAL_NAME_UNIFORM_RESOURCE_IDENTIFIER = 6;
    public static final int X509_GENERAL_NAME_IP_ADDRESS = 7;
    public static final int X509_GENERAL_NAME_REGISTERED_ID = 8;
    public static final int X509_SUBJECT_ALT_NAME_OTHER_NAME = 0;
    public static final int X509_SUBJECT_ALT_NAME_RFC822_NAME = 1;
    public static final int X509_SUBJECT_ALT_NAME_DNS_NAME = 2;
    public static final int X509_SUBJECT_ALT_NAME_X400_ADDRESS = 3;
    public static final int X509_SUBJECT_ALT_NAME_DIRECTORY_NAME = 4;
    public static final int X509_SUBJECT_ALT_NAME_EDI_PARTY_NAME = 5;
    public static final int X509_SUBJECT_ALT_NAME_UNIFORM_RESOURCE_IDENTIFIER = 6;
    public static final int X509_SUBJECT_ALT_NAME_IP_ADDRESS = 7;
    public static final int X509_SUBJECT_ALT_NAME_REGISTERED_ID = 8;
    public static final int PKI_RSA_ALGORITHM = 1;
    public static final int PKI_UNKNOWN_ALGORITM = 0;
    public static final int PKI_SIGN_WITH_RSA_AND_MD2 = 1;
    public static final int PKI_SIGN_WITH_RSA_AND_MD5 = 2;
    public static final int PKI_SIGN_WITH_RSA_AND_SHA1 = 4;
    public static final int PKI_SIGN_WITH_RSA_AND_SHA_256 = 8;
    public static final int PKI_SIGN_WITH_RSA_AND_SHA_384 = 16;
    public static final int PKI_SIGN_WITH_RSA_AND_SHA_512 = 32;
    public static final int OBJECT_KEY_CERT = 1;
    public static final int TRUSTED_ROOT_CERT = 2;
    public static final int CHAIN_CERT = 4;
    public static final int CHAIN_CERT_DESCENDING = 8;
    public static final int SELF_SIGNED_CERT = 16;
    public static final int WAIVE_SUBJECT_NAME_COMPARISON = 256;
    public static final int PRIVATE_KEY = 2;
    public static final int PRIVATE_KEY_EXTRACTABLE = 4;
    public static final int PKI_NO_CA = 0;
    public static final int PKI_ORGANIZATIONAL_CA = 1;
    public static final int PKI_SUB_ORGANIZATIONAL_CA = 2;
    public static final int NOVELL_CERT = 524288;
    public static final int TREE_CA_CERT = 0x100000;
    public static final int DEFAULT_YEAR_ENCODING = 0;
    public static final int TWO_DIGIT_YEAR = 0;
    public static final int FOUR_DIGIT_YEAR = 1;
    public static final int PKI_SERVICE_INFO = 0;
    public static final int PKI_CA_INFO = 1;
    public static final int PKI_USER_INFO = 2;
    public static final int PKI_SERVER_INFO = 3;
    public static final int PKI_SERVER_HEALTH_CHECK = 4;
    public static final int PKI_OVERWRITE_KEYPAIR = 1;
    public static final int PKI_STORE_PRIVKEY_IN_OBJECT = 2;
    public static final int PKI_PRIVATE_KEY_EXPORTABLE = 4;
    public static final int PKI_CUSTOM_SUBJECT_NAME = 4096;
    public static final int PUBLIC_KEY_SINGLE_SERVER = 306;
    public static final int PUBLIC_KEY_TWO_SERVER = 276;
    public static final int PUBLIC_KEY_EXTERNAL_CA = 276;
    public static final int KMO_EMPTY = 0;
    public static final int KMO_KEY_PAIR_PRESENT = 1;
    public static final int KMO_TRUSTED_ROOT_PRESENT = 2;
    public static final int KMO_CERTIFICATE_PRESENT = 3;
    public static final int KMO_CERTIFICATE_INVALID = -1;
    public static final int NO_CA_OPERATIONAL = 0;
    public static final int TREE_CA_OPERATIONAL = 1;
    public static final int SUB_CA_OPERATIONAL = 2;
    public static final int MAX_CERTIFICATE_SIZE = 65536;
    public static final int MAX_SINGLE_CERTIFICATE_SIZE = 8192;
    public static final int MAX_CSR_SIZE = 8192;
    public static final int MAX_NICK_NAME_BYTES = 1024;
    public static final int MAX_NICK_NAME_CHARS = 512;
    public static final int PKI_RETRY = 1;
    public static final int PKI_INVALID = -1;
    public static final int USER_CERT_RETRY_COUNT = 3;
    public static final int UNKNOWN_VERSION = 0;
    public static final int VERSION_ONE = 1;
    public static final int VERSION_TWO = 2;
    public static final int VERSION_THREE = 3;
    public static final int FIELD_NON_CRITICAL = 0;
    public static final int FIELD_CRITICAL = 1;
    public static final int PKI_INTERNAL_KEY_PAIR = 1;
    public static final int PKI_EXTERNAL_KEY_PAIR = 2;
    public static final int DIGITAL_SIGNATURE = 32768;
    public static final int NON_REPUDIATION = 16384;
    public static final int KEY_ENCIPHERMENT = 8192;
    public static final int DATA_ENCIPHERMENT = 4096;
    public static final int KEY_AGREEMENT = 2048;
    public static final int KEY_CERT_SIGN = 1024;
    public static final int CRL_SIGN = 512;
    public static final int ENCIPHER_ONLY = 256;
    public static final int DECIPHER_ONLY = 128;
    public static final int PKIS_VERSION_ONE = 65536;
    public static final int PKIS_VERSION_ONE_FIVE = 65541;
    public static final int PKIS_VERSION_TWO = 131072;
    public static final int PKIS_VERSION_ONE_ZERO_ZERO = 65536;
    public static final int PKIS_VERSION_ONE_ZERO_FIVE = 65541;
    public static final int PKIS_VERSION_ONE_ZERO_NINE = 65545;
    public static final int PKIS_VERSION_TWO_ZERO_ZERO = 131072;
    public static final int PKIS_VERSION_TWO_ZERO_TWO = 131074;
    public static final int PKIS_VERSION_TWO_ZERO_THREE = 131075;
    public static final int PKIS_VERSION_TWO_ONE_ONE = 131089;
    public static final int PKIS_VERSION_TWO_TWO_ZERO = 131584;
    public static final int PKIS_VERSION_TWO_TWO_ONE = 131585;
    public static final int PKIS_VERSION_TWO_FOUR_ZERO = 132096;
    public static final int PKIS_VERSION_TWO_FIVE_ZERO = 132352;
    public static final int PKIS_VERSION_TWO_FIVE_TWO = 132354;
    public static final int PKIS_VERSION_TWO_FIVE_FOUR = 132356;
    public static final int PKIS_VERSION_TWO_SIX_ZERO = 132608;
    public static final int PKIS_VERSION_TWO_SEVEN_ZERO = 132864;
    public static final int PKIS_VERSION_TWO_SEVEN_TWO = 132866;
    public static final int PKIS_VERSION_TWO_SEVEN_THREE = 132867;
    public static final int PKIS_VERSION_TWO_SEVEN_FOUR = 132868;
    public static final int PKIS_VERSION_TWO_SEVEN_FIVE = 132869;
    public static final int PKIS_VERSION_TWO_SEVEN_SIX = 132870;
    public static final int PKIS_VERSION_TWO_SEVEN_SEVEN = 132871;
    public static final int PKIS_VERSION_TWO_SEVEN_EIGHT = 132872;
    public static final int PKIS_VERSION_TWO_SEVEN_NINE = 132873;
    public static final int PKIS_VERSION_THREE_ZERO_ZERO = 196608;
    public static final int PKIS_VERSION_THREE_ONE_ZERO = 196864;
    public static final int PKIS_VERSION_THREE_ONE_ONE = 196865;
    public static final int PKI_CERTIFICATE_NORMAL = 4;
    public static final int PKI_CSR_PENDING = 9;
    public static final int PKI_PRIVATE_KEY_NOT_IN_NDS = 6;
    public static final int PKI_CERTIFICATE_ON_HOLD = 65541;
    public static final int PKI_ALL_VENDORS = 0;
    public static final int PKI_VENDOR_UNKNOWN = 1;
    public static final int PKI_VENDOR_EXTERNAL = 2;
    public static final int PKI_VENDOR_NOVELL = 3;
    public static final int PKI_VENDOR_ENTRUST = 4;
    public static final int PKI_VENDOR_VERISIGN = 5;
    public static final int PKI_OBJECT_KEY_CERTIFICATE = 1;
    public static final int PKI_TRUSTED_ROOT_CERTIFICATE = 2;
    public static final int PKI_CHAIN_CERTIFICATE = 4;
    public static final int PKI_SELF_SIGNED_CERTIFICATE = 16;
    public static final int PKI_CA_KEY_AND_CERTS = 21;
    public static final int PKI_NOVELL_CERTIFICATE = 524288;
    public static final int PKI_ORG_CA_CERTIFICATE = 0x100000;
    public static final int PKI_WAIVE_SUBJECT_NAME_IN_CERTIFICATE = 256;
    public static final int PKI_TYPE_CRL_CONTAINER = 1;
    public static final int PKI_TYPE_CERTIFICATE_CONTAINER = 2;
    public static final int PKI_MINUTES = 1;
    public static final int PKI_HOURS = 2;
    public static final int PKI_DAYS = 3;
    public static final int PKI_WEEKS = 4;
    public static final int PKI_MONTHS = 5;
    public static final int PKI_NS_DOS = 0;
    public static final int PKI_NS_MACINTOSH = 1;
    public static final int PKI_NS_UNIX = 2;
    public static final int PKI_NS_FTAM = 3;
    public static final int PKI_NS_OS2 = 4;
    public static final int PKI_CLEAR = 1;
    public static final int PKI_ADD = 2;
    public static final int PKI_DELETE = 4;
    public static final int PKI_SORT = 16;
    public static final int PKI_CLEAR_CERTS = 1;
    public static final int PKI_ADD_CERT = 2;
    public static final int PKI_DEL_CERT = 4;
    public static final int PKI_SORT_LIST = 16;
    public static final int EXTENSION_DONT_ENCODE = 1;
    public static final int EXTENSION_CRITICAL = 2;
    public static final int NPKI_CERTIFICATE_CREATE_NORMAL = 0;
    public static final int NPKI_CERTIFICATE_CREATE_FORCE = 1;
    public static final int NPKI_CERTIFICATE_CREATE_NO_OVERWRITE = 2;
    public static final int NPKI_CERTIFICATE_CREATE_CA_CHANGE_FORCE = 4;
    public static final int NPKI_DONT_QUERY_IP_AND_DNS = 16;
    public static final int NPKI_DONT_REPLACE_SSL_IP = 32;
    public static final int NPKI_DONT_REPLACE_SSL_DNS = 64;
    public static final int NPKI_CA_RIGHTS_DEFAULT = 0;
    public static final int NPKI_CA_RIGHTS_READ_NCP = 1;
    public static final int NPKI_CA_RIGHTS_WRITE_ALL = 2;
    public static final int NPKI_CA_RIGHTS_SELF_PROVISION_SERVER = 4;
    public static final int NPKI_CA_RIGHTS_SELF_PROVISION_USER = 8;
    public static final int NPKI_CA_RIGHTS_ISSUE_CRL_ALL = 16;
    public static final int NPKI_CA_CHANGE_HEALTH_CHECK_FORCE = 32;
    private long m_context = -1L;
    private static boolean m_libLoaded = false;

    private void loadLibrary() throws NPKI_Exception {
        if (!m_libLoaded) {
            try {
                if (OSUtil.getOSType() == 1) {
                    this.netwareLoadLibrary();
                } else {
                    System.loadLibrary("npkiapi");
                }
                m_libLoaded = true;
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                throw new NPKI_Exception("Unable to load NPKIAPI - library could not be found");
            }
            catch (SecurityException securityException) {
                throw new NPKI_Exception("Unable to load NPKIAPI - security exception");
            }
            catch (Throwable throwable) {
                throw new NPKI_Exception("Unable to load NPKIAPI");
            }
        }
    }

    private void netwareLoadLibrary() throws IOException {
        try {
            Runtime.getRuntime().exec("load npkiapi");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        System.loadLibrary("npkijni");
    }

    private void checkContext() throws NPKI_Exception {
        if (this.m_context == -1L) {
            throw new NPKI_Exception("Invalid | uninitialized context");
        }
    }

    public NPKIAPI() throws NPKI_Exception {
        this.initialize();
    }

    private static native int NPKICreateContext(Long var0);

    public void createContext() throws NPKI_Exception {
        Long l = new Long(0L);
        this.loadLibrary();
        this.freeContext();
        int n = NPKIAPI.NPKICreateContext(l);
        if (n != 0) {
            throw new NPKI_Exception(n);
        }
        this.m_context = l;
    }

    private static native void NPKIFreeContext(long var0);

    public void freeContext() throws NPKI_Exception {
        this.loadLibrary();
        if (this.m_context != -1L) {
            long l = this.m_context;
            this.m_context = -1L;
            NPKIAPI.NPKIFreeContext(l);
        }
    }

    private static native int NPKISetTreeName(long var0, String var2);

    public void setTreeName(String string) throws NPKI_Exception {
        this.loadLibrary();
        this.checkContext();
        int n = NPKIAPI.NPKISetTreeName(this.m_context, string);
        if (n != 0) {
            throw new NPKI_Exception(n);
        }
    }

    private static native int NPKISetDefaultDSContactServerDN(long var0, String var2);

    public void setDefaultDSContactServerDN(String string) throws NPKI_Exception {
        this.loadLibrary();
        this.checkContext();
        int n = NPKIAPI.NPKISetDefaultDSContactServerDN(this.m_context, string);
        if (n != 0) {
            throw new NPKI_Exception(n);
        }
    }

    private static native int NPKIGetDefaultDSContactServerDN(long var0, String[] var2);

    public String getDefaultDSContactServerDN() throws NPKI_Exception {
        String[] stringArray = new String[1];
        this.loadLibrary();
        this.checkContext();
        int n = NPKIAPI.NPKIGetDefaultDSContactServerDN(this.m_context, stringArray);
        if (n != 0) {
            throw new NPKI_Exception(n);
        }
        return stringArray[0];
    }

    private static native int NPKIDSLogin(long var0, String var2, String var3);

    public void dsLogin(String string, String string2) throws NPKI_Exception {
        this.loadLibrary();
        this.checkContext();
        int n = NPKIAPI.NPKIDSLogin(this.m_context, string, string2);
        if (n != 0) {
            throw new NPKI_Exception(n);
        }
    }

    private static native int NPKISetIdentity(long var0, int var2);

    public void setIdentity(int n) throws NPKI_Exception {
        this.loadLibrary();
        this.checkContext();
        int n2 = NPKIAPI.NPKISetIdentity(this.m_context, n);
        if (n2 != 0) {
            throw new NPKI_Exception(n2);
        }
    }

    private static native int NPKIDSLogout(long var0);

    public void dsLogout() throws NPKI_Exception {
        this.loadLibrary();
        this.checkContext();
        int n = NPKIAPI.NPKIDSLogout(this.m_context);
        if (n != 0) {
            throw new NPKI_Exception(n);
        }
    }

    private static native int NPKIDSConnectToReferral(long var0, byte[] var2);

    public void dsConnectToReferral(byte[] byArray) throws NPKI_Exception {
        this.loadLibrary();
        this.checkContext();
        int n = NPKIAPI.NPKIDSConnectToReferral(this.m_context, byArray);
        if (n != 0) {
            throw new NPKI_Exception(n);
        }
    }

    private static native int NPKIDeleteDSObject(long var0, String var2);

    public void deleteDSObject(String string) throws NPKI_Exception {
        this.loadLibrary();
        this.checkContext();
        int n = NPKIAPI.NPKIDeleteDSObject(this.m_context, string);
        if (n != 0) {
            throw new NPKI_Exception(n);
        }
    }

    private static native int NPKIFindKeyGenServersForUser(long var0, String var2, Integer var3);

    public int findKeyGenServersForUser(String string) throws NPKI_Exception {
        Integer n = new Integer(0);
        this.loadLibrary();
        this.checkContext();
        int n2 = NPKIAPI.NPKIFindKeyGenServersForUser(this.m_context, string, n);
        if (n2 != 0) {
            throw new NPKI_Exception(n2);
        }
        return n;
    }

    private static native int NPKIFindServersInContext(long var0, String var2, Integer var3);

    public int findServersInContext(String string) throws NPKI_Exception {
        Integer n = new Integer(0);
        this.loadLibrary();
        this.checkContext();
        int n2 = NPKIAPI.NPKIFindServersInContext(this.m_context, string, n);
        if (n2 != 0) {
            throw new NPKI_Exception(n2);
        }
        return n;
    }

    private static native int NPKIServerNames(long var0, int var2, String[] var3, String[] var4);

    public void serverNames(int n, String[] stringArray, String[] stringArray2) throws NPKI_Exception {
        this.loadLibrary();
        this.checkContext();
        int n2 = NPKIAPI.NPKIServerNames(this.m_context, n, stringArray, stringArray2);
        if (n2 != 0) {
            throw new NPKI_Exception(n2);
        }
    }

    private static native int NPKIFindOrganizationalCA(long var0, String[] var2);

    public String findOrganizationalCA() throws NPKI_Exception {
        String[] stringArray = new String[1];
        this.loadLibrary();
        this.checkContext();
        int n = NPKIAPI.NPKIFindOrganizationalCA(this.m_context, stringArray);
        if (n != 0) {
            throw new NPKI_Exception(n);
        }
        return stringArray[0];
    }

    private static native int NPKIReadSecurityRightsLevel(long var0, String var2, Integer var3);

    public void readSecurityRightsLevel(String string, Integer n) throws NPKI_Exception {
        this.loadLibrary();
        this.checkContext();
        int n2 = NPKIAPI.NPKIReadSecurityRightsLevel(this.m_context, string, n);
        if (n2 != 0) {
            throw new NPKI_Exception(n2);
        }
    }

    private static native int NPKISetSecurityRightsLevel(long var0, String var2, int var3);

    public void setSecurityRightsLevel(String string, int n) throws NPKI_Exception {
        this.loadLibrary();
        this.checkContext();
        int n2 = NPKIAPI.NPKISetSecurityRightsLevel(this.m_context, string, n);
        if (n2 != 0) {
            throw new NPKI_Exception(n2);
        }
    }

    private static native int NPKIGetCAInfo(long var0, String var2, Integer var3);

    public void getCAInfo(String string, Integer n) throws NPKI_Exception {
        this.loadLibrary();
        this.checkContext();
        int n2 = NPKIAPI.NPKIGetCAInfo(this.m_context, string, n);
        if (n2 != 0) {
            throw new NPKI_Exception(n2);
        }
    }

    private static native int NPKICRLConfigurationDN(long var0, int var2, Integer var3, String[] var4, String[] var5);

    public void cRLConfigurationDN(int n, Integer n2, String[] stringArray, String[] stringArray2) throws NPKI_Exception {
        this.loadLibrary();
        this.checkContext();
        int n3 = NPKIAPI.NPKICRLConfigurationDN(this.m_context, n, n2, stringArray, stringArray2);
        if (n3 != 0) {
            throw new NPKI_Exception(n3);
        }
    }

    private static native int NPKIGetServerUTCTime(long var0, String var2, Integer var3);

    public int getServerUTCTime(String string) throws NPKI_Exception {
        Integer n = new Integer(0);
        this.loadLibrary();
        this.checkContext();
        int n2 = NPKIAPI.NPKIGetServerUTCTime(this.m_context, string, n);
        if (n2 != 0) {
            throw new NPKI_Exception(n2);
        }
        return n;
    }

    private static native int NPKIGetHostServerDN(long var0, String var2, String[] var3);

    public String getHostServerDN(String string) throws NPKI_Exception {
        String[] stringArray = new String[1];
        this.loadLibrary();
        this.checkContext();
        int n = NPKIAPI.NPKIGetHostServerDN(this.m_context, string, stringArray);
        if (n != 0) {
            throw new NPKI_Exception(n);
        }
        return stringArray[0];
    }

    private static native int NPKIGetServerCertificateStatus(long var0, String var2, String var3, Integer var4);

    public int getServerCertificateStatus(String string, String string2) throws NPKI_Exception {
        Integer n = new Integer(0);
        this.loadLibrary();
        this.checkContext();
        int n2 = NPKIAPI.NPKIGetServerCertificateStatus(this.m_context, string, string2, n);
        if (n2 != 0) {
            throw new NPKI_Exception(n2);
        }
        return n;
    }

    private static native int NPKIGetSASServiceName(long var0, String var2, String[] var3);

    public String getSAServiceName(String string) throws NPKI_Exception {
        String[] stringArray = new String[1];
        this.loadLibrary();
        this.checkContext();
        int n = NPKIAPI.NPKIGetSASServiceName(this.m_context, string, stringArray);
        if (n != 0) {
            throw new NPKI_Exception(n);
        }
        return stringArray[0];
    }

    private static native int NPKIGetServerInfo(long var0, String var2, int var3, Integer var4, Integer var5, Integer var6, Integer var7, Integer var8, Integer var9, Integer var10, Integer var11);

    public void getServerInfo(String string, int n, Integer n2, Integer n3, Integer n4, Integer n5, Integer n6, Integer n7, Integer n8, Integer n9) throws NPKI_Exception {
        this.loadLibrary();
        this.checkContext();
        int n10 = NPKIAPI.NPKIGetServerInfo(this.m_context, string, n, n2, n3, n4, n5, n6, n7, n8, n9);
        if (n10 != 0) {
            throw new NPKI_Exception(n10);
        }
    }

    private static native int NPKIGetAlgorithmInfo(long var0, int var2, Integer var3, Integer var4, Integer var5);

    public void getAlgorithmInfo(int n, Integer n2, Integer n3, Integer n4) throws NPKI_Exception {
        this.loadLibrary();
        this.checkContext();
        int n5 = NPKIAPI.NPKIGetAlgorithmInfo(this.m_context, n, n2, n3, n4);
        if (n5 != 0) {
            throw new NPKI_Exception(n5);
        }
    }

    private static native int NPKIGenerateCertificateFromCSR(long var0, String var2, byte[] var3, String var4, int var5, int var6, int var7, int var8, NPKI_Extension var9, NPKI_Extension var10, NPKI_ExtAltNames var11, NPKI_Extension var12, NPKI_ASN1_Extensions var13);

    public void generateCertificateFromCSR(String string, byte[] byArray, String string2, int n, int n2, int n3, int n4, NPKI_Extension nPKI_Extension, NPKI_Extension nPKI_Extension2, NPKI_ExtAltNames nPKI_ExtAltNames, NPKI_Extension nPKI_Extension3, NPKI_ASN1_Extensions nPKI_ASN1_Extensions) throws NPKI_Exception {
        this.loadLibrary();
        this.checkContext();
        int n5 = NPKIAPI.NPKIGenerateCertificateFromCSR(this.m_context, string, byArray, string2, n, n2, n3, n4, nPKI_Extension, nPKI_Extension2, nPKI_ExtAltNames, nPKI_Extension3, nPKI_ASN1_Extensions);
        if (n5 != 0) {
            throw new NPKI_Exception(n5);
        }
    }

    private static native int NPKIDSObjectExists(long var0, String var2);

    public boolean dsObjectExists(String string) throws NPKI_Exception {
        boolean bl = false;
        this.loadLibrary();
        this.checkContext();
        int n = NPKIAPI.NPKIDSObjectExists(this.m_context, string);
        if (0 == n) {
            bl = true;
        } else if (-601 != n) {
            throw new NPKI_Exception(n);
        }
        return bl;
    }

    private static native int NPKICreateServerCertificate(long var0, String var2, String var3, String var4, int var5, int var6, String var7, int var8, int var9, int var10, int var11, int var12, int var13, NPKI_Extension var14, NPKI_Extension var15, NPKI_ExtAltNames var16, NPKI_Extension var17, NPKI_ASN1_Extensions var18);

    public void createServerCertificate(String string, String string2, String string3, int n, int n2, String string4, int n3, int n4, int n5, int n6, int n7, int n8, NPKI_Extension nPKI_Extension, NPKI_Extension nPKI_Extension2, NPKI_ExtAltNames nPKI_ExtAltNames, NPKI_Extension nPKI_Extension3, NPKI_ASN1_Extensions nPKI_ASN1_Extensions) throws NPKI_Exception {
        this.loadLibrary();
        this.checkContext();
        int n9 = NPKIAPI.NPKICreateServerCertificate(this.m_context, string, string2, string3, n, n2, string4, n3, n4, n5, n6, n7, n8, nPKI_Extension, nPKI_Extension2, nPKI_ExtAltNames, nPKI_Extension3, nPKI_ASN1_Extensions);
        if (n9 != 0) {
            throw new NPKI_Exception(n9);
        }
    }

    private static native int NPKICSRInfo(long var0, byte[][] var2);

    public byte[] csrInfo() throws NPKI_Exception {
        byte[][] byArrayArray = new byte[1][];
        this.loadLibrary();
        this.checkContext();
        int n = NPKIAPI.NPKICSRInfo(this.m_context, byArrayArray);
        if (n != 0) {
            throw new NPKI_Exception(n);
        }
        return byArrayArray[0];
    }

    private static native int NPKICertInfo(long var0, byte[][] var2);

    public byte[] certInfo() throws NPKI_Exception {
        byte[][] byArrayArray = new byte[1][];
        this.loadLibrary();
        this.checkContext();
        int n = NPKIAPI.NPKICertInfo(this.m_context, byArrayArray);
        if (n != 0) {
            throw new NPKI_Exception(n);
        }
        return byArrayArray[0];
    }

    private static native int NPKICreateUserCertificate(long var0, String var2, String var3, String var4, String var5, int var6, int var7, String var8, int var9, int var10, int var11, int var12, int var13, int var14, NPKI_Extension var15, NPKI_Extension var16, NPKI_ExtAltNames var17, NPKI_Extension var18, NPKI_ASN1_Extensions var19);

    public void createUserCertificate(String string, String string2, String string3, String string4, int n, int n2, String string5, int n3, int n4, int n5, int n6, int n7, int n8, NPKI_Extension nPKI_Extension, NPKI_Extension nPKI_Extension2, NPKI_ExtAltNames nPKI_ExtAltNames, NPKI_Extension nPKI_Extension3, NPKI_ASN1_Extensions nPKI_ASN1_Extensions) throws NPKI_Exception {
        this.loadLibrary();
        this.checkContext();
        int n9 = NPKIAPI.NPKICreateUserCertificate(this.m_context, string, string2, string3, string4, n, n2, string5, n3, n4, n5, n6, n7, n8, nPKI_Extension, nPKI_Extension2, nPKI_ExtAltNames, nPKI_Extension3, nPKI_ASN1_Extensions);
        if (n9 != 0) {
            throw new NPKI_Exception(n9);
        }
    }

    private static native int NPKIDeleteUserCertificate(long var0, String var2, String var3, int var4, byte[] var5);

    public void deleteUserCertificate(String string, String string2, int n, byte[] byArray) throws NPKI_Exception {
        this.loadLibrary();
        this.checkContext();
        int n2 = NPKIAPI.NPKIDeleteUserCertificate(this.m_context, string, string2, n, byArray);
        if (n2 != 0) {
            throw new NPKI_Exception(n2);
        }
    }

    private static native int NPKIReadAllNickNames(long var0, String var2, Integer var3);

    public int readAllNickNames(String string) throws NPKI_Exception {
        Integer n = new Integer(0);
        this.loadLibrary();
        this.checkContext();
        int n2 = NPKIAPI.NPKIReadAllNickNames(this.m_context, string, n);
        if (n2 != 0) {
            throw new NPKI_Exception(n2);
        }
        return n;
    }

    private static native int NPKINickName(long var0, int var2, String[] var3);

    public String nickName(int n) throws NPKI_Exception {
        String[] stringArray = new String[1];
        this.loadLibrary();
        this.checkContext();
        int n2 = NPKIAPI.NPKINickName(this.m_context, n, stringArray);
        if (n2 != 0) {
            throw new NPKI_Exception(n2);
        }
        return stringArray[0];
    }

    private static native int NPKIStoreUserCertificate(long var0, String var2, String var3, String var4, int var5, byte[] var6, int var7, byte[] var8);

    public void storeUserCertificate(String string, String string2, String string3, int n, byte[] byArray, int n2) throws NPKI_Exception {
        this.loadLibrary();
        this.checkContext();
        int n3 = NPKIAPI.NPKIStoreUserCertificate(this.m_context, string, string2, string3, n, byArray, n2, null);
        if (n3 != 0) {
            throw new NPKI_Exception(n3);
        }
    }

    private static native int NPKICertificateList(long var0, byte[] var2, int var3, Integer var4);

    public int certificateList(byte[] byArray, int n) throws NPKI_Exception {
        Integer n2 = new Integer(0);
        this.loadLibrary();
        this.checkContext();
        int n3 = NPKIAPI.NPKICertificateList(this.m_context, byArray, n, n2);
        if (n3 != 0) {
            throw new NPKI_Exception(n3);
        }
        return n2;
    }

    private static native int NPKIStoreServerCertificatesFromCertificateList(long var0, String var2, String var3, int var4, int var5);

    public void storeServerCertificatesFromCertificateList(String string, String string2, int n, int n2) throws NPKI_Exception {
        this.loadLibrary();
        this.checkContext();
        int n3 = NPKIAPI.NPKIStoreServerCertificatesFromCertificateList(this.m_context, string, string2, n, n2);
        if (n3 != 0) {
            throw new NPKI_Exception(n3);
        }
    }

    private static native int NPKIFindUserCertificates(long var0, String var2, String var3, byte[] var4, int var5, int var6, int var7, int var8, short var9, String var10, String var11, int var12, int var13, int var14, Integer var15);

    public int findUserCertificates(String string, String string2, byte[] byArray, int n, int n2, int n3, int n4, short s, String string3, String string4, int n5, int n6, int n7) throws NPKI_Exception {
        Integer n8 = new Integer(0);
        this.loadLibrary();
        this.checkContext();
        int n9 = NPKIAPI.NPKIFindUserCertificates(this.m_context, string, string2, byArray, n, n2, n3, n4, s, string3, string4, n5, n6, n7, n8);
        if (n9 != 0) {
            throw new NPKI_Exception(n9);
        }
        return n8;
    }

    private static native int NPKIUserCertInfo(long var0, int var2, String[] var3, byte[][] var4, Integer var5, byte[][] var6, Integer var7);

    public byte[] userCertInfo(int n, String[] stringArray, Integer n2, Integer n3) throws NPKI_Exception {
        byte[][] byArrayArray = new byte[1][];
        byte[][] byArrayArray2 = new byte[1][];
        this.loadLibrary();
        this.checkContext();
        int n4 = NPKIAPI.NPKIUserCertInfo(this.m_context, n, stringArray, byArrayArray, n2, byArrayArray2, n3);
        if (n4 != 0) {
            throw new NPKI_Exception(n4);
        }
        return byArrayArray[0];
    }

    private static native int NPKIImportUserKey(long var0, String var2, String var3, String var4, int var5, byte[] var6);

    public void importUserKey(String string, String string2, String string3, int n, byte[] byArray) throws NPKI_Exception {
        this.loadLibrary();
        this.checkContext();
        int n2 = NPKIAPI.NPKIImportUserKey(this.m_context, string, string2, string3, n, byArray);
        if (n2 != 0) {
            throw new NPKI_Exception(n2);
        }
    }

    private static native int NPKIImportServerKey(long var0, String var2, String var3, String var4, int var5, byte[] var6);

    public void importServerKey(String string, String string2, String string3, int n, byte[] byArray) throws NPKI_Exception {
        this.loadLibrary();
        this.checkContext();
        int n2 = NPKIAPI.NPKIImportServerKey(this.m_context, string, string2, string3, n, byArray);
        if (n2 != 0) {
            throw new NPKI_Exception(n2);
        }
    }

    private static native int NPKIImportCAKey(long var0, String var2, String var3, String var4, int var5, byte[] var6);

    public void importCAKey(String string, String string2, String string3, int n, byte[] byArray) throws NPKI_Exception {
        this.loadLibrary();
        this.checkContext();
        int n2 = NPKIAPI.NPKIImportCAKey(this.m_context, string, string2, string3, n, byArray);
        if (n2 != 0) {
            throw new NPKI_Exception(n2);
        }
    }

    private static native int NPKIExportUserKey(long var0, String var2, String var3, int var4, byte[][] var5);

    public byte[] exportUserKey(String string, String string2, int n) throws NPKI_Exception {
        byte[][] byArrayArray = new byte[1][];
        this.loadLibrary();
        this.checkContext();
        int n2 = NPKIAPI.NPKIExportUserKey(this.m_context, string, string2, n, byArrayArray);
        if (n2 != 0) {
            throw new NPKI_Exception(n2);
        }
        return byArrayArray[0];
    }

    private static native int NPKIExportServerKey(long var0, String var2, String var3, String var4, int var5, byte[][] var6);

    public byte[] exportServerKey(String string, String string2, String string3, int n) throws NPKI_Exception {
        byte[][] byArrayArray = new byte[1][];
        this.loadLibrary();
        this.checkContext();
        int n2 = NPKIAPI.NPKIExportServerKey(this.m_context, string, string2, string3, n, byArrayArray);
        if (n2 != 0) {
            throw new NPKI_Exception(n2);
        }
        return byArrayArray[0];
    }

    private static native int NPKIExportCAKey(long var0, String var2, String var3, int var4, byte[][] var5);

    public byte[] exportCAKey(String string, String string2, int n) throws NPKI_Exception {
        byte[][] byArrayArray = new byte[1][];
        this.loadLibrary();
        this.checkContext();
        int n2 = NPKIAPI.NPKIExportCAKey(this.m_context, string, string2, n, byArrayArray);
        if (n2 != 0) {
            throw new NPKI_Exception(n2);
        }
        return byArrayArray[0];
    }

    private static native int NPKIKMOExportRead(long var0, String var2, Integer var3);

    public void KMOExportRead(String string, Integer n) throws NPKI_Exception {
        this.loadLibrary();
        this.checkContext();
        int n2 = NPKIAPI.NPKIKMOExportRead(this.m_context, string, n);
        if (n2 != 0) {
            throw new NPKI_Exception(n2);
        }
    }

    private static native int NPKIKMOExportValue(long var0, int var2, String[] var3, String[] var4, String[] var5, Integer var6);

    public void KMOExportValue(int n, String[] stringArray, String[] stringArray2, String[] stringArray3, Integer n2) throws NPKI_Exception {
        this.loadLibrary();
        this.checkContext();
        int n3 = NPKIAPI.NPKIKMOExportValue(this.m_context, n, stringArray, stringArray2, stringArray3, n2);
        if (n3 != 0) {
            throw new NPKI_Exception(n3);
        }
    }

    private static native int NPKIKMOExportAddValue(long var0, String var2, String var3, String var4, int var5);

    public void KMOExportAddValue(String string, String string2, String string3, int n) throws NPKI_Exception {
        this.loadLibrary();
        this.checkContext();
        int n2 = NPKIAPI.NPKIKMOExportAddValue(this.m_context, string, string2, string3, n);
        if (n2 != 0) {
            throw new NPKI_Exception(n2);
        }
    }

    private static native int NPKIKMOExportClearValue(long var0, int var2);

    public void KMOExportClearValue(int n) throws NPKI_Exception {
        this.loadLibrary();
        this.checkContext();
        int n2 = NPKIAPI.NPKIKMOExportClearValue(this.m_context, n);
        if (n2 != 0) {
            throw new NPKI_Exception(n2);
        }
    }

    private static native int NPKIKMOExportClearAllValues(long var0);

    public void KMOExportClearAllValues() throws NPKI_Exception {
        this.loadLibrary();
        this.checkContext();
        int n = NPKIAPI.NPKIKMOExportClearAllValues(this.m_context);
        if (n != 0) {
            throw new NPKI_Exception(n);
        }
    }

    private static native int NPKIKMOExportWrite(long var0, String var2);

    public void KMOExportWrite(String string) throws NPKI_Exception {
        this.loadLibrary();
        this.checkContext();
        int n = NPKIAPI.NPKIKMOExportWrite(this.m_context, string);
        if (n != 0) {
            throw new NPKI_Exception(n);
        }
    }

    private static native int NPKICreateOrganizationalCA(long var0, String var2, String var3, int var4, int var5, String var6, int var7, int var8, int var9, int var10, int var11, int var12, NPKI_Extension var13, NPKI_Extension var14, NPKI_ExtAltNames var15, NPKI_Extension var16, NPKI_ASN1_Extensions var17, String[] var18, int var19);

    public String createOrganizationalCA(String string, String string2, int n, int n2, String string3, int n3, int n4, int n5, int n6, int n7, int n8, NPKI_Extension nPKI_Extension, NPKI_Extension nPKI_Extension2, NPKI_ExtAltNames nPKI_ExtAltNames, NPKI_Extension nPKI_Extension3, NPKI_ASN1_Extensions nPKI_ASN1_Extensions, int n9) throws NPKI_Exception {
        String[] stringArray = new String[1];
        this.loadLibrary();
        this.checkContext();
        int n10 = NPKIAPI.NPKICreateOrganizationalCA(this.m_context, string, string2, n, n2, string3, n3, n4, n5, n6, n7, n8, nPKI_Extension, nPKI_Extension2, nPKI_ExtAltNames, nPKI_Extension3, nPKI_ASN1_Extensions, stringArray, n9);
        if (n10 != 0) {
            throw new NPKI_Exception(n10);
        }
        return stringArray[0];
    }

    private static native int NPKIGetCRLConfigurationInfo(long var0, String var2, Integer var3, Integer var4, Integer var5, Integer var6, Integer var7, Integer var8, Integer var9, Integer var10, String[] var11, String[] var12, Integer var13, String[] var14, String[] var15);

    public void getCRLConfigurationInfo(String string, Integer n, Integer n2, Integer n3, Integer n4, Integer n5, Integer n6, Integer n7, Integer n8, String[] stringArray, String[] stringArray2, Integer n9, String[] stringArray3, String[] stringArray4) throws NPKI_Exception {
        this.loadLibrary();
        this.checkContext();
        int n10 = NPKIAPI.NPKIGetCRLConfigurationInfo(this.m_context, string, n, n2, n3, n4, n5, n6, n7, n8, stringArray, stringArray2, n9, stringArray3, stringArray4);
        if (n10 != 0) {
            throw new NPKI_Exception(n10);
        }
    }

    private static native int NPKICRLDistributionPoint(long var0, int var2, String[] var3);

    public void getCRLDistributionPoint(int n, String[] stringArray) throws NPKI_Exception {
        this.loadLibrary();
        this.checkContext();
        int n2 = NPKIAPI.NPKICRLDistributionPoint(this.m_context, n, stringArray);
        if (n2 != 0) {
            throw new NPKI_Exception(n2);
        }
    }

    private static native int NPKICreatePKIContainer(long var0, int var2, String var3, String var4, int var5, String var6);

    public void createPKIContainer(int n, String string, String string2, int n2, String string3) throws NPKI_Exception {
        this.loadLibrary();
        this.checkContext();
        int n3 = NPKIAPI.NPKICreatePKIContainer(this.m_context, n, string, string2, n2, string3);
        if (n3 != 0) {
            throw new NPKI_Exception(n3);
        }
    }

    private static native int NPKICreateCRLConfiguration(long var0, int var2, String var3, String var4, String var5);

    public void createCRLConfiguration(int n, String string, String string2, String string3) throws NPKI_Exception {
        this.loadLibrary();
        this.checkContext();
        int n2 = NPKIAPI.NPKICreateCRLConfiguration(this.m_context, n, string, string2, string3);
        if (n2 != 0) {
            throw new NPKI_Exception(n2);
        }
    }

    private static native int NPKISetCRLFileName(long var0, String var2, int var3, String var4, String var5);

    public void setCRLFileName(String string, int n, String string2, String string3) throws NPKI_Exception {
        this.loadLibrary();
        this.checkContext();
        int n2 = NPKIAPI.NPKISetCRLFileName(this.m_context, string, n, string2, string3);
        if (n2 != 0) {
            throw new NPKI_Exception(n2);
        }
    }

    private static native int NPKISetNextIssueTime(long var0, String var2, int var3);

    public void setNextIssueTime(String string, int n) throws NPKI_Exception {
        this.loadLibrary();
        this.checkContext();
        int n2 = NPKIAPI.NPKISetNextIssueTime(this.m_context, string, n);
        if (n2 != 0) {
            throw new NPKI_Exception(n2);
        }
    }

    private static native int NPKISetTimeInterval(long var0, String var2, int var3, int var4);

    public void setTimeInterval(String string, int n, int n2) throws NPKI_Exception {
        this.loadLibrary();
        this.checkContext();
        int n3 = NPKIAPI.NPKISetTimeInterval(this.m_context, string, n, n2);
        if (n3 != 0) {
            throw new NPKI_Exception(n3);
        }
    }

    private static native int NPKISetDistributionPoints(long var0, String var2, int var3, String var4);

    public void setDistributionPoints(String string, int n, String string2) throws NPKI_Exception {
        this.loadLibrary();
        this.checkContext();
        int n2 = NPKIAPI.NPKISetDistributionPoints(this.m_context, string, n, string2);
        if (n2 != 0) {
            throw new NPKI_Exception(n2);
        }
    }

    private static native int NPKISetCertificateAuthorityDN(long var0, String var2, String var3);

    public void setCertificateAuthorityDN(String string, String string2) throws NPKI_Exception {
        this.loadLibrary();
        this.checkContext();
        int n = NPKIAPI.NPKISetCertificateAuthorityDN(this.m_context, string, string2);
        if (n != 0) {
            throw new NPKI_Exception(n);
        }
    }

    private static native int NPKICreateCRLDistributionPoint(long var0, int var2, String var3, String var4, String var5);

    public void createCRLDistributionPoint(int n, String string, String string2, String string3) throws NPKI_Exception {
        this.loadLibrary();
        this.checkContext();
        int n2 = NPKIAPI.NPKICreateCRLDistributionPoint(this.m_context, n, string, string2, string3);
        if (n2 != 0) {
            throw new NPKI_Exception(n2);
        }
    }

    private static native int NPKISetDistributionPointDNList(long var0, String var2, int var3, int var4, String var5, String var6);

    public void setDistributionPointDNList(String string, int n, int n2, String string2, String string3) throws NPKI_Exception {
        this.loadLibrary();
        this.checkContext();
        int n3 = NPKIAPI.NPKISetDistributionPointDNList(this.m_context, string, n, n2, string2, string3);
        if (n3 != 0) {
            throw new NPKI_Exception(n3);
        }
    }

    private static native int NPKIIssueCRL(long var0, String var2, int var3);

    public void issueCRL(String string, int n) throws NPKI_Exception {
        this.loadLibrary();
        this.checkContext();
        int n2 = NPKIAPI.NPKIIssueCRL(this.m_context, string, n);
        if (n2 != 0) {
            throw new NPKI_Exception(n2);
        }
    }

    private static native int NPKIRevokeCertificate(long var0, String var2, String var3, byte[] var4, int var5, int var6, int var7, String var8, Integer var9);

    public void revokeCertificate(String string, String string2, byte[] byArray, int n, int n2, int n3, String string3, Integer n4) throws NPKI_Exception {
        this.loadLibrary();
        this.checkContext();
        int n5 = NPKIAPI.NPKIRevokeCertificate(this.m_context, string, string2, byArray, n, n2, n3, string3, n4);
        if (n5 != 0) {
            throw new NPKI_Exception(n5);
        }
    }

    private static native int NPKIGetServerKMOInfo(long var0, int var2, String var3, String var4, int var5, byte[][] var6, Integer var7, Integer var8, byte[][] var9, Integer var10, byte[][] var11);

    public void getServerKMOInfo(int n, String string, String string2, int n2, byte[][] byArray, Integer n3, Integer n4, byte[][] byArray2, Integer n5, byte[][] byArray3) throws NPKI_Exception {
        this.loadLibrary();
        this.checkContext();
        int n6 = NPKIAPI.NPKIGetServerKMOInfo(this.m_context, n, string, string2, n2, byArray, n3, n4, byArray2, n5, byArray3);
        if (n6 != 0) {
            throw new NPKI_Exception(n6);
        }
    }

    private static native int NPKIGetServerCertificates(long var0, String var2, String var3, int var4, byte[][] var5, Integer var6, Integer var7);

    public byte[] getServerCertificates(String string, String string2, int n, Integer n2, Integer n3) throws NPKI_Exception {
        byte[][] byArrayArray = new byte[1][];
        this.loadLibrary();
        this.checkContext();
        int n4 = NPKIAPI.NPKIGetServerCertificates(this.m_context, string, string2, n, byArrayArray, n2, n3);
        if (n4 != 0) {
            throw new NPKI_Exception(n4);
        }
        return byArrayArray[0];
    }

    private static native int NPKIGetCACertificates(long var0, String var2, int var3, byte[][] var4, byte[][] var5, Integer var6, Integer var7);

    public byte[] getCACertificates(String string, int n, Integer n2, Integer n3) throws NPKI_Exception {
        byte[][] byArrayArray = new byte[1][];
        byte[][] byArrayArray2 = new byte[1][];
        this.loadLibrary();
        this.checkContext();
        int n4 = NPKIAPI.NPKIGetCACertificates(this.m_context, string, n, byArrayArray, byArrayArray2, n2, n3);
        if (n4 != 0) {
            throw new NPKI_Exception(n4);
        }
        if (byArrayArray[0] != null) {
            return byArrayArray[0];
        }
        return byArrayArray2[0];
    }

    private static native int NPKIAdditionalRootsInfo(long var0, int var2, byte[][] var3);

    public byte[] additionalRootsInfo(int n) throws NPKI_Exception {
        byte[][] byArrayArray = new byte[1][];
        this.loadLibrary();
        this.checkContext();
        int n2 = NPKIAPI.NPKIAdditionalRootsInfo(this.m_context, n, byArrayArray);
        if (n2 != 0) {
            throw new NPKI_Exception(n2);
        }
        return byArrayArray[0];
    }

    private static native int NPKIChainCertInfo(long var0, int var2, byte[][] var3);

    public byte[] chainCertInfo(int n) throws NPKI_Exception {
        byte[][] byArrayArray = new byte[1][];
        this.loadLibrary();
        this.checkContext();
        int n2 = NPKIAPI.NPKIChainCertInfo(this.m_context, n, byArrayArray);
        if (n2 != 0) {
            throw new NPKI_Exception(n2);
        }
        return byArrayArray[0];
    }

    private static native int NPKIStoreServerCertificates(long var0, String var2, String var3, int var4, int var5, byte[] var6);

    public void storeServerCertificates(String string, String string2, int n, int n2, byte[] byArray) throws NPKI_Exception {
        this.loadLibrary();
        this.checkContext();
        int n3 = NPKIAPI.NPKIStoreServerCertificates(this.m_context, string, string2, n, n2, byArray);
        if (n3 != 0) {
            throw new NPKI_Exception(n3);
        }
    }

    private static native int NPKIFindServerCertificateNames(long var0, String var2, Integer var3);

    public int findServerCertificateNames(String string) throws NPKI_Exception {
        Integer n = new Integer(0);
        this.loadLibrary();
        this.checkContext();
        int n2 = NPKIAPI.NPKIFindServerCertificateNames(this.m_context, string, n);
        if (n2 != 0) {
            throw new NPKI_Exception(n2);
        }
        return n;
    }

    private static native int NPKIServerCertificateName(long var0, int var2, String[] var3);

    public String serverCertificateName(int n) throws NPKI_Exception {
        String[] stringArray = new String[1];
        this.loadLibrary();
        this.checkContext();
        int n2 = NPKIAPI.NPKIServerCertificateName(this.m_context, n, stringArray);
        if (n2 != 0) {
            throw new NPKI_Exception(n2);
        }
        return stringArray[0];
    }

    private static native int NPKIGetWrappedServerKey(long var0, String var2, String var3, byte[][] var4);

    public byte[] getWrappedServerKey(String string, String string2) throws NPKI_Exception {
        byte[][] byArrayArray = new byte[1][];
        this.loadLibrary();
        this.checkContext();
        int n = NPKIAPI.NPKIGetWrappedServerKey(this.m_context, string, string2, byArrayArray);
        if (n != 0) {
            throw new NPKI_Exception(n);
        }
        return byArrayArray[0];
    }

    private static native int NPKIGetServerIPAndDNSInfo(long var0, String var2, Integer var3);

    public int getServerIPAndDNSInfo(String string) throws NPKI_Exception {
        Integer n = new Integer(0);
        this.loadLibrary();
        this.checkContext();
        int n2 = NPKIAPI.NPKIGetServerIPAndDNSInfo(this.m_context, string, n);
        if (n2 != 0) {
            throw new NPKI_Exception(n2);
        }
        return n;
    }

    private static native int NPKIGetServerIPAddress(long var0, int var2, Short var3, byte[][] var4, String[] var5, Short var6);

    public byte[] getServerIPAddress(int n, Short s, String[] stringArray, Short s2) throws NPKI_Exception {
        byte[][] byArrayArray = new byte[1][];
        this.loadLibrary();
        this.checkContext();
        int n2 = NPKIAPI.NPKIGetServerIPAddress(this.m_context, n, s, byArrayArray, stringArray, s2);
        if (n2 != 0) {
            throw new NPKI_Exception(n2);
        }
        return byArrayArray[0];
    }

    private static native int NPKIGetServerDNSName(long var0, int var2, String[] var3);

    public String getServerDNSName(int n) throws NPKI_Exception {
        String[] stringArray = new String[1];
        this.loadLibrary();
        this.checkContext();
        int n2 = NPKIAPI.NPKIGetServerDNSName(this.m_context, n, stringArray);
        if (n2 != 0) {
            throw new NPKI_Exception(n2);
        }
        return stringArray[0];
    }

    private static native int NPKICreateTrustedRootContainer(long var0, String var2);

    public void createTrustedRootContainer(String string) throws NPKI_Exception {
        this.loadLibrary();
        this.checkContext();
        int n = NPKIAPI.NPKICreateTrustedRootContainer(this.m_context, string);
        if (n != 0) {
            throw new NPKI_Exception(n);
        }
    }

    private static native int NPKICreateTrustedRoot(long var0, String var2, byte[] var3);

    public void createTrustedRoot(String string, byte[] byArray) throws NPKI_Exception {
        this.loadLibrary();
        this.checkContext();
        int n = NPKIAPI.NPKICreateTrustedRoot(this.m_context, string, byArray);
        if (n != 0) {
            throw new NPKI_Exception(n);
        }
    }

    private static native int NPKIFindTrustedRootsInContext(long var0, String var2, Integer var3);

    public int findTrustedRootsInContext(String string) throws NPKI_Exception {
        Integer n = new Integer(0);
        this.loadLibrary();
        this.checkContext();
        int n2 = NPKIAPI.NPKIFindTrustedRootsInContext(this.m_context, string, n);
        if (n2 != 0) {
            throw new NPKI_Exception(n2);
        }
        return n;
    }

    private static native int NPKIGetTrustedRootInfo(long var0, int var2, String[] var3, String[] var4, String[] var5, String[] var6, byte[][] var7);

    public byte[] getTrustedRootInfo(int n, String[] stringArray, String[] stringArray2, String[] stringArray3, String[] stringArray4) throws NPKI_Exception {
        byte[][] byArrayArray = new byte[1][];
        this.loadLibrary();
        this.checkContext();
        int n2 = NPKIAPI.NPKIGetTrustedRootInfo(this.m_context, n, stringArray, stringArray2, stringArray3, stringArray4, byArrayArray);
        if (n2 != 0) {
            throw new NPKI_Exception(n2);
        }
        return byArrayArray[0];
    }

    private static native int NPKIVerifyCertificateWithTrustedRoots(long var0, byte[] var2, String var3, int var4, Integer var5, Integer var6, Integer var7, Integer var8, Integer var9);

    public void verifyCertificateWithTrustedRoots(byte[] byArray, String string, int n, Integer n2, Integer n3, Integer n4, Integer n5, Integer n6) throws NPKI_Exception {
        this.loadLibrary();
        this.checkContext();
        int n7 = NPKIAPI.NPKIVerifyCertificateWithTrustedRoots(this.m_context, byArray, string, n, n2, n3, n4, n5, n6);
        if (n7 != 0) {
            throw new NPKI_Exception(n7);
        }
    }

    private static native int NPKICreateSASServiceObject(long var0, String var2, String var3);

    public void createSASServiceObject(String string, String string2) throws NPKI_Exception {
        this.loadLibrary();
        this.checkContext();
        int n = NPKIAPI.NPKICreateSASServiceObject(this.m_context, string, string2);
        if (n != 0) {
            throw new NPKI_Exception(n);
        }
    }

    private static native int NPKIConnectToIPAddress(long var0, int var2, short var3, byte[] var4);

    public void connectToIPAddress(int n, short s, byte[] byArray) throws NPKI_Exception {
        this.loadLibrary();
        this.checkContext();
        int n2 = NPKIAPI.NPKIConnectToIPAddress(this.m_context, n, s, byArray);
        if (n2 != 0) {
            throw new NPKI_Exception(n2);
        }
    }

    private static native int NPKIConnectToIPAddressEx(long var0, int var2, short var3, byte[] var4, String[] var5, String[] var6);

    public void connectToIPAddress(int n, short s, byte[] byArray, String[] stringArray, String[] stringArray2) throws NPKI_Exception {
        this.loadLibrary();
        this.checkContext();
        int n2 = NPKIAPI.NPKIConnectToIPAddressEx(this.m_context, n, s, byArray, stringArray, stringArray2);
        if (n2 != 0) {
            throw new NPKI_Exception(n2);
        }
    }

    private static native int NPKIGetLocalServerInfo(long var0, String[] var2, String[] var3);

    public void getLocalServerInfo(String[] stringArray, String[] stringArray2) throws NPKI_Exception {
        this.loadLibrary();
        this.checkContext();
        int n = NPKIAPI.NPKIGetLocalServerInfo(this.m_context, stringArray, stringArray2);
        if (n != 0) {
            throw new NPKI_Exception(n);
        }
    }

    private static native int NPKIConnectToAddress(long var0, int var2, int var3, short var4, byte[] var5);

    public void connectToAddress(int n, int n2, short s, byte[] byArray) throws NPKI_Exception {
        this.loadLibrary();
        this.checkContext();
        int n3 = NPKIAPI.NPKIConnectToAddress(this.m_context, n, n2, s, byArray);
        if (n3 != 0) {
            throw new NPKI_Exception(n3);
        }
    }

    private static native int NPKIVersionInfo(Integer var0);

    public int versionInfo() throws NPKI_Exception {
        Integer n = new Integer(0);
        this.loadLibrary();
        this.checkContext();
        int n2 = NPKIAPI.NPKIVersionInfo(n);
        if (n2 != 0) {
            throw new NPKI_Exception(n2);
        }
        return n;
    }

    private static native int NPKICreateDefaultCertificates(long var0, String var2, NPKI_CertificateNamesList var3, Integer var4, Integer var5, Object var6, Object var7, Object var8, Object var9);

    public int createDefaultCertificates(String string, NPKI_CertificateNamesList nPKI_CertificateNamesList, Integer n) throws NPKI_Exception {
        Integer n2 = new Integer(0);
        this.loadLibrary();
        this.checkContext();
        int n3 = NPKIAPI.NPKICreateDefaultCertificates(this.m_context, string, nPKI_CertificateNamesList, n2, n, null, null, null, null);
        if (n3 != 0) {
            throw new NPKI_Exception(n3);
        }
        return n2;
    }

    private static native int NPKIAdditionalCertificate(long var0, int var2, NPKI_CertificateName var3);

    public NPKI_CertificateName additionalCertificate(int n) throws NPKI_Exception {
        NPKI_CertificateName nPKI_CertificateName = new NPKI_CertificateName();
        this.loadLibrary();
        this.checkContext();
        int n2 = NPKIAPI.NPKIAdditionalCertificate(this.m_context, n, nPKI_CertificateName);
        if (n2 != 0) {
            throw new NPKI_Exception(n2);
        }
        return nPKI_CertificateName;
    }

    private static native int NPKIDSLoginAsServer(long var0);

    public void DSLoginAsServer() throws NPKI_Exception {
        this.loadLibrary();
        this.checkContext();
        int n = NPKIAPI.NPKIDSLoginAsServer(this.m_context);
        if (n != 0) {
            throw new NPKI_Exception(n);
        }
    }

    public void initialize() throws NPKI_Exception {
        try {
            this.loadLibrary();
            this.createContext();
        }
        catch (NPKI_Exception nPKI_Exception) {
            this.destroy();
            throw nPKI_Exception;
        }
    }

    public void destroy() {
        try {
            this.freeContext();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void finalize() throws Throwable {
        try {
            this.destroy();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        super.finalize();
    }
}

