/*
 * Decompiled with CFR 0.152.
 */
package com.novell.security.japi.pki;

import com.novell.security.japi.pki.NPKIToolbox;
import com.novell.security.japi.pki.NPKI_Exception;

public class NPKITcache
extends NPKIToolbox {
    private long m_context = -1L;
    public static final int NPKIT_PEM_NORMAL_NAME = 0;
    public static final int NPKIT_PEM_ASCII_NAME = 1;
    public static final int NPKIT_PEM_OVERWRITE_FILE = 100;
    public static final int NPKIT_NORMAL_FORMAT = 0;
    public static final int NPKIT_PEM_FORMAT = 1;
    public static final int NPKIT_PEM_OBJ_UNKNOWN = 0;
    public static final int NPKIT_PEM_OBJ_X509 = 1;
    public static final int NPKIT_PEM_OBJ_X509_REQUEST = 2;
    public static final int NPKIT_PEM_OBJ_X509_TRUSTED = 3;
    public static final int NPKIT_PEM_OBJ_CRL = 4;
    public static final int NPKIT_PEM_OBJ_PKCS7 = 5;
    public static final int NPKIT_PEM_OBJ_WRAP_PRIV_KEY = 6;
    public static final int NPKIT_PEM_OBJ_TERISA_KEY_FILE = 7;
    public static final int NPKIT_PEM_OBJ_RSA_PRIV_KEY = 8;
    public static final int NPKIT_PEM_OBJ_PRIV_KEY = 9;

    public NPKITcache() throws NPKI_Exception {
        this.initialize();
    }

    public void initialize() throws NPKI_Exception {
        super.initialize();
    }

    public long getContextHandle() {
        return this.m_context;
    }

    private static native int cacheCreateContext(Long var0);

    public void createContext() throws NPKI_Exception {
        int n;
        Long l = new Long(0L);
        if (this.m_context != -1L) {
            this.freeContext();
        }
        if ((n = NPKITcache.cacheCreateContext(l)) != 0) {
            throw new NPKI_Exception(n);
        }
        this.m_context = l;
    }

    private static native void cacheFreeContext(long var0);

    public void freeContext() {
        if (this.m_context != -1L) {
            NPKITcache.cacheFreeContext(this.m_context);
        }
        this.m_context = -1L;
    }

    private static native void cacheClearAllElements(long var0);

    public void clearAllElements() {
        if (this.m_context == -1L) {
            NPKITcache.cacheClearAllElements(this.m_context);
        }
    }

    private static native int cacheAddElement(long var0, int var2, byte[] var3);

    public void addElement(int n, byte[] byArray) throws NPKI_Exception {
        if (this.m_context == -1L) {
            throw new NPKI_Exception(-1228);
        }
        int n2 = NPKITcache.cacheAddElement(this.m_context, n, byArray);
        if (n2 != 0) {
            throw new NPKI_Exception(n2);
        }
    }

    private static native int cacheAddPKCS12Elements(long var0, String var2, byte[] var3, Integer var4);

    public void addPKCS12Elements(String string, byte[] byArray, Integer n) throws NPKI_Exception {
        if (this.m_context == -1L) {
            throw new NPKI_Exception(-1228);
        }
        int n2 = NPKITcache.cacheAddPKCS12Elements(this.m_context, string, byArray, n);
        if (n2 != 0) {
            throw new NPKI_Exception(n2);
        }
    }

    private static native int cacheExportToPKCS12(long var0, int var2, String var3, String var4, String var5, byte[][] var6);

    public void exportToPKCS12(int n, String string, String string2, String string3, byte[][] byArray) throws NPKI_Exception {
        if (this.m_context == -1L) {
            throw new NPKI_Exception(-1228);
        }
        int n2 = NPKITcache.cacheExportToPKCS12(this.m_context, n, string, string2, string3, byArray);
        if (n2 != 0) {
            throw new NPKI_Exception(n2);
        }
    }

    private static native int cacheElementInfo(long var0, int var2, Integer var3, byte[][] var4, int var5);

    public int elementInfo(int n, byte[][] byArray) throws NPKI_Exception {
        Integer n2 = new Integer(0);
        if (this.m_context == -1L) {
            throw new NPKI_Exception(-1228);
        }
        int n3 = NPKITcache.cacheElementInfo(this.m_context, n, n2, byArray, 0);
        if (n3 != 0) {
            throw new NPKI_Exception(n3);
        }
        return n2;
    }

    public int elementInfo(int n, int n2, byte[][] byArray) throws NPKI_Exception {
        Integer n3 = new Integer(0);
        if (this.m_context == -1L) {
            throw new NPKI_Exception(-1228);
        }
        int n4 = NPKITcache.cacheElementInfo(this.m_context, n2, n3, byArray, n);
        if (n4 != 0) {
            throw new NPKI_Exception(n4);
        }
        return n3;
    }

    private static native int cacheWrite(long var0, int var2, String var3, String var4);

    public void write(int n, String string, String string2) throws NPKI_Exception {
        if (this.m_context == -1L) {
            throw new NPKI_Exception(-1228);
        }
        int n2 = NPKITcache.cacheWrite(this.m_context, n, string, string2);
        if (n2 != 0) {
            throw new NPKI_Exception(n2);
        }
    }

    private static native int cacheRead(long var0, int var2, String var3, String var4, Integer var5);

    public int read(int n, String string, String string2) throws NPKI_Exception {
        Integer n2 = new Integer(0);
        if (this.m_context == -1L) {
            throw new NPKI_Exception(-1228);
        }
        int n3 = NPKITcache.cacheRead(this.m_context, n, string, string2, n2);
        if (n3 != 0) {
            throw new NPKI_Exception(n3);
        }
        return n2;
    }
}

