/*
 * Decompiled with CFR 0.152.
 */
package com.novell.security.japi.pki;

import com.novell.security.japi.pki.NPKI_Exception;
import com.novell.security.japi.pki.OSUtil;
import java.io.IOException;
import java.util.Date;

public abstract class NPKIToolbox {
    private static boolean m_libLoaded = false;

    public abstract void createContext() throws NPKI_Exception;

    public abstract void freeContext() throws NPKI_Exception;

    protected void initialize() throws NPKI_Exception {
        this.loadLibrary();
        if ((double)this.version() < 2.4) {
            throw new NPKI_Exception("The java interface to NPKIT is newer than the native code");
        }
        this.createContext();
    }

    public void destroy() {
        try {
            this.freeContext();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void finalize() throws Throwable {
        try {
            this.destroy();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        super.finalize();
    }

    protected void loadLibrary() throws NPKI_Exception {
        if (!m_libLoaded) {
            try {
                if (OSUtil.getOSType() == 1) {
                    this.netwareLoadLibrary();
                } else {
                    System.loadLibrary("npkit");
                }
                m_libLoaded = true;
            }
            catch (Throwable throwable) {
                throw new NPKI_Exception("Unable to load the NPKIT library");
            }
        }
    }

    private void netwareLoadLibrary() throws IOException {
        try {
            Runtime.getRuntime().exec("load npkit");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        System.loadLibrary("npkitjni");
    }

    private static native int getNPKITVersion();

    public int version() throws NPKI_Exception {
        this.loadLibrary();
        return NPKIToolbox.getNPKITVersion();
    }

    public String getUTCString(Integer n) {
        return new Date(n.longValue() * 1000L).toString();
    }

    private static native int nativeDecodeCSR(byte[] var0, Integer var1, String[] var2, Integer var3, String[] var4, byte[][] var5, byte[][] var6, Integer var7, Integer var8, String[] var9);

    public void decodeCSR(byte[] byArray, Integer n, String[] stringArray, Integer n2, String[] stringArray2, byte[][] byArray2, byte[][] byArray3, Integer n3, Integer n4, String[] stringArray3) throws NPKI_Exception {
        this.loadLibrary();
        int n5 = NPKIToolbox.nativeDecodeCSR(byArray, n, stringArray, n2, stringArray2, byArray2, byArray3, n3, n4, stringArray3);
        if (n5 != 0) {
            throw new NPKI_Exception(n5);
        }
    }
}

