/*
 * Decompiled with CFR 0.152.
 */
package com.novell.security.japi.pki;

public class OSUtil {
    public static final int NETWARE = 1;
    private static final String NETWARE_VALUE = "NetWare";
    public static final int WINDOWS_XX = 2;
    private static final String WINDOWS_VALUE = "Windows";
    public static final int SOLARIS = 3;
    private static final String SOLARIS_VALUE = "SOLARIS";
    private static final String SunOs_VALUE = "SunOS";
    private static final String OSF_VALUE = "OSF-1";
    private static final String OSF1_VALUE = "OSF1";
    public static final int LINUX = 4;
    private static final String Linux_VALUE = "Linux";
    public static final int AIX = 5;
    private static final String AIX_VALUE = "AIX";
    public static final int HPUX = 6;
    private static final String HPUX_VALUE = "HP-UX";
    private static String OS_NAME_KEY = "os.name";
    private static String OS_VERSION_KEY = "os.version";
    private static String OS_HARDWARE_KEY = "os.arch";
    private static String JAVA_VERSION_KEY = "java.version";
    private static String JAVA_VENDOR_KEY = "java.vendor";
    private static String JAVA_VENDOR_URL_KEY = "java.vendor.url";
    private static String JAVA_HOME_KEY = "java.home";
    private static String JAVA_CLASS_VERSION_KEY = "java.class.version";
    private static String JAVA_CLASS_PATH_KEY = "java.class.path";
    private static String FILE_SEPARATOR_KEY = "file.separator";
    private static String PATH_SEPARATOR_KEY = "path.separator";
    private static String LINE_SEPARATOR_KEY = "line.separator";
    private static String USER_NAME_KEY = "user.name";
    private static String USER_HOME_KEY = "user.home";
    private static String USER_DIR_KEY = "user.dir";
    private static boolean osTypeInitialized = false;
    private static int osType;

    public static int getOSType() {
        if (!osTypeInitialized) {
            osType = OSUtil.initOSType();
            osTypeInitialized = true;
        }
        return osType;
    }

    public static int initOSType() {
        String string = System.getProperty(OS_NAME_KEY);
        if (string.startsWith(NETWARE_VALUE, 0)) {
            return 1;
        }
        if (string.startsWith(WINDOWS_VALUE, 0)) {
            return 2;
        }
        if (string.startsWith(SOLARIS_VALUE, 0)) {
            return 3;
        }
        if (string.startsWith(SunOs_VALUE, 0)) {
            return 3;
        }
        if (string.startsWith(OSF_VALUE, 0)) {
            return 3;
        }
        if (string.startsWith(OSF1_VALUE, 0)) {
            return 3;
        }
        if (string.startsWith(Linux_VALUE, 0)) {
            return 4;
        }
        if (string.startsWith(AIX_VALUE, 0)) {
            return 5;
        }
        if (string.startsWith(HPUX_VALUE, 0)) {
            return 6;
        }
        return 4;
    }

    public static String getOSName() {
        return System.getProperty(OS_NAME_KEY);
    }

    public static String getOSVersion() {
        return System.getProperty(OS_VERSION_KEY);
    }

    public static String getOSHardwareType() {
        return System.getProperty(OS_HARDWARE_KEY);
    }

    public static String getJavaVersion() {
        return System.getProperty(JAVA_VERSION_KEY);
    }

    public static String getJavaVendor() {
        return System.getProperty(JAVA_VENDOR_KEY);
    }

    public static String getJavaVendorURL() {
        return System.getProperty(JAVA_VENDOR_URL_KEY);
    }

    public static String getJavaHomeDir() {
        return System.getProperty(JAVA_HOME_KEY);
    }

    public static String getJavaClassVersion() {
        return System.getProperty(JAVA_CLASS_VERSION_KEY);
    }

    public static String getJavaClassPath() {
        return System.getProperty(JAVA_CLASS_PATH_KEY);
    }

    public static String getFileSeparator() {
        return System.getProperty(FILE_SEPARATOR_KEY);
    }

    public static String getPathSeparator() {
        return System.getProperty(PATH_SEPARATOR_KEY);
    }

    public static String getLineSeparator() {
        return System.getProperty(LINE_SEPARATOR_KEY);
    }

    public static String getUserName() {
        return System.getProperty(USER_NAME_KEY);
    }

    public static String getUserHomeDir() {
        return System.getProperty(USER_HOME_KEY);
    }

    public static String getUserDirctory() {
        return System.getProperty(USER_DIR_KEY);
    }

    public static String getSystemAttribute(String string) {
        return System.getProperty(string);
    }

    public static void delay(long l) {
        try {
            Thread.sleep(l);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static String formatMB(long l) {
        Float f;
        String string;
        StringBuffer stringBuffer = new StringBuffer();
        if (l < 1024L) {
            l = 0L;
        }
        float f2 = (float)l / 1048576.0f;
        int n = 0;
        if (f2 == 0.0f) {
            return new String("0");
        }
        if ((double)f2 >= 1.0) {
            n = (int)f2;
            f2 -= (float)n;
            stringBuffer.append(n);
        }
        if ((string = new String((f = new Float(f2)).toString())).length() > 4) {
            string = string.substring(0, 4);
        }
        if (string.indexOf(46) > -1) {
            string = string.substring(string.indexOf(46));
        }
        stringBuffer.append(string);
        return stringBuffer.toString();
    }
}

