/***************************************************************************

  Copyright (c) 2002-2006 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.
  
 *	File:				NPKIT_Cache.h
 *	Date:				October 30, 2002
 *
 *	Description:	Cache C APIs header file.  
 ***************************************************************************/

#ifndef   _NPKIT_CACHE_H_
#define   _NPKIT_CACHE_H_

#if defined(__cplusplus)
extern "C" {
#endif

#include <npkit.h>
#include <ntypes.h>
#if ! defined ( UNICODE_TYPE_DEFINED )
	#include "unicode.h"
#endif

/***************************************************************************/
// NPKIT_Cache context definations
//#define NPKIT_CacheContext					nuint32
//#define NPKIT_INVALID_CACHE_CONTEXT		0xffffffff

#define NPKIT_CacheContext						size_t
const	size_t NPKIT_INVALID_CACHE_CONTEXT = (size_t) -1;

/***************************************************************************/
// NPKIT_Cache Name Flags
#define NPKIT_PEM_NORMAL_NAME		 			0
#define NPKIT_PEM_ASCII_NAME		 			1
#define NPKIT_PEM_OVERWRITE_FILE				1000

/***************************************************************************/
// NPKIT_Cache	Element types
#define NPKIT_PEM_OBJ_UNKNOWN					0
#define NPKIT_PEM_OBJ_X509						1
#define NPKIT_PEM_OBJ_X509_REQUEST			2
#define NPKIT_PEM_OBJ_X509_TRUSTED			3
#define NPKIT_PEM_OBJ_CRL						4
#define NPKIT_PEM_OBJ_PKCS7					5
#define NPKIT_PEM_OBJ_WRAP_PRIV_KEY			6
#define NPKIT_PEM_OBJ_TERISA_KEY_FILE		7
#define NPKIT_PEM_OBJ_RSA_PRIV_KEY			8
#define NPKIT_PEM_OBJ_PRIV_KEY				9

/***************************************************************************/
// NPKIT_Cache Element Flags
#define NPKIT_NORMAL_FORMAT		 			0
#define NPKIT_PEM_FORMAT			 			1


N_EXTERN_LIBRARY (NWRCODE) NPKIT_CacheCreateContext
(
	NPKIT_CacheContext 		*context						// OUT
);

N_EXTERN_LIBRARY (void) NPKIT_CacheFreeContext
(
	NPKIT_CacheContext 		context						// IN
);

N_EXTERN_LIBRARY (void) NPKIT_CacheClearAllElements
(
	NPKIT_CacheContext 		context,						// IN
	void							*reserved1,					// for future use -- pass NULL
	void							*reserved2					// for future use -- pass NULL
);

N_EXTERN_LIBRARY (NWRCODE) NPKIT_CacheAddElement
(
	NPKIT_CacheContext 		context,						// IN
	const nuint32				elementType,				// IN
	const pnuint8 				data,							// IN
	const nuint32				dataLength,					// IN
	void							*reserved1,					// for future use -- pass NULL
	void							*reserved2,					// for future use -- pass NULL
	void							*reserved3,					// for future use -- pass NULL
	void							*reserved4					// for future use -- pass NULL
);

N_EXTERN_LIBRARY (NWRCODE) NPKIT_CacheAddPKCS12Elements
(
	NPKIT_CacheContext 		context,						// IN
	const unicode				*password,					// IN
	const pnuint8 				pfxData,						// IN
	const nuint32				pfxDataLength,				// IN
	nuint32						*numberOfElementsAdded,	// OUT
	void							*reserved1,					// for future use -- pass NULL
	void							*reserved2,					// for future use -- pass NULL
	void							*reserved3,					// for future use -- pass NULL
	void							*reserved4					// for future use -- pass NULL
);

N_EXTERN_LIBRARY (NWRCODE) NPKIT_CacheExportToPKCS12
(
	NPKIT_CacheContext 		context,						// IN
	const nuint32				flags,						// IN
	const unicode				*name,						// IN
	const char					*path,						// IN
	const unicode				*password,					// IN
	const nuint8				**pfxData,					// OUT
	nuint32						*pfxSize,					// OUT
	void							*reserved1,					// for future use -- pass NULL
	void							*reserved2,					// for future use -- pass NULL
	void							*reserved3,					// for future use -- pass NULL
	void							*reserved4					// for future use -- pass NULL
);

N_EXTERN_LIBRARY (NWRCODE) NPKIT_CacheElementInfo
(
	NPKIT_CacheContext 		context,						// IN
	const nuint32				index,						// IN
	pnuint32 					elementType,				// OUT
	nuint8 const				**data,						// OUT
	pnuint32 					dataLength,					// OUT
	pnuint32						flags,						// IN
	void							*reserved2,					// for future use -- pass NULL
	void							*reserved3,					// for future use -- pass NULL
	void							*reserved4					// for future use -- pass NULL
);

N_EXTERN_LIBRARY (NWRCODE) NPKIT_CacheWrite
(
	NPKIT_CacheContext 		context,						// IN
	const nuint32				flags,						// IN
	const unicode				*name,						// IN
	const char					*path,						// IN
	void							*reserved1,					// for future use -- pass NULL
	void							*reserved2					// for future use -- pass NULL
);

N_EXTERN_LIBRARY (NWRCODE) NPKIT_CacheRead
(
	NPKIT_CacheContext 		context,						// IN
	const nuint32				flags,						// IN
	const unicode				*name,						// IN
	const char					*path,						// IN
	pnuint32 					numberOfElements,			// OUT
	void							*reserved1,					// for future use -- pass NULL
	void							*reserved2					// for future use -- pass NULL
);

#if defined(__cplusplus)
}
#endif

#endif    //   _NPKIT_CACHE_H_ 
