/***************************************************************************

  Copyright (c) 2002-2007 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.
  
 *	File:				NPKIT_Certificate.h
 *	Date:				June 16, 2004
 *
 *	Description:	NPKIT Certificate APIs header file.  
 ***************************************************************************/

#ifndef   _NPKIT_CERTIFICATE_H_
#define   _NPKIT_CERTIFICATE_H_

#if defined(__cplusplus)
extern "C" {
#endif

#include <npkit.h>
#include <ntypes.h>
#include "npkicert.h"
#include "NPKIT_Cache.h"

#if ! defined ( UNICODE_TYPE_DEFINED )
	#include "unicode.h"
#endif
/***************************************************************************/
// NPKIT_Certificate context definations
//#define NPKIT_CertificateContext					nuint32
//#define NPKIT_INVALID_CERTIFICATE_CONTEXT		0xffffffff

#define NPKIT_CertificateContext						size_t
const	size_t NPKIT_INVALID_CERTIFICATE_CONTEXT = (size_t) -1;

/***************************************************************************/

N_EXTERN_LIBRARY (NWRCODE) NPKIT_CertificateCreateContext
(
	NPKIT_CertificateContext 		*context
);

N_EXTERN_LIBRARY (void) NPKIT_CertificateFreeContext
(
	NPKIT_CertificateContext 		context
);

N_EXTERN_LIBRARY (NWRCODE) NPKIT_CertificateCreate
(
	NPKIT_CertificateContext 		context,
	const nuint32						keyType, 
	const nuint32						keySize, 
	const unicode						*subjectDN, 
	const nuint32						signatureAlgorithm,
	const nuint32						flags,
	const nuint32						validFrom, 
	const nuint32						validTo,
	const nuint32						publicKeyFlags,
	const nuint32						privateKeyFlags,
	const NPKI_ASN1_Extensions		*extensions,
	void									*reserved1,// for future use -- pass NULL
	void									*reserved2,// for future use -- pass NULL
	void									*reserved3,// for future use -- pass NULL
	void									*reserved4 // for future use -- pass NULL
);

N_EXTERN_LIBRARY (NWRCODE) NPKIT_CertificateSignCertificate
(
	NPKIT_CertificateContext 		context,
	const NPKIT_CacheContext		signingCAContext,
	const nuint32						flags,
	const nuint8						*csr, 
	const nuint32						csrLen, 
	const unicode						*subjectDN, 
	const nuint32						validFrom, 
	const nuint32						validTo,
	const NPKI_ASN1_Extensions		*extensions,
	void									*reserved1,// for future use -- pass NULL
	void									*reserved2,// for future use -- pass NULL
	void									*reserved3,// for future use -- pass NULL
	void									*reserved4 // for future use -- pass NULL
);

N_EXTERN_LIBRARY (NWRCODE) NPKIT_CertificateSignData
(
	NPKIT_CertificateContext 		context,
	const NPKIT_CacheContext		signingContext,
	const nuint32						algorithmID,
	const nuint8						*data,
	const nuint32						dataLen,
	nuint8 const						**signedData,
	nuint32								*signedDataLen,
	void									*reserved1,// for future use -- pass NULL
	void									*reserved2,// for future use -- pass NULL
	void									*reserved3,// for future use -- pass NULL
	void									*reserved4 // for future use -- pass NULL
);

N_EXTERN_LIBRARY (NWRCODE) NPKIT_CertificateCertificateInfo
(
	NPKIT_CertificateContext 	context,
	nuint32 							*certificateSize,
	nuint8 const 					**certificate,
	void								*reserved1,// for future use -- pass NULL
	void								*reserved2 // for future use -- pass NULL
);

N_EXTERN_LIBRARY (NWRCODE) NPKIT_CertificateCSRInfo
(
	NPKIT_CertificateContext 	context,
	nuint32 							*CSRSize,
	nuint8 const 					**CSR,
	void								*reserved1,// for future use -- pass NULL
	void								*reserved2 // for future use -- pass NULL
);

N_EXTERN_LIBRARY (NWRCODE) NPKIT_CertificateWrappedPriavateKeyInfo
(
	NPKIT_CertificateContext 	context,
	nuint32 							*wrappedPriavateKeySize,
	nuint8 const 					**wrappedPriavateKey,
	void								*reserved1,// for future use -- pass NULL
	void								*reserved2 // for future use -- pass NULL
);

N_EXTERN_LIBRARY (NWRCODE) NPKIT_CertificateConvertKeyFormat
(
	NPKIT_CertificateContext 		context,
	const nuint32						inputFlags,
	const nuint32						outputFlags,
	const nuint8						*inputKey, 
	const nuint32						inputKeyLen, 
	nuint8 const						**outputKey, 
	nuint32								*outputKeyLen,
	void									*reserved1,// for future use -- pass NULL
	void									*reserved2,// for future use -- pass NULL
	void									*reserved3,// for future use -- pass NULL
	void									*reserved4 // for future use -- pass NULL
);

N_EXTERN_LIBRARY (NWRCODE) NPKIT_CertificateEncodeKeyUsageExtension
(
	NPKIT_CertificateContext 	context,
	nuint16 							keyUsageBits,
	nuint32 							critical,
	nuint32 							*encodedKeyUsageExtensionSize,
	nuint8 const 					**encodedKeyUsageExtension,
	void								*reserved1,// for future use -- pass NULL
	void								*reserved2 // for future use -- pass NULL
);

N_EXTERN_LIBRARY (NWRCODE) NPKIT_CertificateEncodeExtendedKeyUsageExtension
(
	NPKIT_CertificateContext 	context,
   nuint32							extendedKeyUsageBits,
	nuint32 							critical,
	nuint32 							*encodedExtendedKeyUsageExtensionSize,
	nuint8 const 					**encodedExtendedKeyUsageExtension,
	void								*reserved1,// for future use -- pass NULL
	void								*reserved2 // for future use -- pass NULL
);

N_EXTERN_LIBRARY (NWRCODE) NPKIT_CertificateEncodeBasicConstraintsExtension
(
	NPKIT_CertificateContext 	context,
   nuint32							cA,
   nuint32							pathConstraint,
	nuint32 							critical,
	nuint32 							*encodedBasicConstraintsExtensionSize,
	nuint8 const 					**encodedBasicConstraintsExtension,
	void								*reserved1,// for future use -- pass NULL
	void								*reserved2 // for future use -- pass NULL
);

N_EXTERN_LIBRARY (NWRCODE) NPKIT_CertificateEncodeSubjectAltNamesExtension
(
	NPKIT_CertificateContext 	context,
	NPKI_ExtAltNames 				*altNames,
	nuint32 							critical,
	nuint32 							*encodedSubjectAltNamesExtensionSize,
	nuint8 const 					**encodedSubjectAltNamesExtension,
	void								*reserved1,// for future use -- pass NULL
	void								*reserved2 // for future use -- pass NULL
);

N_EXTERN_LIBRARY (NWRCODE) NPKIT_CertificateEncodeAIAExtension
(
	NPKIT_CertificateContext 	context,
	NPKI_EXT_AIAValues			*AIANamesStruct,
	nuint32 							critical,
	nuint32 							*encodedAIAExtensionSize,
	nuint8 const 					**encodedAIAExtension,
	void								*reserved1,// for future use -- pass NULL
	void								*reserved2 // for future use -- pass NULL
);

#if defined(__cplusplus)
}
#endif

#endif    //   _NPKIT_CACHE_H_ 
