/***************************************************************************

  Copyright (c) 2002 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.
  
 *	File:				NPKIT_Verify.h
 *	Date:				January 30, 2002
 *
 *	Description:	NPKIT_Verify APIs header file.  
 ***************************************************************************/

#ifndef   _NPKIT_Verify_H_
#define   _NPKIT_Verify_H_

#if defined(__cplusplus)
extern "C" {
#endif

#include <npkit.h>
#if ! defined ( UNICODE_TYPE_DEFINED )
	#include "unicode.h"
#endif
#include <time.h>
#include "nverify.h"

// NPKIT_VerifyCertificate does not check CRLs use NPKIT_VerifyCertChain for complete verification
N_EXTERN_LIBRARY (NWRCODE) NPKIT_VerifyCertificate
(
	const pnuint8 				issuerCertificate,		// IN
	const nuint32 				issuerCertificateLen,	// IN
	const pnuint8 				subjectCertificate,		// IN 
	const nuint32 				subjectCertificateLen,	// IN
	const pnuint8 				CRL, 							// for future use -- pass NULL
	const nuint32 				CRLLen,						// for future use -- pass zero
	pnuint32						reason,						// OUT
	pnuint32						reserved,					// for future use -- pass NULL
	void							*reserved1,					// for future use -- pass NULL
	void							*reserved2,					// for future use -- pass NULL
	void							*reserved3,					// for future use -- pass NULL
	void							*reserved4					// for future use -- pass NULL
);

N_EXTERN_LIBRARY (NWRCODE) NPKIT_VerifyCertChain
(
	NPKI_CertChain						*certificates,				// IN
	nuint32								flags,						// IN
	pnuint32								cRLReason,					// OUT
	pnuint32								cRLHoldInstruction,		// OUT
	time_t  								*cRLRevocationTime,		// OUT
	time_t  								*cRLInvalidityDateTime,	// OUT
	NPKI_CertChain						**revokedCertificate,	// OUT
	pnuint32								certInvalidityReason,	// OUT
	NPKIT_CRLCacheContext			CRLCacheContext,			// IN (Optional)
	NPKIT_ENHANCED_VERIFY_OPTIONS	*enhancedOptions,			// IN (Optional)
	void									*reserved2,					// reserved for future use, pass NULL
	void									*reserved3,					// reserved for future use, pass NULL
	void									*reserved4					// reserved for future use, pass NULL
);

N_EXTERN_LIBRARY (NWRCODE) NPKIT_VerifyCertChainWithCallback
(
	NPKI_VerifyCallBackStruct	*data						// IN
);

N_EXTERN_LIBRARY (NWRCODE) NPKIT_VerifyIssuerSubjectNameMatch
(
	const pnuint8 				issuerCertificate,		// IN
	const nuint32 				issuerCertificateLen,	// IN
	const pnuint8 				subjectCertificate,		// IN
	const nuint32 				subjectCertificateLen	// IN
);

N_EXTERN_LIBRARY (NWRCODE) NPKIT_VerifySignatureWithCertificate
(
	const pnuint8 				data, 
	const nuint32 				dataLen,
	nuint32						algorithmId,
	const pnuint8 				signature, 
	const nuint32 				signatureLen,
	const pnuint8 				certificate, 
	const nuint32 				certificateLen,
	void							*reserved1,
	void							*reserved2,
	void							*reserved3,
	void							*reserved4
);

N_EXTERN_LIBRARY (NWRCODE) NPKIT_VerifyCertificatePrivateKeyAgreement
(
	const pnuint8 				certificate, 
	const nuint32 				certificateLen,
	const pnuint8 				wrappedPrivateKey,
	const nuint32 				wrappedPrivateKeyLen,
	void							*reserved1,
	void							*reserved2,
	void							*reserved3,
	void							*reserved4
);

N_EXTERN_LIBRARY (NWRCODE) NPKIT_CreateCRLCacheContext
(
	NPKIT_CRLCacheContext	*context
);

N_EXTERN_LIBRARY (void) NPKIT_FreeCRLCacheContext
(
	NPKIT_CRLCacheContext	context
);

#if defined(__cplusplus)
}
#endif
#endif    /*   _NPKIT_Verify_H_  */
