/***************************************************************************

  Copyright (c) 2002-2007 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.
  
 *	File:				NPKIT_x509.h
 *	Date:				January 30, 2002
 *
 *	Description:	x509 C APIs header file.  
 ***************************************************************************/

#ifndef   _NPKIT_X509_H_
#define   _NPKIT_X509_H_

#if defined(__cplusplus)
extern "C" {
#endif

#include <npkit.h>
#if ! defined ( UNICODE_TYPE_DEFINED )
	#include "unicode.h"
#endif
#include <time.h>

/***************************************************************************/
// NPKIT_x509CertList flags
#define NPKIT_CLEAR_CERTS									0x01
#define NPKIT_ADD_CERT										0x02
#define NPKIT_DEL_CERT										0x04
#define NPKIT_SORT_LIST										0x10

/***************************************************************************/
// NPKIT_x509 context definations
//#define NPKIT_x509Context								nuint32
//#define NPKIT_CRLContext									nuint32
//#define NPKIT_CSRContext									nuint32
//#define NPKIT_x509CertListContext						nuint32
//#define NPKIT_INVALID_X509_CONTEXT					0xffffffff
//#define NPKIT_INVALID_CRL_CONTEXT						0xffffffff
//#define NPKIT_INVALID_CSR_CONTEXT						0xffffffff
//#define NPKIT_INVALID_X509CertList_CONTEXT			0xffffffff

#define NPKIT_x509Context									size_t
#define NPKIT_CRLContext									size_t
#define NPKIT_CSRContext									size_t
#define NPKIT_x509CertListContext						size_t
const	size_t NPKIT_INVALID_X509_CONTEXT = (size_t) -1;
const	size_t NPKIT_INVALID_CRL_CONTEXT = (size_t) -1;
const	size_t NPKIT_INVALID_CSR_CONTEXT = (size_t) -1;
const	size_t NPKIT_INVALID_X509CertList_CONTEXT = (size_t) -1;

/***************************************************************************/
// Possible "dataSet" values from NPKIT_x509CRLDistributionPoint()
#define NPKIT_x509DistPtsFullName						0x0001
#define NPKIT_x509DistPtsNameRelativeToCRLIssuer	0x0002
#define NPKIT_x509DistPtsReasons							0x0004
#define NPKIT_x509DistPtsCRLIssuer						0x0008

/***************************************************************************/
// Possible "reasons" values from NPKIT_x509CRLDistributionPoint()
#define NPKIT_x509UnknownType								0x00000000
#define NPKIT_x509CRLType									0x00000001
#define NPKIT_x509DeltaCRLType							0x00000002
#define NPKIT_x509OnlyUserCertsType						0x00000004
#define NPKIT_x509OnlyCACertsType						0x00000008
#define NPKIT_x509OnlySomeReasonsType					0x00000010
#define NPKIT_x509IndirectCRLType						0x00000020

/***************************************************************************/
// Possible "accessMethods" from NPKIT_x509AuthorityInformationAccess()
#define NPKIT_x509UnknownAccessMethod					0x00000000
#define NPKIT_x509OCSP										0x00000001
#define NPKIT_x509CAIssuers								0x00000002

// The following enum has been changed because of naming conflicts  7/26/2006
//enum NPKIT_x509Extension
//{
//	None,		   
//	Unknown,
//	DecodeError,
//	AuthorityKeyIdentifier,
//	SubjectKeyIdentifier,
//	KeyUsage,
//	PrivateKeyUsagePeriod,
//	CertificatePolicies,
//	PolicyMapping,
//	SubjectAltName,
//	IssuerAltName,
//	SubjectDirectoryAttributes,
//	BasicConstraints,
//	NameConstraints,
//	PolicyConstraints,
//	CRLDistributionPoints,
//	ExtendedKeyUsage,
//	AuthorityInfoAccess,
//	NovellAttribute,
//	CRLNumber,
//	ReasonCode,
//	InstructionCode,
//	InvalidityDate,
//	DeltaCRLIndicator,
//	IssuingDistributionPoint,
//	CertificateIssuer,
//	InhibitAnyPolicy,
//	FreshestCRL,
//	OCSPNoCheck
//};
enum NPKIT_x509Extension
{
	NPKIT_x509_None,		   
	NPKIT_x509_Unknown,
	NPKIT_x509_DecodeError,
	NPKIT_x509_AuthorityKeyIdentifier,
	NPKIT_x509_SubjectKeyIdentifier,
	NPKIT_x509_KeyUsage,
	NPKIT_x509_PrivateKeyUsagePeriod,
	NPKIT_x509_CertificatePolicies,
	NPKIT_x509_PolicyMapping,
	NPKIT_x509_SubjectAltName,
	NPKIT_x509_IssuerAltName,
	NPKIT_x509_SubjectDirectoryAttributes,
	NPKIT_x509_BasicConstraints,
	NPKIT_x509_NameConstraints,
	NPKIT_x509_PolicyConstraints,
	NPKIT_x509_CRLDistributionPoints,
	NPKIT_x509_ExtendedKeyUsage,
	NPKIT_x509_AuthorityInfoAccess,
	NPKIT_x509_NovellAttribute,
	NPKIT_x509_CRLNumber,
	NPKIT_x509_ReasonCode,
	NPKIT_x509_InstructionCode,
	NPKIT_x509_InvalidityDate,
	NPKIT_x509_DeltaCRLIndicator,
	NPKIT_x509_IssuingDistributionPoint,
	NPKIT_x509_CertificateIssuer,
	NPKIT_x509_InhibitAnyPolicy,
	NPKIT_x509_FreshestCRL,
	NPKIT_x509_OCSPNoCheck
};

N_EXTERN_LIBRARY (NWRCODE) NPKIT_x509CertListCreateContext
(
	NPKIT_x509CertListContext	*context								// OUT
);

N_EXTERN_LIBRARY (void) NPKIT_x509CertListFreeContext
(
	NPKIT_x509CertListContext	context								// IN
);

N_EXTERN_LIBRARY (NWRCODE) NPKIT_x509CertListGetListInfo
(
	NPKIT_x509CertListContext	context,								// IN
	pnuint32							numberOfCertsInList,				// OUT
	void								*reserved1,							// for future use -- pass NULL
	void								*reserved2,							// for future use -- pass NULL
	void								*reserved3,							// for future use -- pass NULL
	void								*reserved4							// for future use -- pass NULL
);

N_EXTERN_LIBRARY (NWRCODE) NPKIT_x509CertListGetCertInfo
(
	NPKIT_x509CertListContext	context,								// IN
	nuint32							index,								// IN
	nuint8 const					**certificate,						// OUT
	pnuint32							certificateLen,					// OUT
	void								*reserved1,							// for future use -- pass NULL
	void								*reserved2,							// for future use -- pass NULL
	void								*reserved3,							// for future use -- pass NULL
	void								*reserved4							// for future use -- pass NULL
);

N_EXTERN_LIBRARY (NWRCODE) NPKIT_x509CertListModify
(
	NPKIT_x509CertListContext	context,								// IN
	const nuint8 					*certificate, 						// IN
	const nuint32 					certificateLen,					// IN
	nuint32 							flags, 								// IN
	nuint32 							*numberOfCertsInList,			// OUT
	void								*reserved1,							// for future use -- pass NULL
	void								*reserved2,							// for future use -- pass NULL
	void								*reserved3,							// for future use -- pass NULL
	void								*reserved4							// for future use -- pass NULL
);

N_EXTERN_LIBRARY (NWRCODE) NPKIT_x509CreateContext
(
	NPKIT_x509Context 			*context								// OUT
);

N_EXTERN_LIBRARY (void) NPKIT_x509FreeContext
(
	NPKIT_x509Context 			context								// IN
);

N_EXTERN_LIBRARY (NWRCODE) NPKIT_x509DecodeCertificate
(
	NPKIT_x509Context 			context,								// IN
	const nuint8 					*certificate,						// IN
	const nuint32					certificateLen,					// IN
	nuint8 const	 				**unsignedCertificate,			// OUT
	pnuint32							unsignedCertificateLen,			// OUT
	nuint8 const 					**signature,						// OUT
	pnuint32							signatureLen,						// OUT
	nuint8 const 					**serialNumber,					// OUT
	pnuint32							serialNumberLen,					// OUT
	nuint8 const 					**keyModulus,						// OUT
	pnuint32							keyModulusLen,						// OUT
	nuint8 const 					**keyExponent,						// OUT
	pnuint32							keyExponentLen,					// OUT
	unicode const	 				**publicKeyAlgorithmOID,		// OUT
	unicode const 					**signatureKeyAlgorithmOID,	// OUT
	unicode const 					**subjectName,						// OUT
	unicode const 					**issuerName,						// OUT
	struct tm const				**startDate,						// OUT
	struct tm const				**endDate,							// OUT
	time_t const					**startTime,						// OUT
	time_t const					**endTime,							// OUT
	pnuint32			 				numberOfExtensions,				// OUT
	pnuint32							version,								// OUT
	pnuint32							keySize								// OUT
);

N_EXTERN_LIBRARY (NWRCODE) NPKIT_x509GetExtensionData
(
	NPKIT_x509Context 			context,								// IN
	nuint32 							index,								// IN
	enum NPKIT_x509Extension	*type,								// OUT
	unicode const 					**OID,								// OUT
	pnbool8 							critical,							// OUT
	pnuint32 						valueLen,							// OUT
	nuint8 const 					**value								// OUT
);

N_EXTERN_LIBRARY (NWRCODE) NPKIT_x509BasicConstraintsInfo
(
	NPKIT_x509Context 			context,								// IN
	nuint8 const 					**cA,									// OUT
	nuint32 const 					**pathLenConstraint				// OUT
);

N_EXTERN_LIBRARY (NWRCODE) NPKIT_x509KeyUsageInfo
(
	NPKIT_x509Context				context,								// IN
	pnuint16 	 					keyUsage								// OUT
);

N_EXTERN_LIBRARY (NWRCODE) NPKIT_x509NovellExtensionInfo
(
	NPKIT_x509Context 			context,								// IN
	unicode const					**version,							// OUT
	unicode const					**URIReference,					// OUT
	nbool8							*keyQEnforceQuality,				// OUT
	nint16 							*keyQCSCriteria,					// OUT
	nint16 							*keyQCSRating,						// OUT
	nint16 							*keyQCryptoCriteria,				// OUT
	nint16 							*keyQCryptoRating,				// OUT
	nint16 							*keyQKeyStorage,					// OUT
	nbool8							*cryptoProEnforceQuality,		// OUT
	nint16 							*cryptoProCSCriteria,			// OUT
	nint16 							*cryptoProCSRating,				// OUT
	nint16 							*cryptoProCryptoCriteria,		// OUT
	nint16 							*cryptoProCryptoRating,			// OUT
	nint16 							*cryptoProKeyStorage,			// OUT
	nint16 							*certificateClass,				// OUT
	nuint8 const					**EIDRootLabel,					// OUT
	nint32							*EIDRootLabelLen,					// OUT
	nuint8 const					**EIDEnterpriseLabel,			// OUT
	nint32							*EIDEnterpriseLabelLen,			// OUT
	nuint8 const					**EIDRegistryLabel,				// OUT
	nint32							*EIDRegistryLabelLen				// OUT
);

N_EXTERN_LIBRARY (NWRCODE) NPKIT_x509SubjectAltNamesInfo
(
	NPKIT_x509Context 			context,								// IN
	pnuint32 						numSubjectAltNames				// OUT
);

N_EXTERN_LIBRARY (NWRCODE) NPKIT_x509SubjectAltName
(
	NPKIT_x509Context 			context,								// IN
	nuint32 							index,								// IN
	nuint8  							*type,								// OUT
	nuint8 const					**value,								// OUT
	pnuint32 						length,								// OUT
	unicode const					**name								// OUT
);

N_EXTERN_LIBRARY (NWRCODE) NPKIT_x509IssuerAltNamesInfo
(
	NPKIT_x509Context 			context,								// IN
	pnuint32 						numIssuerAltNames					// OUT
);

N_EXTERN_LIBRARY (NWRCODE) NPKIT_x509IssuerAltName
(
	NPKIT_x509Context 			context,								// IN
	nuint32 							index,								// IN
	nuint8  							*type,								// OUT
	nuint8 const					**value,								// OUT
	pnuint32							length,								// OUT
	unicode const					**name								// OUT
);

N_EXTERN_LIBRARY (NWRCODE) NPKIT_x509CRLDistributionPointsInfo
(
	NPKIT_x509Context 			context,								// IN
	pnuint32 						numCRLDistributionPoints		// OUT
);

N_EXTERN_LIBRARY (NWRCODE) NPKIT_x509CRLDistributionPoint
(
	NPKIT_x509Context 			context,								// IN
	nuint32 							index,								// IN
	pnuint32 						dataSets,							// OUT
	nuint8  							*fullNameType,						// OUT
	nuint8 const					**fullNameValue,					// OUT
	pnuint32 						fullNameValueLength,				// OUT
	unicode const					**fullName,							// OUT
	unicode const					**nameRelativeToCRLIssuer,		// OUT
	pnuint32 						reasons,								// OUT
	nuint8  							*crlIssuerType,					// OUT
	nuint8 const					**crlIssuerValue,					// OUT
	pnuint32 						crlIssuerValueLength,			// OUT
	unicode const					**crlIssuerName					// OUT
);

N_EXTERN_LIBRARY (NWRCODE) NPKIT_x509CRLDistributionPoint2
(
	NPKIT_x509Context 			context,								// IN
	nuint32 							index,								// IN
	pnuint32 						dataSets,							// OUT
	unicode const					**nameRelativeToCRLIssuer,		// OUT
	pnuint32 						reasons,								// OUT
	pnuint32 						numDistributionPointNames,		// OUT
	pnuint32 						numCRLIssuerNames,				// OUT
	void								*reserved1,							// for future use -- pass NULL
	void								*reserved2							// for future use -- pass NULL
);

N_EXTERN_LIBRARY (NWRCODE) NPKIT_x509DistributionPointName
(
	NPKIT_x509Context 			context,								// IN
	nuint32 							index,								// IN
	nuint8  							*fullNameType,						// OUT
	nuint8 const					**fullNameValue,					// OUT
	pnuint32 						fullNameValueLength,				// OUT
	unicode const					**fullName,							// OUT
	void								*reserved1,							// for future use -- pass NULL
	void								*reserved2							// for future use -- pass NULL
);

N_EXTERN_LIBRARY (NWRCODE) NPKIT_x509CRLIssuer
(
	NPKIT_x509Context 			context,								// IN
	nuint32 							index,								// IN
	nuint8  							*crlIssuerType,					// OUT
	nuint8 const					**crlIssuerValue,					// OUT
	pnuint32 						crlIssuerValueLength,			// OUT
	unicode const					**crlIssuerName,					// OUT
	void								*reserved1,							// for future use -- pass NULL
	void								*reserved2							// for future use -- pass NULL
);
	
N_EXTERN_LIBRARY (NWRCODE) NPKIT_x509AIAInfo
(
	NPKIT_x509Context 			context,								// IN
	pnuint32							numAuthorityInfoAccess			// OUT
);

N_EXTERN_LIBRARY (NWRCODE) NPKIT_x509AIA
(
	NPKIT_x509Context 			context,								// IN
	nuint32 							index,								// IN
	nuint32 							*accessMethod,						// OUT
	nuint8  							*nameType,							// OUT
	nuint8 const					**nameValue,						// OUT
	pnuint32 						nameValueLength,					// OUT
	unicode const					**name,								// OUT
	void								*reserved1,							// for future use -- pass NULL
	void								*reserved2							// for future use -- pass NULL
);

N_EXTERN_LIBRARY (NWRCODE) NPKIT_x509ExtendedKeyUsageInfo
(
	NPKIT_x509Context 			context,								// IN
	pnuint32 						numExtendedKeyUsage				// OUT
);

N_EXTERN_LIBRARY (NWRCODE) NPKIT_x509ExtendedKeyUsage
(
	NPKIT_x509Context 			context,								// IN
	nuint32 							index,								// IN
	pnuint32	 						type,									// OUT
	unicode const					**keyPurposeId,					// OUT
	void								*reserved1,							// for future use -- pass NULL
	void								*reserved2							// for future use -- pass NULL
);

N_EXTERN_LIBRARY (NWRCODE) NPKIT_x509CertificatePoliciesInfo
(
	NPKIT_x509Context 			context,								// IN
	pnuint32 						numCertificatePolicies			// OUT
);

N_EXTERN_LIBRARY (NWRCODE) NPKIT_x509CertificatePolicy
(
	NPKIT_x509Context 			context,								// IN
	nuint32 							index,								// IN
	unicode const					**certPolicyId,					// OUT
	nuint32							*numPolicyQualifiers,			// OUT
	void								*reserved1,							// for future use -- pass NULL
	void								*reserved2							// for future use -- pass NULL
);

N_EXTERN_LIBRARY (NWRCODE) NPKIT_x509PolicyQualifier
(
	NPKIT_x509Context 			context,								// IN
	nuint32 							index,								// IN
	nuint32							*qualifierType,					// OUT
	nuint32							*cPSuriLength,						// OUT
	nuint8 const					**cPSuri,							// OUT
	unicode const					**unicodeCPSuri,					// OUT
	nuint32							*organizationType,				// OUT
	nuint32							*organizationLength,				// OUT
	nuint8 const					**organization,					// OUT
	unicode const					**unicodeOrganization,			// OUT
	nuint32							*numNoticeNumbers,				// OUT
	nuint32							*explicitTextType,				// OUT
	nuint32							*explicitTextLength,				// OUT
	nuint8 const					**explicitText,					// OUT
	unicode const					**unicodeExplicitText,			// OUT
	void								*reserved1,							// for future use -- pass NULL
	void								*reserved2							// for future use -- pass NULL
);

N_EXTERN_LIBRARY (NWRCODE) NPKIT_x509NoticeNumber
(
	NPKIT_x509Context 			context,								// IN
	nuint32 							index,								// IN
	nuint32							*length,								// OUT
	nuint8 const					**number,							// OUT
	unicode const					**unicodeNumber,					// OUT
	void								*reserved1,							// for future use -- pass NULL
	void								*reserved2							// for future use -- pass NULL
);

/***************************************************************************/
N_EXTERN_LIBRARY (NWRCODE) NPKIT_CRLCreateContext
(
	NPKIT_CRLContext 				*context								// OUT
);

N_EXTERN_LIBRARY (void) NPKIT_CRLFreeContext
(
	NPKIT_CRLContext 				context								// IN
);

N_EXTERN_LIBRARY (NWRCODE) NPKIT_CRLDecode
(
	NPKIT_CRLContext 				context,								// IN
	const nuint8 					*cRLData,							// IN
	nuint32 							cRLDataLen,							// IN
	nuint8 const					**unsignedCRL,						// OUT
	pnuint32							unsignedCRLLength,				// OUT
	pnuint32							signatureAlgorithmType,			// OUT
	unicode const 					**signatureAlgorithmOID,		// OUT
	nuint8 const					**signature,						// OUT
	pnuint32							signatureLength,					// OUT
	pnuint32							version,								// OUT
	unicode const 					**issuerName,						// OUT
	struct tm const				**thisUpdate,						// OUT
	time_t const					**thisUpdateTime,					// OUT
	struct tm const				**nextUpdate,						// OUT
	time_t const					**nextUpdateTime,					// OUT
	pnuint32 						numberOfRevokedCertificates,	// OUT
	pnuint32 						numberOfCRLExtensions			// OUT
);

N_EXTERN_LIBRARY (NWRCODE) NPKIT_CRLEntryInfo
(
	NPKIT_CRLContext 				context,								// IN
	const nuint32					index,								// IN
	nuint8 const					**serialNumber,					// OUT
	pnuint32							serialNumberLen,					// OUT
	struct tm const				**revocationDate,					// OUT
	time_t const					**revocationTime,					// OUT
	pnuint32 						numberOfCRLEntryExtensions		// OUT
);

N_EXTERN_LIBRARY (NWRCODE) NPKIT_CRLExtensionInfo
(
	NPKIT_CRLContext 				context,								// IN
	nuint32 							index,								// IN
	enum NPKIT_x509Extension	*type,								// OUT
	unicode const 					**OID,								// OUT
	pnbool8 							critical,							// OUT
	pnuint32 						valueLen,							// OUT
	nuint8 const 					**value								// OUT
);

N_EXTERN_LIBRARY (NWRCODE) NPKIT_CRLEntryExtensionInfo
(
	NPKIT_CRLContext 				context,								// IN
	const nuint32					extensionIndex,					// IN
	enum NPKIT_x509Extension	*type,								// OUT
	unicode const 					**OID,								// OUT
	pnbool8 							critical,							// OUT
	pnuint32 						valueLen,							// OUT
	nuint8 const 					**value								// OUT
);

N_EXTERN_LIBRARY (NWRCODE) NPKIT_CRLReasonCodeInfo
(
	NPKIT_CRLContext 				context,								// IN
	pnuint32 						reason								// OUT
);

N_EXTERN_LIBRARY (NWRCODE) NPKIT_CRLInvalidityDateInfo
(
	NPKIT_CRLContext 				context,								// IN
	struct tm const				**invalidityDate,					// OUT
	time_t const					**invalidityDateTime				// OUT
);

/***************************************************************************/
N_EXTERN_LIBRARY (NWRCODE) NPKIT_CSRCreateContext
(
	NPKIT_CSRContext 				*context								// OUT
);

N_EXTERN_LIBRARY (void) NPKIT_CSRFreeContext
(
	NPKIT_CSRContext 				context								// IN
);

N_EXTERN_LIBRARY (NWRCODE) NPKIT_CSRDecode
(
	NPKIT_CSRContext	 		context,									// IN
	const nuint8 				*csr, 									// IN
	const nuint32				csrLen,									// IN
	pnuint32						version,									// OUT
	unicode const 				**subjectName,							// OUT
	pnuint32						keyAlgorithmType,						// OUT
	unicode const 				**keyAlgorithmOID,					// OUT
	nuint8 const 				**keyModulus,							// OUT
	pnuint32						keyModulusLen,							// OUT
	nuint8 const 				**keyExponent,							// OUT
	pnuint32						keyExponentLen,						// OUT
	pnuint32						keySize,									// OUT
	pnuint32						signatureKeyAlgorithmType,			// OUT
	unicode const 				**signatureKeyAlgorithmOID,		// OUT
	pnuint32			 			numberOfAttributes,					// OUT
	pnuint32			 			numberOfExtensions,					// OUT
	void							*reserved1,								// for future use -- pass NULL
	void							*reserved2,								// for future use -- pass NULL
	void							*reserved3,								// for future use -- pass NULL
	void							*reserved4								// for future use -- pass NULL
);

N_EXTERN_LIBRARY (NWRCODE) NPKIT_CSRGetExtensionData
(
	NPKIT_CSRContext 				context,								// IN
	nuint32 							index,								// IN
	enum NPKIT_x509Extension	*type,								// OUT
	unicode const 					**OID, 								// OUT
	pnbool8 							critical, 							// OUT
	pnuint32 						valueLen,							// OUT
	nuint8 const 					**value,								// OUT
	void								*reserved1,							// for future use -- pass NULL
	void								*reserved2							// for future use -- pass NULL
);

N_EXTERN_LIBRARY (NWRCODE) NPKIT_CSRBasicConstraintsInfo
(
	NPKIT_x509Context 			context,
	nuint8 const 					**cA, 
	nuint32 const 					**pathLenConstraint,
	nuint32 const					**basicConstraintsEncoded
);

N_EXTERN_LIBRARY (NWRCODE) NPKIT_CSRKeyUsageInfo
(
	NPKIT_x509Context				context,
	pnuint16 	 					keyUsage
);

N_EXTERN_LIBRARY (NWRCODE) NPKIT_CSRSubjectAltNamesInfo
(
	NPKIT_x509Context 			context,
	pnuint32 						numSubjectAltNames
);

N_EXTERN_LIBRARY (NWRCODE) NPKIT_CSRSubjectAltName
(
	NPKIT_x509Context 			context,
	nuint32 							index,
	nuint8  							*type,
	nuint8 const					**value,
	pnuint32							length,
	unicode const					**name
);

N_EXTERN_LIBRARY (NWRCODE) NPKIT_CSRIssuerAltNamesInfo
(
	NPKIT_x509Context 			context,
	pnuint32							numIssuerAltNames
);

N_EXTERN_LIBRARY (NWRCODE) NPKIT_CSRIssuerAltName
(
	NPKIT_x509Context 		context,
	nuint32 						index,
	nuint8  						*type,
	nuint8 const				**value,
	pnuint32 					length,
	unicode const				**name
);

N_EXTERN_LIBRARY (NWRCODE) NPKIT_CSRCRLDistributionPointsInfo
(
	NPKIT_x509Context 			context,
	pnuint32 						numCRLDistributionPoints
);

N_EXTERN_LIBRARY (NWRCODE) NPKIT_CSRCRLDistributionPoint
(
	NPKIT_x509Context 			context,
	nuint32 							index,
	pnuint32 						dataSets,
	unicode const					**nameRelativeToCRLIssuer,
	pnuint32 						reasons,
	pnuint32 						numDistributionPointNames,
	pnuint32 						numCRLIssuerNames,
	void								*reserved1,
	void								*reserved2
);

N_EXTERN_LIBRARY (NWRCODE) NPKIT_CSRDistributionPointName
(
	NPKIT_x509Context 			context,
	nuint32 							index,
	nuint8  							*fullNameType,
	nuint8 const					**fullNameValue,
	pnuint32 						fullNameValueLength,
	unicode const					**fullName,
	void								*reserved1,
	void								*reserved2
);

N_EXTERN_LIBRARY (NWRCODE) NPKIT_CSRCRLIssuer
(
	NPKIT_x509Context 			context,
	nuint32 							index,
	nuint8  							*crlIssuerType,
	nuint8 const					**crlIssuerValue,
	pnuint32 						crlIssuerValueLength,
	unicode const					**crlIssuerName,
	void								*reserved1,
	void								*reserved2
);

N_EXTERN_LIBRARY (NWRCODE) NPKIT_CSRAIAInfo
(
	NPKIT_x509Context 			context,
	pnuint32							numAuthorityInfoAccess
);

N_EXTERN_LIBRARY (NWRCODE) NPKIT_CSRAIA
(
	NPKIT_x509Context 			context,
	nuint32 							index,
	nuint32 							*accessMethod,
	nuint8  							*nameType,
	nuint8 const					**nameValue,
	pnuint32 						nameValueLength,
	unicode const					**name,
	void								*reserved1,
	void								*reserved2
);

N_EXTERN_LIBRARY (NWRCODE) NPKIT_CSRExtendedKeyUsageInfo
(
	NPKIT_x509Context 			context,
	pnuint32 						numExtendedKeyUsage
);

N_EXTERN_LIBRARY (NWRCODE) NPKIT_CSRExtendedKeyUsage
(
	NPKIT_x509Context 			context,
	nuint32 							index,
	pnuint32 						type,
	unicode const					**keyPurposeId,
	void								*reserved1,
	void								*reserved2
);

N_EXTERN_LIBRARY (NWRCODE) NPKIT_CSRCertificatePoliciesInfo
(
	NPKIT_x509Context 			context,
	pnuint32 						numCertificatePolicies
);

N_EXTERN_LIBRARY (NWRCODE) NPKIT_CSRCertificatePolicy
(
	NPKIT_x509Context 			context,
	nuint32 							index,
	unicode const					**certPolicyId,
	nuint32							*numPolicyQualifiers,
	void								*reserved1,
	void								*reserved2
);

N_EXTERN_LIBRARY (NWRCODE) NPKIT_CSRPolicyQualifier
(
	NPKIT_x509Context 			context,
	nuint32 							index,
	nuint32							*qualifierType,
	nuint32							*cPSuriLength,
	nuint8 const					**cPSuri,
	unicode const					**unicodeCPSuri,
	nuint32							*organizationType,
	nuint32							*organizationLength,
	nuint8 const					**organization,
	unicode const					**unicodeOrganization,
	nuint32							*numNoticeNumbers,
	nuint32							*explicitTextType,
	nuint32							*explicitTextLength,
	nuint8 const					**explicitText,
	unicode const					**unicodeExplicitText,
	void								*reserved1,
	void								*reserved2
);

N_EXTERN_LIBRARY (NWRCODE) NPKIT_CSRNoticeNumber
(
	NPKIT_x509Context 			context,
	nuint32 							index,
	nuint32							*length,
	nuint8 const					**number,
	unicode const					**unicodeNumber,
	void								*reserved1,
	void								*reserved2
);

#if defined(__cplusplus)
}
#endif

#endif    //   _NPKIT_X509_H_ 
