/***************************************************************************

  Copyright (c) 1997-2007 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.
  
 *	File:		NPKI.h
 *	Description:	NPKI APIs header file.  
 ***************************************************************************/

#ifndef   _NPKI_H_
#define   _NPKI_H_

#if defined(__cplusplus)
extern "C" {
#endif

#include <npki_ver.h>
#include <ntypes.h>
#if ! defined ( UNICODE_H )
#	include "unicode.h"
#endif
#include <time.h>

#include "nverify.h"
#include "npkicert.h"
#include "NPKIT_Cache.h"

/***************************************************************************/
/* NPKI context definations */
//#define NPKIContext										nuint32
//#define NPKI_INVALID_CONTEXT							0xffffffff

#define NPKIContext										size_t
const size_t NPKI_INVALID_CONTEXT = (size_t) -1;
/***************************************************************************/
/* Public Key Flags to use when creating a Certificate Authority */
#define PUBLIC_KEY_ORGANIZATIONAL_CA				0x0001 | 0x0002 | 0x0020

/***************************************************************************/
/* Public Key Flags to use when creating a server or user Certificate */
#define PUBLIC_KEY_SINGLE_SERVER						0x0002 | 0x0020 | 0x0100
#define PUBLIC_KEY_TWO_SERVER							0x0004 | 0x0010 | 0x0100
#define PUBLIC_KEY_EXTERNAL_CA						0x0004 | 0x0010 | 0x0100

/* Optional Public Key Flags to use when creating a server or user Certificate */
#define PKI_CUSTOM_SUBJECT_NAME						0x00001000

/***************************************************************************/
/* Flags to use when importing a server private key and certificate */
#define PKI_OVERWRITE									0x01

/***************************************************************************/
/* Private Key Flags to use when creating a certificate authority, server or user Certificate */
#define PRIVATE_KEY										0x0002

/* Optional Private Key Flags to use when creating a user or server Certificate */
//#define PRIVATE_KEY_EXTRACTABLE					0x0004 -- Moved to npkicert.h

/***************************************************************************/
/* Flags to indicate the status of a KMO */
#define KMO_EMPTY											0
#define KMO_KEY_PAIR_PRESENT							1
#define KMO_TRUSTED_ROOT_PRESENT						2
#define KMO_CERTIFICATE_PRESENT						3
#define KMO_INVALID_STATUS								0xffffffff

/***************************************************************************/
/* Flags to use when calling NPKIGetServerInfo */
#define PKI_CA_INFO										0x01
#define PKI_USER_INFO									0x02
#define PKI_SERVER_INFO 								0x03
#define PKI_SERVER_HEALTH_CHECK						0x04

/***************************************************************************/
/* Flags to compare against when calling CAOperational */
#define PKI_NO_CA											0x00
#define PKI_ORGANIZATIONAL_CA							0x01
#define PKI_SUB_ORGANIZATIONAL_CA					0x02
/***************************************************************************/
/* Key generation algorithms supported *///		(moved to npkicert.h)
//#define PKI_RSA_ALGORITHM							0x01	 

/* Signature and hashing algorithms supported */
//#define PKI_UNKNOWN_ALGORITM						0x00
//#define PKI_SIGN_WITH_RSA_AND_MD2					0x01
//#define PKI_SIGN_WITH_RSA_AND_MD5					0x02
//#define PKI_SIGN_WITH_RSA_AND_SHA1				0x04

/***************************************************************************/
/* Flags to use with the NPKIStoreUserCertificate */
#define PKI_INTERNAL_KEY_PAIR							0x00000001
#define PKI_EXTERNAL_KEY_PAIR							0x00000002
#define PKI_DONT_CHECK_NICKNAME_UNIQUENESS		0x00004000

/***************************************************************************/
/* Flags to indicate the status of a user certificate */
#define PKI_CERTIFICATE_NORMAL						0x0004
#define PKI_CSR_PENDING									0x0001 | 0x0008
#define PKI_PRIVATE_KEY_NOT_IN_NDS					0x0002 | 0x0004
#define PKI_CERTIFICATE_ON_HOLD						0x0001 | 0x0004 |0x10000

/* Defines to identify user certificate vendor ID's */
#define PKI_ALL_VENDORS		 							0
#define PKI_VENDOR_UNKNOWN 							1
#define PKI_VENDOR_EXTERNAL 							2
#define PKI_VENDOR_NOVELL 								3
#define PKI_VENDOR_ENTRUST 							4
#define PKI_VENDOR_VERISIGN 							5
#define PKI_VENDOR_ACTIVCARD 							6

/***************************************************************************/
/* Flags to use with the NPKIGetCACertificates, NPKIGetServerCertificates, NPKIExportServerCert and NPKIStoreServerCertificates */
/*   -- determine which certificates are returned */
#define PKI_OBJECT_KEY_CERTIFICATE					0x01
#define PKI_TRUSTED_ROOT_CERTIFICATE				0x02   /* not for use with NPKIExportServerCert, Use PKI_SELF_SIGNED_CERTIFICATE */
#define PKI_CHAIN_CERTIFICATE							0x04
#define PKI_SELF_SIGNED_CERTIFICATE					0x10  /* not for use with NPKIGetServerCertificates */

/***************************************************************************/
// Flags to use with the NPKIGetServerKMOInfo
#define PKI_READ_DATA									0x0000
#define PKI_READ_AND_CACHE_DATA						0x1000

/***************************************************************************/
/* Flags to use with the NPKIExportCAKey*/
#define PKI_CA_KEY_AND_CERTS							0x04 | 0x10 | 0x01

/***************************************************************************/

/* Other flags to use with the NPKIStoreServerCertificates  */
/*	  -- used to specify which cert in a chain should be treated as the root certificate.  */
#define PKI_NOVELL_CERTIFICATE 						0x00080000
#define PKI_ORG_CA_CERTIFICATE						0x00100000
/*   -- use when storeing an external certificate whose subject name does not match original subject name */
#define PKI_WAIVE_SUBJECT_NAME_IN_CERTEFICATE	0x100 
																		
/***************************************************************************/
/* Certificate Creation Flags */
#define ALL_DEFAULT_OPTIONS							0x000

	// Date encoding Flags
#define DEFAULT_YEAR_ENCODING							0x000
#define GENERALIZED_TIME_ENCODING					0x001
#define UTC_TIME_ENCODING								0x002
	// Directory Name encoding Flags
#define BMP_IA5_NAME_ENCODING							0x000
#define UTF8_NAME_ENCODING								0x100

/***************************************************************************/
// Certificate List flags
#define PKI_CLEAR											0x01
#define PKI_ADD											0x02
#define PKI_DELETE										0x04
#define PKI_SORT											0x10

#define PKI_CLEAR_CERTS									PKI_CLEAR
#define PKI_ADD_CERT										PKI_ADD
#define PKI_DEL_CERT										PKI_DELETE
#define PKI_SORT_LIST									PKI_SORT

#define PKI_MINUTES										1
#define PKI_HOURS											2
#define PKI_DAYS											3
#define PKI_WEEKS											4
#define PKI_MONTHS										5

/***************************************************************************/
// Container types to use with NPKICreatePKIContainer
#define PKI_TYPE_CRL_CONTAINER						0x01
#define PKI_TYPE_CERTIFICATE_CONTAINER				0x02

/***************************************************************************/
// Name space types to use with NPKISetCRLFileName
#define PKI_NS_DOS										0x00
#define PKI_NS_MACINTOSH								0x01
#define PKI_NS_UNIX										0x02
#define PKI_NS_FTAM										0x03
#define PKI_NS_OS2										0x04

/***************************************************************************/
/* general-purpose extension structure *///			(moved to npkicert.h)
//typedef struct NPKI_Extension
//{
//	nuint32	flags;
//	nuint32	length;		/* length of value */
//	nuint8	*value;
//}NPKI_Extension;

/* general-purpose extension flags */
//#define PKI_EXTENSION_INCLUDE							0x00
//#define PKI_EXTENSION_DONT_INCLUDE					0x01
//#define PKI_EXTENSION_CRITICAL							0x02

/* Key Usage extension values */
//#define X509_KEY_USAGE_DIGITAL_SIGNATURE			0x8000
//#define X509_KEY_USAGE_NON_REPUDIATION	 			0x4000
//#define X509_KEY_USAGE_KEY_ENCIPHERMENT 			0x2000
//#define X509_KEY_USAGE_DATA_ENCIPHERMENT			0x1000
//#define X509_KEY_USAGE_KEY_AGREEMENT	 				0x0800
//#define X509_KEY_USAGE_KEY_CERT_SIGN	 				0x0400
//#define X509_KEY_USAGE_CRL_SIGN			 			0x0200
//#define X509_KEY_USAGE_ENCIPHER_ONLY					0x0100
//#define X509_KEY_USAGE_DECIPHER_ONLY					0x0080

/* Basic Constraints extension flags */
//#define X509_BASIC_CONSTRAINTS_CA						0x0100

/* Basic Constraints defines --  */
//#define X509_CA												0xff
//#define X509_CA_PATH_LENGTH_UNLIMITED				0xffffffff

/* Alternative Name structures */
//typedef struct NPKI_AltName
//{
//	nuint16 		type;
//	nuint16 		length;
//	nuint8  		*value;		
//}NPKI_AltName;

//typedef struct NPKI_ExtAltNames
//{
//	nuint32			flags;
//	nuint16			numberOfNames;
//	NPKI_AltName	*altName;	  /* Array of structures */
//}NPKI_ExtAltNames;

/* General Name types */
//#define X509_GENERAL_NAME_OTHER_NAME								0x0000
//#define X509_GENERAL_NAME_RFC822_NAME							0x0001
//#define X509_GENERAL_NAME_DNS_NAME								0x0002
//#define X509_GENERAL_NAME_X400_ADDRESS							0x0003
//#define X509_GENERAL_NAME_DIRECTORY_NAME						0x0004
//#define X509_GENERAL_NAME_EDI_PARTY_NAME						0x0005
//#define X509_GENERAL_NAME_UNIFORM_RESOURCE_IDENTIFIER		0x0006
//#define X509_GENERAL_NAME_IP_ADDRESS								0x0007
//#define X509_GENERAL_NAME_REGISTERED_ID							0x0008

/* Alternative Names types -  for backward compatibility */
//#define X509_SUBJECT_ALT_NAME_OTHER_NAME						X509_GENERAL_NAME_OTHER_NAME						
//#define X509_SUBJECT_ALT_NAME_RFC822_NAME						X509_GENERAL_NAME_RFC822_NAME						
//#define X509_SUBJECT_ALT_NAME_DNS_NAME							X509_GENERAL_NAME_DNS_NAME							
//#define X509_SUBJECT_ALT_NAME_X400_ADDRESS						X509_GENERAL_NAME_X400_ADDRESS						
//#define X509_SUBJECT_ALT_NAME_DIRECTORY_NAME					X509_GENERAL_NAME_DIRECTORY_NAME					
//#define X509_SUBJECT_ALT_NAME_EDI_PARTY_NAME					X509_GENERAL_NAME_EDI_PARTY_NAME					
//#define X509_SUBJECT_ALT_NAME_UNIFORM_RESOURCE_IDENTIFIER	X509_GENERAL_NAME_UNIFORM_RESOURCE_IDENTIFIER	
//#define X509_SUBJECT_ALT_NAME_IP_ADDRESS						X509_GENERAL_NAME_IP_ADDRESS						
//#define X509_SUBJECT_ALT_NAME_REGISTERED_ID					X509_GENERAL_NAME_REGISTERED_ID					

/* Novell Security Attributes (TM) extension flags */
//#define NOVELL_EXTENSION_SERVER_DEFAULT				0x00100
//#define NOVELL_EXTENSION_USER_DEFAULT				0x00200 
//#define NOVELL_EXTENSION_ORGCA_DEFAULT				0x00400 
//#define NOVELL_EXTENSION_EXTRACTABLE_KEY			0x10000

/* Generic structure to provide ASN1 encoded extensions to the API */
//typedef struct NPKI_ASN1_Extensions
//{
//	NPKI_Extension extension;
//	struct NPKI_ASN1_Extensions *next;
//}NPKI_ASN1_Extensions;

/* Reason codes for NPKIValicateCertificate failure */
#define PKI_UNSPECIFIED									0
#define PKI_KEY_COMPROMISED							1
#define PKI_CA_COMPROMISED								2
#define PKI_AFFILIATION_CHANGED						3
#define PKI_SUPERSEDED									4
#define PKI_CESSATION_OF_OPERATION					5
#define PKI_CERTIFICATE_HOLD							6
#define PKI_REMOVE_FROM_CRL							8

/***************************************************************************/
/* Hold Instruction codes for NPKIValicateCertificate failure with reason code PKI_CERTIFICATE_HOLD */
#define PKI_HOLD_INSTRUCTION_NONE					0
#define PKI_HOLD_INSTRUCTION_CALL_ISSUER			1
#define PKI_HOLD_INSTRUCTION_REJECT					2

/***************************************************************************/
// optional Flags to use with  NPKI_CertificateName structure below
#define NPKI_CERTIFICATE_CREATE_NORMAL				0x00000000
#define NPKI_CERTIFICATE_CREATE_FORCE				0x00000001
#define NPKI_CERTIFICATE_CREATE_NO_OVERWRITE		0x00000002
#define NPKI_CERTIFICATE_CREATE_CA_CHANGE_FORCE	0x00000004

#define NPKI_DONT_QUERY_IP_AND_DNS					0x00000010
#define NPKI_DONT_REPLACE_SSL_IP						0x00000020
#define NPKI_DONT_REPLACE_SSL_DNS					0x00000040

#define NPKI_DEFAULT_IP_CERTIFICATE					0x00000100
#define NPKI_DEFAULT_DNS_CERTIFICATE				0x00000200

/***************************************************************************/
// Values for the CA's Security Rights Level attribute -- values may be or'ed together.
#define NPKI_CA_RIGHTS_DEFAULT						0x00
#define NPKI_CA_RIGHTS_READ_NCP						0x01
#define NPKI_CA_RIGHTS_WRITE_ALL						0x02
#define NPKI_CA_RIGHTS_SELF_PROVISION_SERVER		0x04
#define NPKI_CA_RIGHTS_SELF_PROVISION_USER		0x08
#define NPKI_CA_RIGHTS_ISSUE_CRL_ALL				0x10
#define NPKI_CA_CHANGE_HEALTH_CHECK_FORCE			0x20

/***************************************************************************/
// Structure for specifing certificate names used in NPKICreateDefaultCertificates
typedef struct NPKI_CertificateName
{
	nuint32								flags;
	unicode								*certificateName;
	unicode								*ipAddress;
	unicode								*DNSName;
	nuint32								ccode;
	void									*reserved1;	// for future use -- pass NULL
	void									*reserved2;	// for future use -- pass NULL
	struct NPKI_CertificateName	*next;
}NPKI_CertificateName;


/***************************************************************************/
/* prototypes */

N_EXTERN_LIBRARY (NWRCODE) NPKICreateContext
(
	NPKIContext 						*context
);

N_EXTERN_LIBRARY (void) NPKIFreeContext
(
	NPKIContext 						context
);

N_EXTERN_LIBRARY (NWRCODE) NPKIVersionInfo
(
	nuint32								*versionNumber,
	void									*reserved1,
	void									*reserved2
);

// WARNING -- NPKIGetLocalServerInfo can only be used if your process is  -- WARNING
// WARNING -- running within DHost (i.e. within eDir)							  -- WARNING
N_EXTERN_LIBRARY (NWRCODE) NPKIGetLocalServerInfo
(
	unicode const				**treeName,
	unicode const				**serverDN,
	void 							*reserved1,
	void 							*reserved2,
	void 							*reserved3,
	void 							*reserved4
);

N_EXTERN_LIBRARY (NWRCODE) NPKISetDefaultDSContactServerDN
(
	const NPKIContext 		context,
	const unicode 				*serverDN
);

N_EXTERN_LIBRARY (NWRCODE) NPKIGetDefaultDSContactServerDN
(
	const NPKIContext 		context,
	const unicode 				**serverDN
);

N_EXTERN_LIBRARY (NWRCODE) NPKISetTreeName
(
	const NPKIContext 				context,
	const unicode 						*treeName
);

N_EXTERN_LIBRARY (NWRCODE) NPKIDSLogin
(
	const NPKIContext 				context,
	const unicode 						*objectDN,
	const pnstr8 						password
);

// NPKISetIdentity is not directly related to NWPKISetIdentity 
//  (i.e. the identitiyContext is a DClient context, not a NWDSAPI context)
N_EXTERN_LIBRARY (NWRCODE) NPKISetIdentity
(
	const NPKIContext 				context,
	const nuint32						identityContext
);

N_EXTERN_LIBRARY (NWRCODE) NPKIDSLogout
(
	const NPKIContext 				context
);

N_EXTERN_LIBRARY (NWRCODE) NPKIDSConnectToAddress
(
	const NPKIContext 				context,
	int									flags, 
	int									type, 
	unsigned								size, 
	void									*data
);

N_EXTERN_LIBRARY (NWRCODE) NPKIConnectToIPAddress
(
	const NPKIContext 				context,
	const nuint32						flags,
	const nuint16						port,
	const char 							*iPAddress,
	unicode const						**treeName,
	unicode const						**serverDN
);

N_EXTERN_LIBRARY (NWRCODE) NPKIDeleteDSObject
(
	const NPKIContext 				context,
	const unicode						*objectDN
);

N_EXTERN_LIBRARY (NWRCODE) NPKIFindKeyGenServersForUser
(
	const NPKIContext 				context,
	const unicode 						*nameContextDN,
	pnuint32								numberOfServers
);

N_EXTERN_LIBRARY (NWRCODE) NPKIFindServersInContext
(
	const NPKIContext 				context,
	const unicode 						*nameContextDN,
	pnuint32								numberOfServers
);

N_EXTERN_LIBRARY (NWRCODE) NPKIDSLoginAsServer
(
	const NPKIContext 		context
);

N_EXTERN_LIBRARY (NWRCODE) NPKIServerNames
(
	const NPKIContext 				context,
	nuint32 								index,
	unicode const						**serverDN,
	unicode const						**serverName
);

N_EXTERN_LIBRARY (NWRCODE) NPKIFindOrganizationalCA
(
	const NPKIContext 				context,
	unicode const 						**objectDN
);

N_EXTERN_LIBRARY (NWRCODE) NPKIReadSecurityRightsLevel
(
	const NPKIContext 				context,
	const unicode 						*objectDN, 
	pnuint32								securityRightsLevel,
	void									*reserved1,
	void 									*reserved2
);

N_EXTERN_LIBRARY (NWRCODE) NPKISetSecurityRightsLevel
(
	const NPKIContext 				context,
	const unicode 						*objectDN, 
	const nuint32						securityRightsLevel,
	void									*reserved1,
	void 									*reserved2
);

N_EXTERN_LIBRARY (NWRCODE) NPKIGetCAInfo
(
	const NPKIContext 				context,
	const unicode 						*objectDN, 
	pnuint32								numberOfCRLConfigurations,
	void 									*reserved1,
	void 									*reserved2,
	void 									*reserved3,
	void 									*reserved4
);

N_EXTERN_LIBRARY (NWRCODE) NPKICRLConfigurationDN
(
	const NPKIContext 				context,
	nuint32								index, 
	pnuint32								objectFlags,
	unicode const						**objectDN, 
	unicode const						**data,
	void 									*reserved1,
	void 									*reserved2
);

N_EXTERN_LIBRARY (NWRCODE) NPKIGetServerUTCTime
(
	const NPKIContext 				context,
	const unicode 						*serverDN,
	pnuint32								time
);

N_EXTERN_LIBRARY (NWRCODE) NPKIGetHostServerDN
(
	const NPKIContext 				context,
	const unicode 						*objectDN,
	unicode const 						**serverDN
);

N_EXTERN_LIBRARY (NWRCODE) NPKIGetServerCertificateStatus
(
	const NPKIContext 				context,
	const unicode 						*serverDN, 
	const unicode 						*certificateName,
	pnuint32								flags
);

N_EXTERN_LIBRARY (NWRCODE) NPKIGetKMOCertificateName
(
	const NPKIContext 				context,
	const unicode 						*kmoDN,
	unicode const 						**certificateName
);

N_EXTERN_LIBRARY (NWRCODE) NPKIGetSASServiceName
(
	const NPKIContext 				context,
	const unicode 						*serverDN, 
	unicode const 						**serviceName
);

N_EXTERN_LIBRARY (NWRCODE) NPKIGetServerInfo
(
	const NPKIContext 				context,
	const unicode 						*serverDN, 
	const nuint32 						flags,
	pnuint32 							keyGenerationAlgorithms,
	pnuint32 							signingAlgorithms,
	pnuint32 							maxValidFromTime,
	pnuint32 							maxValidToTime,
	pnuint32 							caOperational,
	pnuint32 							pathLength,
	pnuint32 							healthCheckCcode,	
	pnuint32								serverVersion,	 
	void 									*reserved2	 
);

N_EXTERN_LIBRARY (NWRCODE) NPKIGetAlgorithmInfo
(
	const NPKIContext 				context,
	const nuint32 						algorithm, 
	pnuint32								maxKeyEncryptKeySize,
	pnuint32								maxSigningKeySize,
	pnuint32								maxDataEncryptKeySize,
	void 									*reserved1,	 
	void 									*reserved2	 
);

N_EXTERN_LIBRARY (NWRCODE) NPKIGenerateCertificateFromCSR
(
	const NPKIContext 				context,
	const unicode 						*caServerDN, 
	const pnuint8 						extCSR, 
	const nuint32 						extCSRSize,
	const unicode 						*subjectDN, 
	const nuint32 						signatureAlgorithm,
	const nuint32 						flags,
	const nuint32 						validFrom, 
	const nuint32 						validTo,
	const NPKI_Extension 			*keyUsage, 
	const NPKI_Extension 			*basicConstraints, 
	const NPKI_ExtAltNames			*altNames, 
	const NPKI_Extension 			*NovellAttr,
	const NPKI_ASN1_Extensions		*extensions,
	void 									*reserved1,
	void 									*reserved2
);

N_EXTERN_LIBRARY (NWRCODE) NPKIDSObjectExists
(
	const NPKIContext					context,
	const unicode						*objectDN
);

N_EXTERN_LIBRARY (NWRCODE) NPKICreateServerCertificate
(
	const NPKIContext 				context,
	const unicode 						*keyGenServerDN, 
	const unicode 						*signServerDN, 
	const unicode 						*certificateName, 
	const nuint32 						keyType, 
	const nuint32 						keySize, 
	const unicode 						*subjectDN, 
	const nuint32 						signatureAlgorithm,
	const nuint32 						flags,
	const nuint32 						validFrom, 
	const nuint32 						validTo,
	const nuint32 						publicKeyFlags,
	const nuint32 						privateKeyFlags,
	const NPKI_Extension 			*keyUsage, 
	const NPKI_Extension 			*basicConstraints, 
	const NPKI_ExtAltNames			*altNames, 
	const NPKI_Extension 			*NovellAttr, 
	const NPKI_ASN1_Extensions		*extensions,
	void 									*reserved1,
	void 									*reserved2
);

N_EXTERN_LIBRARY (NWRCODE) NPKICSRInfo
(
	const NPKIContext 				context,
	pnuint32								csrSize,
	nuint8 const 						**csr
);

N_EXTERN_LIBRARY (NWRCODE) NPKICertInfo
(
	const NPKIContext 				context,
	pnuint32								certSize,
	nuint8 const 						**cert
);

N_EXTERN_LIBRARY (NWRCODE) NPKICreateUserCertificate
(
	const NPKIContext 				context,
	const unicode 						*keyGenServerDN, 
	const unicode 						*signServerDN, 
	const unicode 						*userDN, 
	const unicode 						*nickName, 
	const nuint32 						keyType, 
	const nuint32 						keySize, 
	const unicode 						*subjectDN, 
	const nuint32 						signatureAlgorithm,
	const nuint32 						flags,
	const nuint32 						validFrom, 
	const nuint32 						validTo,
	const nuint32 						publicKeyFlags,
	const nuint32 						privateKeyFlags,
	const NPKI_Extension 			*keyUsage, 
	const NPKI_Extension 			*basicConstraints, 
	const NPKI_ExtAltNames			*altNames, 
	const NPKI_Extension 			*NovellAttr,
	const NPKI_ASN1_Extensions 	*extensions,
	void 									*reserved1,
	void 									*reserved2
);

N_EXTERN_LIBRARY (NWRCODE) NPKIDeleteUserCertificate
(
	const NPKIContext 				context,
	const unicode 						*userDN,
	const unicode 						*nickName,
	const nuint32 						flags,
	const pnuint8						certificate,	 
	const nuint32						certificateLen 
);

N_EXTERN_LIBRARY (NWRCODE) NPKIReadAllNickNames
(
	const NPKIContext 				context,
	const unicode 						*userDN,
	pnuint32								numberOfNickNames
);

N_EXTERN_LIBRARY (NWRCODE) NPKINickName
(
	const NPKIContext 				context,
	nuint32 								index,
	unicode const 						**nickName
);

N_EXTERN_LIBRARY (NWRCODE) NPKIStoreUserCertificate
(
	const NPKIContext 				context,
	const unicode 						*userDN,
	const unicode 						*nickName,
	const unicode 						*signerDN,
	const nuint32 						flags,
	const pnuint8 						cert, 
	const nuint32 						certSize,
	const nuint32 						vendorID,
	const pnuint8 						privateKey, 
	const nuint32 						privateKeySize,
	void 									*reserved1,
	void 									*reserved2
);

N_EXTERN_LIBRARY (NWRCODE) NPKICertificateList
(
	const NPKIContext 				context,
	const pnuint8 						certificate,
	const nuint32 						certificateLen,
	const nuint32 						flags,
	pnuint32 							numberOfCertsInList
);

N_EXTERN_LIBRARY (NWRCODE) NPKIStoreServerCertificatesFromCertificateList
(
	const NPKIContext 				context,
	const unicode 						*serverDN,
	const unicode 						*certificateName,
	const nuint32 						flags,
	const nuint32 						trustedRootIndex,
	void 									*reserved1,
	void 									*reserved2
);

N_EXTERN_LIBRARY (NWRCODE) NPKIFindUserCertificates
(
	const NPKIContext 				context,
	const unicode 						*userDN,
	const unicode 						*nickName,
	const pnuint8 						serialNumber, 
	const nuint32 						serialNumberLen, 
	const nuint32 						keyType, 
	const nuint32 						minKeySize, 
	const nuint32 						maxKeySize, 
	const nuint32 						searchOnKeyUsage, 
	const nuint16 						keyUsageValue, 
	const unicode 						*issuerDN, 
	const unicode						*subjectDN, 
	const nuint32 						certificateValid,
	const nuint32 						vendorID,
	const nuint32 						certificateStatus,
	void 									*reserved1,
	void 									*reserved2,
	void 									*reserved3,
	void 									*reserved4,
	nuint32 								*numberOfUserCerts
);

N_EXTERN_LIBRARY (NWRCODE) NPKIUserCertInfo
(
	const NPKIContext 				context,
	const nuint32						index,
	unicode const 						**nickName,
	pnuint32								certSize,
	nuint8 const 						**cert,
	pnuint32								certStatus,
	pnuint32								certChainSize,
	nuint8 const 						**certChain,
	pnuint32		 						vendorID,
	void 									*reserved1,
	void 									*reserved2
);

N_EXTERN_LIBRARY (NWRCODE) NPKIImportUserKey
(
	const NPKIContext		context,
	const unicode			*userDN,
	const unicode 			*nickName,
	const unicode 			*password,
	const nuint32 			flags, 
	const nuint32 			pfxSize,
	const nuint8  			*pfx,
	void 				  		*reserved1,
	void 				  		*reserved2,
	void 				  		*reserved3,
	void 				  		*reserved4
);

N_EXTERN_LIBRARY (NWRCODE) NPKIImportServerKey
(
	const NPKIContext 				context,
	const unicode						*serverDN,
	const unicode 						*certificateName,
	const unicode 						*password,
	const nuint32 						flags,
	const nuint32 						pfxSize,
	const nuint8  						*pfx
);

N_EXTERN_LIBRARY (NWRCODE) NPKIImportCAKey
(
	const NPKIContext					context,
	const unicode						*hostServerDN,
	const unicode						*organizationlCAName,
	const unicode						*password,
	const nuint32						flags,
	const nuint32						pfxSize,
	const nuint8						*pfx
);

N_EXTERN_LIBRARY (NWRCODE) NPKIExportUserKey
(
	const NPKIContext 				context,
	const unicode 						*nickname,
	const unicode 						*password,
	const nuint32 						flags,
	pnuint32 							pfxSize,
	nuint8 const 						**pfx
);

N_EXTERN_LIBRARY (NWRCODE) NPKIExportServerKey
(
	const NPKIContext 				context,
	const unicode						*serverDN,
	const unicode 						*certificateName,
	const unicode 						*password,
	const nuint32 						flags,
	pnuint32 							pfxSize,
	nuint8 const 						**pfx
);

N_EXTERN_LIBRARY (NWRCODE) NPKIExportCAKey
(
	const NPKIContext					context,
	const unicode						*organizationlCAName,
	const unicode						*password,
	const nuint32						flags,
	pnuint32								pfxSize,
	nuint8 const						**pfx
);

N_EXTERN_LIBRARY (NWRCODE) NPKICreateOrganizationalCA
(
	const NPKIContext 				context,
	const unicode 						*serverDN, 
	const unicode 						*organizationalCAName,
	const nuint32 						keyType, 
	const nuint32 						keySize, 
	const unicode 						*subjectDN,
	const nuint32 						signatureAlgorithm,
	const nuint32 						flags,
	const nuint32 						validFrom, 
	const nuint32 						validTo,
	const nuint32 						publicKeyFlags,
	const nuint32 						privateKeyFlags,
	const NPKI_Extension 			*keyUsage, 
	const NPKI_Extension 			*basicConstraints, 
	const NPKI_ExtAltNames			*altNames, 
	const NPKI_Extension 			*NovellAttr,
	const NPKI_ASN1_Extensions 	*extensions,
	unicode const 						**organizationalCADN,
	const nuint32 						retryFlag,
	void 									*reserved1,	 
	void 									*reserved2	 
);

N_EXTERN_LIBRARY (NWRCODE) NPKIGetServerCertificates
(
	const NPKIContext 				context,
	const unicode 						*serverDN,
	const unicode 						*certificateName,
	const nuint32 						flags,
	pnuint32								objectCertSize,
	nuint8 const 						**objectCert,
	pnuint32								numberOfChainCerts,
	pnuint32								rootCertIndex,
	void 				  					*reserved1,
	void 				  					*reserved2
);

N_EXTERN_LIBRARY (NWRCODE) NPKIGetServerKMOInfo
(
	const NPKIContext 				context,
	const NPKIT_CacheContext		cacheContext, // optional
	const unicode 						*serverDN,
	const unicode 						*certificateName,
	const nuint32 						flags,
	pnuint32								objectCertSize,
	nuint8 const 						**objectCert,
	pnuint32								numberOfChainCerts,
	pnuint32								rootCertIndex,
	pnuint32								wrappedKeySize,
	nuint8 const						**wrappedKey,
	pnuint32								numberOfAdditionalRoots,
	pnuint32								terisaKeyFileSize,
	nuint8 const 						**terisaKeyFile,
	void 				  					*reserved1,
	void 				  					*reserved2,
	void 				  					*reserved3,
	void 				  					*reserved4
);

N_EXTERN_LIBRARY (NWRCODE) NPKIAdditionalRootsInfo
(
	const NPKIContext 				context,
	const nuint32						index,
	pnuint32								certSize,
	nuint8 const 						**cert,
	void 				  					*reserved1,
	void 				  					*reserved2
);

N_EXTERN_LIBRARY (NWRCODE) NPKIGetCACertificates
(
	const NPKIContext 				context,
	const unicode 						*objectDN,
	const nuint32 						flags,
	pnuint32								objectCertSize,
	nuint8 const 						**objectCert,
	pnuint32								selfSignedCertSize,
	nuint8 const 						**selfSignedCert,
	pnuint32								numberOfChainCerts,
	pnuint32								rootCertIndex,
	void 				  					*reserved1,
	void 				  					*reserved2
);

N_EXTERN_LIBRARY (NWRCODE) NPKIChainCertInfo
(
	const NPKIContext 				context,
	const nuint32						index,
	pnuint32								certSize,
	nuint8 const 						**cert,
	void 				  					*reserved1,
	void 				  					*reserved2
);

N_EXTERN_LIBRARY (NWRCODE) NPKIStoreServerCertificates
(
	const NPKIContext 				context,
	const unicode 						*serverDN,
	const unicode 						*certificateName,
	const nuint32 						flags,
	const nuint32 						trustedRoot,
	const pnuint8 						certificate,
	const nuint32 						certificateLen,
	void 									*reserved1,
	void 									*reserved2
);

N_EXTERN_LIBRARY (NWRCODE) NPKIFindServerCertificateNames
(
	const NPKIContext 				context,
	const unicode 						*serverDN, 
	pnuint32								numberOfCertificateNames 
);

N_EXTERN_LIBRARY (NWRCODE) NPKIServerCertificateName
(
	const NPKIContext 				context,
	nuint32 								index,
	unicode const 						**serverCertificateName
);

N_EXTERN_LIBRARY (NWRCODE) NPKIGetWrappedServerKey
(
	const NPKIContext 				context,
	const unicode 						*serverDN,
	const unicode 						*serverCertificateName,
	pnuint32								wrappedKeySize,
	nuint8 const						**wrappedKey
);

N_EXTERN_LIBRARY (NWRCODE) NPKIGetServerIPAndDNSInfo
(
	const NPKIContext 				context,
	const unicode 						*serverDN, 
	const pnuint32 					numberOfIPAddresses
);

N_EXTERN_LIBRARY (NWRCODE) NPKIGetServerIPAddress
(
	const NPKIContext 				context,
	nuint32 								index,
	nuint16								*ipLength,
	nuint8 const 						**ipValue,
	unicode const 						**ipNumber,
	nuint16								*numberOfDNSNames
);

N_EXTERN_LIBRARY (NWRCODE) NPKIGetServerDNSName
(
	const NPKIContext 				context,
	nuint32 								index,
	unicode const 						**DNSName
);

N_EXTERN_LIBRARY (NWRCODE) NPKICreateTrustedRootContainer
(
	const NPKIContext 				context,
	const unicode 						*objectDN
);

N_EXTERN_LIBRARY (NWRCODE) NPKICreateTrustedRoot
(
	const NPKIContext 				context,
	const unicode						*objectDN,
	const pnuint8 						certificate, 
	const nuint32 						certificateLen
);

N_EXTERN_LIBRARY (NWRCODE) NPKIFindTrustedRootsInContext
(
	const NPKIContext 				context,
	const unicode						*nameContextDN,
	pnuint32								numberOfTrustedRoots
);

N_EXTERN_LIBRARY (NWRCODE) NPKIGetTrustedRootInfo
(
	const NPKIContext 				context,
	nuint32 								index,
	unicode const						**name,
	unicode const						**validFrom,
	unicode const						**validTo,
	unicode const						**subjectName,
	nuint8 const						**certificate,
	pnuint32								certificateLen
);

N_EXTERN_LIBRARY (NWRCODE) NPKIVerifyCertificateWithTrustedRoots
(
	const NPKIContext 				context,
	const pnuint8 						certificate, 
	const nuint32 						certificateLen,
	const unicode 						*TRContextDN,
	NPKIT_ENHANCED_VERIFY_OPTIONS	*enhancedOptions,			// IN (Optional)
	nuint32		 						flags,
	pnuint32								cRLReason,
	pnuint32								cRLHoldInstruction,
	time_t								*cRLRevocationTime,
	time_t		 						*cRLInvalidityDateTime,
	pnuint32		 						certInvalidityReason,
	void									*reserved4
);

N_EXTERN_LIBRARY (NWRCODE) NPKICreateSASServiceObject
(
	const NPKIContext 				context,
	const unicode 						*serverName,
	const unicode						*contextDN
);

N_EXTERN_LIBRARY (NWRCODE) NPKICreateDefaultCertificates
(
	const NPKIContext			context,
	const unicode				*serverDN,
	NPKI_CertificateName		*certificateNames,
	pnuint32						numberOfAdditionalCertificates,
	pnuint32						flags,
	void							*reserved2,
	void							*reserved3,
	void							*reserved4,
	void							*reserved5
);

N_EXTERN_LIBRARY (NWRCODE) NPKIAdditionalCertificate
(
	const NPKIContext   		context,
	nuint32 				  		index,
	NPKI_CertificateName		**certificateName
);

N_EXTERN_LIBRARY (NWRCODE) NPKICreateUser
(
	const NPKIContext 		context,
	const unicode 				*userName,
	const unicode 				*contextDN
);

N_EXTERN_LIBRARY (NWRCODE) NPKIGetCRLConfigurationInfo
(
	const NPKIContext 		context,
	const unicode 				*objectDN,
	pnuint32						status,
	pnuint32						cRLNumber,
	pnuint32						issueTime,
	pnuint32						attemptTime,
	pnuint32						nextIssueTime,
	pnuint32						intervalUnitType,
	pnuint32						intervalNumberOfUnits,
	pnuint32						fileNameSpaceType,
	unicode const				**fileVolumeDN,
	unicode const				**fileVolumePath,
	pnuint32						numberOfCRLDistributionPoints,
	unicode const				**cLRdistributionPointDN,
	unicode const				**certificateAuthorityDN,
	void 							*reserved1,
	void 							*reserved2,
	void 							*reserved3,
	void 							*reserved4
);

N_EXTERN_LIBRARY (NWRCODE) NPKICRLDistributionPoint
(
	const NPKIContext 		context,
	nuint32 						index,
	unicode const 				**cRLDistributionPoint,
	void 							*reserved1,
	void 							*reserved2
);

N_EXTERN_LIBRARY (NWRCODE) NPKICreatePKIContainer
(
	const NPKIContext 		context,
	const nuint32 				flags,
	const unicode 				*objectName,
	const unicode 				*contextDN,
	const nuint32 				type,
	const unicode 				*linkObjectDN,
	void 							*reserved1,
	void 							*reserved2
);

N_EXTERN_LIBRARY (NWRCODE) NPKICreateCRLConfiguration
(
	const NPKIContext 		context,
	const nuint32 				flags,
	const unicode 				*objectName,
	const unicode 				*contextDN,
	const unicode 				*hostServerDN,
	void 							*reserved1,
	void 							*reserved2
);

N_EXTERN_LIBRARY (NWRCODE) NPKISetCRLFileName
(
	const NPKIContext 		context,
	const unicode 				*objectDN,
	const nuint32 				nameSpaceType,
	const unicode 				*volumeDN,
	const unicode 				*volumePath,
	void 							*reserved1,
	void 							*reserved2
);

N_EXTERN_LIBRARY (NWRCODE) NPKISetNextIssueTime
(
	const NPKIContext 		context,
	const unicode 				*objectDN,
	const nuint32 				nextIssueTime,
	void 							*reserved1,
	void 							*reserved2
);

N_EXTERN_LIBRARY (NWRCODE) NPKISetTimeInterval
(
	const NPKIContext 		context,
	const unicode 				*objectDN,
	const nuint32 				unitType,
	const nuint32 				numberOfUnits,
	void 							*reserved1,
	void 							*reserved2
);

N_EXTERN_LIBRARY (NWRCODE) NPKISetDistributionPoints
(
	const NPKIContext 		context,
	const unicode 				*objectDN,
	const nuint32 				flags,
	const unicode 				*distributionPoint,
	void 							*reserved1,
	void 							*reserved2
);

N_EXTERN_LIBRARY (NWRCODE) NPKISetCertificateAuthorityDN
(
	const NPKIContext 		context,
	const unicode 				*objectDN,
	const unicode 				*certificateAuthorityDN,
	void 							*reserved1,
	void 							*reserved2
);

N_EXTERN_LIBRARY (NWRCODE) NPKICreateCRLDistributionPoint
(
	const NPKIContext 		context,
	const nuint32 				flags,
	const unicode 				*objectName,
	const unicode 				*contextDN,
	const unicode 				*linkObjectDN,
	void 							*reserved1,
	void 							*reserved2
);

N_EXTERN_LIBRARY (NWRCODE) NPKISetDistributionPointDNList
(
	const NPKIContext 		context,
	const unicode 				*objectDN,
	const nuint32 				flags,
	const nuint32 				objectFlags,
	const unicode 				*linkObjectDN,
	const unicode 				*data,
	void 							*reserved1,
	void 							*reserved2
);

N_EXTERN_LIBRARY (NWRCODE) NPKIRevokeCertificate
(
	const NPKIContext			context,
	const unicode 				*cRLConfiguationDN,
	const unicode				*reserved,
	const pnuint8 				certificate,
	const nuint32 				certificateLen,
	const nuint32 				flags,
	const nuint32 				reasonCode,
	const nuint32 				invalidityDate,
	const unicode 				*comment,
	void 							*reserved1,
	void 							*reserved2,
	void 							*reserved3,
	void 							*reserved4,
	pnuint32						nextIssuanceDate
);

N_EXTERN_LIBRARY (NWRCODE) NPKIIssueCRL
(
	const NPKIContext			context,
	const unicode 				*cRLConfiguationDN,
	const nuint32 				flags,
	void 							*reserved1,
	void 							*reserved2,
	void 							*reserved3,
	void 							*reserved4
);

N_EXTERN_LIBRARY (NWRCODE) NPKIKMOExportRead
(
	const NPKIContext 				context,
	const unicode 						*objectDN, 
	pnuint32								numberOfValues,
	void									*reserved1,
	void 									*reserved2
);

N_EXTERN_LIBRARY (NWRCODE) NPKIKMOExportValue
(
	const NPKIContext		context,
	nuint32					index,
	unicode const 			**certificateName, 
	char const	 			**certificatePath, 
	char const				**keyPath, 
	pnuint32					keyFormat,
	void						*reserved1,
	void 						*reserved2
);

N_EXTERN_LIBRARY (NWRCODE) NPKIKMOExportAddValue
(
	const NPKIContext 				context,
	const unicode 						*certificateName, 
	const char							*certificatePath, 
	const char							*keyPath, 
	nuint32								keyFormat,
	void									*reserved1,
	void 									*reserved2
);

N_EXTERN_LIBRARY (NWRCODE) NPKIKMOExportClearValue
(
	const NPKIContext 				context,
	nuint32								index,
	void									*reserved1,
	void 									*reserved2
);

N_EXTERN_LIBRARY (NWRCODE) NPKIKMOExportClearAllValues
(
	const NPKIContext 				context,
	void									*reserved1,
	void 									*reserved2
);

N_EXTERN_LIBRARY (NWRCODE) NPKIKMOExportWrite
(
	const NPKIContext 				context,
	const unicode 						*objectDN, 
	void									*reserved1,
	void 									*reserved2
);

#if defined(__cplusplus)
}
#endif
#endif    /*   _NPKI_H_  */
