/***************************************************************************

  Copyright (c) 1997-2007 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.
  
 *	File:		npkicert.h
 *	Description:	NPKI APIs header file.  
 ***************************************************************************/

#ifndef   _NPKICERT_H_
#define   _NPKICERT_H_

#if defined(__cplusplus)
extern "C" {
#endif

#include <ntypes.h>

/***************************************************************************/
/* 						Certificate Extension Defines									*/
/***************************************************************************/
/* general-purpose extension structure */
typedef struct NPKI_Extension
{
	nuint32	flags;
	nuint32	length;		/* length of value */
	nuint8	*value;
}NPKI_Extension;

typedef struct NPKI_ASN1_Extensions
{
	NPKI_Extension extension;
	struct NPKI_ASN1_Extensions *next;
}NPKI_ASN1_Extensions;

// general-purpose extension flags
#define PKI_EXTENSION_INCLUDE													0x00
#define PKI_EXTENSION_DONT_INCLUDE											0x01
#define PKI_EXTENSION_CRITICAL												0x02
#define PKI_EXTENSION_NON_CRITICAL											0x00

// Basic Constraints extension flags
#define X509_BASIC_CONSTRAINTS_CA											0x0100

// Key Usage extension values 
#define X509_KEY_USAGE_DIGITAL_SIGNATURE									0x8000
#define X509_KEY_USAGE_NON_REPUDIATION	 									0x4000
#define X509_KEY_USAGE_KEY_ENCIPHERMENT 									0x2000
#define X509_KEY_USAGE_DATA_ENCIPHERMENT									0x1000
#define X509_KEY_USAGE_KEY_AGREEMENT	 									0x0800
#define X509_KEY_USAGE_KEY_CERT_SIGN	 									0x0400
#define X509_KEY_USAGE_CRL_SIGN			 									0x0200
#define X509_KEY_USAGE_ENCIPHER_ONLY										0x0100
#define X509_KEY_USAGE_DECIPHER_ONLY										0x0080

// Extended Key Usage extension values 
#define X509_EXTENDED_KEY_USAGE_ANY											0x00000001
#define X509_EXTENDED_KEY_USAGE_SERVER_AUTHENTICATION					0x00000002
#define X509_EXTENDED_KEY_USAGE_CLIENT_AUTHENTICATION					0x00000004
#define X509_EXTENDED_KEY_USAGE_CODE_SIGNING								0x00000008
#define X509_EXTENDED_KEY_USAGE_EMAIL_PROTECTION						0x00000010
#define X509_EXTENDED_KEY_USAGE_TIME_STAMPING							0x00000020
#define X509_EXTENDED_KEY_USAGE_OCSP_SIGNING								0x00000040

#define X509_EXTENDED_KEY_USAGE_MICROSOFT_CertTrustListSigning		0x00000100
#define X509_EXTENDED_KEY_USAGE_MICROSOFT_TimeStampSigning			0x00000200
#define X509_EXTENDED_KEY_USAGE_MICROSOFT_ServerGatedCrypto			0x00000400
#define X509_EXTENDED_KEY_USAGE_MICROSOFT_EncryptedFileSystem		0x00000800

#define X509_EXTENDED_KEY_USAGE_NORTHROP_GRUMMAN						0x00001000
#define X509_EXTENDED_KEY_USAGE_TELETRUST_DirectoryService			0x00002000
#define X509_EXTENDED_KEY_USAGE_CSOR_GAK									0x00004000
#define X509_EXTENDED_KEY_USAGE_CSOR_KRAKey								0x00008000

// Basic Constraints defines
#define X509_NON_CA																0x00
#define X509_CA																	0xFF
#define X509_CA_PATH_LENGTH_UNLIMITED										0xFFFFFFFF

/* Alternative Name structures */
typedef struct NPKI_AltName
{
	nuint16 		type;
	nuint16 		length;
	nuint8  		*value;		
}NPKI_AltName;

typedef struct NPKI_ExtAltNames
{
	nuint32			flags;
	nuint16			numberOfNames;
	NPKI_AltName	*altName;	  /* Array of structures */
}NPKI_ExtAltNames;

/* General Name types */
#define X509_GENERAL_NAME_OTHER_NAME								0x0000
#define X509_GENERAL_NAME_RFC822_NAME								0x0001
#define X509_GENERAL_NAME_DNS_NAME									0x0002
#define X509_GENERAL_NAME_X400_ADDRESS								0x0003
#define X509_GENERAL_NAME_DIRECTORY_NAME							0x0004
#define X509_GENERAL_NAME_EDI_PARTY_NAME							0x0005
#define X509_GENERAL_NAME_UNIFORM_RESOURCE_IDENTIFIER			0x0006
#define X509_GENERAL_NAME_IP_ADDRESS								0x0007
#define X509_GENERAL_NAME_REGISTERED_ID							0x0008

/* Alternative Names types -  for backward compatibility */
#define X509_SUBJECT_ALT_NAME_OTHER_NAME							X509_GENERAL_NAME_OTHER_NAME						
#define X509_SUBJECT_ALT_NAME_RFC822_NAME							X509_GENERAL_NAME_RFC822_NAME						
#define X509_SUBJECT_ALT_NAME_DNS_NAME								X509_GENERAL_NAME_DNS_NAME							
#define X509_SUBJECT_ALT_NAME_X400_ADDRESS						X509_GENERAL_NAME_X400_ADDRESS						
#define X509_SUBJECT_ALT_NAME_DIRECTORY_NAME						X509_GENERAL_NAME_DIRECTORY_NAME					
#define X509_SUBJECT_ALT_NAME_EDI_PARTY_NAME						X509_GENERAL_NAME_EDI_PARTY_NAME					
#define X509_SUBJECT_ALT_NAME_UNIFORM_RESOURCE_IDENTIFIER	X509_GENERAL_NAME_UNIFORM_RESOURCE_IDENTIFIER	
#define X509_SUBJECT_ALT_NAME_IP_ADDRESS							X509_GENERAL_NAME_IP_ADDRESS						
#define X509_SUBJECT_ALT_NAME_REGISTERED_ID						X509_GENERAL_NAME_REGISTERED_ID					

/* AIA Name structure */
#define X509_AccessMethod_OCSP										0x0000
#define X509_AccessMethod_CA_ISSUERS								0x0001

typedef struct NPKIT_EXT_AccessDescription
{
	nuint32				accessMethod;	  // use a defined method above
	nuint16 				generalNameType;
	nuint16 				generalNameLength;
	nuint8  				*generalNameValue;		
}NPKIT_EXT_AccessDescription;

typedef struct NPKI_EXT_AIAValues
{
	nuint32								flags;
	nuint16								numberOfValues;
	NPKIT_EXT_AccessDescription	*accessDescription;	  /* Array of structures */
}NPKI_EXT_AIAValues;

/* Novell Security Attributes (TM) extension flags */
#define NOVELL_EXTENSION_SERVER_DEFAULT							0x00100
#define NOVELL_EXTENSION_USER_DEFAULT								0x00200 
#define NOVELL_EXTENSION_ORGCA_DEFAULT								0x00400 
#define NOVELL_EXTENSION_EXTRACTABLE_KEY							0x10000

/***************************************************************************/
// Certificate Creation Flags 
#define NPKI_CSR															0x0001
#define NPKI_SELF_SIGNED_CERTIFICATE								0x0002

/***************************************************************************/
/* Key generation algorithms supported */
#define PKI_RSA_ALGORITHM												0x01

/* Key generation default flag  */
#define NPKI_KEY_DEFAULT												0x0000

/* Optional Private Key Flags to use when creating a user or server Certificate */
#define PRIVATE_KEY_EXTRACTABLE										0x0004

/* Signature and hashing algorithms supported */
#define PKI_UNKNOWN_ALGORITM											0x00
#define PKI_SIGN_WITH_RSA_AND_MD2									0x01
#define PKI_SIGN_WITH_RSA_AND_MD5									0x02
#define PKI_SIGN_WITH_RSA_AND_SHA1									0x04
#define PKI_SIGN_WITH_RSA_AND_SHA_256								0x08
#define PKI_SIGN_WITH_RSA_AND_SHA_384								0x10
#define PKI_SIGN_WITH_RSA_AND_SHA_512								0x20

/***************************************************************************/
// Private Key Format Flags 
#define NPKI_WRAPPED_PRIVATE_KEY										0x0001
#define NPKI_RAW_PRIVATE_KEY_INFO									0x0002 // PKCS#8
#define NPKI_RAW_PRIVATE_KEY											0x0004 // PKCS#1


#if defined(__cplusplus)
}
#endif
#endif    /*  _NPKICERT_H_  */
