/***************************************************************************

  Copyright (c) 2000-2006 Novell, Inc.  All Rights Reserved.

  THIS WORK IS SUBJECT TO U.S. AND INTERNATIONAL COPYRIGHT LAWS AND
  TREATIES. NO PART OF THIS WORK MAY BE USED, PRACTICED, PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED, ABRIDGED, CONDENSED,
  EXPANDED, COLLECTED, COMPILED, LINKED, RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.
  
 *	File:		NVERIFY.h
 *
 *	Description:	NPKI APIs header file.  
 ***************************************************************************/

#ifndef   _NVERIFY_H_
#define   _NVERIFY_H_

#if defined(__cplusplus)
extern "C" {
#endif

#include <nwccs.h>
#include <npkicert.h>
#include <ntypes.h>
#include <time.h>
#if ! defined ( UNICODE_TYPE_DEFINED )
	#include "unicode.h"
#endif

/***************************************************************************/
//	Common defines for verify fuctions
// 	i.e.	NPKIT_VerifyCertificate
// 			NPKIT_VerifyCertChain
// 			NPKIT_VerifyCertChainWithCallback
//				NPKIVerifyCertificateWithTrustedRoots 


/***************************************************************************/
// Certificate Invalidity Reasons
#define NPKIx509CertificateValid								0x0000000
#define NPKIx509Invalid_System_Error						0x0000001
#define NPKIx509Invalid_Decode_Error						0x0000002
#define NPKIx509Invalid_Subject_Issuer_Name				0x0000003
#define NPKIx509Invalid_Future								0x0000004
#define NPKIx509Invalid_Expired								0x0000005
#define NPKIx509Invalid_Issuer_Not_CA						0x0000006
#define NPKIx509Invalid_Path_Length							0x0000007
#define NPKIx509Invalid_Unknown_Critical_Extension		0x0000008
#define NPKIx509Invalid_KeyUsage								0x0000009
#define NPKIx509Invalid_CRL_Decode_Error					0x000000A
#define NPKIx509Invalid_Certificate_On_CRL				0x000000B
#define NPKIx509Invalid_Cant_Process_CDP					0x000000C
#define NPKIx509Invalid_Cant_Read_CRL						0x000000D
#define NPKIx509Invalid_Invalid_CRL							0x000000E
#define NPKIx509Invalid_Expired_CRL							0x000000F
#define NPKIx509Invalid_CRL_Issuer_Name					0x0000010
#define NPKIx509Invalid_Issuer_Not_Trusted				0x0000011
#define NPKIx509Invalid_CDP_Exists_Did_Not_Check_CRL	0x0000012
#define NPKIx509Invalid_Invalid_Signature					0x0000013
#define NPKIx509Invalid_Algorithm_Not_Supported			0x0000014
#define NPKIx509Invalid_Missing_Required_Extension		0x0000015
#define NPKIx509Invalid_Extension_Not_Critical			0x0000016
#define NPKIx509Invalid_Missing_Certificate_Policy		0x0000017

#define NPKIx509Invalid_OCSP_REVOKED						0x0000020
#define NPKIx509Invalid_OCSP_ERROR							0x0000021
#define NPKIx509Invalid_OCSP_UNKNOWN						0x0000022
										 
/***************************************************************************/
// Possible cRLReason values for verify functions when 
// 1) certInvalidityReason == NPKIx509Invalid_Certificate_On_CRL
#define PKI_UNSPECIFIED								0
#define PKI_KEY_COMPROMISED						1
#define PKI_CA_COMPROMISED							2
#define PKI_AFFILIATION_CHANGED					3
#define PKI_SUPERSEDED								4
#define PKI_CESSATION_OF_OPERATION				5
#define PKI_CERTIFICATE_HOLD						6
#define PKI_PRIVILEDGE_WITHDRAWN					7
#define PKI_AA_COMPROMISE							8

/***************************************************************************/
// Possible cRLHoldInstruction values for verify functions when 
// 1) certInvalidityReason == NPKIx509Invalid_Certificate_On_CRL and
// 2)	cRLReason == PKI_CERTIFICATE_HOLD
#define PKI_HOLD_INSTRUCTION_NONE				0
#define PKI_HOLD_INSTRUCTION_CALL_ISSUER		1
#define PKI_HOLD_INSTRUCTION_REJECT				2


typedef struct NPKI_CRL
{
	pnuint8						cRL;
	nuint32						cRLLen;
	nuint32						flags;	// for future use -- pass zero
	struct NPKI_CRL			*next;	  
}NPKI_CRL;

typedef struct NPKI_ERROR
{
	nuint32						certInvalidityReason;
	nuint32						cRLReason;
	nuint32						cRLHoldInstruction;
	time_t  						cRLRevocationTime;
	time_t  						cRLInvalidityDateTime;
	void							*reserved1;	// for future use
	void							*reserved2;	// for future use
	struct NPKI_ERROR			*next;	  
}NPKI_ERROR;

typedef struct NPKI_CertChain
{
	pnuint8						cert;
	nuint32						certLen;
	NPKI_CRL						*cRLStruct;	// for future use -- pass NULL (optional - use to pass pre-fetched crls)
	nuint32						flags;		// for future use -- pass zero
	nuint32						numErrors;	// for future use -- pass zero
	NPKI_ERROR					*error;		// for future use -- pass NULL
	void							*reserved1;	// for future use -- pass NULL
	void							*reserved2;	// for future use -- pass NULL
	struct NPKI_CertChain	*next;
}NPKI_CertChain;

/* Flags for the NPKI_VerifyCallBackStruct */
#define NPKI_VERIFY_NORMAL								0x00000000
#define NPKI_VERIFY_DONT_CHECK_CERTIFICATE		0x00000001
#define NPKI_VERIFY_DONT_CHECK_REVOCATION			0x00000002
#define NPKI_VERIFY_DONT_CHECK_CRL					NPKI_VERIFY_DONT_CHECK_REVOCATION 
#define NPKI_VERIFY_DONT_USE_CACHED_CRL			0x00000010 
#define NPKI_VERIFY_DONT_CHECK_ROOT_VALIDITY		0x00000100


#define NPKIT_CRLCacheContext		nuint32

#define NPKIT_REVOCATION_CRL_ONLY				0x00000001
#define NPKIT_REVOCATION_OCSP_ONLY				0x00000002
#define NPKIT_REVOCATION_OCSP_CRL				0x00000100
#define NPKIT_REVOCATION_DEFAULT					NPKIT_REVOCATION_OCSP_CRL

#define NPKIT_REVOCATION_CONFIGURED_OCSP		0x00010000

#define NPKIT_OCSP_SIGN_ALWAYS					0x00000001
#define NPKIT_OCSP_SIGN_IF_NEEDED				0x00000002

#define NPKIT_OCSP_REQUESTORNAME_DIRECTORY	0x00000100

typedef struct NPKIT_ENHANCED_VERIFY_OPTIONS
{
	nuint32							revocationPreference;
	nuint32							OCSPFlags;
	nuint8							*OCSPRequestorName;
	NICI_CC_HANDLE					ccsContext;
	NICI_OBJECT_HANDLE			OCSPRequestSigningKey;
	NPKI_CertChain					*OCSPRequestCertificates;
	nuint8							*OCSPConfiguredURL;
	NPKI_CertChain					*OCSPConfiguredCertificates;
	nuint8							*LDAPServerURL;
	time_t							*cRLGracePeriod;
	void								*reserved3;		// for future use
	void								*reserved4;		// for future use
	void								*reserved5;		// for future use
	void								*reserved6;		// for future use
	void								*reserved7;		// for future use
	void								*reserved8;		// for future use
	void								*reserved9;		// for future use
	void								*reserved10;	// for future use
}NPKIT_ENHANCED_VERIFY_OPTIONS;

typedef struct NPKI_VerifyCallBackStruct
{
	void 									(*callback) (void *data);	// IN - The function to be called 
	NPKI_CertChain						*certificateChain;			// IN	- The chain of certificates to be validated (In order, starting with the subject cert)
	nuint32								flags; 							// IN	- Special processing flags, see Flags section above 
	NWRCODE								ccode; 							// OUT - return value of the verifiy function
	nuint32								cRLReason;						// OUT - reason code from the crl (only if cert is on crl) -- see defines above
	nuint32								cRLHoldInstruction;			// OUT - hold instruction from the crl (only if cert is on crl)
	time_t  								cRLRevocationTime;			// OUT - time of certificate revocation (only if cert is on crl)
	time_t  								cRLInvalidityDateTime;		// OUT - time certificate became invalid (only if cert is on crl and invalidityDate specified on crl)
	NPKI_CertChain						*revokedCertificate;			// OUT - pointer to which certificate is invalid (only if a cert is invalid)
	nuint32								certInvalidityReason;		// OUT - value to specify why a cert is invalid -- see defines above
	void									*reserved1;						// Reserved for future use
	NPKIT_CRLCacheContext			*CRLCacheContext;				// IN -- The CRL cache context.  (0 uses the global context)
	NPKIT_ENHANCED_VERIFY_OPTIONS	*enhancedOptions;				// IN -- optional structure to send in enanced verifiy info
	void									*userData;						// IN -- Available for caller to pass information to the callback function
}NPKI_VerifyCallBackStruct;

#if defined(__cplusplus)
}
#endif
#endif    /*   _NVERIFY_H_  */
