/***************************************************************************
 Copyright (c) 1998-2002 Novell, Inc.  All Rights Reserved.

 THIS WORK IS SUBJECT TO U.S. AND INTERNATIONAL COPYRIGHT LAWS AND
 TREATIES.  USE AND REDISTRIBUTION OF THIS WORK IS SUBJECT TO THE 
 LICENSE AGREEMENT ACCOMPANYING THE SOFTWARE DEVELOPMENT KIT (SDK)
 THAT CONTAINS THIS WORK.

 Pursuant to the SDK License Agreement, Novell hereby grants to 
 Developer a royalty-free, non-exclusive license to include the
 sample code AES.C and derivative binaries in its product.
 Novell grants to Developer worldwide distribution rights to market,
 distribute or sell the sample code AES.C and derivative
 binaries as a component of Developer's product(s).  Novell shall 
 have no obligations to Developer or Developer's customers with 
 respect to this code.

DISCLAIMER:

   Novell, Inc. makes no representations or warranties with respect
to the contents or use of this code, and specifically disclaims any
express or implied warranties of merchantability or fitness for any
particular purpose.  Further, Novell, Inc. reserves the right to revise
this publication and to make changes to its content, at any time,
without obligation to notify any person or entity of such revisions or
changes.

   Further, Novell, Inc. makes no representations or warranties with
respect to any software, and specifically disclaims any express or
implied warranties of merchantability or fitness for any particular
purpose.  Further, Novell, Inc. reserves the right to make changes to
any and all parts of the software, at any time, without obligation to
notify any person or entity of such changes.                          

***************************************************************************/
#ifdef WIN32
#	include <windows.h>
#endif

#include <stdio.h>
#include "npki.h"
#include "pkierr.h"

NWRCODE ExportUserCert(void)
{
	NWRCODE				ccode = PKI_SUCCESS;
	NPKIContext			myPKI = NPKI_INVALID_CONTEXT;
	nuint32				pfxSize;
	nuint8 const		*pfx;

	// user/system infomation	
	unicode				myTree[]	= {'T','E','S','T',0};
	unicode				myUser[]	= {'A','d','m','i','n','.','n','o','v','e','l','l',0};
	char					password[]	= {'t','e','s','t',0};
	char*					startIPAddress = "192.168.0.2";
	
	// PFX info
	unicode				pword[] = {'1','2','3','4','5','6',0};
	unicode				myNick[]	= {'n','i','c','k','n','a','m','e',0};

	//	NOTE: You must be logged in as the user in order to export the private key.
	//		Not even admin or someone with supervisor rights can export someone elses' 
	//		private key.

	ccode = NPKICreateContext(&myPKI);
	if (ccode != PKI_SUCCESS)
	{
		goto ERR_EXIT;
	}
	
	// Set the tree name, this is the tree we will make all calls to.
  	ccode = NPKISetTreeName(myPKI, myTree);	 
	if (ccode != PKI_SUCCESS)
	{
		goto ERR_EXIT;
	}

	ccode = NPKIConnectToIPAddress(myPKI, 0, 0, startIPAddress,	NULL,	NULL);

	ccode = NPKIDSLogin(myPKI, myUser, password);
	if (ccode != PKI_SUCCESS)
	{
		goto ERR_EXIT;
	}

	ccode = NPKIExportUserKey 
	(
		myPKI,
		myNick,
		pword,
		PKI_OBJECT_KEY_CERTIFICATE | PKI_CHAIN_CERTIFICATE,
		&pfxSize,
		&pfx
	);
	if (ccode != PKI_SUCCESS)
	{
		goto ERR_EXIT;
	}

	// write pfx to a binary file and store in a secure place
	{
		FILE		*stream = NULL;
		size_t	size = 0;
		
	   stream = fopen("User.pfx", "wb");
		if (stream != NULL)
		{
			size = fwrite(pfx, sizeof(char), pfxSize, stream);
			fclose(stream);	
		}
	}
	
ERR_EXIT:
	NPKIDSLogout(myPKI);
	
	if (myPKI != NPKI_INVALID_CONTEXT)
		NPKIFreeContext(myPKI);

	return ccode;
}

