/***************************************************************************
 Copyright (c) 1998-2002 Novell, Inc.  All Rights Reserved.

 THIS WORK IS SUBJECT TO U.S. AND INTERNATIONAL COPYRIGHT LAWS AND
 TREATIES.  USE AND REDISTRIBUTION OF THIS WORK IS SUBJECT TO THE 
 LICENSE AGREEMENT ACCOMPANYING THE SOFTWARE DEVELOPMENT KIT (SDK)
 THAT CONTAINS THIS WORK.

 Pursuant to the SDK License Agreement, Novell hereby grants to 
 Developer a royalty-free, non-exclusive license to include the
 sample code AES.C and derivative binaries in its product.
 Novell grants to Developer worldwide distribution rights to market,
 distribute or sell the sample code AES.C and derivative
 binaries as a component of Developer's product(s).  Novell shall 
 have no obligations to Developer or Developer's customers with 
 respect to this code.

DISCLAIMER:

   Novell, Inc. makes no representations or warranties with respect
to the contents or use of this code, and specifically disclaims any
express or implied warranties of merchantability or fitness for any
particular purpose.  Further, Novell, Inc. reserves the right to revise
this publication and to make changes to its content, at any time,
without obligation to notify any person or entity of such revisions or
changes.

   Further, Novell, Inc. makes no representations or warranties with
respect to any software, and specifically disclaims any express or
implied warranties of merchantability or fitness for any particular
purpose.  Further, Novell, Inc. reserves the right to make changes to
any and all parts of the software, at any time, without obligation to
notify any person or entity of such changes.                          

***************************************************************************/
#ifdef WIN32
#	include <windows.h>
#endif

#include <stdio.h>
#include "npki.h"
#include "pkierr.h"

NWRCODE GetServerCertificate(void)
{
	NWRCODE  			ccode = PKI_SUCCESS;
	NPKIContext 		myPKI = NPKI_INVALID_CONTEXT;
	nuint32				numberOfServers = 0;
	nuint32				flags	= 0;
	nuint32				objectCertSize	= 0;
	nuint8 const		*objectCert = NULL;
	nuint32				chainCertSize	= 0;
	nuint8 const		*chainCert = NULL;
	nuint8 const		*wrappedKey	= NULL;
	nuint32				wrappedKeySize	= 0;
	nuint32				numberOfChainCerts = 0;
	nuint32				index;

	// user/system infomation	
	unicode				myTree[]	= {'T','E','S','T',0};
	unicode				myUser[]	= {'A','d','m','i','n','.','n','o','v','e','l','l',0};
	char					password[]	= {'t','e','s','t',0};
	char*					startIPAddress = "192.168.0.2";
	
	// certificate info
	unicode				certName[] = {'c','e','r','t','i','f','i','c','a','t','e',0};
	unicode				serverDN[] = {'T','e','s','t','5','1','.','n','o','v','e','l','l',0};

	ccode = NPKICreateContext(&myPKI);
	if (ccode != PKI_SUCCESS)
	{
		goto ERR_EXIT;
	}
	
	// Set the tree name, this is the tree we will make all calls to.
  	ccode = NPKISetTreeName(myPKI, myTree);	 
	if (ccode != PKI_SUCCESS)
	{
		goto ERR_EXIT;
	}

	ccode = NPKIConnectToIPAddress(myPKI, 0, 0, startIPAddress,	NULL,	NULL);
	
	// Login in
	ccode = NPKIDSLogin(myPKI, myUser, password);
	if (ccode != PKI_SUCCESS)
	{
		goto ERR_EXIT;
	}

	ccode = NPKIGetServerCertificateStatus(myPKI, serverDN, certName, &flags);
	if (ccode != PKI_SUCCESS)
	{
		goto ERR_EXIT;
	}
	
	if (flags != KMO_CERTIFICATE_PRESENT)
	{
		goto ERR_EXIT;
	}
			
			// retieve the certificates
	ccode = NPKIGetServerCertificates
	(
		myPKI, 
		serverDN, 
		certName, 
		PKI_OBJECT_KEY_CERTIFICATE | PKI_CHAIN_CERTIFICATE,
		&objectCertSize, 
		&objectCert, 
		&numberOfChainCerts, 
		NULL, 
		NULL, 
		NULL
	);
	if (ccode != PKI_SUCCESS)
	{
		goto ERR_EXIT;
	}
	// you should either use the object certificate or copy it for later use
	{
		FILE		*stream = NULL;
		size_t	size = 0;
		
	   stream = fopen("ServerCert.cer", "wb");
		if (stream != NULL)
		{
			size = fwrite(objectCert, sizeof(char), objectCertSize, stream);
			fclose(stream);	
		}
	}
			
	for (index = 0; index < numberOfChainCerts; index++)
	{
		ccode = NPKIChainCertInfo
		(	
			myPKI, 
			index, 
			&chainCertSize, 
			&chainCert, 
			NULL, 
			NULL
		);
		if (ccode != PKI_SUCCESS)
		{
			continue;
		}
		// you should either use the chain certificate within this loop or copy it for later use
	}

ERR_EXIT:
	NPKIDSLogout(myPKI);

	if (myPKI != NPKI_INVALID_CONTEXT)
		NPKIFreeContext(myPKI);

	return ccode;
}
