/***************************************************************************
 Copyright (c) 1998-2002 Novell, Inc.  All Rights Reserved.

 THIS WORK IS SUBJECT TO U.S. AND INTERNATIONAL COPYRIGHT LAWS AND
 TREATIES.  USE AND REDISTRIBUTION OF THIS WORK IS SUBJECT TO THE 
 LICENSE AGREEMENT ACCOMPANYING THE SOFTWARE DEVELOPMENT KIT (SDK)
 THAT CONTAINS THIS WORK.

 Pursuant to the SDK License Agreement, Novell hereby grants to 
 Developer a royalty-free, non-exclusive license to include the
 sample code AES.C and derivative binaries in its product.
 Novell grants to Developer worldwide distribution rights to market,
 distribute or sell the sample code AES.C and derivative
 binaries as a component of Developer's product(s).  Novell shall 
 have no obligations to Developer or Developer's customers with 
 respect to this code.

DISCLAIMER:

   Novell, Inc. makes no representations or warranties with respect
to the contents or use of this code, and specifically disclaims any
express or implied warranties of merchantability or fitness for any
particular purpose.  Further, Novell, Inc. reserves the right to revise
this publication and to make changes to its content, at any time,
without obligation to notify any person or entity of such revisions or
changes.

   Further, Novell, Inc. makes no representations or warranties with
respect to any software, and specifically disclaims any express or
implied warranties of merchantability or fitness for any particular
purpose.  Further, Novell, Inc. reserves the right to make changes to
any and all parts of the software, at any time, without obligation to
notify any person or entity of such changes.                          

***************************************************************************/
#ifdef WIN32
#	include <windows.h>
#endif

#include <stdio.h>
#include "npki.h"
#include "pkierr.h"

#define SECONDS_IN_YEARS 365 * 24 * 60 * 60

NWRCODE SignCSR(void)
{
	NWRCODE  			ccode = PKI_SUCCESS;
	NPKIContext 		myPKI = NPKI_INVALID_CONTEXT;
	unicode const 		*organizationalCADN;
	unicode const 		*signingServerDN;
	nuint32 				caOperational;
	nuint8  const 		*certificate;
	nuint32 				certificateSize;
	nuint32 				maxValidFromTime;
	nuint32 				maxValidToTime;
	nuint32 				currentServerTime;
	nuint32				signatureAlgorithms = 0;
	nuint8				*CSR = NULL;
	nuint32				CSRSize = 0;
	
	// user/system infomation	
	unicode				myTree[]	= {'T','E','S','T',0};
	unicode				myUser[]	= {'A','d','m','i','n','.','n','o','v','e','l','l',0};
	char					password[]	= {'t','e','s','t',0};
	char*					startIPAddress = "192.168.0.2";
	
	// certificate info
	NPKI_Extension 	NovellAttr = {PKI_EXTENSION_DONT_INCLUDE,0};
	
	/*----------------------------------------------------
		Start --- Important --- Important --- Start
	
    Put your own functions here to get the CSR and CSRSize
	------------------------------------------------------*/
	{
		FILE		*stream = NULL;
		size_t	size = 0;
		
	   stream = fopen("serverCSR.b64", "rb");
		if (stream != NULL)
		{
	   	fseek(stream, 0L, SEEK_END);
			size = ftell(stream);
	   	fseek(stream, 0L, SEEK_SET);
			if ((CSR = (nuint8 *)malloc(size)) == NULL)
			{
				ccode = PKI_E_INSUFFICIENT_MEMORY;
				goto ERR_EXIT;
			}
		
			CSRSize = fread(CSR, sizeof(char), size, stream);
			fclose(stream);	
		}
		else
		{
			ccode = PKI_E_FILE_OPEN;
			goto ERR_EXIT;
		}
	}
	/*----------------------------------------------------
		End --- Important --- Important --- End
	------------------------------------------------------*/
	
	ccode = NPKICreateContext(&myPKI);
	if (ccode != PKI_SUCCESS)
	{
		goto ERR_EXIT;
	}
	
	// Set the tree name, this is the tree we will make all calls to.
  	ccode = NPKISetTreeName(myPKI, myTree);	 
	if (ccode != PKI_SUCCESS)
	{
		goto ERR_EXIT;
	}

	ccode = NPKIConnectToIPAddress(myPKI, 0, 0, startIPAddress,	NULL,	NULL);
	
	// Login in
	ccode = NPKIDSLogin(myPKI, myUser, password);
	if (ccode != PKI_SUCCESS)
	{
		goto ERR_EXIT;
	}

	// Find the Organiztional Certificate Authority
	ccode = NPKIFindOrganizationalCA(myPKI, &organizationalCADN);
	if (ccode != PKI_SUCCESS)
	{
		goto ERR_EXIT;
	}
	
	// Get the DN of the CA server (server which hosts the Organiztional Certificate Authority)
	ccode = NPKIGetHostServerDN(myPKI, organizationalCADN, &signingServerDN);
	if (ccode != PKI_SUCCESS)
	{
		goto ERR_EXIT;
	}
		
	ccode = NPKIGetServerUTCTime
	(
		myPKI,
		signingServerDN, 
		&currentServerTime
	);
	if (ccode != PKI_SUCCESS)
	{
		goto ERR_EXIT;
	}
	
	// Get information from the CA server
	ccode = NPKIGetServerInfo
	(
		myPKI, 
		signingServerDN, 
		PKI_USER_INFO, 
		NULL,
		&signatureAlgorithms,
		&maxValidFromTime,
		&maxValidToTime,
		&caOperational,
		NULL,
		NULL,
		NULL,
		NULL
	);
	if (ccode != PKI_SUCCESS)
	{
		goto ERR_EXIT;
	}

	if (!(signatureAlgorithms & PKI_SIGN_WITH_RSA_AND_SHA1))	// (other algorithms could be used)
	{
		ccode = PKI_E_ALGORITHM_NOT_SUPPORTED;
		goto ERR_EXIT;
	}
	
	if (caOperational != PKI_ORGANIZATIONAL_CA)	
	{															
		ccode = PKI_E_CA_NOT_OPERATIONAL;
		goto ERR_EXIT;
	}	

	if (maxValidFromTime < currentServerTime)
		maxValidFromTime = currentServerTime;
		
	if (maxValidToTime > currentServerTime + (2 * SECONDS_IN_YEARS)) // approx 2 years -- no leap calculations
		maxValidToTime = currentServerTime + (2 * SECONDS_IN_YEARS);
		
	ccode = NPKIGenerateCertificateFromCSR
	(
		myPKI, 
		signingServerDN, 
		CSR, 
		CSRSize,
		NULL, 
		PKI_SIGN_WITH_RSA_AND_SHA1,
		DEFAULT_YEAR_ENCODING, 
		maxValidFromTime, 
		maxValidToTime,
		NULL, 
		NULL, 
		NULL, 
		&NovellAttr,
		NULL,
		NULL,
		NULL
	);
	if (ccode != PKI_SUCCESS)
	{
		goto ERR_EXIT;
	}

	// Retrieve the certificate
	ccode = NPKICertInfo
	(
		myPKI,
		&certificateSize,
		&certificate
	);	
	if (ccode != PKI_SUCCESS)
	{
		goto ERR_EXIT;
	}
	
	// use the certificate or save it for later use
	{
		FILE		*stream = NULL;
		size_t	size = 0;
		
	   stream = fopen("ExternalCert.cer", "wb");
		if (stream != NULL)
		{
			size = fwrite(certificate, sizeof(char), certificateSize, stream);
			fclose(stream);	
		}
	}
	
ERR_EXIT:
	if (CSR != NULL)
	{
		free(CSR);
	}
	
	NPKIDSLogout(myPKI);

	if (myPKI != NPKI_INVALID_CONTEXT)
		NPKIFreeContext(myPKI);

	return ccode;
}	
