package com.novell;
import java.io.*;
import java.util.*;
import com.novell.security.nmas.mgmt.NMASChallengeResponseMgr;
import com.novell.security.nmas.mgmt.NMASChallengeResponseException;
import javax.naming.ldap.LdapContext;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.NamingException;
import javax.naming.Context;

public class SetChallengeResponse {
	
	public static void main(String args[]) {

		if(args.length < 6) {
			System.out.println("Usage: host port adminDN password userDN file");
			System.out.println("localhost 636 cn=admin,o=novell novell cn=developer,o=novell questions.txt");
		}
		
		String host = args[0];
		int port = Integer.parseInt(args[1]);
		String adminDN = args[2];
		String password = args[3];
		String userDN = args[4];
		String filename = args[5];
		
		try {
			BufferedReader in = new BufferedReader(new FileReader(filename));
			String str;

			ArrayList questions = new ArrayList();
			ArrayList answers = new ArrayList();

			while ((str = in.readLine()) != null) {
				StringTokenizer st = new StringTokenizer(str, "?"); 
	            		questions.add(st.nextToken().trim()); 
	            		answers.add(st.nextToken().trim()); 
			}

			String[]sChallenges = (String[]) questions.toArray(new String[questions.size()]);
			String[]sResponses = (String[]) answers.toArray(new String[answers.size()]);

			String s = "<Challenges> RandomQuestions=\"1\" GUID=\"123456\"\n";
			for(int i=0; i < sChallenges.length; i++)
			{		
				System.out.println("Question: " + sChallenges[i] + " Answer: " + sResponses[i]);
				s = s + "\t<Challenge Define=\"Admin\" Type=\"Required\" MinLength=\"2\" MaxLength=\"255\">" + sChallenges[i] + "</Challenge>\n";
			}
			s = s + "</Challenges>\n";

			LdapContext ld = getLdapContext(host, adminDN, password, port);
		
			NMASChallengeResponseMgr mgr = new NMASChallengeResponseMgr(ld);
			mgr.setChallengeQuestions(userDN, s);
			System.out.println(mgr.getChallengeQuestions(userDN));
			mgr.setChallengeResponses(userDN, sChallenges, sResponses);

			in.close();
		}
		catch (FileNotFoundException e) {
			System.out.println("Can't find file: " + args[2]);
			return;
		}
		catch (IOException e) {
			e.printStackTrace();
		}
		catch (NMASChallengeResponseException e) {
			System.out.println(e.getNmasRetCode());
			e.printStackTrace();
		}
		catch (NamingException e) {
			e.printStackTrace();
		}
	}
	
    public static LdapContext getLdapContext(String ldapHost, String loginDN, String pwd, int iSSLPort)
    throws NamingException {

	    LdapContext ldapCtx = null;
	
	    // Create a Hashtable object.
	    Hashtable env = new Hashtable(5, 0.75f);
	    env.put(Context.SECURITY_PROTOCOL, "ssl");
	    env.put(Context.INITIAL_CONTEXT_FACTORY, "com.sun.jndi.ldap.LdapCtxFactory");
	    env.put(Context.PROVIDER_URL, "ldap://" + ldapHost + ":" + iSSLPort);
	    env.put(Context.SECURITY_AUTHENTICATION, "simple");
	    env.put(Context.SECURITY_PRINCIPAL, loginDN);
	    env.put(Context.SECURITY_CREDENTIALS, pwd);
	
	    // Construct an LdapContext object.
	    ldapCtx = new InitialLdapContext(env, null);

    return (ldapCtx);

    } // end getLdapCtx method

}
