/**************************************************************************
* %name:          nssscl.h %
* %instance:      security_1 %
* %version:       security#17.1.1 %
* %created_by:    cameron %
* %date_modified: Thu Sep 01 12:23:38 2005 %
***************************************************************************
*
* Copyright (c) 1998-2005 Novell, Inc. All rights reserved.
*
* THIS WORK IS SUBJECT TO U.S. AND INTERNATIONAL COPYRIGHT LAWS AND TREATIES.
* USE AND REDISTRIBUTION OF THIS WORK IS SUBJECT TO THE LICENSE AGREEMENT
* ACCOMPANYING THE SOFTWARE DEVELOPMENT KIT (SDK) THAT CONTAINS THIS WORK.
* PURSUANT TO THE SDK LICENSE AGREEMENT, NOVELL HEREBY GRANTS TO DEVELOPER A
* ROYALTY-FREE, NON-EXCLUSIVE LICENSE TO INCLUDE NOVELL'S SAMPLE CODE IN ITS
* PRODUCT. NOVELL GRANTS DEVELOPER WORLDWIDE DISTRIBUTION RIGHTS TO MARKET,
* DISTRIBUTE, OR SELL NOVELL'S SAMPLE CODE AS A COMPONENT OF DEVELOPER'S
* PRODUCTS. NOVELL SHALL HAVE NO OBLIGATIONS TO DEVELOPER OR DEVELOPER'S
* CUSTOMERS WITH RESPECT TO THIS CODE.
**************************************************************************/

#ifndef		_NSSSCL_H_
#define		_NSSSCL_H_

/* This is the NDK header file for the SecretStore version 3.02. */
#if defined(__cplusplus) || defined(c_plusplus)
extern "C"
{
#endif

#ifndef _SSPROTO_H_
#define _SSPROTO_H_
#if defined(WIN32)

	#define SS_GLOBAL_LIBCALL_PTR(RET)			RET * __stdcall
	#define SS_GLOBAL_LIBCALL(RET)				RET	__stdcall 
	#define SS_EXTERN_LIBCALL_PTR(RET)			extern RET * __stdcall
	#define SS_EXTERN_LIBCALL(RET)				extern RET __stdcall
	#define SS_TYPEDEF_LIBCALL_PTR(RET, PTR)	typedef RET	* (__stdcall *PTR)
	#define SS_TYPEDEF_LIBCALL(RET, PTR)		typedef RET	(__stdcall *PTR)

#else

	#define SS_GLOBAL_LIBCALL_PTR(RET)			RET *
	#define SS_GLOBAL_LIBCALL(RET)				RET
	#define SS_EXTERN_LIBCALL_PTR(RET)			extern RET *
	#define SS_EXTERN_LIBCALL(RET)				extern RET
	#define SS_TYPEDEF_LIBCALL_PTR(RET, PTR)	typedef RET * (*PTR)
	#define SS_TYPEDEF_LIBCALL(RET, PTR)		typedef RET	(*PTR)

#endif

#endif //* _SSPROTO_H_

/* ########################################################################### */
/* ####################### SecretStore Constants ############################# */
/* ########################################################################### */


#ifndef	_SSSHAR_H 

#define 		NSSS_VERSION_NUMBER				0x00030304L	//*  client version number

#define		NSSS_MAX_SECRET_ID_CHARS		256		//* double bytes including NULL
#define		NSSS_MAX_SECRET_ID_LEN			512		//* in bytes including NULL

#define		NSSS_MIN_SECRET_BUF_LEN			3968	//* (4K-128)to match server
#define		NSSS_MID_SECRET_BUF_LEN			32768	//* (4K-128)to match server
#define		NSSS_MAX_SECRET_BUF_LEN			60416	//* (59K)to match server
#define		NSSS_MAX_EP_PWORD_CHARS			64		//* enhanced protection max password (chars)
#define		NSSS_MAX_EP_PWORD_LEN			128		//* enhanced protection max password (bytes)

#define		NSSS_MAX_LDAP_PWORD_LEN			128		//* user's ldap login password

#define		NSSS_MAX_MP_PWORD_HINT_CHARS	64		//* enhanced protection max hint (chars)
#define		NSSS_MAX_MP_PWORD_HINT_LEN		128		//* enhanced protection maximum hint (bytes)

#define		NSSS_MAX_TREE_NAME_CHARS		32		//* max tree name length (chars)
#define		NSSS_MAX_TREE_NAME_LEN			64		//* max tree name length (bytes)
				
#define		NSSS_MAX_DN_CHARS				258		//* max DN length (chars)
#define		NSSS_MAX_DN_LEN					516		//* max DN length (bytes)

#define		NSSS_MAX_IP_ADDR_LEN			16		//* IP address string length (bytes including NULL)
#define		NSSS_MAX_ADDR_LEN				512		//* can be IP or DNS name (bytes including null)

#define		NSSS_NICI_UNDETERMINED_ENGINE	0
#define		NSSS_NICI_DOMESTIC_ENGINE		1
#define		NSSS_NICI_EXPORT_ENGINE			2

#define		NSSS_MIN_IDLIST_BUF_LEN			16384	//* (16K)
#define		NSSS_MID_IDLIST_BUF_LEN			32768	//* (32K)
#define		NSSS_MAX_IDLIST_BUF_LEN			65536	//* (64kK)
#define		NSSS_JUMBO_IDLIST_BUF_LEN		131072	//* (128K)
#define		NSSS_JUMBO_ENUM_BUF_LEN			131072	//* (128K)
#define		NSSS_ENUM_BUFFER_GUESS			32768	//* (32K)

#define		NSSS_MAX_LDAP_CRED_BUF_LEN		65536	//* (64kK)

#define		NSSS_ENUM_DELIM					"*"		//* immutable

/* ########################################################################### */
/* ############################### API FLAGS ################################# */
/* ########################################################################### */

/* input only flag for Unlock API													   
   ============================== */
/* can delete locked secrets from store to remove lock */
#define		NSSS_REMOVE_LOCK_FROM_STORE_F	0x00000004L
/* if the store is not locked return an error otherwise use the info supplied
	 to unlock the store. In the absense of this flag when the store is not 
	 locked the SecretStore returns success. */
#define		NSSS_IS_STORE_LOCKED_F			0x00000008L
#define		NSSS_VERIFY_MP_F				0x00008000L


/* input only flags for Write	API
   ============================== */
/* Enhanced Protection indicator flag for Read & Write */
#define		NSSS_ENHANCED_PROTECTION_F		0x00000001L
/* Enhanced Protection optional password indicator flag for Read & Write */
#define		NSSS_EP_PASSWORD_USED_F			0x00000040L
/* if Secret ID is in the SecretStore already don't overwrite the secret */
#define 		NSSS_CHK_SID_FOR_COLISION_F		0x00004000L

/* input only flag for Read API 
   ============================ */
/* request all possible repair on damaged store */
#define		NSSS_REPAIR_THE_STORE_F			0x00000008L

/* input only flag for all the APIs
   ================================ */
//* This flag tells the call that the strings such as 
//* secretID, DN, searchString etc. are already converted 
//* to Unicode and no conversion is necessary, results
//* like secretIDList will be returned in unicode. 
#define		NSSS_ALL_STRINGS_UNICODE_F		0x00000010L
#define		NSSS_SET_TREE_NAME_F			0x00000080L
//* Internally destroys the DS context passed in
#define		NSSS_DESTROY_CONTEXT_F			0x00000200L
#define		NSSS_UNBINDLDAP_F				0x00001000L

/* input only flag for GetServiceInformation API
   ============================================= */
//* will return a DS context for reuse in the subsequent calls
#define		NSSS_GET_CONTEXT_F				0x00000100L



/* input flag for all APIs
   ======================= */
//* this flag indicates LDAP based acess to the directory is desired
#define		NSSS_BINDLDAP_F					0x00000800L

/* output only flags from Read API (statFlags on reading a secret)
	also these come back on GetServiceInformation (statFlags on the store)
   ==================================================================== */
/* Non-Repudiation lock on secret */
#define		NSSS_SECRET_LOCKED_F			0x00010000L
/* Secret not initialized with a Write yet */
#define		NSSS_SECRET_NOT_INITIALIZED_F	0x00020000L	
/* Secret is marked for Enhanced Protection */
#define		NSSS_ENHANCED_PROTECT_INFO_F	0x00040000L	
/* Store not synchronized across replicas */
#define		NSSS_STORE_NOT_SYNCED_F			0x00080000L 
/* There is EP password on the secret */
#define		NSSS_EP_PWORD_PRESENT_F			0x00200000L

/* input only flag for Read, Unlock, and SetMP APIs
   ================================================ */
#define		NSSS_EP_MASTER_PWORD_USED_F		0x00000020L

/* output only flags from Read API (statFlags on reading asecret
   ============================================================= */
/* Last secret modification by admin */
#define		NSSS_ADMIN_LAST_MOD_F			0x00100000L 


/* output only flag from GetServiceInformation API statFlags 
   ========================================================= */
/* There is master password on the secretstore  */
#define		NSSS_EP_MASTER_PWORD_PRESENT_F	0x00400000L

/* output only flag from GetServiceInformation, and read API statFlags 
   =================================================================== */
#define		NSSS_MP_NOT_ALLOWED_F			0x00800000L

/* internal flag to the server
   =========================== */
#define 		NSSS_SYNC_IN_PROGRESS_F			0x02000000L 

/* output only flag for last Admin that has unlocked the store 
   =========================================================== */
#define 		NSSS_ADMIN_UNLOCKED_F			0x04000000L 

/* output only flag for server internal features
   ============================================ */
#define 		NSSS_LATSTAMP_ALLOWED_F			0x08000000L /* ss last access time stamp allowed */
#define 		NSSS_ADMIN_AUTHORIZED_F			0x10000000L /* ss admin authorized */

/* output only flag to indicate SecretStore contains hidden secrets
   ================================================================ */
#define		NSSS_HIDDEN_SECRET_F			0x20000000L


#define	NSSSRemoveSecretID	NSSSRemoveSecret

/* ########################################################################### */
/* ###################### CURRENT CONTEXT VERSION ############################ */
/* ########################################################################### */
#define	NSSS_CUR_CTX_VERSION	0x00000001L


/* ########################################################################### */
/* ############################ CONTEXT FLAGS ################################ */
/* ########################################################################### */
/* context flags for the type of context passed in or to initialize (can only use one.) 
   =================================================================================== */
#define		NSSS_NCP_CTX_F					0x00000001L	//* Context is for NCP
#define		NSSS_LDAP_CTX_F					0x00000002L	//* Context is for LDAP
#define		NSSS_CONTEXT_INITIALIZED_F		0x00000004L	//* Context already initialized
#define		NSSS_INIT_LDAP_SS_HANDLE_F		0x00000008L	//* Init handle struct without bind
#define		NSSS_DEINIT_LDAP_SS_HANDLE_F	0x00000010L	//* Deinit handle struct without unbind
#define		NSSS_REINIT_TARGET_DN_F			0x00000020L	//* Reinit the target DN in the context
#define		NSSS_LDAP_CONTEXT_LESS_DN_F		0x00000040L	//* Resolve LDAP DN as contextless
#define		NSSS_ADV_BIND_INFO_F			0x00000080L	//* Use advanced bind structure
															//* and perform service location 


/* ########################################################################### */
/* ################# CURRENT ADVANCED BIND INFO VERSION ###################### */
/* ########################################################################### */
#define	NSSS_CUR_ADV_BIND_INFO_VER	0x00000000L

/* ########################################################################### */
/* ########################## ADVANCED BIND INFO FLAGS ####################### */
/* ########################################################################### */
//* indicates that password struct is supplied for credential to bind
#define	NSSS_PWORD_CRED_F			0x00000001L
												   
//* this flags allows the caller to override the default anonymous port 389 for 
//* service location and contextless name resolution in advance bind
#define	NSSS_SET_ANON_PORT_F		0x00000002L 



/* ########################################################################### */
/* ########################### STRUCTURE DEFINITIONS ######################### */
/* ########################################################################### */

//********************************* NOTE ****************************************
//* All of the character arrays in the structures have the max length in bytes
//* but apps should pass in strings with the number of chars that is half the 
//* length of these char arrays. These arrays are double the size in length 
//* for unicode strings. (Reference the length in chars for each above.)
//********************************* NOTE ****************************************

//* Secret ID type
typedef	struct _ss_secret_id
{
	long				len;						//* max id len in bytes
	char				id[NSSS_MAX_SECRET_ID_LEN]; //* should be passed in # of chars
} SS_SECRET_ID_T;

//* Secret Data type 
typedef	struct	_ss_secret
{
	long				len;
	char				*data;
} SS_SECRET_T;


//* Service location information. Each API-specific extension structures point to a
//* SS_SERVER_INFO_T structure. 
typedef struct _ss_server_info
{
	char				treeName[NSSS_MAX_TREE_NAME_LEN];
	char				ssServerDN[NSSS_MAX_DN_LEN];
	char				ssServerIPAddr[NSSS_MAX_IP_ADDR_LEN];
	char				sssConfigDN[NSSS_MAX_DN_LEN];
} SS_SERVER_INFO_T;

//* new version big enough for unicode IP or DNS address
typedef struct _ss_userver_info
{
	char				treeName[NSSS_MAX_TREE_NAME_LEN];
	char				ssServerDN[NSSS_MAX_DN_LEN];
	char				ssServerIPAddr[NSSS_MAX_ADDR_LEN];
	char				sssConfigDN[NSSS_MAX_DN_LEN];
} SS_USERVER_INFO_T;

typedef struct _ss_advanced_credential
{
	unsigned long		len;
	void				*data;
} SS_ADV_CRED_T, SS_CERT_T;


typedef struct _ss_address
{
	long				len;
	char				addr[NSSS_MAX_ADDR_LEN];
} SS_ADDR_T;


typedef struct _ss_advanced_bind_info
{
	unsigned long		version;		//* ldap bind structure version
	unsigned long		flags;			//* ldap bind structure applicable flags
	unsigned long		portNum;
	SS_ADDR_T			hName;			//* ip address (DNS name) of a servrer in the tree								
	SS_CERT_T			cert;			//* server certificate obtained and used internally
	SS_ADV_CRED_T		*cred;			//* password (struct defined above), adv cred for future
} SS_ADV_BIND_INFO_T;


typedef struct _ss_ldap_bind_info
{
	unsigned long		portNum;								//* default: 636
	char				lHostName[ NSSS_MAX_DN_LEN ]; 		//* Ex: "nsd10.novell.com" or ip addr
	char				trustedRootCert[ NSSS_MAX_DN_LEN ]; 	//* default: "c:\TrustedRootCertificate.der"
	char				loginPword[ NSSS_MAX_LDAP_PWORD_LEN ];	//* LDAP login password (utf8)
} SS_LDAPBIND_INFO_T;

typedef struct _ss_obj_id
{
	long			len;
	char			id[NSSS_MAX_DN_LEN];
} SS_OBJECT_DN_T;


//* password structure
typedef	struct _ss_pword
{
	unsigned long		pwordLen;		//* enhanced protection len & pword to set
	char				pword[NSSS_MAX_EP_PWORD_LEN]; //* should be passed in # of chars
} SS_PWORD_T;


//* hint structure
typedef	struct _ss_hint
{
	unsigned long		hintLen;		//* enhanced protection len & pword to set
	char				hint[NSSS_MAX_MP_PWORD_HINT_LEN];	//* should be passed in # of chars
} SS_HINT_T;

//* Read extended optional data
typedef	struct	_sss_read_extension
{
	unsigned long		statFlags;		//* OUT - return flags on the secret
	unsigned long		crtStamp;		//* OUT - secret creation time stamp
	unsigned long		latStamp;		//* OUT - last accessed time stamp (optional)
	unsigned long		lmtStamp;		//* OUT - last modified time stamp
}	SSS_READEXT_T;

//* Get service info extended data 
typedef	struct	_sss_get_service_information_extension
{
	unsigned long			statusFlags;	//* OUT - return flags on the store
	unsigned long			secretCount;	//* OUT - number of the secrets in the store
	unsigned long			lockCount;		//* OUT - number of lock secrets
	unsigned long			enumBufLen;		//* OUT - secret ID enumeration buffer length
	unsigned long			hidSecCount;	//* OUT - count of hidden secrets
	unsigned long			clientVersion;	//* OUT - client version			
	unsigned long			serverVersion;	//* OUT - server version			
	unsigned long			serverCryptoStrength;	//* OUT - client crypto strength (Domestic/Export)	
	unsigned long			clientCryptoStrength;	//* OUT - client crypto strength (Domestic/Export)	
	unsigned long			unlockTStamp;	//* OUT - last admin unlock timestamp */
	unsigned long			admnDNLen;		//* OUT - last admin DN to unlock the store */
	char					admnDN[NSSS_MAX_DN_LEN];
	unsigned long			hintLen;		//* OUT - master password hint
	char					hint[NSSS_MAX_MP_PWORD_HINT_LEN];
}	SSS_GSINFOEXT_T;


/* ###################################################################################### */
/* #################### Extension Structure definitions for FUTURE ###################### */
/* ###################################################################################### */

//* optional extension structure
typedef	struct	_ss_extension
{
	unsigned long		clientVersion;	//* IN - client version should be passed in
	void				*extParms;		//* IN - extended optional data defined for future
}	SS_EXT_T;


#endif //* SSSHAR_H

typedef	struct	_sss_handles	SSS_HANDLES_T;

//* new context structure to be allocated by the caller
//* caller DN is an out parameter on NCP and can be an in parameter on LDAP
typedef	struct	_sss_context
{
	unsigned long		flags;			//* IN- context type indicator and 
										//* initialization flags
	unsigned long		dsCtx;			//* IN/OUT- ldap/ncp context
	unsigned long		version;		//* IN- context version indicator
	SS_SERVER_INFO_T	ssServerInfo;	//* IN/OUT- preferred SecretStore server info
	SS_OBJECT_DN_T		callerDN; 		//* IN/OUT- DN of the caller. OUT-For NCP.
										//*IN-For LDAP (use LDAP form)
	SSS_HANDLES_T		*handles;		//* OUT- internal, created by GetServiceInfo, 
										//* destroyed with the context
	void				*bindInfo;		//* IN - LDAP or other advanced bind info (non-NCP)
}	SSS_CONTEXT_T;



#ifndef _SSSHS_H_


#define SS_APPLICATION_TYPE_F		0x00000001L
#define SS_CREDENTIAL_TYPE_F		0x00000002L

typedef struct _ss_sh_secret_id
{
	int  	type;								// The shared secret type i.e. SS_App  or  SS_CredSet
	char 	pName[NSSS_MAX_SECRET_ID_LEN];		// The shared secret name. This is the same as the identifier 
	int  	len;								// except that it excludes the header and is not escaped.
} SS_SH_SECRET_ID_T;


/* ########################## FUNCTION PROTOTYPES ######################### */

/* ##################################################################### */
/* ######################### NEW NDK EXPORTED APIS ##################### */
/* ##################################################################### */

//**************************************************************
//* Support Functions for processing (populating or extracting) 
//* data components from a Shared Secret buffers
//**************************************************************
SS_EXTERN_LIBCALL_PTR(void)
NSSSCreateSHSHandle();

SS_EXTERN_LIBCALL(int)
NSSSDestroySHSHandle(void *handle);	// in 

SS_EXTERN_LIBCALL(int)
NSSSGetNextSHSEntry
	(
		int 			bRestart,	//* in (set to 1 to begin from head of list)
		void 			*handle,	//* in 
		int				*keyLen,	//* out
		unsigned char	*key,		//* out 
		int 			*valLen,	//* out
		unsigned char	*val,		//* out
		unsigned long	ssCtxFlags	//* int
	);

SS_EXTERN_LIBCALL(int)
NSSSAddSHSEntry
	(
		void 				*handle,	//* in
		unsigned char		*key,		//* in
		unsigned char		*val,		//* in
		unsigned long		ssCtxFlags	//* in
	);


SS_EXTERN_LIBCALL(int)
NSSSRemoveSHSEntry
	(
		void 			*handle,	//* in 
		unsigned char 	*key,		//* in
		unsigned char 	*value,		//* in
		unsigned long	ssCtxFlags	//* in
	);


//**************************************************************
//* These function calls will utilize the Support Functions for 
//* populating or extracting data from a Shared Secret.
//**************************************************************
SS_EXTERN_LIBCALL(int)
NSSSWriteSharedSecret
(
	void				*	handle,
	SS_SH_SECRET_ID_T	*	pSharedSecret,
	SSS_CONTEXT_T		*	context,
	SS_OBJECT_DN_T		*	targetObjDN,
	unsigned long			ssFlags,
	SS_PWORD_T			*	epPassword,
	SS_EXT_T	 		*	ext
);

SS_EXTERN_LIBCALL(int)
NSSSReadSharedSecret
(
	void				*	handle,
	SS_SH_SECRET_ID_T   *	pSharedSecret,
	SSS_CONTEXT_T		*	context,		
	SS_OBJECT_DN_T		*	targetObjDN, 
	unsigned long			ssFlags,
	SS_PWORD_T			*	epPassword,
	SSS_READEXT_T		*	readData,
	SS_EXT_T	 		*	ext
);

SS_EXTERN_LIBCALL(int)
NSSSRemoveSharedSecret
(
	SS_SH_SECRET_ID_T	*	pSharedSecret,
	SSS_CONTEXT_T		*	context,
	SS_OBJECT_DN_T		*	targetObjDN,
	unsigned long			ssFlags,
	SS_EXT_T	 		*	ext
);

#endif //*_SSSHS_H_

//***********************
//* SecretStore raw APIs
//***********************

SS_EXTERN_LIBCALL(int)
NSSSReadSecret
(
	SSS_CONTEXT_T		*		context,		
	SS_OBJECT_DN_T		*		targetObjDN, 
	unsigned long				ssFlags,
	SS_PWORD_T			*		epPassword,
	SSS_READEXT_T		*		readData,
	SS_SECRET_ID_T		*		secretID,
	SS_SECRET_T 	 	*		secretValue,
	SS_EXT_T	 		*		ext
);

SS_EXTERN_LIBCALL(int)
NSSSWriteSecret
(
	SSS_CONTEXT_T		*		context,		
	SS_OBJECT_DN_T		*		targetObjDN, 
	unsigned long				ssFlags,
	SS_PWORD_T			*		epPassword,
	SS_SECRET_ID_T		*		secretID,
	SS_SECRET_T 		*		secretValue,
	SS_EXT_T			*		ext
);

SS_EXTERN_LIBCALL(int)
NSSSRemoveSecret
(
	SSS_CONTEXT_T		*		context,		
	SS_OBJECT_DN_T		*		targetObjDN, 
	unsigned long				ssFlags,
  SS_SECRET_ID_T		*		secretID,
	SS_EXT_T			*		ext
);

SS_EXTERN_LIBCALL(int)
NSSSGetServiceInformation
(
	SSS_CONTEXT_T		*		context,		
	SS_OBJECT_DN_T		*		targetObjDN, 
	unsigned long				ssFlags,
	SSS_GSINFOEXT_T		*		gsData,
	SS_EXT_T			*		ext
);

SS_EXTERN_LIBCALL(int)
NSSSUnlockSecrets
(
	SSS_CONTEXT_T		*		context,		
	SS_OBJECT_DN_T		*		targetObjDN, 
	unsigned long				ssFlags,
  SS_PWORD_T	 		*		passowrd,
	SS_EXT_T			*		ext
);

SS_EXTERN_LIBCALL(int)
NSSSRemoveSecretStore
(
	SSS_CONTEXT_T		*		context,		
	SS_OBJECT_DN_T		*		targetObjDN, 
	unsigned long				ssFlags,
	SS_EXT_T			*		ext
);

SS_EXTERN_LIBCALL(int)
NSSSEnumerateSecretIDs
(
	SSS_CONTEXT_T		*		context,		
	SS_OBJECT_DN_T		*		targetObjDN, 
	unsigned long				ssFlags,
  char				*		searchString,
	unsigned long		*		count,
  SS_SECRET_T			*		secretIDList,
	SS_EXT_T			*		ext
);


SS_EXTERN_LIBCALL(int)
NSSSSetEPMasterPassword
(
	SSS_CONTEXT_T		*		context,		
	SS_OBJECT_DN_T		*		targetObjDN, 
	unsigned long				ssFlags,
  SS_PWORD_T	 		*		passowrd,
  SS_HINT_T	 		*		hint,
	SS_EXT_T			*		ext
);

/* ####################################################################### */
/* ############################## ERROR CODES ############################ */
/* ####################################################################### */

#ifndef _SSSHAR_H

#define		NSSS_SUCCESS					0x00000000		/*    0 */
#define		NSSS_E_OBJECT_NOT_FOUND			0xFFFFFCE0		/* -800 */
#define		NSSS_E_NICI_FAILURE				0xFFFFFCDF		/* -801 */
#define		NSSS_E_INVALID_SECRET_ID 		0xFFFFFCDE		/* -802 */
#define		NSSS_E_SYSTEM_FAILURE			0xFFFFFCDD		/* -803 */
#define		NSSS_E_ACCESS_DENIED  			0xFFFFFCDC		/* -804 */
#define		NSSS_E_NDS_INTERNAL_FAILURE		0xFFFFFCDB		/* -805 */
#define		NSSS_E_SECRET_UNINITIALIZED		0xFFFFFCDA		/* -806 */
#define		NSSS_E_BUFFER_LEN				0xFFFFFCD9		/* -807 */
#define		NSSS_E_INCOMPATIBLE_VERSION		0xFFFFFCD8		/* -808 */
#define		NSSS_E_CORRUPTED_STORE			0xFFFFFCD7		/* -809 */
#define		NSSS_E_SECRET_ID_EXISTS			0xFFFFFCD6		/* -810 */
#define		NSSS_E_NDS_PWORD_CHANGED		0xFFFFFCD5		/* -811 */
#define		NSSS_E_INVALID_TARGET_OBJECT	0xFFFFFCD4		/* -812 */
#define		NSSS_E_STORE_NOT_FOUND			0xFFFFFCD3		/* -813 */
#define		NSSS_E_SERVICE_NOT_FOUND		0xFFFFFCD2		/* -814 */
#define		NSSS_E_SECRET_ID_TOO_LONG		0xFFFFFCD1		/* -815 */
#define		NSSS_E_ENUM_BUFF_TOO_SHORT		0xFFFFFCD0		/* -816 */
#define		NSSS_E_NOT_AUTHENTICATED		0xFFFFFCCF		/* -817 */
#define		NSSS_E_NOT_SUPPORTED			0xFFFFFCCE		/* -818 */
#define		NSSS_E_NDS_PWORD_INVALID		0xFFFFFCCD		/* -819 */
#define		NSSS_E_NICI_OUTOF_SYNC			0xFFFFFCCC		/* -820 */
#define		NSSS_E_SERVICE_NOT_SUPPORTED	0xFFFFFCCB		/* -821 */
#define		NSSS_E_TOKEN_NOT_SUPPORTED		0xFFFFFCCA		/* -822 */
#define		NSSS_E_UNICODE_OP_FAILURE		0xFFFFFCC9		/* -823 */
#define		NSSS_E_TRANSPORT_FAILURE		0xFFFFFCC8		/* -824 */
#define		NSSS_E_CRYPTO_OP_FAILURE		0xFFFFFCC7		/* -825 */
#define		NSSS_E_SERVER_CONN_FAILURE		0xFFFFFCC6		/* -826 */
#define		NSSS_E_CONN_ACCESS_FAILURE		0xFFFFFCC5		/* -827 */
#define		NSSS_E_ENUM_BUFF_TOO_LONG		0xFFFFFCC4		/* -828 */
#define		NSSS_E_SECRET_BUFF_TOO_LONG		0xFFFFFCC3		/* -829 */
#define		NSSS_E_SECRET_ID_TOO_SHORT		0xFFFFFCC2		/* -830 */
#define		NSSS_E_CORRUPTED_PACKET_DATA	0xFFFFFCC1		/* -831 */
#define		NSSS_E_EP_ACCESS_DENIED			0xFFFFFCC0		/* -832 */
#define		NSSS_E_SCHEMA_NOT_EXTENDED		0xFFFFFCBF		/* -833 */
#define		NSSS_E_ATTR_NOT_FOUND			0xFFFFFCBE		/* -834 */
#define		NSSS_E_MIGRATION_NEEDED			0xFFFFFCBD		/* -835 */
#define		NSSS_E_MP_PWORD_INVALID			0xFFFFFCBC		/* -836 */
#define		NSSS_E_MP_PWORD_NOT_SET			0xFFFFFCBB		/* -837 */
#define		NSSS_E_MP_PWORD_NOT_ALLOWED		0xFFFFFCBA		/* -838 */
#define		NSSS_E_WRONG_REPLICA_TYPE		0xFFFFFCB9		/* -839 */
#define		NSSS_E_ATTR_VAL_NOT_FOUND		0xFFFFFCB8		/* -840 */
#define		NSSS_E_INVALID_PARAM			0xFFFFFCB7		/* -841 */
#define		NSSS_E_NEED_SECURE_CHANNEL		0xFFFFFCB6		/* -842 */
#define		NSSS_E_CONFIG_NOT_SUPPORTED		0xFFFFFCB5		/* -843 */
#define		NSSS_E_STORE_NOT_LOCKED			0xFFFFFCB4		/* -844 */
#define		NSSS_E_TIME_OUT_OF_SYNC			0xFFFFFCB3		/* -845 */
#define		NSSS_E_VERSION_MISMATCH			0xFFFFFCB2		/* -846 */
#define		NSSS_E_SECRET_BUFF_TOO_SHORT	0xFFFFFCB1		/* -847 */
#define	 	NSSS_E_SH_SECRET_FAILURE		0xFFFFFCB0		/* -848 */
#define  		NSSS_E_PARSER_FAILURE			0xFFFFFCAF		/* -849 */
#define  		NSSS_E_UTF8_OP_FAILURE			0xFFFFFCAE		/* -850 */
#define  		NSSS_E_CTX_LESS_CN_NOT_UNIQUE	0xFFFFFCAD		/* -851 */
#define  		NSSS_E_UNSUPPORTED_BIND_CRED	0xFFFFFCAC		/* -852 */
#define  		NSSS_E_CERTIFICATE_NOT_FOUND	0xFFFFFCAB		/* -853 */
					
#define		NSSS_E_NOT_IMPLEMENTED			0xFFFFFC88		/* -888 */
#define		NSSS_E_BETA_EXPIRED				0xFFFFFC7D		/* -899 */


/* #########################################################################
   ########################### ERROR DESCRIPTIONS ########################## 
   #########################################################################

NSSS_E_OBJECT_NOT_FOUND			-800 
	Description: Can't find the target object DN in NDS. (Resolve name failed.)

NSSS_E_NICI_FAILURE				-801
	Description: NICI operations have failed.

NSSS_E_INVALID_SECRET_ID			-802 
	Description: Secret ID is not in the User Secret Store.

NSSS_E_SYSTEM_FAILURE				-803 
	Description: Some internal operating system services have not been available.

NSSS_E_ACCESS_DENIED				-804 
	Description: Access to the target Secret Store has been denied!

NSSS_E_NDS_INTERNAL_FAILURE		-805 
	Description: Some internal NDS services have not been available.

NSSS_E_SECRET_UNINITIALIZED		-806 
	Description: Secret has not been initialized with a write.

NSSS_E_BUFFER_LEN					-807 
	Description: Size of the buffer is not in a nominal range between minimum and maximum.

NSSS_E_INCOMPATIBLE_VERSION		-808 
	Description: Client and server components are not of the compatible versions.

NSSS_E_CORRUPTED_STORE			-809 
	Description: Secret Store data on the server has been corrupted.

NSSS_E_SECRET_ID_EXISTS			-810 
	Description: Secret ID already exists in the Secret Store.

NSSS_E_NDS_PWORD_CHANGED			-811 
	Description: User NDS password has been changed by the administrator.

NSSS_E_INVALID_TARGET_OBJECT		-812 
	Description: Target NDS User object not found.

NSSS_E_STORE_NOT_FOUND			-813 
	Description: Target NDS User object does not have a Secret Store.

NSSS_E_SERVICE_NOT_FOUND			-814 
	Description: Secret Store not on the Network.	

NSSS_E_SECRET_ID_TOO_LONG			-815 
	Description: Lenght of the Secret ID buffer exceeds the limit.

NSSS_E_ENUM_BUFF_TOO_SHORT		-816 
	Description: Lenght of the Enumeration buffer too short.

NSSS_E_NOT_AUTHENTICATED			-817 
	Description: User not authenticated.

NSSS_E_NOT_SUPPORTED				-818 
	Description: Not supported operations.

NSSS_E_NDS_PWORD_INVALID			-819 
	Description: Typed in NDS password not valid.

NSSS_E_NICI_OUTOF_SYNC			-820 
	Description: Session keys of the client and server NICI are out of sync.

NSSS_E_SERVICE_NOT_SUPPORTED		-821 
	Description: Requested service not supported yet.

NSSS_E_TOKEN_NOT_SUPPORTED		-822 
	Description: NDS authentication type not supported.

NSSS_E_UNICODE_OP_FAILURE		 	-823 
	Description: Unicode text conversion operation failed.

NSSS_E_TRANSPORT_FAILURE		 	-824 
	Description: Connection to server is lost.

NSSS_E_CRYPTO_OP_FAILURE			-825 
	Description: Cryptographic operation failed.

NSSS_E_SERVER_CONN_FAILURE		 -826 
	Description: Opening a connection to the server failed.

NSSS_E_CONN_ACCESS_FAILURE		-827 
	Description: Access to server connection failed.

NSSS_E_ENUM_BUFF_TOO_LONG		 	-828 
	Description: Size of the enumeration buffer exceeds the limit.

NSSS_E_SECRET_BUFF_TOO_LONG		 -829 
	Description: Size of the Secret buffer exceeds the limit.

NSSS_E_SECRET_ID_TOO_SHORT		 -830
	Description: Lenght of the Secret ID should be greater than zero.

NSSS_E_CORRUPTED_PACKET_DATA		-831 
	Description: Protocol data corrupted on the wire.

NSSS_E_EP_ACCESS_DENIED			-832
	Description: EP password validation failed. Access to the secret denied!

NSSS_E_SCHEMA_NOT_EXTENDED		-833
	Description: Schema is not extended to support SecreStore on the target tree.
					
NSSS_E_ATTR_NOT_FOUND			 	-834 
	Description: One of the optional service attributes is not instantiated.

NSSS_E_MIGRATION_NEEDED			-835
	Description: Server has been upgraded and user SecretStore should be updated.

NSSS_E_MP_PWORD_INVALID			-836
	Description: Master passwrod could not be verified to read or unlock the secrets.

NSSS_E_MP_PWORD_NOT_SET			-837		
	Description: Master password has not been set on the SecretStore.

NSSS_E_MP_PWORD_NOT_ALLOWED		-838	
	Description: Ability to use master password has been disabled.

NSSS_E_WRONG_REPLICA_TYPE			-839 
	Description: Not a writeable replica of NDS.

NSSS_E_ATTR_VAL_NOT_FOUND			-840 
	Description: Target attrbute is not instantiated in NDS.

NSSS_E_INVALID_PARAM				-841 
	Description: API parameter is not initialized.

NSSS_E_NEED_SECURE_CHANNEL		-842 
	Description: Connection to the SecretStore needs to be over SSL.

NSSS_E_CONFIG_NOT_SUPPORTED		-843
	Description: No server to support the given override configuration is found.

NSSS_E_STORE_NOT_LOCKED			-844
	Description: Attempt to unlock SecretStore failed because the store is not locked.

NSSS_E_TIME_OUT_OF_SYNC			-845
	Description: NDS Replica on the server that holds SecretStore is out of sync with the replica ring.

NSSS_E_VERSION_MISMATCH		    -846
	Description: Versions of the client dlls don't match.

NSSS_E_SECRET_BUFF_TOO_SHORT		-847 
	Description: Buffer supplied for the secret is too short (minimum NSSS_MIN_IDLIST_BUF_LEN).

NSSS_E_SH_SECRET_FAILURE			-848
	Description: Shared Secret processing and operations failed.

NSSS_E_PARSER_FAILURE				-849
	Description: Shared Secret parser operations failed.

NSSS_E_UTF8_OP_FAILURE			-850
	Description: Utf8 string operations failed.

NSSS_E_CTX_LESS_CN_NOT_UNIQUE		-851
	Description: Contextless name for LDAP bind does not resolve to a unique DN

NSSS_E_UNSUPPORTED_BIND_CRED		-852 
	Description: login credential for advanced bind is not supported

NSSS_E_CERTIFICATE_NOT_FOUND		-853
	Description: LDAP Root Cert required for Bind operations not found


NSSS_E_NOT_IMPLEMENTED			-888
	Description: Feature not implemented yet.

NSSS_E_BETA_EXPIRED				-899
	Description: Product's BETA life has expired! Official release copy should be
		purchased.



   ########################### END OFERROR CODES ########################## */


/* ######################################################################## */
/* #################### TRANSLATION MACROS FOR OLD NAMES ################## */
/* ######################################################################## */

#define		NSSO_SUCCESS							NSSS_SUCCESS					
#define		NSSO_E_OBJECT_NOT_FOUND					NSSS_E_OBJECT_NOT_FOUND			
#define		NSSO_E_NICI_FAILURE						NSSS_E_NICI_FAILURE				
#define		NSSO_E_INVALID_SECRET_ID 				NSSS_E_INVALID_SECRET_ID 		
#define		NSSO_E_SYSTEM_FAILURE					NSSS_E_SYSTEM_FAILURE			
#define		NSSO_E_ACCESS_DENIED  					NSSS_E_ACCESS_DENIED  			
#define		NSSO_E_NDS_INTERNAL_FAILURE				NSSS_E_NDS_INTERNAL_FAILURE		
#define		NSSO_E_SECRET_UNINITIALIZED				NSSS_E_SECRET_UNINITIALIZED		
#define		NSSO_E_BUFFER_LEN						NSSS_E_BUFFER_LEN				
#define		NSSO_E_INCOMPATIBLE_VERSION				NSSS_E_INCOMPATIBLE_VERSION		
#define		NSSO_E_CORRUPTED_STORE					NSSS_E_CORRUPTED_STORE			
#define		NSSO_E_SECRET_ID_EXISTS					NSSS_E_SECRET_ID_EXISTS			
#define		NSSO_E_NDS_PWORD_CHANGED				NSSS_E_NDS_PWORD_CHANGED		
#define		NSSO_E_INVALID_TARGET_OBJECT			NSSS_E_INVALID_TARGET_OBJECT	
#define		NSSO_E_STORE_NOT_FOUND					NSSS_E_STORE_NOT_FOUND			
#define		NSSO_E_SERVICE_NOT_FOUND				NSSS_E_SERVICE_NOT_FOUND		
#define		NSSO_E_SECRET_ID_TOO_LONG				NSSS_E_SECRET_ID_TOO_LONG		
#define		NSSO_E_ENUM_BUFF_TOO_SHORT				NSSS_E_ENUM_BUFF_TOO_SHORT		
#define		NSSO_E_NOT_AUTHENTICATED				NSSS_E_NOT_AUTHENTICATED		
#define		NSSO_E_NOT_SUPPORTED					NSSS_E_NOT_SUPPORTED			
#define		NSSO_E_NDS_PWORD_INVALID				NSSS_E_NDS_PWORD_INVALID		
#define		NSSO_E_NICI_OUTOF_SYNC					NSSS_E_NICI_OUTOF_SYNC			
#define		NSSO_E_SERVICE_NOT_SUPPORTED			NSSS_E_SERVICE_NOT_SUPPORTED	
#define		NSSO_E_TOKEN_NOT_SUPPORTED				NSSS_E_TOKEN_NOT_SUPPORTED		
#define		NSSO_E_UNICODE_OP_FAILURE				NSSS_E_UNICODE_OP_FAILURE		
#define		NSSO_E_TRANSPORT_FAILURE				NSSS_E_TRANSPORT_FAILURE		
#define		NSSO_E_CRYPTO_OP_FAILURE				NSSS_E_CRYPTO_OP_FAILURE		
#define		NSSO_E_SERVER_CONN_FAILURE				NSSS_E_SERVER_CONN_FAILURE		
#define		NSSO_E_CONN_ACCESS_FAILURE				NSSS_E_CONN_ACCESS_FAILURE		
#define		NSSO_E_ENUM_BUFF_TOO_LONG				NSSS_E_ENUM_BUFF_TOO_LONG		
#define		NSSO_E_SECRET_BUFF_TOO_LONG				NSSS_E_SECRET_BUFF_TOO_LONG		
#define		NSSO_E_SECRET_ID_TOO_SHORT				NSSS_E_SECRET_ID_TOO_SHORT		
#define		NSSO_E_CORRUPTED_PACKET_DATA			NSSS_E_CORRUPTED_PACKET_DATA	
#define		NSSO_E_EP_ACCESS_DENIED					NSSS_E_EP_ACCESS_DENIED			
#define		NSSO_E_SCHEMA_NOT_EXTENDED				NSSS_E_SCHEMA_NOT_EXTENDED		
#define		NSSO_E_ATTR_NOT_FOUND					NSSS_E_ATTR_NOT_FOUND			
#define		NSSO_E_MIGRATION_NEEDED					NSSS_E_MIGRATION_NEEDED			
#define		NSSO_E_MP_PWORD_INVALID					NSSS_E_MP_PWORD_INVALID			
#define		NSSO_E_MP_PWORD_NOT_SET					NSSS_E_MP_PWORD_NOT_SET			
#define		NSSO_E_MP_PWORD_NOT_ALLOWED				NSSS_E_MP_PWORD_NOT_ALLOWED		
#define		NSSO_E_WRONG_REPLICA_TYPE				NSSS_E_WRONG_REPLICA_TYPE		
#define		NSSO_E_ATTR_VAL_NOT_FOUND				NSSS_E_ATTR_VAL_NOT_FOUND		
#define		NSSO_E_INVALID_PARAM					NSSS_E_INVALID_PARAM			
#define		NSSO_E_NEED_SECURE_CHANNEL				NSSS_E_NEED_SECURE_CHANNEL		
#define		NSSO_E_CONFIG_NOT_SUPPORTED				NSSS_E_CONFIG_NOT_SUPPORTED		
#define		NSSO_E_STORE_NOT_LOCKED					NSSS_E_STORE_NOT_LOCKED
#define		NSSO_E_TIME_OUT_OF_SYNC					NSSS_E_TIME_OUT_OF_SYNC

#define		NSSO_E_NOT_IMPLEMENTED					NSSS_E_NOT_IMPLEMENTED			
#define		NSSO_E_BETA_EXPIRED						NSSS_E_BETA_EXPIRED				

#define		NSSO_NICI_UNDETERMINED_ENGINE			NSSS_NICI_UNDETERMINED_ENGINE
#define		NSSO_NICI_DOMESTIC_ENGINE	 			NSSS_NICI_DOMESTIC_ENGINE	 
#define		NSSO_NICI_EXPORT_ENGINE		 			NSSS_NICI_EXPORT_ENGINE		 

#endif /* _NSSS_H */


#define 		NSSO_VERSION_NUMBER			 	 		NSSS_VERSION_NUMBER			 
#define		NSSO_MAX_SECRET_ID_CHARS				NSSS_MAX_SECRET_ID_CHARS	 	 
#define		NSSO_MAX_SECRET_ID_LEN		 			NSSS_MAX_SECRET_ID_LEN		 
#define		NSSO_MID_SECRET_BUF_LEN		 			NSSS_MID_SECRET_BUF_LEN		 
#define		NSSO_MAX_SECRET_BUF_LEN		 			NSSS_MAX_SECRET_BUF_LEN		 
#define		NSSO_MAX_EP_PWORD_CHARS		 			NSSS_MAX_EP_PWORD_CHARS		 
#define		NSSO_MAX_EP_PWORD_LEN		 			NSSS_MAX_EP_PWORD_LEN		 
#define		NSSO_MAX_LDAP_PWORD_LEN		 			NSSS_MAX_LDAP_PWORD_LEN		 
#define		NSSO_MAX_MP_PWORD_HINT_CHARS 			NSSS_MAX_MP_PWORD_HINT_CHARS 
#define		NSSO_MAX_MP_PWORD_HINT_LEN	 			NSSS_MAX_MP_PWORD_HINT_LEN	 
#define		NSSO_MAX_TREE_NAME_CHARS	 			NSSS_MAX_TREE_NAME_CHARS	 
#define		NSSO_MAX_TREE_NAME_LEN		 			NSSS_MAX_TREE_NAME_LEN		 
#define		NSSO_MAX_DN_CHARS			 			NSSS_MAX_DN_CHARS			 
#define		NSSO_MAX_DN_LEN				 			NSSS_MAX_DN_LEN				 
#define		NSSO_MAX_IP_ADDR_LEN		 			NSSS_MAX_IP_ADDR_LEN		 
#define		NSSO_MIN_IDLIST_BUF_LEN		 			NSSS_MIN_IDLIST_BUF_LEN		 
#define		NSSO_MID_IDLIST_BUF_LEN		 			NSSS_MID_IDLIST_BUF_LEN		 
#define		NSSO_MAX_IDLIST_BUF_LEN		 			NSSS_MAX_IDLIST_BUF_LEN		 
#define		NSSO_JUMBO_IDLIST_BUF_LEN	 			NSSS_JUMBO_IDLIST_BUF_LEN	 
#define		NSSO_JUMBO_ENUM_BUF_LEN		 			NSSS_JUMBO_ENUM_BUF_LEN		 
#define		NSSO_ENUM_BUFFER_GUESS		 			NSSS_ENUM_BUFFER_GUESS		 
#define		NSSO_ENUM_DELIM				 			NSSS_ENUM_DELIM				 

#define		NSSO_REMOVE_LOCK_FROM_STORE_F			NSSS_REMOVE_LOCK_FROM_STORE_F		
#define		NSSO_ENHANCED_PROTECTION_F				NSSS_ENHANCED_PROTECTION_F		
#define		NSSO_CREATE_ID_F						NSSS_CREATE_ID_F				
#define		NSSO_EP_PASSWORD_USED_F					NSSS_EP_PASSWORD_USED_F			
#define		NSSO_REPAIR_THE_STORE_F					NSSS_REPAIR_THE_STORE_F			
#define		NSSO_ALL_STRINGS_UNICODE_F				NSSS_ALL_STRINGS_UNICODE_F		
#define		NSSO_SET_TREE_NAME_F					NSSS_SET_TREE_NAME_F			
#define		NSSO_DESTROY_CONTEXT_F					NSSS_DESTROY_CONTEXT_F			
#define		NSSO_UNBINDLDAP_F						NSSS_UNBINDLDAP_F				
#define		NSSO_GET_CONTEXT_F						NSSS_GET_CONTEXT_F				
#define		NSSO_BINDLDAP_F							NSSS_BINDLDAP_F					
#define		NSSO_SECRET_LOCKED_F					NSSS_SECRET_LOCKED_F			
#define		NSSO_SECRET_NOT_INITIALIZED_F			NSSS_SECRET_NOT_INITIALIZED_F	
#define		NSSO_ENHANCED_PROTECT_INFO_F			NSSS_ENHANCED_PROTECT_INFO_F	
#define		NSSO_STORE_NOT_SYNCED_F					NSSS_STORE_NOT_SYNCED_F			
#define		NSSO_EP_PWORD_PRESENT_F					NSSS_EP_PWORD_PRESENT_F			
#define		NSSO_EP_MASTER_PWORD_USED_F				NSSS_EP_MASTER_PWORD_USED_F		
#define		NSSO_ADMIN_LAST_MOD_F					NSSS_ADMIN_LAST_MOD_F			
#define		NSSO_EP_MASTER_PWORD_PRESENT_F			NSSS_EP_MASTER_PWORD_PRESENT_F
#define		NSSO_MP_NOT_ALLOWED_F					NSSS_MP_NOT_ALLOWED_F			
#define 		NSSO_SYNC_IN_PROGRESS_F					NSSS_SYNC_IN_PROGRESS_F			
#define 		NSSO_ADMIN_UNLOCKED_F					NSSS_ADMIN_UNLOCKED_F			
#define		NSSO_DS_CTX_F							NSSS_NCP_CTX_F					
#define		NSSO_LDAP_CTX_F							NSSS_LDAP_CTX_F					
#define		NSSO_NICI_CTX_F							NSSS_NICI_CTX_F					

#define		NSSO_ReadSecret							NSSS_ReadSecret
#define		NSSO_WriteSecret						NSSS_WriteSecret
#define		NSSO_AddSecretID						NSSS_AddSecretID
#define		NSSO_RemoveSecretID						NSSS_RemoveSecret
#define		NSSO_GetServiceInformation				NSSS_GetServiceInformation
#define		NSSO_UnlockSecrets						NSSS_UnlockSecrets
#define		NSSO_RemoveSecretStore					NSSS_RemoveSecretStore
#define		NSSO_EnumerateSecretIDs					NSSS_EnumerateSecretIDs
#define		NSSO_SetEPMasterPassword				NSSS_SetEPMasterPassword


#if defined(__cplusplus) || defined(c_plusplus)
}
#endif

#endif /* _NSSSCL_H */
