--
-- SecretStore Services (SSS) Schema Definitions
--
-- Novell Inc.
-- 1800 South Novell Place
-- Provo, UT 84606-6194
--
-- VeRsIoN=MAC 2.12
-- CoPyRiGhT=(c) Copyright 1997-2001, Novell, Inc.  All rights reserved
--
-- Object ID (OID) sub-arc is registered with Internal Schema Registration
-- as of 09-11-2001.
--
-- OIDs Defined as Follows:
--    joint-iso-ccitt (2)
--      country (16)
--        us (840)
--          organization (1)
--            Novell (113719)
--              applications (1)
--                SSS (266)
--                  SSS Attribute Types (4)
--                    specific attribute definitions
--                  SSS Attribute Syntaxes (5)
--                    specific syntax definitions
--                  SSS Object Classes (6)
--                    specific class definitions
--
--
sssSchemaExtentions {2 16 840 1 113719 1 266} DEFINITIONS ::=
BEGIN
--
---------------------------------------------------------------------------
--
-- SecretStore Attributes
--
--    Note: Reserving OIDs ...266 4 1 1-3 for upcoming attribute renaming
--          (specifically, for "SAS:" attributes).
--   
---------------------------------------------------------------------------
--   
--
-- Private SecretStore Attributes
--    The SecretStore is implemented as hidden attributes on the user
--    object and behaves as a multi-valued attribute with labels per
--    entry.  It is accessible only through the SecretStore Service
--    running on an NDS server on authenticated connections.  Only the
--    user can read secrets within SecretStore. Enhanced protection
--    provides non-repudiation by locking the store upon administrative
--    password change event.  In the future, these three attributes will
--    be renamed and renumbered to fit into the new sub-arc (266).
--   
-- SAS:SecretStore (... 39 4 1 3)
--    SecretStore attribute for user and service objects.  Not for
--    instantiation; used for ACL checking of SecretStore.
--
"SAS:SecretStore" ATTRIBUTE ::=
{
  Operation  ADD,
  SyntaxID   SYN_BOOLEAN,
  Flags      {DS_SINGLE_VALUED_ATTR, DS_SYNC_IMMEDIATE},
  ASN1ObjID  {2 16 840 1 113719 1 39 4 1 3}
}

--
-- SAS:SecretStoreKey (... 39 4 1 4)
--    SecretStore key attribute for user and service objects.
--
"SAS:SecretStoreKey" ATTRIBUTE ::=
{
  Operation  ADD,
  SyntaxID   SYN_OCTET_STRING,
  Flags      {DS_HIDDEN_ATTR, DS_SINGLE_VALUED_ATTR, DS_SYNC_IMMEDIATE},
  ASN1ObjID  {2 16 840 1 113719 1 39 4 1 4}
}

--
-- SAS:SecretStoreData (... 39 4 1 5)
--    SecretStore data attribute for user and service objects.
--
"SAS:SecretStoreData" ATTRIBUTE ::=
{
  Operation  ADD,
  SyntaxID   SYN_OCTET_STRING,
  Flags      {DS_HIDDEN_ATTR, DS_SYNC_IMMEDIATE},
  ASN1ObjID  {2 16 840 1 113719 1 39 4 1 5}
}

--
-- Proxy SecretStore Attributes
--    The Proxy SecretStore is accessible to any application with ACL rights
--    to the user's sssProxyStore attributes. User-sensitive data should not
--    be written to the Proxy SecretStore unless the Enhanced Protection
--    Application Password option is used.
--
-- sssProxyStoreKey (... 266 4 4)
--    SecretStore key attribute for user/service objects' proxy store.
--
"sssProxyStoreKey" ATTRIBUTE ::=
{
  Operation  ADD,
  SyntaxID   SYN_OCTET_STRING,
  Flags      {DS_HIDDEN_ATTR, DS_SINGLE_VALUED_ATTR, DS_SYNC_IMMEDIATE},
  ASN1ObjID  {2 16 840 1 113719 1 266 4 4}
}

--
-- sssProxyStoreSecrets (... 266 4 5)
--    SecretStore data attribute for user/service objects' proxy store.
--
"sssProxyStoreSecrets" ATTRIBUTE ::=
{
  Operation  ADD,
  SyntaxID   SYN_OCTET_STRING,
  Flags      {DS_HIDDEN_ATTR, DS_SYNC_IMMEDIATE},
  ASN1ObjID  {2 16 840 1 113719 1 266 4 5}
}

--
-- sssActiveServerList (... 266 4 6)
--    Storage for a list of SecretStore servers that service objects in a
--    R/W partition.  This attribute will exist only on objects that act
--    as a partition root, and will be dynamically updated by SecretStore
--    servers as they boot up and shut down.  The contents are in a data
--    format defined by SecretStore.
--
"sssActiveServerList" ATTRIBUTE ::=
{
  Operation     ADD,
  SyntaxID      SYN_OCTET_STRING,
  Flags         {DS_SYNC_IMMEDIATE},
  ASN1ObjID     {2 16 840 1 113719 1 266 4 6}
}

--
-- SecretStore Server Policy Attributes
--    The following 7 attributes allow configuration of the SecretStore
--    servers within a tree, and are found on the SecretStore server policy
--    container (sssServerPolicies) as well as on all policy override
--    objects (sssServerPolicyOverride).
--
-- sssCacheRefreshInterval (... 266 4 7)
--    SecretStore service configuration variable; specifies the number of
--    minutes between the server's cache refresh process.  The default
--    value is 10 minutes.
--
"sssCacheRefreshInterval"  ATTRIBUTE ::=
{
  Operation     ADD,
  SyntaxID      SYN_INTEGER,
  Flags         {DS_SINGLE_VALUED_ATTR, DS_SYNC_IMMEDIATE},
  ASN1ObjID     {2 16 840 1 113719 1 266 4 7}
}

--
-- sssAdminList  (... 266 4 8)
--    Storage for a list of SecretStore administrators that can unlock
--    SecretStore for other users.  All administrators in this list must
--    have authentication at the level defined by sssAdminGALabel or
--    higher.  The content of this attribute is a distinguished name.
--
"sssAdminList" ATTRIBUTE ::=
{
  Operation     ADD,
  SyntaxID      SYN_DIST_NAME,
  Flags         {DS_SYNC_IMMEDIATE},
  ASN1ObjID     {2 16 840 1 113719 1 266 4 8}
}

--
-- sssAdminGALabel (... 266 4 9)
--    Storage for a single GA Label to be applied to all SS administrators
--    in a given configuration.  Any SecretStore administrator accessing
--    another user's SecretStore must be authenticated at the level
--    defined by this label, or higher.  The contents are in a data format
--    defined by NMAS (currently a string).
--
"sssAdminGALabel" ATTRIBUTE ::=
{
  Operation     ADD,
  SyntaxID      SYN_OCTET_STRING,
  Flags         {DS_SINGLE_VALUED_ATTR, DS_SYNC_IMMEDIATE},
  ASN1ObjID     {2 16 840 1 113719 1 266 4 9}
}

--
-- sssEnableReadTimestamps (... 266 4 10)
--    SecretStore service configuration variable; specifies whether or not
--    the server will return timestamps when secrets are read.  Default
--    value is false (timestamps not returned).
--
"sssEnableReadTimestamps"  ATTRIBUTE ::=
{
  Operation     ADD,
  SyntaxID      SYN_BOOLEAN,
  Flags         {DS_SINGLE_VALUED_ATTR, DS_SYNC_IMMEDIATE},
  ASN1ObjID     {2 16 840 1 113719 1 266 4 10}
}

--
-- sssDisableMasterPasswords (... 266 4 11)
--    SecretStore service configuration variable; specifies whether or not
--    the server will allow access to secrets via use of the master
--    password feature.  Default value is false (master passwords used).
--
"sssDisableMasterPasswords"  ATTRIBUTE ::=
{
  Operation     ADD,
  SyntaxID      SYN_BOOLEAN,
  Flags         {DS_SINGLE_VALUED_ATTR, DS_SYNC_IMMEDIATE},
  ASN1ObjID     {2 16 840 1 113719 1 266 4 11}
}

--
-- sssEnableAdminAccess (... 266 4 12)
--    SecretStore service configuration variable; specifies whether or not
--    the server will allow use of SecretStore administrator features.  The
--    default value is false (SS administrators not allowed).
--
"sssEnableAdminAccess"  ATTRIBUTE ::=
{
  Operation     ADD,
  SyntaxID      SYN_BOOLEAN,
  Flags         {DS_SINGLE_VALUED_ATTR, DS_SYNC_IMMEDIATE},
  ASN1ObjID     {2 16 840 1 113719 1 266 4 12}
}

--
-- sssReadSecretPolicies (... 266 4 13)
--    Storage for list a of SecretID prefixes and associated policy
--    information.  Initially, this will associate GA labels with SecretIDs
--    so that policies can be applied during ReadSecret calls to ensure
--    proper authentication before allowing access to data.
--
"sssReadSecretPolicies" ATTRIBUTE ::=
{
  Operation     ADD,
  SyntaxID      SYN_OCTET_STRING,
  Flags         {DS_SYNC_IMMEDIATE},
  ASN1ObjID     {2 16 840 1 113719 1 266 4 13}
}

--
-- sssServerPolicyOverrideDN (... 266 4 14)
--    Points to an sssServerPolicyOverride object.  On users and
--    containers, this overrides the default search behavior when locating
--    configuration data.
--
"sssServerPolicyOverrideDN" ATTRIBUTE ::=
{
  Operation     ADD,
  SyntaxID      SYN_DIST_NAME,
  Flags         {DS_SINGLE_VALUED_ATTR, DS_SYNC_IMMEDIATE},
  ASN1ObjID     {2 16 840 1 113719 1 266 4 14}
}

--
---------------------------------------------------------------------------
--
-- SecretStore Classes
--
---------------------------------------------------------------------------
--
-- sssServerPolicies (... 266 6 1)
--    The SecretStore policy container.  It is used to hold default server
--    configuration data.
--
"sssServerPolicies" OBJECT-CLASS ::=
{
  Operation     ADD,
  Flags         {DS_CONTAINER_CLASS, DS_EFFECTIVE_CLASS},
  SubClassOf    {"Top"},
  ContainedBy   {"SAS:Security"},
  NamedBy       {"CN"},
  MustContain   {"CN"},
  MayContain    {"sssCacheRefreshInterval",
                 "sssEnableReadTimestamps",
                 "sssDisableMasterPasswords",
                 "sssEnableAdminAccess",
                 "sssAdminList",
                 "sssAdminGALabel",
                 "sssReadSecretPolicies" },
  ASN1ObjID     {2 16 840 1 113719 1 266 6 1}
}

--
-- sssServerPolicyOverride (... 266 6 2)
--    SecretStore policy override object.  This holds server configuration
--    data specific to a given container and its subordinates, thus
--    overriding the default configuration settings.
--
"sssServerPolicyOverride" OBJECT-CLASS ::=
{
  Operation     ADD,
  Flags         {DS_EFFECTIVE_CLASS},
  SubClassOf    {"Top"},
  ContainedBy   {"sssServerPolicies",
                 "Organization",
                 "Organizational Unit",
                 "Country",
                 "Locality",
                 "domain" },
  NamedBy       {"CN"},
  MustContain   {"CN"},
  MayContain    {"sssCacheRefreshInterval",
                 "sssEnableReadTimestamps",
                 "sssDisableMasterPasswords",
                 "sssEnableAdminAccess",
                 "sssAdminList",
                 "sssAdminGALabel",
                 "sssReadSecretPolicies" },
  ASN1ObjID     {2 16 840 1 113719 1 266 6 2}
}

---------------------------------------------------------------------------
--
-- Modifications To Existing Classes
--
---------------------------------------------------------------------------
--
"User" OBJECT-CLASS ::=
{
   Operation    MODIFY,
   MayContain   {"SAS:SecretStore",
                 "SAS:SecretStoreData",
                 "SAS:SecretStoreKey",
                 "sssProxyStoreKey",
                 "sssProxyStoreSecrets",
                 "sssServerPolicyOverrideDN"}
}

"Tree Root" OBJECT-CLASS ::=
{
   Operation    MODIFY,
   MayContain   {"sssActiveServerList"}
}

"Organization" OBJECT-CLASS ::=
{
   Operation    MODIFY,
   MayContain   {"sssActiveServerList",
--                 "sssServerPolicyOverride",
                 "sssServerPolicyOverrideDN"}
}

"Organizational Unit" OBJECT-CLASS ::=
{
   Operation    MODIFY,
   MayContain   {"sssActiveServerList",
--                 "sssServerPolicyOverride",
                 "sssServerPolicyOverrideDN"}
}

"domain" OBJECT-CLASS ::=
{
   Operation    MODIFY,
   MayContain   {"sssActiveServerList",
--                 "sssServerPolicyOverride",
                 "sssServerPolicyOverrideDN"}
}

"Country" OBJECT-CLASS ::=
{
   Operation    MODIFY,
   MayContain   {"sssActiveServerList",
--                 "sssServerPolicyOverride",
                 "sssServerPolicyOverrideDN"}
}

"Locality" OBJECT-CLASS ::=
{
   Operation    MODIFY,
   MayContain   {"sssActiveServerList",
--                 "sssServerPolicyOverride",
                 "sssServerPolicyOverrideDN"}
}

END
