/**************************************************************************
* %name:         ssshs.h %
* %instance:     security_1 %
* %version:      7 %
* %created_by:	bkinser %
* %date_modified: Fri Nov 15 12:35:35 2002 %
***************************************************************************
* Unpublished Copyright (c) 2000-2003, Novell, Inc. All rights reserved.
*
* This work is subject to U.S. and international copyright laws and
* treaties.  Use and redistribution of this work is subject to the license
* agreement accompanying the software development kit (SDK) that contains
* this work.  Pursuant to the SDK license agreement, Novell hereby grants
* to developer a royalty-free, non-exclusive license to include Novell's
* sample code in its product.  Novell grants developer worldwide
* distribution rights to market, distribute, or sell Novell's sample code
* as a component of developer's products.  Novell shall have no obligations
* to developer or developer's customers with respect to this code.
***************************************************************************
* Description: The code in this module implements the internal SharedSecret
* client API for SercretStore v3.10.
**************************************************************************/

#ifndef _SSSHS_H_
#define _SSSHS_H_

#if defined(__cplusplus) || defined(c_plusplus)
extern "C" 
{
#endif

#if defined(WIN32) || defined(N_PLAT_CLIENT)
	#ifndef SHS_UNICODE
		#define	SHS_UNICODE
		//** Windows specific includes.
		#include <windows.h>
		#include <string.h>
		#include <tchar.h>
		#define	unicode 		wchar_t
		#define	unistr			wcsstr
		#define	unitok			wcstok
		#define	unilen			wcslen
		#define	unicpy			wcscpy
		#define unisize(s)		((wcslen((s))+1)*sizeof(wchar_t))
		#define	unitol			_wtol
		#define	unicmp			wcscmp
		#define	unicat			wcscat
	#endif

#elif defined(N_PLAT_NLM)

	//** NetWare NLM specific includes.
	#include <stdio.h>
	#include <stdlib.h>
	#include <unicode.h>

#elif defined(UNIX)

	//** Unix specific includes.
#include "dtypes.h"
#undef LO_HI_MACH_TYPE
#undef STRICT_ALIGNMENT
#include "portable.h"
#include "ssunicode.h"

#endif

#include "nssscl.h"


#ifndef SS_UNICODE_INFO
#define SS_UNICODE_INFO

#define SS_APPLICATION_TYPE_F		0x00000001L
#define SS_CREDENTIAL_TYPE_F		0x00000002L

#define SS_UTF8_CONVERSION_LEN	128

#endif //* SS_UNICODE_INFO


typedef struct _ss_sh_secret_id
{
	int  	type;								// The shared secret type i.e. SS_App  or  SS_CredSet
	char 	pName[NSSS_MAX_SECRET_ID_LEN];		// The shared secret name. This is the same as the identifier 
	int  	len;								// except that it excludes the header and is not escaped.

} SS_SH_SECRET_ID_T;


	//* The following functions will be exposed as exported API:

	//**************************************************************
	//* These function calls will utilize the Support Functions for 
	//* populating or extracting data from a Shared Secret.
	//**************************************************************
SS_EXTERN_LIBCALL(int)
NSSSWriteSharedSecret
	(
		void				*	handle,
		SS_SH_SECRET_ID_T	*	pSharedSecret,
		SSS_CONTEXT_T		*	context,
		SS_OBJECT_DN_T		*	targetObjDN,
		unsigned long			ssFlags,
		SS_PWORD_T			*	epPassword,
		SS_EXT_T	 		*	ext
	);

SS_EXTERN_LIBCALL(int)
NSSSReadSharedSecret
	(
		void				*	handle,
		SS_SH_SECRET_ID_T   *	pSharedSecret,
		SSS_CONTEXT_T		*	context,		
		SS_OBJECT_DN_T		*	targetObjDN, 
		unsigned long			ssFlags,
		SS_PWORD_T			*	epPassword,
		SSS_READEXT_T		*	readData,
		SS_EXT_T	 		*	ext
	);

SS_EXTERN_LIBCALL(int)
NSSSRemoveSharedSecret
	(
		SS_SH_SECRET_ID_T	*	pSharedSecret,
		SSS_CONTEXT_T		*	context,
		SS_OBJECT_DN_T		*	targetObjDN,
		unsigned long			ssFlags,
		SS_EXT_T	 		*	ext
	);


	//**************************************************************
//* Support Functions for processing (populating or extracting) 
//* data components from a Shared Secret
//**************************************************************
SS_EXTERN_LIBCALL_PTR(void)
NSSSCreateSHSHandle();

SS_EXTERN_LIBCALL(int)
NSSSDestroySHSHandle(void *handle);	// in 


SS_EXTERN_LIBCALL(int)
NSSSGetNextSHSEntry
	(
		int 			bRestart,	//* in (set to 1 to begin from head of list)
		void 			*handle,	//* in 
		int				*keyLen,	//* out
		unsigned char	*key,		//* out 
		int 			*valLen,	//* out
		unsigned char	*val,		//* out
		unsigned long	ssCtxFlags	//* int
	);

SS_EXTERN_LIBCALL(int)
NSSSAddSHSEntry
	(
		void 				*handle,	//* in
		unsigned char		*key,		//* in
		unsigned char		*val,		//* in
		unsigned long		ssCtxFlags	//* in
	);


SS_EXTERN_LIBCALL(int)
NSSSRemoveSHSEntry
	(
		void 			*handle,	//* in 
		unsigned char 	*key,		//* in
		unsigned char 	*value,		//* in
		unsigned long	ssCtxFlags	//* in
	);


#if defined(__cplusplus) || defined(c_plusplus)
}
#endif


#endif
