/**************************************************************************
 %name: sshtst.c %
 %version: 11 %
 %date_modified: Tue May 17 16:47:30 2005 %

 Copyright (c) 1997-2005 Novell, Inc.  All rights reserved.

 THIS WORK IS SUBJECT TO U.S. AND INTERNATIONAL COPYRIGHT LAWS AND TREATIES.
 USE AND REDISTRIBUTION OF THIS WORK IS SUBJECT TO THE LICENSE AGREEMENT
 ACCOMPANYING THE SOFTWARE DEVELOPMENT KIT (SDK) THAT CONTAINS THIS WORK.
 PURSUANT TO THE SDK LICENSE AGREEMENT, NOVELL HEREBY GRANTS TO DEVELOPER A
 ROYALTY-FREE, NON-EXCLUSIVE LICENSE TO INCLUDE NOVELL'S SAMPLE CODE IN ITS
 PRODUCT. NOVELL GRANTS DEVELOPER WORLDWIDE DISTRIBUTION RIGHTS TO MARKET,
 DISTRIBUTE, OR SELL NOVELL'S SAMPLE CODE AS A COMPONENT OF DEVELOPER'S
 PRODUCTS. NOVELL SHALL HAVE NO OBLIGATIONS TO DEVELOPER OR DEVELOPER'S
 CUSTOMERS WITH RESPECT TO THIS CODE.
**************************************************************************/


/***************************************************************
 *** This code is available at "www.developer.novell.com/ndk/ **
 ***************************************************************/


/* Sample SharedSecret code for SecretStore Service APIs */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#ifndef N_PLAT_NLM
#include <conio.h>
#else
#include	<signal.h>
#include	<nwthread.h>
#endif

#include <time.h>
#include <ssshs.h>
#include <nssscl.h>
#include "nssbldno.h"




///////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////


/*
 * Global data
 */
int		optErr = 1;			// if error message should be printed
int   	optIdx = 1;	   		// index into parent argv vector
int   	optionString = 1;	// character checked for validity
char 	*optArg = NULL;		// argument associated with option

#define BADCHAR 	(int)'?'
#define ERRMSG  	""

/* interactive flag */
static int	aFlag = 1;

/*  */
/*
 * NAME - sss_GetOpt
 *
 * DESCRIPTION
 *	An implementation of the Unix getopt() function.
 *
 */
int sss_GetOpt( int nArgc, char **nArgv, char *optStr )
{ /* beginning of the call */
/* ########################## DECLARATIONS START HERE ######################### */

	static	char		*place = ERRMSG;
			char		*nxtOpt;

/* ############################## CODE STARTS HERE ############################ */

	if(!*place)  
	{
		if((optIdx >= nArgc) ||
			((*(place = nArgv[optIdx]) != '-')
				&& (*(place = nArgv[optIdx]) != '/')) ||
					(!*++place))
		{
			return(-1);
		}

		if((*place == '-') || (*place == '/'))
		{
			++optIdx;
			return(-1);
		}
	}

	if((optionString = (int)*place++) == (int)'=' || 
			!(nxtOpt = strchr(optStr, optionString))) 
	{
		if(!*place) 
		{
			++optIdx;
		}

		return(BADCHAR);
	}

	if(*++nxtOpt != '=') 
	{
		optArg = NULL;
		if(!*place) 
		{
			++optIdx;
		}
	}
	else 
	{
		if(*place)
		{
			optArg = place + 1;
		}
		else if(nArgc <= ++optIdx) 
		{
			place = ERRMSG;
			return(BADCHAR);
		}
	 	else 
		{
	 		optArg = nArgv[optIdx];
		}

		place = ERRMSG;
		++optIdx;
	}

	return(optionString);

/* ########################## CODE ENDS HERE ######################### */
} /* end of GetOPt */




void Pause()
{ /* beginning of the call */
/* ############################## CODE STARTS HERE ############################ */

	if(aFlag)
	{
		printf("\nPress a key ==>\n");
		getch();
	}
/* ########################## CODE ENDS HERE ######################### */
} /* end of Pause */



/*  */
/*
 * NAME - PrintFlags
 *
 * DESCRIPTION
 *	This function will print the 
 *	status flags read form a secret.		   
 *		   
 */
void PrintFlags(char *msg, unsigned long	statFlags)
{ // beginning of the call 
// ############################## CODE STARTS HERE ############################

	if(aFlag)
	{
		printf("%s", msg);

		if(statFlags & NSSS_ENHANCED_PROTECT_INFO_F)
			printf("\tENHANCED PROTECTION...\n");

		if(statFlags & NSSS_STORE_NOT_SYNCED_F)
			printf("\tSTORE NOT SYNCED...\n");

		if(statFlags & NSSS_SECRET_NOT_INITIALIZED_F)
			printf("\tSECRET NOT INITIALIZED...\n");

		if(statFlags & NSSS_SECRET_LOCKED_F)
			printf("\tSECRET LOCKED...\n");

		// doesn't apply to the server 
		if(strcmp(msg, "SecretStore Flags:\n"))
		{
			if(statFlags & NSSS_ADMIN_LAST_MOD_F)
				printf("\tADMIN MODIFIED LAST...\n");
			else
				printf("\tOWNER MODIFIED LAST...\n");
		}

		if(statFlags & NSSS_EP_PWORD_PRESENT_F)
			printf("\tEP PWORD PRESENT...\n");

		if(statFlags & NSSS_EP_MASTER_PWORD_PRESENT_F)
			printf("\tMASTER PWORD PRESENT...\n");
		
		if(statFlags & NSSS_MP_NOT_ALLOWED_F)
			printf("\tMASTER PWORD NOT ALLOWED...\n");

		if(statFlags & NSSS_HIDDEN_SECRET_F)
			printf("\tHIDDEN SECRET IN SECRETSTORE...\n");

		if(statFlags & NSSS_ADMIN_UNLOCKED_F)
			printf("\tADMIN LAST UNLOCKED THE SECRETSTORE...\n");
	}

// ########################## CODE ENDS HERE ######################### 
} // end of PrintFlags



/*  */
/*
 * NAME - main
 *
 * DESCRIPTION
 *	SecretStore SharedSecret test program.		   
 *		   
 */
void	main
(
	int 		argc, 
	char 		**argv
)
{ /* beginning of the call */
/* ########################## DECLARATIONS START HERE ######################### */

	SSS_CONTEXT_T			ctx = {0};
	SSS_GSINFOEXT_T			gsInfo = {0};
	SSS_READEXT_T			rInfo = {0};
	SS_OBJECT_DN_T			targetObjDN = {0};
//	char					*nameStr;

	int						bAppTest = 0, bMultiCredTest = 0, bMultiEntryTest = 0, bUTF8Test = 0;
	char					pSecret[NSSO_MAX_SECRET_BUF_LEN];
	char					tempSecretID[NSSO_MAX_SECRET_ID_CHARS];
	char					multiCredApp[] = "SharedSecret Multiple CredSet Application Test";
	char					multiEntryCredSet[] = "SharedSecret Multiple Entry CredSet Test";
	unsigned char			UTF8Key[] = {0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x77, 0x6F, 0x72, 0x64, 00};
	unsigned char			UTF8Value[] = {0xED, 0x98, 0x9C, 0xED, 0x98, 0xA4, 0xED, 0x95, 0xAB, 0xED, 0x9B, 0xA7, 0xED, 0x9D, 0x8F, 00};
	char					UTF8TestID[] = "UFT8Test";


	char			*keyEntries[5] =
					{
						"username01",
						"username02",
						"username03", 
						"username04",
						"username05" 
					};
	char			*valEntries[5] =
					{
						"password01",
						"password02",
						"password03",
						"password04",
						"password05" 
					};

	char			*mKeyEntries[5] =
					{
						"company",
						"description",
						"username", 
						"password",
						"pin number" 
					};
	char			*mValEntries[5] =
					{
						"Novell, Inc.",
						"SharedSecret Test Utility",
						"John Doe", 
						"novell",
						"000000000" 
					};

	char			*appNames[5] =
					{
						"\\SharedSecret:E:\\Novell\\ssshsTest.01CN=AppTest/O=novell", 
						"\\SharedSecret:E:\\Novell\\ssshsTest.02CN=AppTest/O=novell",
						"\\SharedSecret:E:\\Novell\\ssshsTest.03CN=AppTest/O=novell", 
						"\\SharedSecret:E:\\Novell\\ssshsTest.04CN=AppTest/O=novell", 
						"\\SharedSecret:E:\\Novell\\ssshsTest.05CN=AppTest/O=novell"
					};

	char			*credSetNames[5] =
					{
						"\\SharedSecret:E:\\Novell\\ssshsTest.01CN=CredSet/O=novell", 
						"\\SharedSecret:E:\\Novell\\ssshsTest.02CN=CredSet/O=novell",
						"\\SharedSecret:E:\\Novell\\ssshsTest.03CN=CredSet/O=novell", 
						"\\SharedSecret:E:\\Novell\\ssshsTest.04CN=CredSet/O=novell", 
						"\\SharedSecret:E:\\Novell\\ssshsTest.05CN=CredSet/O=novell"
					};

	int						rcode = NSSS_SUCCESS;
	int						exCount = 1, i, j, remLock = 0, unlock = 0,
							master = 0, rCount = 1;
	long					opCount, bufSize = NSSS_MAX_SECRET_BUF_LEN;
	unsigned long			startTime, endTime, pFlag = 0L, count = 0;
	int						c;

	SS_SECRET_ID_T			secretID = {0};

	// SharedSecret data
	void				*handle;			// handle for passing to functions
	SS_SH_SECRET_ID_T	shSecret; // SharedSecret struct
	char				key[NSSS_MAX_SECRET_ID_LEN];
	char				value[NSSS_MAX_SECRET_BUF_LEN];
	int					kLen = 0;
	int					vLen = 0;

	memset(key, 0, NSSS_MAX_SECRET_ID_LEN);
	memset(value, 0, NSSS_MAX_SECRET_BUF_LEN);
	memset(pSecret, 0, NSSS_MAX_SECRET_BUF_LEN);
	memset(tempSecretID, 0, NSSS_MAX_SECRET_BUF_LEN);

/* ############################## CODE STARTS HERE ############################ */

	printf("\nSecretStore NDK SharedSecret Test Program version %s ...\n\n", GSS_BLD_STR);

#ifdef	N_PLAT_NLM
	AtUnload(UnloadLDAPSSCLMain);
	atexit(UnloadLDAPSSCLMain);

	ssLSSCLModuleHandle = GetNLMHandle();

#ifdef FAST_ALLOC
 		if(ss_InitSSAllocTag())
		{
			goto ERROR_1;
		}
#endif /* FAST_ALLOC */

	ssLSSCLThreadGroupID = GetThreadGroupID();

	if((rcode = NWCallsInit(NULL, NULL)))
	{
		printf("CLIB Initialization Failed [%d]!!\n", rcode);
		goto ERROR_1;
	}

	signal(SIGTERM, UnloadLDAPSSCLMain);

#endif

	//** Process command-line arguments.
	if(argc > 1)
	{
		while ((c = sss_GetOpt(argc, argv, "bBmMsSc=C=?hH")) != -1)
		{
			switch(c)
			{
				case 'b':
				case 'B':

					/* Big secret buffer */
					bufSize = NSSS_MAX_SECRET_BUF_LEN;
					break;

				case 'm':
				case 'M':

					/* Medium secret buffer */
					bufSize = NSSS_MID_SECRET_BUF_LEN; 
					break;

				case 's':
				case 'S':

					/* set active flag to FALSE */
					aFlag = 0;
					printf("Silent Running Mode Active...\n");
					break;

				case 'c':
				case 'C':

					/* Run count */
					exCount = atoi(optArg);
					break;


				default:

					//* case '?':
					//* case 'h':
					//*case 'H':

					printf("\nUsage: sshtst [/m]|[/b][/s /c=[count] /r=[rcount] | /? | /h ]\n");
					printf("\tOptions: [ /m | /M ] for 4k Secret Buffer Size.\n");
					printf("\tOptions: [ /b | /B ] for 59k Secret Buffer Size.\n");
					printf("\tOptions: [ /s | /S ] for Silent Running.\n");
					printf("\t\tSilent sub-Option [ /c | /C ] for number of times to run.\n");
					printf("\tExample: sshtst /s /c=1000\n");
					printf("\tOption: [ /h | /H  | /? ] for Help.\n");
					printf("\tNo command line options will activate interactive running.\n\n");
					printf("\tFor options \"/\" and \"-\" are interchangeable.\n\n");
					exit(0);
			}
		} 
	}
	else
	{
 		printf("Full Interactive Running Mode Active...\n");
	}

	printf("Execution Count Set to: [%d]\n", exCount);
	printf("Initializing...\n");

	startTime = time(NULL);
	printf("Done...\n");
	Pause();

	//** Query the SecretStore service to determine version, etc.  Note that
	//** we get and save the callerDN.
	if(rcode = NSSSGetServiceInformation(&ctx, &targetObjDN, (pFlag | NSSS_GET_CONTEXT_F), &gsInfo, NULL))
	{
		//* Call failed.
		printf("\nError [%d] NSSSGetServiceInformation\n", rcode);
		goto ERROR_1;
	}
	else
	{
		//* Print out service information.
		printf("\nClient Version = [%d.%d.%d]\n",
			((gsInfo.clientVersion >> 16)  & 0x000000FF) , 
				((gsInfo.clientVersion >> 8) & 0x000000FF), 
					(gsInfo.clientVersion & 0x000000FF));

		printf("\nServer Version = [%d.%d.%d]\n",
			((gsInfo.serverVersion >> 16)  & 0x000000FF) , 
				((gsInfo.serverVersion >> 8) & 0x000000FF), 
					(gsInfo.serverVersion & 0x000000FF));

		if(gsInfo.serverCryptoStrength == NSSS_NICI_DOMESTIC_ENGINE)
		{
			printf("Server Crypto Strength = DOMESTIC\n");
		}
		else
		{
			printf("Server Crypto Strength = EXPORT\n");
		}
		
		if(gsInfo.clientCryptoStrength == NSSS_NICI_DOMESTIC_ENGINE)
		{
			printf("Client Crypto Strength = DOMESTIC\n");
		}
		else
		{
			printf("Client Crypto Strength = EXPORT\n");
		}


		printf("\nSecretStore's NDS Tree = %s\n", ctx.ssServerInfo.treeName);
		printf("\nSecretStore's Server = %s\n", ctx.ssServerInfo.ssServerDN);


		if(gsInfo.secretCount)
		{
		  PrintFlags("\nSecretStore Flags:\n", gsInfo.statusFlags);
		}


		if(strlen(ctx.ssServerInfo.sssConfigDN))
		{
			printf("\nNSSS Configuration Container = %s\n", ctx.ssServerInfo.sssConfigDN);
		}

		printf("\nCaller DN = %s\n", ctx.callerDN.id);

	}

	targetObjDN = ctx.callerDN;
	//* reset the flag
	pFlag &= ~NSSS_GET_CONTEXT_F;

	//* Query the user to continue.
	if(aFlag)
	{
		printf("\nDo you want to CONTINUE (y/n)? ");
		c = getch();
		putchar(c);
		printf("\n\n");
	}
	else
	{
		 c = 'y';
	}

	if(!((c == 'y') || (c == 'Y')))
	{
		aFlag = 0;
		goto ERROR_1;
	}

	//* Run the tests as many times as specified by the user.
	for(j = 0, opCount = 0; j < exCount; j++)
	{
			///////////////////////////////////////////////////////////
			/// begin the test for UTF8 ///////////////////////////////
			///////////////////////////////////////////////////////////

			///////////////////////////////////////////
			// run the CREATE a UTF8 Credential Secret
			///////////////////////////////////////////
			if(aFlag)
			{
				printf("\nDo you want to CREATE a UTF8 Credential Secret(y/n)? ");
				c = getch();
				putchar(c);
				printf("\n\n");
			}
			else
			{
				c = 'y';
			}

			if(c == 'y' || c == 'Y')
			{
				bUTF8Test = 1;
				shSecret.type = SS_CREDENTIAL_TYPE_F;
				strcpy(shSecret.pName, UTF8TestID);
				shSecret.len = strlen(shSecret.pName)+1;
				
				handle = NSSSCreateSHSHandle();  // create a new handle
				if(!handle)
				{
					printf("\n\nFAILED to successfully create a valid handle");
					Pause();
					goto ERROR_1;
				}

				printf("\nCalling NSSSReadSharedSecret\n");
			
				rcode = NSSSReadSharedSecret(handle, &shSecret, &ctx, &targetObjDN, pFlag, NULL, &rInfo, NULL);
				
				if(rcode != NSSS_SUCCESS)
				{
					if((rcode != NSSS_E_STORE_NOT_FOUND) && (rcode != NSSS_E_INVALID_SECRET_ID))
					{
						printf("\nNSSSReadSharedSecret returned [%d] in [%s]\n\n", rcode, UTF8TestID);
						Pause();
						goto ERROR_1;
					}
				}

				for(i = 1; i < 2; i++)
				{	
					strcpy(key, UTF8Key);
					strcpy(value, UTF8Value);

					printf("\nCalling NSSSAddSHSEntry for [%s]\n", UTF8TestID);	
			
					if(rcode = NSSSAddSHSEntry(handle, key, value, ctx.flags))
					{
						printf("\nNSSSAddSHSEntry returned [%d] when adding [%s]/[%s]\nto [%s]\n\n", rcode, key, value, "UTF8 Test");
						Pause();
					}
					else
					{
						printf("\nAdded [%s]=[%s]\n", key, value);
					}
				}

				printf("\nCalling NSSSWriteSharedSecret\n");
		
				if(rcode = NSSSWriteSharedSecret(handle, &shSecret, &ctx, &targetObjDN, pFlag, NULL, NULL))
				{
					printf("\n\nNSSSWriteSharedSecret returned [%d] when storing data in\n[%s]\n\n", rcode, UTF8TestID);
					Pause();
					goto ERROR_1;
				}
				else
				{
					printf("\nNSSSWriteSharedSecret SUCCEEDED\n");
				}

				memset(key, 0, NSSS_MAX_SECRET_ID_LEN);
				memset(value, 0, NSSS_MAX_SECRET_BUF_LEN);
				
				NSSSDestroySHSHandle(handle);  // destroy the handle
			}


			memset(key, 0, NSSS_MAX_SECRET_ID_LEN);
			memset(value, 0, NSSS_MAX_SECRET_BUF_LEN);

			if(bUTF8Test)
			{
				///////////////////////////////////////////////
				// run the READ the UTF8 Credential Secret test
				///////////////////////////////////////////////
				if(aFlag)
				{
					printf("\nDo you want to READ the UTF8 Credential Secret(y/n)? ");
					c = getch();
					putchar(c);
					printf("\n\n");
				}
				else
				{
					c = 'y';
				}

				if(c == 'y' || c == 'Y')
				{
					shSecret.type = SS_CREDENTIAL_TYPE_F;
					strcpy(shSecret.pName, UTF8TestID);
					shSecret.len = strlen(shSecret.pName)+1;

					handle = NSSSCreateSHSHandle();  // create a new handle
					if(!handle)
					{
						printf("\n\nFAILED to successfully create a valid handle");
						Pause();
						goto ERROR_1;
					}
					
					printf("\nCalling NSSSReadSharedSecret\n");
		
					rcode = NSSSReadSharedSecret(handle, &shSecret, &ctx, &targetObjDN, pFlag, NULL, &rInfo, NULL);
					
					if(rcode != NSSS_SUCCESS)
					{
						printf("\nNSSSReadSharedSecret returned [%d] in [%s]\n\n", rcode, UTF8TestID);
						Pause();
						goto ERROR_1;
					}

					printf("\nCalling NSSSGetNextEntry\n");
		
					if(!(rcode = NSSSGetNextSHSEntry(1, handle, &kLen, key, &vLen, value, ctx.flags)))
					{
						while(rcode == NSSS_SUCCESS)
						{
							if(0 == strlen(key))
							{
								break;
							}

							strcpy(pSecret, key);
							strcat(pSecret, "=");
							strcat(pSecret, value);
							printf("\nNSSSGetNextSHSEntry returned [%s]:[%s]\n", key, value);
							
							// clear the buffers
							memset(key, 0, NSSS_MAX_SECRET_ID_LEN);
							memset(value, 0, NSSS_MAX_SECRET_BUF_LEN);
							memset(pSecret, 0, NSSS_MAX_SECRET_BUF_LEN);

							rcode = NSSSGetNextSHSEntry(0, handle, &kLen, key, &vLen, value, ctx.flags);
						}
					}
					
					NSSSDestroySHSHandle(handle);  // destroy the handle
				}
			}

			memset(key, 0, NSSS_MAX_SECRET_ID_LEN);
			memset(value, 0, NSSS_MAX_SECRET_BUF_LEN);


			//////////////////////////////////////////////////////////////////////////////////////////
			/////////// end of MBCS test for UTF8 ////////////////////////////////////////////////////
			//////////////////////////////////////////////////////////////////////////////////////////

			//////////////////////////////////////////////////////////////////////////////////////////
			// run the CREATE Application SharedSecrets with an associated default Credential Set test
			//////////////////////////////////////////////////////////////////////////////////////////
			if(aFlag)
			{
				printf("\nDo you want to CREATE Application SharedSecrets with\nan associated default Credential Set(y/n)? ");
				c = getch();
				putchar(c);
				printf("\n\n");
			}
			else
			{
				c = 'y';
			}

			if(c == 'y' || c == 'Y')
			{
				bAppTest = 1;

				for(i = 1; i < 6; i++)
				{
					shSecret.type = SS_APPLICATION_TYPE_F;
					strcpy(shSecret.pName, appNames[i-1]);
					shSecret.len = strlen(shSecret.pName)+1;

					// create the App secredID and key/value pair secret data
					handle = NSSSCreateSHSHandle();  // create a new handle
					if(!handle)
					{
						printf("\n\nFAILED to successfully create a valid handle");
						Pause();
						goto ERROR_1;
					}
					
					printf("\nCalling NSSSReadSharedSecret\n");
				
					rcode = NSSSReadSharedSecret(handle, &shSecret, &ctx, &targetObjDN, pFlag, NULL, &rInfo, NULL);
					
					if(rcode != NSSS_SUCCESS)
					{
						if((rcode != NSSS_E_STORE_NOT_FOUND) && (rcode != NSSS_E_INVALID_SECRET_ID))
						{
							printf("\nNSSSReadSharedSecret returned [%d] when reading [%s]\n\n", rcode, appNames[i-1]);
							Pause();
							goto ERROR_1;
						}
					}

					strcpy(key, "SS_CredSet");
					strcpy(value, credSetNames[i-1]);

					printf("\nCalling NSSSAddSHSEntry\n");
			
					if(rcode = NSSSAddSHSEntry(handle, key, value, ctx.flags))
					{
						printf("\n\nNSSSAddSHSEntry returned [%d] when adding\n[%s] and [%s]\n\n", rcode, key, value);
						Pause();
					}
					else
					{
						printf("\nAdded [%s]:[%s]\n", key, value);
					}

					printf("\nCalling NSSSWriteSharedSecret\n");
				
					if(rcode = NSSSWriteSharedSecret(handle, &shSecret, &ctx, &targetObjDN, pFlag, NULL, NULL))
					{
						printf("\nNSSSWriteSharedSecret returned [%d] when storing [%s]:[%s]\nto [%s]\n\n", rcode, key, value, appNames[i-1]);
						Pause();
						goto ERROR_1;
					}
					else
					{
						printf("\nNSSSWriteSharedSecret SUCCEEDED\n");
					}

					NSSSDestroySHSHandle(handle);  // destroy the handle
					
					memset(key, 0, NSSS_MAX_SECRET_ID_LEN);
					memset(value, 0, NSSS_MAX_SECRET_BUF_LEN);



					////////////////////////////////////////////////////////////////
					// create the CredSet secredID and key/value pair secret data
					handle = NSSSCreateSHSHandle();  // create a new handle
					if(!handle)
					{
						printf("\n\nFAILED to successfully create a valid handle");
						Pause();
						goto ERROR_1;
					}

					shSecret.type = SS_CREDENTIAL_TYPE_F;
					strcpy(shSecret.pName, credSetNames[i-1]);
					shSecret.len = strlen(shSecret.pName)+1;
					
					printf("\nCalling NSSSReadSharedSecret\n");
			
					rcode = NSSSReadSharedSecret(handle, &shSecret, &ctx, &targetObjDN, pFlag, NULL, &rInfo, NULL);
					
					if(rcode != NSSS_SUCCESS)
					{
						if((rcode != NSSS_E_STORE_NOT_FOUND) && (rcode != NSSS_E_INVALID_SECRET_ID))
						{
							printf("\nNSSSReadSharedSecret returned [%d] when reading [%s]\n\n", rcode, credSetNames[i-1]);
							Pause();
							goto ERROR_1;
						}
					}

					strcpy(key, keyEntries[i-1]);
					strcpy(value, valEntries[i-1]);

					printf("\nCalling NSSSAddSHSEntry\n");	
			
					if(rcode = NSSSAddSHSEntry(handle, key, value, ctx.flags))
					{
						printf("\nNSSSAddSHSEntry returned [%d] when adding \n[%s]:[%s]\nto [%s]\n\n", rcode, key, value, credSetNames[i-1]);
						Pause();
					}
					else
					{
						printf("\nAdded [%s]=[%s]\n", key, value);
					}

					printf("\nCalling NSSSWriteSharedSecret\n");
				
					if(rcode = NSSSWriteSharedSecret(handle, &shSecret, &ctx, &targetObjDN, pFlag, NULL, NULL))
					{
						printf("\n\nNSSSWriteSharedSecret returned [%d] when storing\n[%s]:[%s]\nto [%s]\n\n", rcode, key, value, credSetNames[i-1]);
						Pause();
						goto ERROR_1;
					}
					else
					{
						printf("\nNSSSWriteSharedSecret SUCCEEDED\n");
					}

					NSSSDestroySHSHandle(handle);  // destroy the handle
				}
			}

			memset(key, 0, NSSS_MAX_SECRET_ID_LEN);
			memset(value, 0, NSSS_MAX_SECRET_BUF_LEN);





			if(bAppTest)
			{
				//////////////////////////////////////////////////
				// run the READ the Application SharedSecrets test
				//////////////////////////////////////////////////
				if(aFlag)
				{
					printf("\nDo you want to READ the Application SharedSecrets(y/n)? ");
					c = getch();
					putchar(c);
					printf("\n\n");
				}
				else
				{
					c = 'y';
				}

				if(c == 'y' || c == 'Y')
				{
					shSecret.type = SS_APPLICATION_TYPE_F;

					for(i = 1; i < 6; i++)
					{
						strcpy(shSecret.pName, appNames[i-1]);
						shSecret.len = strlen(shSecret.pName)+1;
						handle = NSSSCreateSHSHandle();  // create a new handle
						if(!handle)
						{
							printf("\n\nFAILED to successfully create a valid handle");
							Pause();
							goto ERROR_1;
						}
						
						printf("\nCalling NSSSReadSharedSecret\n");

						rcode = NSSSReadSharedSecret(handle, &shSecret, &ctx, &targetObjDN, pFlag, NULL, &rInfo, NULL);
						if(rcode != NSSS_SUCCESS)
						{
							printf("\nNSSSReadSharedSecret returned [%d] when reading [%s]\n\n", rcode, appNames[i-1]);
							Pause();
							goto ERROR_1;

						}

						printf("\nCalling NSSSGetNextSHSEntry\n");
					
						if(!(rcode = NSSSGetNextSHSEntry(1, handle, &kLen, key, &vLen, value, ctx.flags)))
						{
							while(rcode == NSSS_SUCCESS)
							{
								if(0 == strlen(key))
								{
									break;
								}

								strcpy(pSecret, key);
								strcat(pSecret, ":");
								strcat(pSecret, value);
								printf("\nNSSSGetNextSHSEntry returned [%s]:[%s]\n", key, value);
								
								// clear the buffers
								memset(key, 0, NSSS_MAX_SECRET_ID_LEN);
								memset(value, 0, NSSS_MAX_SECRET_BUF_LEN);
								memset(pSecret, 0, NSSS_MAX_SECRET_BUF_LEN);

//								printf("\nCalling NSSSGetNextSHSEntry for retrieving key/value data from [%s]\n", appNames[i-1]);
								
								rcode = NSSSGetNextSHSEntry(0, handle, &kLen, key, &vLen, value, ctx.flags);
							}
						}
						
						NSSSDestroySHSHandle(handle);  // destroy the handle

						memset(key, 0, NSSS_MAX_SECRET_ID_LEN);
						memset(value, 0, NSSS_MAX_SECRET_BUF_LEN);



					}
				}
			}

			memset(key, 0, NSSS_MAX_SECRET_ID_LEN);
			memset(value, 0, NSSS_MAX_SECRET_BUF_LEN);

			////////////////////////////////////////////////////////////////////////////////////////////
			// run the multiple CREATE Credential Sets for a single Application Secret SharedSecret test
			////////////////////////////////////////////////////////////////////////////////////////////
			if(aFlag)
			{
				printf("\nDo you want to CREATE multiple Credential Secrets\nfor a single Application Secret(y/n)? ");
				c = getch();
				putchar(c);
				printf("\n\n");
			}
			else
			{
				c = 'y';
			}

			if(c == 'y' || c == 'Y')
			{
				bMultiCredTest = 1;
				shSecret.type = SS_APPLICATION_TYPE_F;
				strcpy(shSecret.pName, multiCredApp);
				shSecret.len = strlen(shSecret.pName)+1;
				
				handle = NSSSCreateSHSHandle();  // create a new handle
				if(!handle)
				{
					printf("\n\nFAILED to successfully create a valid handle");
					Pause();
					goto ERROR_1;
				}

				printf("\nCalling NSSSReadSharedSecret\n");
			
				rcode = NSSSReadSharedSecret(handle, &shSecret, &ctx, &targetObjDN, pFlag, NULL, &rInfo, NULL);
				
				if(rcode != NSSS_SUCCESS)
				{
					if((rcode != NSSS_E_STORE_NOT_FOUND) && (rcode != NSSS_E_INVALID_SECRET_ID))
					{
						printf("\nNSSSReadSharedSecret returned [%d] when reading [%s]\n\n", rcode, multiCredApp);
						Pause();
						goto ERROR_1;
					}
				}

				for(i = 1; i < 6; i++)
				{	
					strcpy(key, "SS_CredSet");
					strcpy(value, credSetNames[i-1]);

					printf("\nCalling NSSSAddSHSEntry for [%s]\n", multiCredApp);	
			
					if(rcode = NSSSAddSHSEntry(handle, key, value, ctx.flags))
					{
						printf("\nNSSSAddSHSEntry returned [%d] when adding [%s]/[%s]\nto [%s]\n\n", rcode, key, value, multiCredApp);
						Pause();
					}
					else
					{
						printf("\nAdded [%s]:[%s]\n", key, value);
					}
				}

				printf("\nCalling NSSSWriteSharedSecret\n");
		
				if(rcode = NSSSWriteSharedSecret(handle, &shSecret, &ctx, &targetObjDN, pFlag, NULL, NULL))
				{
					printf("\n\nNSSSWriteSharedSecret returned [%d] when storing data in\n[%s]\n\n", rcode, multiCredApp);
					Pause();
					goto ERROR_1;
				}
				else
				{
					printf("\nNSSSWriteSharedSecret SUCCEEDED\n");
				}

				memset(key, 0, NSSS_MAX_SECRET_ID_LEN);
				memset(value, 0, NSSS_MAX_SECRET_BUF_LEN);
				
				NSSSDestroySHSHandle(handle);  // destroy the handle
			}


			memset(key, 0, NSSS_MAX_SECRET_ID_LEN);
			memset(value, 0, NSSS_MAX_SECRET_BUF_LEN);

			if(bMultiCredTest)
			{
				/////////////////////////////////////////////////////////////////////////////////
				// run the READ Credential Sets for a single Application Secret SharedSecret test
				/////////////////////////////////////////////////////////////////////////////////
				if(aFlag)
				{
					printf("\nDo you want to READ the multiple Credential Secrets\nfor a single Application Secret(y/n)? ");
					c = getch();
					putchar(c);
					printf("\n\n");
				}
				else
				{
					c = 'y';
				}

				if(c == 'y' || c == 'Y')
				{
					shSecret.type = SS_APPLICATION_TYPE_F;
					strcpy(shSecret.pName, multiCredApp);
					shSecret.len = strlen(shSecret.pName)+1;

					handle = NSSSCreateSHSHandle();  // create a new handle
					if(!handle)
					{
						printf("\n\nFAILED to successfully create a valid handle");
						Pause();
						goto ERROR_1;
					}
					
					printf("\nCalling NSSSReadSharedSecret\n");
		
					rcode = NSSSReadSharedSecret(handle, &shSecret, &ctx, &targetObjDN, pFlag, NULL, &rInfo, NULL);
					
					if(rcode != NSSS_SUCCESS)
					{
						printf("\nNSSSReadSharedSecret returned [%d] when reading [%s]\n\n", rcode, multiCredApp);
						Pause();
						goto ERROR_1;
					}

					printf("\nCalling NSSSGetNextEntry\n");
		
					if(!(rcode = NSSSGetNextSHSEntry(1, handle, &kLen, key, &vLen, value, ctx.flags)))
					{
						while(rcode == NSSS_SUCCESS)
						{
							if(0 == strlen(key))
							{
								break;
							}

							strcpy(pSecret, key);
							strcat(pSecret, ":");
							strcat(pSecret, value);
							printf("\nNSSSGetNextSHSEntry returned [%s]:[%s]\n", key, value);
							
							// clear the buffers
							memset(key, 0, NSSS_MAX_SECRET_ID_LEN);
							memset(value, 0, NSSS_MAX_SECRET_BUF_LEN);
							memset(pSecret, 0, NSSS_MAX_SECRET_BUF_LEN);

							rcode = NSSSGetNextSHSEntry(0, handle, &kLen, key, &vLen, value, ctx.flags);
						}
					}
					
					NSSSDestroySHSHandle(handle);  // destroy the handle
				}
			}

			memset(key, 0, NSSS_MAX_SECRET_ID_LEN);
			memset(value, 0, NSSS_MAX_SECRET_BUF_LEN);



			///////////////////////////////////////////////////////////////////
			// run the CREATE multiple entries for a single Credential Set test
			///////////////////////////////////////////////////////////////////
			if(aFlag)
			{
				printf("\nDo you want to CREATE multiple entries for a single Credential Set(y/n)? ");
				c = getch();
				putchar(c);
				printf("\n\n");
			}
			else
			{
				c = 'y';
			}

			if(c == 'y' || c == 'Y')
			{
				bMultiEntryTest = 1;
				shSecret.type = SS_CREDENTIAL_TYPE_F;
				strcpy(shSecret.pName, multiEntryCredSet);
				shSecret.len = strlen(shSecret.pName)+1;

				handle = NSSSCreateSHSHandle();  // create a new handle
				if(!handle)
				{
					goto ERROR_1;
				}
				
				printf("\nCalling NSSSReadSharedSecret\n");
		
				rcode = NSSSReadSharedSecret(handle, &shSecret, &ctx, &targetObjDN, pFlag, NULL, &rInfo, NULL);
				
				if(rcode != NSSS_SUCCESS)
				{
					if((rcode != NSSS_E_STORE_NOT_FOUND) && (rcode != NSSS_E_INVALID_SECRET_ID))
					{
						printf("\nNSSSReadSharedSecret returned [%d] when reading [%s]\n\n", rcode, multiEntryCredSet);
						Pause();
						goto ERROR_1;
					}
				}

				for(i = 1; i < 6; i++)
				{	
					strcpy(key, mKeyEntries[i-1]);
					strcpy(value, mValEntries[i-1]);

					printf("\nCalling NSSSAddSHSEntry\n");

					if(!(rcode = NSSSAddSHSEntry(handle, key, value, ctx.flags)))
					{
						printf("\nAdded [%s]=[%s]\n", key, value);
					}
					else
					{
						printf("\nNSSSAddSHSEntry returned [%d] when adding [%s]=[%s]\n\n", rcode, key, value);
						Pause();
					}
				}
				
				printf("\nCalling NSSSWriteSharedSecret\n");
				
				if(rcode = NSSSWriteSharedSecret(handle, &shSecret, &ctx, &targetObjDN, pFlag, NULL, NULL))
				{
					printf("\nNSSSWriteSharedSecret returned [%d] when storing\n[%s]:[%s]\nto [%s]\n\n", rcode, key, value, multiEntryCredSet);
					Pause();
					goto ERROR_1;
				}
				else
				{
					printf("\nNSSSWriteSharedSecret SUCCEEDED\n");
				}
							
				NSSSDestroySHSHandle(handle);  // destroy the handle
			}



			memset(key, 0, NSSS_MAX_SECRET_ID_LEN);
			memset(value, 0, NSSS_MAX_SECRET_BUF_LEN);

			if(bMultiEntryTest)
			{
				/////////////////////////////////////////////////////////////
				// READ the multiple entries in the single Credential Set test
				/////////////////////////////////////////////////////////////
				if(aFlag)
				{
					printf("\nDo you want to READ the multiple entries in the single Credential Set(y/n)? ");
					c = getch();
					putchar(c);
					printf("\n\n");
				}
				else
				{
					c = 'y';
				}

				if(c == 'y' || c == 'Y')
				{
					shSecret.type = SS_CREDENTIAL_TYPE_F;
					strcpy(shSecret.pName, multiEntryCredSet);
					shSecret.len = strlen(shSecret.pName)+1;

					handle = NSSSCreateSHSHandle();  // create a new handle
					if(!handle)
					{
						goto ERROR_1;
					}
					
					printf("\nCalling NSSSReadSharedSecret\n");
			
					rcode = NSSSReadSharedSecret(handle, &shSecret, &ctx, &targetObjDN, pFlag, NULL, &rInfo, NULL);
					
					if(rcode != NSSS_SUCCESS)
					{
						printf("\nNSSSReadSharedSecret returned [%d] when reading [%s]\n\n", rcode, multiEntryCredSet);
						Pause();
						goto ERROR_1;
					}

					printf("\nCalling NSSSGetNextSHSEntry\n");
				
					if(!(rcode = NSSSGetNextSHSEntry(1, handle, &kLen, key, &vLen, value, ctx.flags)))
					{
						while(rcode == NSSS_SUCCESS)
						{
							if(0 == strlen(key))
							{
								break;
							}

							strcpy(pSecret, key);
							strcat(pSecret, "=");
							strcat(pSecret, value);
							printf("\nNSSSGetNextSHSEntry returned [%s]=[%s]\n\n", key, value);
							
							// clear the buffers
							memset(key, 0, NSSS_MAX_SECRET_ID_LEN);
							memset(value, 0, NSSS_MAX_SECRET_BUF_LEN);
							memset(pSecret, 0, NSSS_MAX_SECRET_BUF_LEN);


							rcode = NSSSGetNextSHSEntry(0, handle, &kLen, key, &vLen, value, ctx.flags);
						}
					}

					NSSSDestroySHSHandle(handle);  // destroy the handle
				}
			}

			memset(key, 0, NSSS_MAX_SECRET_ID_LEN);
			memset(value, 0, NSSS_MAX_SECRET_BUF_LEN);




			if(bMultiEntryTest)
			{
				///////////////////////////////////////////////////////////////////////////
				// run the REMOVE the multiple entries from the single Credential Set test
				///////////////////////////////////////////////////////////////////////////
				if(aFlag)
				{
					printf("\nDo you want to REMOVE the multiple entries from the single Credential Set(y/n)? ");
					c = getch();
					putchar(c);
					printf("\n\n");
				}
				else
				{
					c = 'y';
				}

				if(c == 'y' || c == 'Y')
				{
					shSecret.type = SS_CREDENTIAL_TYPE_F;
					strcpy(shSecret.pName, multiEntryCredSet);
					shSecret.len = strlen(shSecret.pName)+1;

					handle = NSSSCreateSHSHandle();  // create a new handle
					if(!handle)
					{
						goto ERROR_1;
					}

					printf("\nCalling NSSSReadSharedSecret\n");
			
					rcode = NSSSReadSharedSecret(handle, &shSecret, &ctx, &targetObjDN, pFlag, NULL, &rInfo, NULL);
					
					if(rcode != NSSS_SUCCESS)
					{
						if((rcode != NSSS_E_STORE_NOT_FOUND) && (rcode != NSSS_E_INVALID_SECRET_ID))
						{
							printf("\nNSSSReadSharedSecret returned [%d] when reading [%s]\n\n", rcode, multiEntryCredSet);
							Pause();
							goto ERROR_1;
						}
					}

					// Remove only the entries we added.
					for(i = 1; i < 6; i++)
					{
						strcpy(key, mKeyEntries[i-1]);
						strcpy(value, mValEntries[i-1]);
						strcpy(shSecret.pName, multiEntryCredSet);
						shSecret.len = strlen(shSecret.pName)+1;

						kLen = strlen(key)+1;
						vLen = strlen(value)+1;
						printf("\nCalling NSSSRemoveSHSEntry\n");
			
						if(!(rcode = NSSSRemoveSHSEntry(handle, key, value, ctx.flags)))
						{
							printf("Removed [%s]=[%s]\n", key, value);		
						}
						else
						{
							printf("FAILED to remove [%s]:[%s]\nfrom [%s]\n\n", key, value, multiEntryCredSet);
						}
						
						// clear the buffers
						memset(key, 0, NSSS_MAX_SECRET_ID_LEN);
						memset(value, 0, NSSS_MAX_SECRET_BUF_LEN);
					}
					
				
					printf("\nCalling NSSSWriteSharedSecret\n");
					
					if(rcode = NSSSWriteSharedSecret(handle, &shSecret, &ctx, &targetObjDN, pFlag, NULL, NULL))
					{
						printf("\nNSSSWriteSharedSecret returned [%d] when storing data in\n[%s]\n\n", rcode, multiEntryCredSet);
						Pause();
						goto ERROR_1;
					}
					else
					{
						printf("\nNSSSWriteSharedSecret SUCCEEDED\n");
					}
					
					rcode = NSSSDestroySHSHandle(handle);
				}				
			}

			memset(key, 0, NSSS_MAX_SECRET_ID_LEN);
			memset(value, 0, NSSS_MAX_SECRET_BUF_LEN);

			if(bMultiCredTest)
			{
				///////////////////////////////////////////////////////////////////////////////////////////
				// run the REMOVE the multiple Credential Sets from the single Application Test Secret test
				///////////////////////////////////////////////////////////////////////////////////////////
				if(aFlag)
				{
					printf("\nDo you want to REMOVE the multiple Credential Sets\nfrom the single Application Test Secret(y/n)? ");
					c = getch();
					putchar(c);
					printf("\n\n");
				}
				else
				{
					c = 'y';
				}

				if(c == 'y' || c == 'Y')
				{
					// Remove only the Cred Sets we added.
					strcpy(shSecret.pName, multiCredApp);
					shSecret.len = strlen(shSecret.pName)+1;
					shSecret.type = SS_APPLICATION_TYPE_F;
					strcpy(key, "SS_CredSet");
					handle = NSSSCreateSHSHandle();  // create a new handle
					if(!handle)
					{
						goto ERROR_1;
					}
				
					printf("\nCalling NSSSReadSharedSecret\n");
			
					rcode = NSSSReadSharedSecret(handle, &shSecret, &ctx, &targetObjDN, pFlag, NULL, &rInfo, NULL);
					
					if(rcode != NSSS_SUCCESS)
					{
						if((rcode != NSSS_E_STORE_NOT_FOUND) && (rcode != NSSS_E_INVALID_SECRET_ID))
						{
							printf("\nNSSSReadSharedSecret returned [%d] when reading [%s]\n\n", rcode, multiCredApp);
							Pause();
							goto ERROR_1;
						}
					}					

					for(i = 1; i < 6; i++)
					{
						strcpy(value, credSetNames[i-1]);
						printf("\nCalling NSSSRemoveSHSEntry\n");
						kLen = strlen(key)+1;
						vLen = strlen(value)+1;	
						if(!(rcode = NSSSRemoveSHSEntry(handle, key, value, ctx.flags)))
						{
							printf("\nRemoved [%s]:[%s]\n", key, value);
						}
						else
						{
							printf("\nNSSSRemoveSHSEntry returned [%d] when removing [%s]:[%s] from [%s]\n\n", rcode, key, value, credSetNames[i-1]);
						}
					}
					
					// clear the buffers
					memset(key, 0, NSSS_MAX_SECRET_ID_LEN);
					memset(value, 0, NSSS_MAX_SECRET_BUF_LEN);
				
					printf("\nCalling NSSSWriteSharedSecret\n");
					
					if(rcode = NSSSWriteSharedSecret(handle, &shSecret, &ctx, &targetObjDN, pFlag, NULL, NULL))
					{
						printf("\nNSSSWriteSharedSecret returned [%d] when storing data in\n[%s]\n\n", rcode, multiCredApp);
						Pause();
						goto ERROR_1;
					}
					else
					{
						printf("\nNSSSWriteSharedSecret SUCCEEDED\n");
					}
					
					rcode = NSSSDestroySHSHandle(handle);
				}
			}

			memset(key, 0, NSSS_MAX_SECRET_ID_LEN);
			memset(value, 0, NSSS_MAX_SECRET_BUF_LEN);


			if(bMultiCredTest)
			{
				//////////////////////////////////////////////////////
				// run the REMOVE the Credential Set Test Secrets test
				//////////////////////////////////////////////////////
				if(aFlag)
				{
					printf("\nDo you want to REMOVE the Credential Set Test Secrets(y/n)?\n");
					c = getch();
					putchar(c);
					printf("\n\n");
				}
				else
				{
					c = 'y';
				}

				if(c == 'y' || c == 'Y')
				{
					for(i = 1; i < 6; i++)
					{
						strcpy(shSecret.pName, credSetNames[i-1]);
						shSecret.type = SS_CREDENTIAL_TYPE_F; 

						// remove one secret at a time 
						if(rcode = NSSSRemoveSharedSecret(&shSecret, &ctx, &targetObjDN, pFlag, NULL))
						{
							printf("NSSSRemoveSharedSecret returned [%d] when removing [%s]\n\n", rcode, shSecret.pName);
							Pause();
						}
						else
						{
							printf("\nRemoved [%s]\n", credSetNames[i-1]);
						}
						
						memset(shSecret.pName, 0, NSSS_MAX_SECRET_ID_LEN);
					}
				}
			}



			if(bAppTest)
			{
				///////////////////////////////////////////////////
				// run the REMOVE the Application Test Secrets test
				///////////////////////////////////////////////////
				if(aFlag)
				{
					printf("\nDo you want to REMOVE the Application Test Secrets(y/n)? ");
					c = getch();
					putchar(c);
					printf("\n\n");
				}
				else
				{
					c = 'y';
				}

				if(c == 'y' || c == 'Y')
				{
					// Remove only the Application SharedSecrets we added.
					for(i = 1; i < 6; i++)
					{
						strcpy(shSecret.pName, appNames[i-1]);
						shSecret.type = SS_APPLICATION_TYPE_F; 
						// remove one secret at a time 
						if(rcode = NSSSRemoveSharedSecret(&shSecret, &ctx, &targetObjDN, pFlag, NULL))
						{
							printf("NSSSRemoveSharedSecret returned [%d] when removing [%s]\n\n", rcode, shSecret.pName);
							Pause();
						}

						else
						{
							printf("\nRemoved [%s]\n", appNames[i-1]);
						}
						
						memset(shSecret.pName, 0, NSSS_MAX_SECRET_ID_LEN);
					}
				}
			}



			if(bAppTest)
			{
				///////////////////////////////////////////////////////////////
				// run the REMOVE the multiple CredSet Application Test Secret
				///////////////////////////////////////////////////////////////
				if(aFlag)
				{
					printf("\nDo you want to REMOVE the multiple CredSet Application Test Secret(y/n)?\n");
					c = getch();
					putchar(c);
					printf("\n\n");
				}
				else
				{
					c = 'y';
				}

				if(c == 'y' || c == 'Y')
				{
					strcpy(shSecret.pName, multiCredApp);
					shSecret.type = SS_APPLICATION_TYPE_F; 
					// remove one secret at a time 
					if(rcode = NSSSRemoveSharedSecret(&shSecret, &ctx, &targetObjDN, pFlag, NULL))
					{
						printf("NSSSRemoveSharedSecret returned [%d] when removing [%s]\n\n", rcode, shSecret.pName);
						Pause();
					}
					else
					{
						printf("\nRemoved [%s]\n", multiCredApp);
					}
					
					memset(shSecret.pName, 0, NSSS_MAX_SECRET_ID_LEN);
				}
			}




			if(bMultiEntryTest)
			{
				/////////////////////////////////////////////////////////////
				// run the REMOVE the multiple entry Application Test Secret
				/////////////////////////////////////////////////////////////
				if(aFlag)
				{
					printf("\nDo you want to REMOVE the multiple entry Application Test Secret(y/n)?\n");
					c = getch();
					putchar(c);
					printf("\n\n");
				}
				else
				{
					c = 'y';
				}

				if(c == 'y' || c == 'Y')
				{
					strcpy(shSecret.pName, multiEntryCredSet);
					shSecret.type = SS_CREDENTIAL_TYPE_F; 
					// remove one secret at a time 
					if(rcode = NSSSRemoveSharedSecret(&shSecret, &ctx, &targetObjDN, pFlag, NULL))
					{
						printf("NSSSRemoveSharedSecret returned [%d] when removing [%s]\n\n", rcode, shSecret.pName);
						Pause();
					}
					else
					{
						printf("\nRemoved [%s]\n", multiEntryCredSet);
					}
					
					memset(shSecret.pName, 0, NSSS_MAX_SECRET_ID_LEN);
				}
			}


			if(bUTF8Test)
			{
				/////////////////////////////////////////////////
				// run the REMOVE the UTF8 Credential Test Secret
				/////////////////////////////////////////////////
				if(aFlag)
				{
					printf("\nDo you want to REMOVE the UTF8 Credential Test Secret(y/n)?\n");
					c = getch();
					putchar(c);
					printf("\n\n");
				}
				else
				{
					c = 'y';
				}

				if(c == 'y' || c == 'Y')
				{
					strcpy(shSecret.pName, UTF8TestID);
					shSecret.type = SS_CREDENTIAL_TYPE_F; 
					// remove one secret at a time 
					if(rcode = NSSSRemoveSharedSecret(&shSecret, &ctx, &targetObjDN, pFlag, NULL))
					{
						printf("NSSSRemoveSharedSecret returned [%d] when removing [%s]\n\n", rcode, shSecret.pName);
						Pause();
					}
					else
					{
						printf("\nRemoved [%s]\n", UTF8TestID);
					}
					
					memset(shSecret.pName, 0, NSSS_MAX_SECRET_ID_LEN);
				}
			}
	
		opCount++;


		printf("\n\n\n");

		printf("NUMBER OF THE LOOPS = %d\n", j+1);
		printf("NUMBER OF OPERATIONS COMPLETED = %d\n", opCount);

	} /* end for */

	endTime = time(NULL);

	printf("ELAPSED TIME IN SECONDS = [%ld]\n\n", (endTime - startTime));

/* ########################## CODE EXITS HERE ##################### */

ERROR_1:

	NSSSGetServiceInformation(&ctx, NULL, (pFlag | NSSS_DESTROY_CONTEXT_F), &gsInfo, NULL);

	Pause();

	exit(0);


/* ########################## CODE ENDS HERE ##################### */
}
