/*
 * Decompiled with CFR 0.152.
 */
package com.novell.security.sso;

import java.security.Permission;

public final class SSPermission
extends Permission {
    public static final String ADMIN = "admin";
    public static final String DEF_NAME = "SecretStore";
    public static final String READ = "read";
    public static final String WRITE = "write";
    private String acts;
    private boolean canAdmin;
    private boolean canRead;
    private boolean canWrite;

    public SSPermission(String actions) throws IllegalArgumentException {
        this(DEF_NAME, actions);
    }

    public SSPermission(String entry, String actions) throws IllegalArgumentException {
        super(entry);
        this.formatActions(actions);
    }

    public String getActions() {
        return this.acts;
    }

    public boolean equals(Object obj) {
        SSPermission ssp = (SSPermission)obj;
        return this.getName().equals(ssp.getName()) && this.acts.equals(ssp.getActions());
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public boolean implies(Permission permission) {
        if (permission instanceof SSPermission) {
            SSPermission perm = (SSPermission)permission;
            if (this.canAdmin) {
                return true;
            }
            if (!this.getName().equals(DEF_NAME) && !perm.getName().equals(this.getName())) {
                return false;
            }
            if (this.canRead && !this.canWrite && perm.canRead && !perm.canWrite) {
                return true;
            }
            if (this.canWrite && !this.canRead && perm.canWrite && !perm.canRead) {
                return true;
            }
            if (this.canRead && this.canWrite && (perm.canRead || perm.canWrite)) {
                return true;
            }
        }
        return false;
    }

    private void formatActions(String actions) throws IllegalArgumentException {
        boolean addComma = false;
        StringBuffer myacts = new StringBuffer();
        if ((actions = actions.toLowerCase()).indexOf(ADMIN) != -1 && this.getName().equals(DEF_NAME)) {
            myacts.append(ADMIN);
            this.canAdmin = true;
        } else {
            if (actions.indexOf(READ) != -1) {
                myacts.append(READ);
                addComma = true;
                this.canRead = true;
            }
            if (actions.indexOf(WRITE) != -1) {
                if (addComma) {
                    myacts.append(',');
                }
                myacts.append(WRITE);
                this.canWrite = true;
            }
        }
        if (myacts.length() == 0) {
            throw new IllegalArgumentException("Invalid Action Specification");
        }
        this.acts = myacts.toString();
    }
}

