/*
 * Decompiled with CFR 0.152.
 */
package com.novell.security.sso;

import com.novell.security.sso.SSException;
import java.io.Serializable;

public class SharedEntry
implements Cloneable,
Comparable,
Serializable {
    public static final char CREDENTIAL_DELIMITER = ':';
    public static final char NORMAL_DELIMITER = '=';
    protected String entryStr;
    protected boolean isCredSet;
    protected String key;
    protected String value;

    public SharedEntry(String key, String value) {
        if (key == null || key.length() == 0 || value == null) {
            throw new SSException(-849, "Invalid SharedEntry data");
        }
        this.key = key;
        this.value = value;
        this.isCredSet = key.equals("SS_CredSet");
    }

    public boolean isCredSet() {
        return this.isCredSet;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public int compareTo(Object obj) {
        if (obj instanceof SharedEntry && !this.isCredSet) {
            return this.key.toUpperCase().compareTo(((SharedEntry)obj).key.toUpperCase());
        }
        return this.toString().toUpperCase().compareTo(obj.toString().toUpperCase());
    }

    public boolean equals(Object obj) {
        if (obj instanceof SharedEntry) {
            if (this.isCredSet) {
                return this.toString().equalsIgnoreCase(obj.toString());
            }
            return this.key.equalsIgnoreCase(((SharedEntry)obj).key);
        }
        return false;
    }

    public static String escapeString(String unescapedString) {
        StringBuffer buffer = new StringBuffer(unescapedString.length() + 6);
        int i = 0;
        while (i < unescapedString.length()) {
            char c = unescapedString.charAt(i);
            switch (c) {
                case '\\': {
                    buffer.append("\\\\");
                    break;
                }
                case ':': {
                    buffer.append("\\:");
                    break;
                }
                case '=': {
                    buffer.append("\\=");
                    break;
                }
                default: {
                    buffer.append(c);
                }
            }
            ++i;
        }
        return buffer.toString();
    }

    public String getKey() {
        return this.key;
    }

    public String getValue() {
        return this.value;
    }

    public int hashCode() {
        if (this.isCredSet) {
            return this.toString().toUpperCase().hashCode();
        }
        return this.key.toUpperCase().hashCode();
    }

    public static SharedEntry parseEntry(String entryStr) throws SSException {
        if (entryStr == null) {
            throw new SSException(-849, "String is null");
        }
        boolean isDelimiterFound = false;
        StringBuffer keyBuff = new StringBuffer(entryStr.length());
        String value = "";
        int i = 0;
        while (i < entryStr.length()) {
            char c = entryStr.charAt(i);
            if (c == '\\') {
                if (i + 1 < entryStr.length() && ((c = entryStr.charAt(i + 1)) == '\\' || c == '=' || c == ':')) {
                    keyBuff.append(c);
                    ++i;
                }
            } else {
                if (c == '=' || c == ':') {
                    if (keyBuff.toString().equals("SS_CredSet") ? c != ':' : c != '=') {
                        throw new SSException(-849, "Invalid delimiter '" + c + '\'');
                    }
                    if (i + 1 < entryStr.length()) {
                        value = entryStr.substring(i + 1, entryStr.length());
                    }
                    isDelimiterFound = true;
                    break;
                }
                keyBuff.append(c);
            }
            ++i;
        }
        if (!isDelimiterFound) {
            throw new SSException(-849, "No valid delimiter in String");
        }
        String key = keyBuff.toString();
        if (key.length() > 0) {
            value = value.length() > 0 ? SharedEntry.unescapeString(value) : value;
            return new SharedEntry(key, value);
        }
        throw new SSException(-849, "No valid key in String");
    }

    public void setValue(String value) {
        String string = this.key;
        synchronized (string) {
            if (value == null) {
                throw new SSException(-849, "Invalid SharedEntry value");
            }
            this.value = value;
            this.entryStr = null;
        }
    }

    public String toString() {
        String string = this.key;
        synchronized (string) {
            if (this.entryStr == null) {
                StringBuffer buffer = new StringBuffer(this.key.length() + this.value.length() + 1);
                String escapedKey = this.isCredSet ? this.key : SharedEntry.escapeString(this.key);
                char delimiter = this.isCredSet ? (char)':' : '=';
                String escapedValue = SharedEntry.escapeString(this.value);
                buffer.append(escapedKey).append(delimiter).append(escapedValue);
                this.entryStr = buffer.toString();
            }
        }
        return this.entryStr;
    }

    public static String unescapeString(String escapedString) {
        StringBuffer buffer = new StringBuffer(escapedString.length());
        int i = 0;
        while (i < escapedString.length()) {
            char c = escapedString.charAt(i);
            if (c == '\\') {
                if (i + 1 < escapedString.length() && (c = escapedString.charAt(i + 1)) == '\\') {
                    buffer.append(c);
                    ++i;
                }
            } else {
                buffer.append(c);
            }
            ++i;
        }
        return buffer.toString();
    }
}

