/*
 * Decompiled with CFR 0.152.
 */
package com.novell.security.sso.ldap.ber;

import com.novell.ldap.asn1.ASN1OctetString;
import com.novell.security.sso.SSException;
import com.novell.security.sso.ldap.ber.ReadResponse;
import com.novell.security.sso.ldap.ber.SSRequest;
import java.io.IOException;
import java.util.Arrays;
import sun.io.CharToByteConverter;

public class ReadRequest
extends SSRequest {
    private transient char[] enhancePass;
    private String secretIdentifier;

    public ReadRequest(int flags, String objName, String secretID, char[] erPassword) {
        super("2.16.840.1.113719.1.148.100.3", flags, objName, false);
        this.secretIdentifier = secretID;
        this.enhancePass = erPassword;
        this.constructPacket();
    }

    public Object createExtendedResponse(String id, byte[] berValue) {
        return new ReadResponse(berValue);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void constructPacket() throws SSException {
        byte[] erbuf222;
        super.constructPacket(false);
        ASN1OctetString asn1_er = null;
        try {
            try {
                this.secretIdentifier = this.secretIdentifier + '\u0000';
                ASN1OctetString asn1_sec = new ASN1OctetString(this.secretIdentifier.getBytes("UTF-8"));
                this.asn1_seq.add(asn1_sec);
                if (this.enhancePass.length > 0) {
                    CharToByteConverter conv = CharToByteConverter.getConverter((String)"UTF-8");
                    char[] temppass = new char[this.enhancePass.length + 1];
                    System.arraycopy(this.enhancePass, 0, temppass, 0, this.enhancePass.length);
                    temppass[this.enhancePass.length] = '\u0000';
                    byte[] buf = conv.convertAll(temppass);
                    asn1_er = new ASN1OctetString(buf);
                    this.asn1_seq.add(asn1_er);
                }
                this.asn1_seq.encode(this.enc, this.out);
                if (this.packet != null) {
                    Arrays.fill(this.packet, (byte)0);
                }
                this.packet = this.out.toByteArray();
            }
            catch (IOException e) {
                throw new SSException(-849, (Throwable)e);
            }
            Object var7_7 = null;
            if (asn1_er == null) return;
            erbuf222 = asn1_er.byteValue();
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            if (asn1_er == null) throw throwable;
            byte[] erbuf222 = asn1_er.byteValue();
            Arrays.fill(erbuf222, (byte)0);
            throw throwable;
        }
        Arrays.fill(erbuf222, (byte)0);
    }
}

