/*
 * Decompiled with CFR 0.152.
 */
package com.novell.security.sso.ldap.ber;

import com.novell.ldap.asn1.ASN1OctetString;
import com.novell.security.sso.SSException;
import com.novell.security.sso.ldap.ber.SSRequest;
import java.io.IOException;
import java.util.Arrays;

public class RemSecRequest
extends SSRequest {
    private String secretIdentifier;

    public RemSecRequest(int flags, String objName, String secretID) {
        super("2.16.840.1.113719.1.148.100.9", flags, objName, false);
        this.secretIdentifier = secretID;
        this.constructPacket();
    }

    protected void constructPacket() throws SSException {
        super.constructPacket(false);
        try {
            this.secretIdentifier = this.secretIdentifier + '\u0000';
            ASN1OctetString asn1_sec = new ASN1OctetString(this.secretIdentifier.getBytes("UTF-8"));
            this.asn1_seq.add(asn1_sec);
            this.asn1_seq.encode(this.enc, this.out);
            if (this.packet != null) {
                Arrays.fill(this.packet, (byte)0);
            }
            this.packet = this.out.toByteArray();
        }
        catch (IOException e) {
            throw new SSException(-849, (Throwable)e);
        }
    }
}

