/*
 * Decompiled with CFR 0.152.
 */
package com.novell.security.sso.ldap.ber;

import com.novell.ldap.asn1.ASN1Integer;
import com.novell.ldap.asn1.ASN1OctetString;
import com.novell.ldap.asn1.ASN1Sequence;
import com.novell.ldap.asn1.LBEREncoder;
import com.novell.security.sso.SSException;
import com.novell.security.sso.ldap.ber.GetInfoResponse;
import com.novell.security.sso.ldap.ber.SSExtension;
import com.novell.security.sso.ldap.ber.SSResponse;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class SSRequest
extends SSExtension {
    protected transient ASN1Sequence asn1_seq = new ASN1Sequence();
    protected transient LBEREncoder enc = new LBEREncoder();
    protected transient ByteArrayOutputStream out = new ByteArrayOutputStream();
    private int flags;
    private String name;

    public SSRequest(String oid) {
        super(oid);
    }

    public SSRequest(String oid, int ssflags, String objName) {
        this(oid, ssflags, objName, true);
    }

    SSRequest(String oid, int ssflags, String objName, boolean autoConstruct) {
        this(oid);
        this.flags = ssflags | 0x10;
        this.name = objName;
        if (autoConstruct) {
            this.constructPacket(true);
        }
    }

    public Object createExtendedResponse(String id, byte[] berValue) {
        if (id.equalsIgnoreCase("2.16.840.1.113719.1.148.100.2")) {
            return new GetInfoResponse(berValue);
        }
        return new SSResponse(id, berValue);
    }

    protected void constructPacket(boolean autoConstruct) throws SSException {
        try {
            this.name = this.name + '\u0000';
            ASN1Integer asn1_ver = new ASN1Integer(772);
            ASN1Integer asn1_flags = new ASN1Integer(this.flags);
            ASN1OctetString asn1_dn = new ASN1OctetString(this.name.getBytes("UTF-8"));
            this.asn1_seq.add(asn1_ver);
            this.asn1_seq.add(asn1_flags);
            this.asn1_seq.add(asn1_dn);
            if (autoConstruct) {
                this.asn1_seq.encode(this.enc, this.out);
                this.packet = this.out.toByteArray();
            }
        }
        catch (IOException e) {
            throw new SSException(-849, (Throwable)e);
        }
    }

    protected void finalize() throws Throwable {
        try {
            this.out.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        super.finalize();
    }
}

