/*
 * Decompiled with CFR 0.152.
 */
package com.novell.security.sso.ldap.ber;

import com.novell.ldap.asn1.ASN1OctetString;
import com.novell.security.sso.SSException;
import com.novell.security.sso.ldap.ber.SSRequest;
import java.io.IOException;
import java.util.Arrays;
import sun.io.CharToByteConverter;

public class WriteRequest
extends SSRequest {
    private transient char[] enhancePass;
    private transient byte[] secret;
    private String secretIdentifier;

    public WriteRequest(int flags, String objName, String secretID, byte[] value, char[] erPassword) {
        super("2.16.840.1.113719.1.148.100.5", flags, objName, false);
        this.secretIdentifier = secretID;
        this.secret = value;
        this.enhancePass = erPassword;
        this.constructPacket();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void constructPacket() throws SSException {
        char[] temppass;
        block8: {
            byte[] erbuf2222;
            super.constructPacket(false);
            ASN1OctetString asn1_er = null;
            temppass = null;
            try {
                try {
                    this.secretIdentifier = this.secretIdentifier + '\u0000';
                    ASN1OctetString asn1_secid = new ASN1OctetString(this.secretIdentifier.getBytes("UTF-8"));
                    ASN1OctetString asn1_sec = new ASN1OctetString(this.secret);
                    this.asn1_seq.add(asn1_secid);
                    this.asn1_seq.add(asn1_sec);
                    if (this.enhancePass.length > 0) {
                        CharToByteConverter conv = CharToByteConverter.getConverter((String)"UTF-8");
                        temppass = new char[this.enhancePass.length + 1];
                        System.arraycopy(this.enhancePass, 0, temppass, 0, this.enhancePass.length);
                        temppass[this.enhancePass.length] = '\u0000';
                        byte[] buf = conv.convertAll(temppass);
                        asn1_er = new ASN1OctetString(buf);
                        this.asn1_seq.add(asn1_er);
                    }
                    this.asn1_seq.encode(this.enc, this.out);
                    if (this.packet != null) {
                        Arrays.fill(this.packet, (byte)0);
                    }
                    this.packet = this.out.toByteArray();
                }
                catch (IOException e) {
                    throw new SSException(-849, (Throwable)e);
                }
                Object var8_8 = null;
                if (asn1_er == null) break block8;
                erbuf2222 = asn1_er.byteValue();
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                if (asn1_er != null) {
                    byte[] erbuf2222 = asn1_er.byteValue();
                    Arrays.fill(erbuf2222, (byte)0);
                }
                if (temppass == null) throw throwable;
                Arrays.fill(temppass, '\u0000');
                throw throwable;
            }
            Arrays.fill(erbuf2222, (byte)0);
        }
        if (temppass == null) return;
        Arrays.fill(temppass, '\u0000');
    }
}

