/*
 * Decompiled with CFR 0.152.
 */
package com.novell.security.sso.ncp;

import com.novell.security.sso.SSException;
import com.novell.security.sso.Secret;
import com.novell.security.sso.SecretStore;
import com.novell.security.sso.ncp.SSOWrap;
import java.util.Arrays;

public final class NCPSecret
extends Secret {
    private String obj;
    private String tree;

    NCPSecret(String identifier, SecretStore secretStore) {
        super(identifier, secretStore);
        this.erPassword = new StringBuffer();
    }

    NCPSecret(String identifier, SecretStore secretStore, String objName, String treeName) {
        super(identifier, secretStore);
        this.obj = objName;
        this.tree = treeName;
        this.erPassword = new StringBuffer();
    }

    NCPSecret(String identifier, SecretStore secretStore, String objName, String treeName, StringBuffer masterPassword) {
        super(identifier, secretStore);
        this.obj = objName;
        this.tree = treeName;
        this.erPassword = masterPassword;
        this.ssFlags |= 1;
        this.ssFlags |= 0x20;
    }

    NCPSecret(String identifier, SecretStore secretStore, StringBuffer masterPassword) {
        super(identifier, secretStore);
        this.erPassword = masterPassword;
        this.ssFlags |= 1;
        this.ssFlags |= 0x20;
    }

    protected synchronized void create0(int flags) throws SSException {
        int rtn = SSOWrap.addSecretID(this.id, flags, this.obj, this.tree);
        if (rtn != 0) {
            throw new SSException(rtn);
        }
        this.isChanged = true;
    }

    protected synchronized void delete0(int flags) throws SSException {
        int rtn = SSOWrap.removeSecretID(this.id, flags, this.obj, this.tree);
        if (rtn != 0) {
            throw new SSException(rtn);
        }
    }

    protected synchronized void read0(int flags) throws SSException {
        this.isInitialized = true;
        String str = null;
        if (this.erPassword.length() > 0) {
            char[] tmp = new char[this.erPassword.length()];
            this.erPassword.getChars(0, this.erPassword.length(), tmp, 0);
            str = new String(tmp);
            Arrays.fill(tmp, '\u0000');
        } else {
            flags &= 0xFFFFFFBF;
            flags &= 0xFFFFFFDF;
        }
        int[] array = new int[5];
        byte[] secretBuf = SSOWrap.readSecret(this.id, flags, str, this.obj, this.tree, array);
        int idx = 0;
        this.status = array[idx++];
        this.crtTime = array[idx++];
        this.accTime = array[idx++];
        this.modTime = array[idx++];
        int err = array[idx];
        this.isChanged = false;
        if (err != 0) {
            if (err == -804 || err == -832 || err == -806 || err == -811) {
                this.getValueException = new SSException(err);
            } else {
                throw new SSException(err);
            }
        }
        if (secretBuf != null && secretBuf.length > 0) {
            Arrays.fill(this.secret, (byte)0);
            this.secret = secretBuf;
        }
    }

    protected synchronized void write0(byte[] value, int flags) throws SSException {
        int rtn;
        String str = null;
        if (this.erPassword.length() > 0) {
            char[] tmp = new char[this.erPassword.length()];
            this.erPassword.getChars(0, this.erPassword.length(), tmp, 0);
            str = new String(tmp);
            Arrays.fill(tmp, '\u0000');
        } else {
            flags &= 0xFFFFFFBF;
            flags &= 0xFFFFFFDF;
        }
        byte[] byArray = value;
        synchronized (byArray) {
            rtn = SSOWrap.writeSecret(this.id, flags, value, str, this.obj, this.tree);
        }
        if (rtn != 0) {
            throw new SSException(rtn);
        }
        this.isChanged = true;
    }
}

