/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap.asn1;

import com.novell.ldap.asn1.ASN1Boolean;
import com.novell.ldap.asn1.ASN1Encoder;
import com.novell.ldap.asn1.ASN1Identifier;
import com.novell.ldap.asn1.ASN1Null;
import com.novell.ldap.asn1.ASN1Numeric;
import com.novell.ldap.asn1.ASN1Object;
import com.novell.ldap.asn1.ASN1OctetString;
import com.novell.ldap.asn1.ASN1Structured;
import com.novell.ldap.asn1.ASN1Tagged;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class LBEREncoder
implements ASN1Encoder {
    public void encode(ASN1Boolean aSN1Boolean, OutputStream outputStream) throws IOException {
        this.encode(aSN1Boolean.getIdentifier(), outputStream);
        outputStream.write(1);
        outputStream.write(aSN1Boolean.booleanValue() ? -1 : 0);
    }

    public final void encode(ASN1Numeric aSN1Numeric, OutputStream outputStream) throws IOException {
        byte[] byArray = new byte[8];
        long l = aSN1Numeric.longValue();
        long l2 = l < 0L ? -1L : 0L;
        long l3 = l2 & 0x80L;
        int n = 0;
        while (n == 0 || l != l2 || (long)(byArray[n - 1] & 0x80) != l3) {
            byArray[n] = (byte)(l & 0xFFL);
            l >>= 8;
            n = (byte)(n + 1);
        }
        this.encode(aSN1Numeric.getIdentifier(), outputStream);
        outputStream.write(n);
        int n2 = n - 1;
        while (n2 >= 0) {
            outputStream.write(byArray[n2]);
            --n2;
        }
    }

    public final void encode(ASN1Null aSN1Null, OutputStream outputStream) throws IOException {
        this.encode(aSN1Null.getIdentifier(), outputStream);
        outputStream.write(0);
    }

    public final void encode(ASN1OctetString aSN1OctetString, OutputStream outputStream) throws IOException {
        this.encode(aSN1OctetString.getIdentifier(), outputStream);
        this.encodeLength(aSN1OctetString.byteValue().length, outputStream);
        outputStream.write(aSN1OctetString.byteValue());
    }

    public final void encode(ASN1Structured aSN1Structured, OutputStream outputStream) throws IOException {
        this.encode(aSN1Structured.getIdentifier(), outputStream);
        ASN1Object[] aSN1ObjectArray = aSN1Structured.toArray();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n = 0;
        while (n < aSN1ObjectArray.length) {
            aSN1ObjectArray[n].encode(this, byteArrayOutputStream);
            ++n;
        }
        this.encodeLength(byteArrayOutputStream.size(), outputStream);
        outputStream.write(byteArrayOutputStream.toByteArray());
    }

    public final void encode(ASN1Tagged aSN1Tagged, OutputStream outputStream) throws IOException {
        if (aSN1Tagged.isExplicit()) {
            this.encode(aSN1Tagged.getIdentifier(), outputStream);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            aSN1Tagged.taggedValue().encode(this, byteArrayOutputStream);
            this.encodeLength(byteArrayOutputStream.size(), outputStream);
            outputStream.write(byteArrayOutputStream.toByteArray());
        } else {
            aSN1Tagged.taggedValue().encode(this, outputStream);
        }
    }

    public final void encode(ASN1Identifier aSN1Identifier, OutputStream outputStream) throws IOException {
        int n = aSN1Identifier.getASN1Class();
        int n2 = aSN1Identifier.getTag();
        byte by = (byte)(n << 6 | (aSN1Identifier.getConstructed() ? 32 : 0));
        if (n2 < 30) {
            outputStream.write(by | n2);
        } else {
            outputStream.write(by | 0x1F);
            this.encodeTagInteger(n2, outputStream);
        }
    }

    private final void encodeLength(int n, OutputStream outputStream) throws IOException {
        if (n < 128) {
            outputStream.write(n);
        } else {
            byte[] byArray = new byte[4];
            int n2 = 0;
            while (n != 0) {
                byArray[n2] = (byte)(n & 0xFF);
                n >>= 8;
                n2 = (byte)(n2 + 1);
            }
            outputStream.write(0x80 | n2);
            int n3 = n2 - 1;
            while (n3 >= 0) {
                outputStream.write(byArray[n3]);
                --n3;
            }
        }
    }

    private final void encodeTagInteger(int n, OutputStream outputStream) throws IOException {
        byte[] byArray = new byte[5];
        int n2 = 0;
        while (n != 0) {
            byArray[n2] = (byte)(n & 0x7F);
            n >>= 7;
            ++n2;
        }
        int n3 = n2 - 1;
        while (n3 > 0) {
            outputStream.write(byArray[n3] | 0x80);
            --n3;
        }
        outputStream.write(byArray[0]);
    }
}

