/*
 * Decompiled with CFR 0.152.
 */
package com.novell.security.sso;

import com.novell.security.sso.SSException;
import com.novell.security.sso.SSPermission;
import com.novell.security.sso.SecretStore;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;

public abstract class Secret
implements Serializable {
    protected long accTime;
    protected long crtTime;
    protected transient StringBuffer erPassword;
    protected SSException getValueException;
    protected String id;
    protected transient boolean isInitialized;
    protected boolean isChanged;
    protected long modTime;
    protected transient byte[] secret;
    protected int ssFlags;
    protected int status;
    protected SecretStore store;

    protected Secret(String identifier, SecretStore secretStore) {
        this.id = identifier.intern();
        this.store = secretStore;
        this.secret = new byte[0];
        this.isChanged = true;
        this.ssFlags = 2;
    }

    public final void create() throws SSException {
        this.setCheckingSecretIDCollision(true);
    }

    public final void create(int flags) throws SSException {
        this.setCheckingSecretIDCollision(true);
    }

    protected abstract void create0(int var1) throws SSException;

    public final void delete() throws SSException {
        this.delete(0);
    }

    public final void delete(int flags) throws SSException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            try {
                sm.checkPermission(new SSPermission("write"));
            }
            catch (SecurityException e) {
                sm.checkPermission(new SSPermission(this.id, "write"));
            }
        }
        this.delete0(flags | this.ssFlags);
    }

    protected abstract void delete0(int var1) throws SSException;

    public boolean equals(Object obj) {
        if (obj instanceof Secret) {
            return this.id == ((Secret)obj).id;
        }
        return false;
    }

    public boolean exists() throws SSException {
        return this.exists(0);
    }

    public boolean exists(int flags) throws SSException {
        try {
            this.read(flags);
        }
        catch (SSException e) {
            int err = e.getErrorCode();
            switch (err) {
                case -832: 
                case -810: 
                case -806: {
                    return true;
                }
                case -813: 
                case -812: 
                case -802: {
                    return false;
                }
            }
            throw e;
        }
        return true;
    }

    protected void finalize() throws Throwable {
        if (this.erPassword != null && (0x400000 & this.getStatus()) != 0x400000) {
            SecretStore.clearBuffer(this.erPassword);
        }
        if (this.secret != null) {
            Arrays.fill(this.secret, (byte)0);
        }
    }

    public Date getAccessTime() throws SSException {
        if (!this.isInitialized) {
            this.read();
        }
        return new Date(this.accTime * 1000L);
    }

    public boolean getAutoCreateIDPolicy() {
        return true;
    }

    public Date getCreateTime() throws SSException {
        if (!this.isInitialized) {
            this.read();
        }
        return new Date(this.crtTime * 1000L);
    }

    public boolean getEnhancedProtectedPolicy() throws SSException {
        return this.isEnhancedProtected();
    }

    public Date getModifyTime() throws SSException {
        if (!this.isInitialized) {
            this.read();
        }
        return new Date(this.modTime * 1000L);
    }

    public int getStatus() throws SSException {
        if (this.isChanged) {
            this.read();
        }
        return this.status;
    }

    public byte[] getValue() throws SSException {
        if (!this.isInitialized) {
            this.read();
        }
        if (this.getValueException != null) {
            throw this.getValueException;
        }
        byte[] secbuf = new byte[this.secret.length];
        System.arraycopy(this.secret, 0, secbuf, 0, this.secret.length);
        return secbuf;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean isCheckingSecretIDCollision() {
        return (0x4000 & this.ssFlags) == 16384;
    }

    public boolean isEnhancedProtected() throws SSException {
        return (0x40000 & this.getStatus()) == 262144;
    }

    public boolean isEnhancedProtectedWithPassword() throws SSException {
        return (0x200000 & this.getStatus()) == 0x200000 || (0x400000 & this.getStatus()) == 0x400000;
    }

    public final void read() throws SSException {
        this.read(0);
    }

    public final void read(int flags) throws SSException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            try {
                sm.checkPermission(new SSPermission("read"));
            }
            catch (SecurityException e) {
                sm.checkPermission(new SSPermission(this.id, "read"));
            }
        }
        this.getValueException = null;
        flags |= this.ssFlags;
        flags &= 0xFFFFFFFD;
        this.read0(flags &= 0xFFFFBFFF);
    }

    protected abstract void read0(int var1) throws SSException;

    public void setAutoCreateIDPolicy(boolean policy) {
    }

    public void setCheckingSecretIDCollision(boolean policy) {
        this.ssFlags = policy ? (this.ssFlags |= 0x4000) : (this.ssFlags &= 0xFFFFBFFF);
    }

    public void setEnhancedProtected(boolean policy) {
        if (policy) {
            this.ssFlags |= 1;
        } else {
            this.ssFlags &= 0xFFFFFFFE;
            this.ssFlags &= 0xFFFFFFBF;
            this.ssFlags &= 0xFFFFFFDF;
        }
    }

    public void setEnhancedProtectedPolicy(boolean policy) {
        this.setEnhancedProtected(policy);
    }

    public void setEnhancedProtectionPassword(char[] erPass) {
        if (erPass == null) {
            throw new NullPointerException("erPass parameter null");
        }
        StringBuffer stringBuffer = this.erPassword;
        synchronized (stringBuffer) {
            if ((0x20 & this.ssFlags) == 32) {
                this.erPassword = new StringBuffer();
            } else {
                SecretStore.clearBuffer(this.erPassword);
            }
            this.erPassword.append(erPass);
            this.ssFlags |= 1;
            this.ssFlags |= 0x40;
            this.ssFlags &= 0xFFFFFFDF;
        }
    }

    public void setValue(byte[] value) throws SSException {
        this.setValue(value, 0);
    }

    public synchronized void setValue(byte[] value, int flags) throws SSException {
        this.write(value, flags);
        Arrays.fill(this.secret, (byte)0);
        if (value != null) {
            byte[] newsec = new byte[value.length];
            System.arraycopy(value, 0, newsec, 0, value.length);
            this.secret = newsec;
        } else {
            this.secret = new byte[0];
        }
    }

    public synchronized boolean sync(Secret targetSecret) throws SSException {
        Secret secret = targetSecret;
        synchronized (secret) {
            if (this.getModifyTime().getTime() != 0L) {
                if (this.getModifyTime().after(targetSecret.getModifyTime())) {
                    targetSecret.setValue(this.secret);
                    boolean bl = true;
                    return bl;
                }
            } else if (this.getCreateTime().after(targetSecret.getCreateTime())) {
                targetSecret.setValue(this.secret);
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    public String toString() {
        return this.id;
    }

    public void unsetEnhancedProtectionPassword() {
        if ((0x400000 & this.getStatus()) == 0x400000) {
            this.erPassword = new StringBuffer();
        } else {
            SecretStore.clearBuffer(this.erPassword);
        }
        this.ssFlags &= 0xFFFFFFBF;
        this.ssFlags &= 0xFFFFFFDF;
    }

    public void update(Secret targetSecret) throws SSException {
        this.update(targetSecret, 0);
    }

    public void update(Secret targetSecret, int flags) throws SSException {
        if (!this.isInitialized) {
            this.read();
        }
        targetSecret.setValue(this.secret, flags);
    }

    protected final void write(byte[] value, int flags) throws SSException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            try {
                sm.checkPermission(new SSPermission("write"));
            }
            catch (SecurityException e) {
                sm.checkPermission(new SSPermission(this.id, "write"));
            }
        }
        flags |= this.ssFlags;
        if (this.isCheckingSecretIDCollision()) {
            this.create0(flags &= 0xFFFFBFFF);
            this.write0(value, flags);
        } else {
            this.write0(value, flags);
        }
    }

    protected abstract void write0(byte[] var1, int var2) throws SSException;
}

