/*
 * Decompiled with CFR 0.152.
 */
package com.novell.security.sso;

import com.novell.security.sso.SSException;
import com.novell.security.sso.SSPermission;
import com.novell.security.sso.Secret;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.Date;
import java.util.Hashtable;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;

public abstract class SecretStore
implements Serializable {
    public static final String CALLER_DN = "com.novell.sso.callerdn";
    public static final String HANDLE = "com.novell.sso.handle";
    public static final String SECRET_STORE = "com.novell.sso.secretstore";
    public static final String SERVER_DN = "com.novell.sso.serverdn";
    public static final String TREE = "com.novell.sso.tree";
    public static final String TARGET_DN = "com.novell.sso.targetdn";
    public static final String USER_DN = "com.novell.sso.targetdn";
    protected byte clientCryptoStrength;
    protected int clientVersion;
    protected int enumBuffLen;
    protected Hashtable env;
    protected transient char[] hint = new char[0];
    protected transient boolean initialized;
    protected String lastAdminUnlockDn;
    protected long lastAdminUnlockTime;
    protected int lockCount;
    protected transient StringBuffer masterPassword = new StringBuffer();
    protected int secretCount;
    protected byte serverCryptoStrength;
    protected int serverVersion;
    protected int status;
    protected static ResourceBundle resourceBundle;

    protected SecretStore() {
    }

    public static final SecretStore getInstance(Hashtable env) throws ClassNotFoundException, IllegalArgumentException, SSException {
        Object obj;
        if (env == null) {
            throw new IllegalArgumentException("Environment properties not specified");
        }
        if (env.containsKey(SECRET_STORE)) {
            String storePath;
            if (env.get(SECRET_STORE).toString().equals("com.novell.security.sso.ldap.LdapSecretStore")) {
                env.put(SECRET_STORE, "com.novell.security.sso.ldap.jndi.JNDISecretStore");
                System.out.println("\"com.novell.security.sso.ldap.LdapSecretStore\" has been changed to \"com.novell.security.sso.ldap.jndi.JNDISecretStore\"");
            }
            if (!((obj = AccessController.doPrivileged(new PrivilegedAction(storePath = env.get(SECRET_STORE).toString()){
                private final /* synthetic */ String val$storePath;
                {
                    this.val$storePath = val$storePath;
                }

                public Object run() {
                    try {
                        return Class.forName(this.val$storePath);
                    }
                    catch (ClassNotFoundException e) {
                        return e;
                    }
                }
            })) instanceof Class)) {
                throw (ClassNotFoundException)obj;
            }
        } else {
            throw new IllegalArgumentException("\"com.novell.secretstore\" property not specified");
        }
        Class cls = (Class)obj;
        try {
            Class[] classes = new Class[]{env.getClass()};
            Constructor con = cls.getConstructor(classes);
            Object[] params = new Object[]{env};
            obj = con.newInstance(params);
            if (obj instanceof SecretStore) {
                return (SecretStore)obj;
            }
            throw new IllegalArgumentException("Invalid SecretStore Implementation: specified class not a subclass of com.novell.security.sso.SecretStore");
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t instanceof SSException) {
                throw (SSException)t;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            throw new IllegalArgumentException(t.getMessage());
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new IllegalArgumentException("Invalid SecretStore Implementation: " + e.getMessage());
        }
    }

    public final byte getClientCryptoStrength() throws SSException {
        if (!this.initialized) {
            this.getServiceInfo();
        }
        return this.clientCryptoStrength;
    }

    public final int getClientVersion() throws SSException {
        if (!this.initialized) {
            this.getServiceInfo();
        }
        return this.clientVersion;
    }

    public final int getEnumBuffLen() throws SSException {
        if (!this.initialized) {
            this.getServiceInfo();
        }
        return this.enumBuffLen;
    }

    public final Object getEnvironmentProperty(String key) {
        return this.env.get(key);
    }

    public final char[] getHint() throws SSException {
        SecurityManager sm;
        if (!this.initialized) {
            this.getServiceInfo();
        }
        if ((sm = System.getSecurityManager()) != null) {
            sm.checkPermission(new SSPermission("admin"));
        }
        char[] hintbuf = new char[this.hint.length];
        System.arraycopy(this.hint, 0, hintbuf, 0, this.hint.length);
        return hintbuf;
    }

    public final String getLastAdminUnlockDn() throws SSException {
        if (!this.initialized) {
            this.getServiceInfo();
        }
        return this.lastAdminUnlockDn;
    }

    public final Date getLastAdminUnlockTime() throws SSException {
        if (!this.initialized) {
            this.getServiceInfo();
        }
        return new Date(this.lastAdminUnlockTime * 1000L);
    }

    public final void setMasterPassword(char[] masterPword) {
        SecretStore.clearBuffer(this.masterPassword);
        this.masterPassword.append(masterPword);
    }

    public final int getNumLockedSecrets() throws SSException {
        if (!this.initialized) {
            this.getServiceInfo();
        }
        return this.lockCount;
    }

    public final int getNumSecrets() throws SSException {
        if (!this.initialized) {
            this.getServiceInfo();
        }
        return this.secretCount;
    }

    public final Secret getSecret(String id) {
        return this.getSecret(id, false);
    }

    public Secret getSecret(String id, boolean useMasterPassword) {
        if (id == null || id.length() == 0) {
            throw new IllegalArgumentException("The identifier may neither be null nor empty");
        }
        if (id.indexOf(42) >= 0) {
            throw new IllegalArgumentException("The identifier may not contain a '*' character");
        }
        return this.getSecret0(id, useMasterPassword);
    }

    protected abstract Secret getSecret0(String var1, boolean var2);

    public Secret[] getSecrets(int flags, String filter, int maxLen, boolean useMasterPassword) throws SSException {
        StringTokenizer tokenizer = this.enumerateSecrets(flags, filter, maxLen);
        Secret[] secrets = new Secret[tokenizer.countTokens()];
        int i = 0;
        while (i < secrets.length) {
            secrets[i] = this.getSecret(tokenizer.nextToken(), useMasterPassword);
            ++i;
        }
        return secrets;
    }

    public final byte getServerCryptoStrength() throws SSException {
        if (!this.initialized) {
            this.getServiceInfo();
        }
        return this.serverCryptoStrength;
    }

    public final int getServerVersion() throws SSException {
        if (!this.initialized) {
            this.getServiceInfo();
        }
        return this.serverVersion;
    }

    public final void getServiceInfo() throws SSException {
        this.getServiceInfo(0);
    }

    public final void getServiceInfo(int flags) throws SSException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new SSPermission("read"));
        }
        this.getServiceInfo0(flags);
    }

    public final int getStatus() throws SSException {
        if (!this.initialized) {
            this.getServiceInfo();
        }
        return this.status;
    }

    public final void commitMasterPasswordChange() throws SSException {
        this.commitMasterPasswordChange(0, new char[0]);
    }

    public final void commitMasterPasswordChange(int flags) throws SSException {
        this.commitMasterPasswordChange(flags, new char[0]);
    }

    public final void commitMasterPasswordChange(int flags, char[] passhint) throws SSException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new SSPermission("admin"));
        }
        this.commitMasterPasswordChange0(flags, passhint);
    }

    public final StringTokenizer enumerateSecrets() throws SSException {
        return this.enumerateSecrets(0, "", 131072);
    }

    public final StringTokenizer enumerateSecrets(int flags, String filter) throws SSException {
        return this.enumerateSecrets(flags, filter, 131072);
    }

    public final StringTokenizer enumerateSecrets(int flags, String filter, int maxLen) throws SSException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new SSPermission("read"));
        }
        return this.enumerateSecrets0(flags, filter, maxLen);
    }

    public final void removeSecretStore() throws SSException {
        this.removeSecretStore(0);
    }

    public final void removeSecretStore(int flags) throws SSException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new SSPermission("admin"));
        }
        this.removeSecretStore0(flags);
    }

    public final int sync(SecretStore targetStore) throws SSException {
        return this.sync(targetStore, 0, "", 131072);
    }

    /*
     * Unable to fully structure code
     */
    public int sync(SecretStore targetStore, int flags, String filter, int maxLen) throws SSException {
        count = 0;
        lastexc = null;
        source = this.enumerateSecrets(flags, filter, maxLen);
        targetstr = "";
        try {
            target = targetStore.enumerateSecrets(flags, filter, maxLen);
            strbuf = new StringBuffer();
            while (target.hasMoreTokens()) {
                strbuf.append(target.nextToken());
            }
            targetstr = strbuf.toString();
            ** GOTO lbl32
        }
        catch (SSException e) {
            if (e.getErrorCode() == -813 || e.getErrorCode() == -802) ** GOTO lbl32
            throw e;
        }
lbl-1000:
        // 1 sources

        {
            str = source.nextToken();
            sourceSecret = this.getSecret(str);
            targetSecret = targetStore.getSecret(str);
            try {
                if (targetstr.indexOf(str) != -1) {
                    if (!sourceSecret.sync(targetSecret)) continue;
                    ++count;
                    continue;
                }
                sourceSecret.update(targetSecret);
                ++count;
                continue;
            }
            catch (SSException e) {
                if (e.hasRoot()) {
                    throw new SSException(e.getRoot(), sourceSecret.id);
                }
                lastexc = new SSException(e.getErrorCode(), SSException.generateMessage(e.getErrorCode()) + " " + sourceSecret.id);
            }
lbl32:
            // 6 sources

            ** while (source.hasMoreTokens())
        }
lbl33:
        // 1 sources

        if (lastexc != null) {
            throw lastexc;
        }
        return count;
    }

    public String toString() {
        return this.env.get("com.novell.sso.targetdn") + " " + this.getClass().getName();
    }

    public final void unlockSecretStore() throws IllegalArgumentException, SSException {
        this.unlockSecretStore(0);
    }

    public final void unlockSecretStore(int flags) throws IllegalArgumentException, SSException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new SSPermission("admin"));
        }
        this.unlockSecretStore0(flags);
    }

    public final void unlockSecretStore(int flags, char[] ndsPassword) throws SSException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new SSPermission("admin"));
        }
        this.unlockSecretStore0(flags, ndsPassword);
    }

    public final void unsetMasterPassword() {
        SecretStore.clearBuffer(this.masterPassword);
    }

    public final void update(SecretStore targetStore) throws SSException {
        this.update(targetStore, 0, "", 131072);
    }

    public void update(SecretStore targetStore, int flags, String filter, int maxLen) throws SSException {
        Secret[] secrets = this.getSecrets(flags, filter, maxLen, false);
        SSException lastexc = null;
        int i = 0;
        while (i < secrets.length) {
            try {
                Secret tempSecret = targetStore.getSecret(secrets[i].id);
                secrets[i].update(tempSecret);
            }
            catch (SSException e) {
                if (e.hasRoot()) {
                    throw new SSException(e.getRoot(), secrets[i].id);
                }
                lastexc = new SSException(e.getErrorCode(), SSException.generateMessage(e.getErrorCode()) + " " + secrets[i].id);
            }
            ++i;
        }
        if (lastexc != null) {
            throw lastexc;
        }
    }

    protected abstract void getServiceInfo0(int var1) throws SSException;

    protected abstract void commitMasterPasswordChange0(int var1, char[] var2) throws SSException;

    protected abstract StringTokenizer enumerateSecrets0(int var1, String var2, int var3) throws SSException;

    public boolean equals(Object obj) {
        return this.toString().equals(obj.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    protected abstract void removeSecretStore0(int var1) throws SSException;

    protected abstract void unlockSecretStore0(int var1) throws IllegalArgumentException, SSException;

    protected abstract void unlockSecretStore0(int var1, char[] var2) throws SSException;

    protected static final void clearBuffer(StringBuffer buf) {
        if (buf != null) {
            StringBuffer stringBuffer = buf;
            synchronized (stringBuffer) {
                int i = 0;
                while (i < buf.length()) {
                    buf.setCharAt(i, '\u0000');
                    ++i;
                }
                buf.setLength(0);
            }
        }
    }

    protected void finalize() throws Throwable {
        SecretStore.clearBuffer(this.masterPassword);
        Arrays.fill(this.hint, '\u0000');
    }

    static {
        try {
            resourceBundle = ResourceBundle.getBundle("com.novell.security.sso.res.SecretStore");
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
    }
}

