/*
 * Decompiled with CFR 0.152.
 */
package com.novell.security.sso;

import com.novell.security.sso.SSException;
import com.novell.security.sso.Secret;
import com.novell.security.sso.SecretStore;
import com.novell.security.sso.SharedEntry;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class SharedSecret
extends Secret {
    public static final String APPLICATION_TYPE = "SS_App";
    public static final String CREDENTIAL_TYPE = "SS_CredSet";
    protected static final String APPLICATION_TYPE_UPPER = "SS_APP";
    protected static final String CREDENTIAL_TYPE_UPPER = "SS_CREDSET";
    static final String ENCODING = "UTF-16LE";
    private String secretType;
    private transient Set sharedData;
    private Secret wrapSecret;
    protected String name;

    public SharedSecret(Secret secret) {
        this(secret, true);
    }

    public SharedSecret(Secret secret, boolean isToAutoLoad) {
        super(secret.toString(), secret.store);
        this.wrapSecret = secret;
        String tmpId = this.id.toUpperCase();
        if (tmpId.startsWith(APPLICATION_TYPE_UPPER)) {
            this.secretType = APPLICATION_TYPE;
        } else if (tmpId.startsWith(CREDENTIAL_TYPE_UPPER)) {
            this.secretType = CREDENTIAL_TYPE;
        } else {
            throw new IllegalArgumentException("This secret is not a shared secret");
        }
        if (this.id.length() > this.secretType.length() + 1) {
            if (this.id.charAt(this.secretType.length()) != ':') {
                throw new IllegalArgumentException("This secret is not a shared secret");
            }
        } else {
            throw new IllegalArgumentException("This secret is not a shared secret");
        }
        this.name = SharedEntry.unescapeString(this.id.substring(this.secretType.length() + 1, this.id.length()));
        this.sharedData = new HashSet();
        if (isToAutoLoad) {
            try {
                this.read();
            }
            catch (SSException e) {
                // empty catch block
            }
        }
    }

    public SharedSecret(SecretStore secretStore, String secretType, String name) {
        this(secretStore, secretType, name, true);
    }

    public SharedSecret(SecretStore secretStore, String secretType, String name, boolean isToAutoLoad) {
        super(name, secretStore);
        if (secretStore == null) {
            throw new IllegalArgumentException("The secretStore may not be null");
        }
        String type = secretType.intern();
        if (type != APPLICATION_TYPE && type != CREDENTIAL_TYPE) {
            throw new IllegalArgumentException("Invalid secret type");
        }
        this.secretType = type;
        String escapedName = SharedEntry.escapeString(name);
        StringBuffer buffer = new StringBuffer(secretType.length() + escapedName.length() + 1);
        this.id = buffer.append(secretType).append(':').append(escapedName).toString();
        this.name = name;
        this.sharedData = new HashSet();
        this.wrapSecret = secretStore.getSecret0(this.id, false);
        if (isToAutoLoad) {
            try {
                this.read();
            }
            catch (SSException e) {
                // empty catch block
            }
        }
    }

    public Date getAccessTime() throws SSException {
        return this.wrapSecret.getAccessTime();
    }

    public Date getCreateTime() throws SSException {
        return this.wrapSecret.getCreateTime();
    }

    public Set getCredSetEntries() throws SSException {
        if (!this.isInitialized) {
            this.read();
        }
        HashSet<SharedEntry> credSets = new HashSet<SharedEntry>(this.sharedData.size());
        Iterator iterator = this.sharedData.iterator();
        while (iterator.hasNext()) {
            SharedEntry entry = (SharedEntry)iterator.next();
            if (!entry.isCredSet()) continue;
            credSets.add(entry);
        }
        return Collections.unmodifiableSet(credSets);
    }

    public Collection getEntries() throws SSException {
        if (!this.isInitialized) {
            this.read();
        }
        return Collections.unmodifiableCollection(this.sharedData);
    }

    public SharedEntry getEntry(String key) throws SSException {
        SharedEntry tempEntry;
        if (!this.isInitialized) {
            this.read();
        }
        if (this.sharedData.contains(tempEntry = new SharedEntry(key, ""))) {
            Iterator iterator = this.sharedData.iterator();
            while (iterator.hasNext()) {
                SharedEntry entry = (SharedEntry)iterator.next();
                if (!tempEntry.equals(entry)) continue;
                return entry;
            }
        }
        return null;
    }

    public Date getModifyTime() throws SSException {
        return this.wrapSecret.getModifyTime();
    }

    public String getName() {
        return this.name;
    }

    public String getSecretType() {
        return this.secretType;
    }

    public boolean isCheckingSecretIDCollision() {
        return this.wrapSecret.isCheckingSecretIDCollision();
    }

    public static boolean isSharedSecret(Secret secret) {
        if (secret instanceof SharedSecret) {
            return true;
        }
        return SharedSecret.isSharedSecretIdentifier(secret.toString());
    }

    public static boolean isSharedSecretIdentifier(String identifier) {
        String id = identifier.toUpperCase();
        String secretType = null;
        if (id.startsWith(APPLICATION_TYPE_UPPER)) {
            secretType = APPLICATION_TYPE;
        } else if (id.startsWith(CREDENTIAL_TYPE_UPPER)) {
            secretType = CREDENTIAL_TYPE;
        } else {
            return false;
        }
        return id.length() > secretType.length() + 1 && id.charAt(secretType.length()) == ':';
    }

    public void setCheckingSecretIDCollision(boolean policy) {
        this.wrapSecret.setCheckingSecretIDCollision(policy);
    }

    public void setEnhancedProtectionPassword(char[] erPass) {
        this.wrapSecret.setEnhancedProtectionPassword(erPass);
    }

    public int getStatus() throws SSException {
        return this.wrapSecret.getStatus();
    }

    public byte[] getValue() throws SSException {
        return this.wrapSecret.getValue();
    }

    public void setValue() throws SSException {
        this.setValue(null);
    }

    public void addEntry(SharedEntry entry) {
        try {
            if (!this.isInitialized) {
                this.read();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (this.sharedData.contains(entry)) {
            this.sharedData.remove(entry);
        }
        this.sharedData.add(entry);
    }

    public void clearEntries() {
        this.sharedData.clear();
    }

    protected void create0(int flags) throws SSException {
    }

    public boolean equals(Object obj) {
        return this.wrapSecret.equals(obj);
    }

    public boolean exists() throws SSException {
        return this.wrapSecret.exists();
    }

    public int hashCode() {
        return this.wrapSecret.hashCode();
    }

    public void removeEntry(SharedEntry entry) {
        try {
            if (!this.isInitialized) {
                this.read();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.sharedData.remove(entry);
    }

    public void unsetEnhancedProtectionPassword() {
        this.wrapSecret.unsetEnhancedProtectionPassword();
    }

    public void update(Secret targetSecret, int flags) throws SSException {
        this.wrapSecret.update(targetSecret, flags);
    }

    protected void delete0(int flags) throws SSException {
        this.wrapSecret.delete(flags);
    }

    protected void read0(int flags) throws SSException {
        this.isInitialized = true;
        this.wrapSecret.read(flags);
        this.populateDataFromSecret(this.wrapSecret.getValue(), true);
    }

    protected void write0(byte[] value, int flags) throws SSException {
        try {
            this.wrapSecret.write(this.populateSecretFromData(value), flags);
        }
        catch (IOException e) {
            throw new SSException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void populateDataFromSecret(byte[] stuffedValue, boolean clearFlag) {
        if (clearFlag) {
            this.sharedData.clear();
        }
        ByteArrayInputStream bin = null;
        InputStreamReader reader = null;
        try {
            try {
                bin = new ByteArrayInputStream(stuffedValue);
                reader = new InputStreamReader((InputStream)bin, ENCODING);
                StringBuffer entryBuff = new StringBuffer(32);
                int c = reader.read();
                while (c != -1) {
                    SharedEntry entry;
                    String entryStr;
                    if (c == 0) {
                        entryStr = entryBuff.toString();
                        if (entryStr.length() > 0) {
                            entry = SharedEntry.parseEntry(entryStr);
                            this.addEntry(entry);
                        }
                        break;
                    }
                    if (c == 10) {
                        entryStr = entryBuff.toString();
                        if (entryStr.length() > 0) {
                            entry = SharedEntry.parseEntry(entryStr);
                            this.addEntry(entry);
                            entryBuff.setLength(0);
                        }
                    } else {
                        entryBuff.append((char)c);
                    }
                    c = reader.read();
                }
            }
            catch (IOException e) {
                throw new SSException(-848, (Throwable)e);
            }
            Object var10_10 = null;
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            try {
                if (reader != null) {
                    reader.close();
                }
                if (bin == null) throw throwable;
                bin.close();
                throw throwable;
            }
            catch (IOException e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException e) {}
        if (reader != null) {
            reader.close();
        }
        if (bin == null) return;
        bin.close();
        return;
    }

    protected byte[] populateSecretFromData(byte[] strippedValue) throws IOException {
        if (strippedValue != null) {
            this.populateDataFromSecret(strippedValue, true);
        }
        ByteArrayOutputStream bout = new ByteArrayOutputStream(this.sharedData.size() * 32);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)bout, ENCODING);
        boolean isFirst = true;
        Iterator iterator = this.sharedData.iterator();
        while (iterator.hasNext()) {
            if (isFirst) {
                isFirst = false;
            } else {
                writer.write(10);
            }
            SharedEntry entry = (SharedEntry)iterator.next();
            writer.write(entry.toString());
        }
        writer.write(0);
        writer.close();
        return bout.toByteArray();
    }
}

