/*
 * Decompiled with CFR 0.152.
 */
package com.novell.security.sso.ldap.ber;

import com.novell.ldap.asn1.ASN1Integer;
import com.novell.ldap.asn1.ASN1OctetString;
import com.novell.security.sso.SSException;
import com.novell.security.sso.ldap.ber.EnumResponse;
import com.novell.security.sso.ldap.ber.SSRequest;
import java.io.IOException;
import java.util.Arrays;

public class EnumRequest
extends SSRequest {
    private String filter;
    private int maxBufferSize;

    public EnumRequest(int flags, String objName, String searchStr, int maxBuffSize) {
        super("2.16.840.1.113719.1.148.100.13", flags, objName, false);
        this.filter = searchStr.length() == 0 ? "*" : searchStr;
        this.maxBufferSize = maxBuffSize;
        this.constructPacket();
    }

    public Object createExtendedResponse(String id, byte[] berValue) {
        return new EnumResponse(berValue);
    }

    protected void constructPacket() throws SSException {
        super.constructPacket(false);
        try {
            this.filter = this.filter + '\u0000';
            ASN1OctetString asn1_search = new ASN1OctetString(this.filter.getBytes("UTF-8"));
            ASN1Integer asn1_size = new ASN1Integer(this.maxBufferSize);
            this.asn1_seq.add(asn1_search);
            this.asn1_seq.add(asn1_size);
            this.asn1_seq.encode(this.enc, this.out);
            if (this.packet != null) {
                Arrays.fill(this.packet, (byte)0);
            }
            this.packet = this.out.toByteArray();
        }
        catch (IOException e) {
            throw new SSException(-849, (Throwable)e);
        }
    }
}

