/*
 * Decompiled with CFR 0.152.
 */
package com.novell.security.sso.ldap.ber;

import com.novell.ldap.asn1.ASN1Integer;
import com.novell.ldap.asn1.ASN1Object;
import com.novell.ldap.asn1.ASN1OctetString;
import com.novell.ldap.asn1.ASN1Sequence;
import com.novell.ldap.asn1.LBERDecoder;
import com.novell.security.sso.SSException;
import com.novell.security.sso.ldap.ber.SSExtension;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import sun.io.ByteToCharConverter;

public class SSResponse
extends SSExtension {
    protected transient ASN1Sequence asn1_seq;
    protected transient LBERDecoder dec;
    protected transient int error;
    protected transient ByteArrayInputStream in;
    protected int packetIdx;

    public SSResponse(String oid, byte[] packet) throws SSException {
        super(oid);
        this.in = new ByteArrayInputStream(packet);
        this.asn1_seq = new ASN1Sequence();
        this.dec = new LBERDecoder();
        try {
            this.asn1_seq = (ASN1Sequence)this.dec.decode(this.in);
            this.parsePacket();
        }
        catch (Exception e) {
            System.out.println("response: " + oid + " packet: " + this.asn1_seq.toString());
            e.printStackTrace();
            throw new SSException(-849, (Throwable)e);
        }
    }

    public int getErrorCode() {
        return this.error;
    }

    protected static char[] formatString(ASN1OctetString asn1_string) throws IOException {
        ByteToCharConverter conv = ByteToCharConverter.getConverter((String)"UTF-8");
        char[] buff = conv.convertAll(asn1_string.byteValue());
        if (buff != null) {
            int i = 0;
            while (i < buff.length) {
                if (buff[i] == '\u0000') {
                    char[] newbuff = new char[i];
                    System.arraycopy(buff, 0, newbuff, 0, i);
                    return newbuff;
                }
                ++i;
            }
        }
        return buff == null ? buff : new char[]{};
    }

    protected void parsePacket() throws IOException {
        ASN1Object obj;
        int size = this.asn1_seq.size();
        if (this.packetIdx < size && this.asn1_seq.get(this.packetIdx) instanceof ASN1Integer && (obj = this.asn1_seq.get(this.packetIdx)) instanceof ASN1Integer) {
            this.error = ((ASN1Integer)obj).intValue();
            ++this.packetIdx;
        }
    }
}

