/*
 * Decompiled with CFR 0.152.
 */
package com.novell.security.sso.ldap.jndi;

import com.novell.security.sso.SSException;
import com.novell.security.sso.Secret;
import com.novell.security.sso.SecretStore;
import com.novell.security.sso.ldap.ber.AddRequest;
import com.novell.security.sso.ldap.ber.ReadRequest;
import com.novell.security.sso.ldap.ber.ReadResponse;
import com.novell.security.sso.ldap.ber.RemSecRequest;
import com.novell.security.sso.ldap.ber.SSResponse;
import com.novell.security.sso.ldap.ber.WriteRequest;
import com.novell.security.sso.ldap.jndi.JNDISecretStore;
import java.util.Arrays;
import javax.naming.NamingException;
import javax.naming.ldap.LdapContext;

public final class JNDISecret
extends Secret {
    private transient LdapContext ctx;
    private String name;

    JNDISecret(String identifier, SecretStore secretStore, LdapContext context, String objName) {
        super(identifier, secretStore);
        this.ctx = context;
        this.name = objName;
        this.erPassword = new StringBuffer();
    }

    JNDISecret(String identifier, SecretStore secretStore, LdapContext context, String objName, StringBuffer masterPword) {
        super(identifier, secretStore);
        this.ctx = context;
        this.name = objName;
        this.erPassword = masterPword;
        this.ssFlags |= 1;
        this.ssFlags |= 0x20;
    }

    protected synchronized void create0(int flags) throws SSException {
        try {
            AddRequest internal = new AddRequest(flags, this.name, this.id);
            JNDISecretStore.InternalRequest req = new JNDISecretStore.InternalRequest(internal.getID(), internal.getEncodedValue());
            JNDISecretStore.InternalResponse tempResp = (JNDISecretStore.InternalResponse)this.ctx.extendedOperation(req);
            SSResponse resp = new SSResponse(tempResp.getID(), tempResp.getEncodedValue());
            if (resp.getErrorCode() != 0) {
                throw new SSException(resp.getErrorCode());
            }
            this.isChanged = true;
        }
        catch (NullPointerException e) {
            this.isChanged = true;
        }
        catch (NamingException e) {
            throw new SSException(JNDISecretStore.checkException(e));
        }
    }

    protected synchronized void delete0(int flags) throws SSException {
        try {
            RemSecRequest internal = new RemSecRequest(flags, this.name, this.id);
            JNDISecretStore.InternalRequest req = new JNDISecretStore.InternalRequest(internal.getID(), internal.getEncodedValue());
            JNDISecretStore.InternalResponse tempResp = (JNDISecretStore.InternalResponse)this.ctx.extendedOperation(req);
            SSResponse resp = new SSResponse(tempResp.getID(), tempResp.getEncodedValue());
            if (resp.getErrorCode() != 0) {
                throw new SSException(resp.getErrorCode());
            }
            this.isChanged = true;
        }
        catch (NullPointerException e) {
            this.isChanged = true;
        }
        catch (NamingException e) {
            throw new SSException(JNDISecretStore.checkException(e));
        }
    }

    protected synchronized void read0(int flags) throws SSException {
        this.isInitialized = true;
        char[] newBuf = new char[this.erPassword.length()];
        if (newBuf.length > 0) {
            this.erPassword.getChars(0, newBuf.length, newBuf, 0);
        } else {
            flags &= 0xFFFFFFBF;
            flags &= 0xFFFFFFDF;
        }
        try {
            try {
                ReadRequest internal = new ReadRequest(flags, this.name, this.id, newBuf);
                JNDISecretStore.InternalRequest req = new JNDISecretStore.InternalRequest(internal.getID(), internal.getEncodedValue());
                JNDISecretStore.InternalResponse tempResp = (JNDISecretStore.InternalResponse)this.ctx.extendedOperation(req);
                ReadResponse resp = new ReadResponse(tempResp.getEncodedValue());
                this.status = resp.getStatFlags();
                this.accTime = resp.getAccessedTime();
                this.crtTime = resp.getCreatedTime();
                this.modTime = resp.getModifiedTime();
                this.isChanged = false;
                int err = resp.getErrorCode();
                if (err != 0) {
                    if (err == -804 || err == -832 || err == -806 || err == -811) {
                        this.getValueException = new SSException(err);
                    } else {
                        throw new SSException(err);
                    }
                }
                Arrays.fill(this.secret, (byte)0);
                this.secret = resp.getSecretValue();
            }
            catch (NamingException e) {
                throw new SSException(JNDISecretStore.checkException(e));
            }
            Object var9_9 = null;
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            Arrays.fill(newBuf, ' ');
            throw throwable;
        }
        Arrays.fill(newBuf, ' ');
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected synchronized void write0(byte[] value, int flags) throws SSException {
        block9: {
            char[] newBuf = new char[this.erPassword.length()];
            if (newBuf.length > 0) {
                this.erPassword.getChars(0, newBuf.length, newBuf, 0);
            } else {
                flags &= 0xFFFFFFBF;
                flags &= 0xFFFFFFDF;
            }
            try {
                try {
                    WriteRequest internal = new WriteRequest(flags, this.name, this.id, value, newBuf);
                    JNDISecretStore.InternalRequest req = new JNDISecretStore.InternalRequest(internal.getID(), internal.getEncodedValue());
                    JNDISecretStore.InternalResponse tempResp = (JNDISecretStore.InternalResponse)this.ctx.extendedOperation(req);
                    SSResponse resp = new SSResponse(tempResp.getID(), tempResp.getEncodedValue());
                    if (resp.getErrorCode() != 0) {
                        throw new SSException(resp.getErrorCode());
                    }
                    Object var9_10 = null;
                }
                catch (NullPointerException e) {
                    this.isChanged = true;
                    Object var9_11 = null;
                    Arrays.fill(newBuf, ' ');
                    break block9;
                }
                catch (NamingException e) {
                    throw new SSException(JNDISecretStore.checkException(e));
                }
            }
            catch (Throwable throwable) {
                Object var9_12 = null;
                Arrays.fill(newBuf, ' ');
                throw throwable;
            }
            Arrays.fill(newBuf, ' ');
        }
        this.isChanged = true;
    }
}

