/*
 * Decompiled with CFR 0.152.
 */
package com.novell.security.sso.ncp;

import com.novell.security.sso.SSException;
import com.novell.security.sso.Secret;
import com.novell.security.sso.SecretStore;
import com.novell.security.sso.ncp.NCPSecret;
import com.novell.security.sso.ncp.SSOWrap;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.StringTokenizer;

public final class NCPSecretStore
extends SecretStore {
    public NCPSecretStore(Hashtable environment) throws SSException {
        try {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    System.loadLibrary("nwsso");
                    return null;
                }
            });
        }
        catch (UnsatisfiedLinkError e) {
            throw new SSException(e, "- Cannot find nwsso.dll.");
        }
        this.env = (Hashtable)environment.clone();
    }

    public synchronized Secret getSecret0(String id, boolean useMasterPassword) {
        if (useMasterPassword) {
            return new NCPSecret(id, this, (String)this.env.get("com.novell.sso.targetdn"), (String)this.env.get("com.novell.sso.tree"), this.masterPassword);
        }
        return new NCPSecret(id, this, (String)this.env.get("com.novell.sso.targetdn"), (String)this.env.get("com.novell.sso.tree"));
    }

    protected synchronized void getServiceInfo0(int flags) throws SSException {
        String tempTree;
        this.initialized = true;
        String[] strings = new String[5];
        int[] array = new int[10];
        String tempUserDn = this.env.containsKey("com.novell.sso.targetdn") ? this.env.get("com.novell.sso.targetdn").toString() : null;
        int rtn = SSOWrap.getServiceInfo(flags, tempUserDn, tempTree = this.env.containsKey("com.novell.sso.tree") ? this.env.get("com.novell.sso.tree").toString() : null, strings, array);
        if (rtn != 0) {
            throw new SSException(rtn);
        }
        int i = 0;
        while (i < strings.length) {
            int nullIdx;
            if (strings[i] != null && (nullIdx = strings[i].indexOf(0)) > 0) {
                strings[i] = strings[i].substring(0, nullIdx);
            }
            ++i;
        }
        int idx = 0;
        if (strings[idx] != null) {
            this.env.put("com.novell.sso.callerdn", strings[idx]);
        }
        if (strings[++idx] != null) {
            this.env.put("com.novell.sso.serverdn", strings[idx]);
        }
        if (strings[++idx] != null) {
            this.env.put("com.novell.sso.tree", strings[idx]);
        }
        if (strings[++idx] != null) {
            if (this.hint != null) {
                Arrays.fill(this.hint, '\u0000');
            }
            this.hint = new char[strings[idx].length()];
            strings[idx].getChars(0, strings[idx].length(), this.hint, 0);
        }
        if (strings[++idx] != null) {
            this.lastAdminUnlockDn = strings[idx];
        }
        idx = 0;
        this.clientVersion = array[idx++];
        this.serverVersion = array[idx++];
        this.clientCryptoStrength = (byte)array[idx++];
        this.serverCryptoStrength = (byte)array[idx++];
        this.status = array[idx++];
        this.secretCount = array[idx++];
        this.lockCount = array[idx++];
        this.enumBuffLen = array[idx++];
        this.lastAdminUnlockTime = array[idx++];
    }

    protected synchronized void commitMasterPasswordChange0(int flags, char[] passhint) throws SSException {
        int err;
        String str = null;
        if (this.masterPassword.length() > 0) {
            char[] tmp = new char[this.masterPassword.length()];
            this.masterPassword.getChars(0, this.masterPassword.length(), tmp, 0);
            str = new String(tmp);
            Arrays.fill(tmp, '\u0000');
        }
        if ((err = SSOWrap.setMasterPassword(flags, str, new String(passhint), (String)this.env.get("com.novell.sso.targetdn"), (String)this.env.get("com.novell.sso.tree"))) != 0) {
            throw new SSException(err);
        }
    }

    protected synchronized StringTokenizer enumerateSecrets0(int flags, String filter, int maxLen) throws SSException {
        Integer err = new Integer(0);
        String tokenString = SSOWrap.enumerateSecretIDs(flags, filter, maxLen, (String)this.env.get("com.novell.sso.targetdn"), (String)this.env.get("com.novell.sso.tree"), err);
        if (err != 0) {
            throw new SSException(err);
        }
        int nullIdx = tokenString.indexOf(0);
        if (nullIdx != -1) {
            tokenString = tokenString.substring(0, nullIdx);
        }
        return new StringTokenizer(tokenString, "*");
    }

    protected synchronized void removeSecretStore0(int flags) throws SSException {
        int rtn = SSOWrap.removeSecretStore(flags, (String)this.env.get("com.novell.sso.targetdn"), (String)this.env.get("com.novell.sso.tree"));
        if (rtn != 0) {
            throw new SSException(rtn);
        }
    }

    protected synchronized void unlockSecretStore0(int flags) throws SSException {
        String str = null;
        if ((flags & 4) != 4) {
            if (this.masterPassword == null) {
                throw new IllegalArgumentException("master password is null");
            }
            flags |= 0x20;
            if (this.masterPassword.length() > 0) {
                char[] tmp = new char[this.masterPassword.length()];
                this.masterPassword.getChars(0, this.masterPassword.length(), tmp, 0);
                str = new String(tmp);
                Arrays.fill(tmp, '\u0000');
            }
        }
        String[] hintBuf = new String[1];
        int err = SSOWrap.unlockSecrets(flags, str, (String)this.env.get("com.novell.sso.targetdn"), (String)this.env.get("com.novell.sso.tree"), hintBuf);
        if (err != 0) {
            throw new SSException(err);
        }
        if (hintBuf[0] != null) {
            Arrays.fill(this.hint, '\u0000');
            int nullIdx = hintBuf[0].indexOf(0);
            if (nullIdx > 0) {
                hintBuf[0] = hintBuf[0].substring(0, nullIdx);
            }
            this.hint = new char[hintBuf[0].length()];
            hintBuf[0].getChars(0, hintBuf[0].length(), this.hint, 0);
        }
    }

    protected synchronized void unlockSecretStore0(int flags, char[] ndsPassword) throws SSException {
        int err;
        if ((flags & 4) != 4) {
            if (ndsPassword == null) {
                throw new IllegalArgumentException("NDS Password is null");
            }
        } else if (ndsPassword == null) {
            ndsPassword = new char[]{};
        }
        String[] hintBuf = new String[1];
        char[] cArray = ndsPassword;
        synchronized (cArray) {
            err = SSOWrap.unlockSecrets(flags, new String(ndsPassword), (String)this.env.get("com.novell.sso.targetdn"), (String)this.env.get("com.novell.sso.tree"), hintBuf);
        }
        if (err != 0) {
            throw new SSException(err);
        }
        if (hintBuf[0] != null) {
            Arrays.fill(this.hint, '\u0000');
            int nullIdx = hintBuf[0].indexOf(0);
            if (nullIdx > 0) {
                hintBuf[0] = hintBuf[0].substring(0, nullIdx);
            }
            this.hint = new char[hintBuf[0].length()];
            hintBuf[0].getChars(0, hintBuf[0].length(), this.hint, 0);
        }
    }
}

