#/bin/bash

ACTIVE_MQ_VERSION_TARGET="5.15.9"
JAVA_DOWNLOAD_CODE="8.40.0.25-ca-jdk8.0.222"
JAVA_VERSION_TARGET="1.8.0_222"
POSTGRESQL_VERSION_TARGET="11.5.0"
TOMCAT_VERSION_TARGET="9.0.22"


ACTIVE_MQ_VALIDITY=( 
  ${ACTIVE_MQ_VALIDITY[@]}
  bin/activemq
)


JAVA_RETAIN_LIB=( 
  ${JAVA_RETAIN_LIB[@]}
  lib/security/cacerts
)

JAVA_VALIDITY=( 
  ${JAVA_VALIDITY[@]}
  bin/java
)


POSTGRESQL_VALIDITY_BIN=( 
  ${POSTGRESQL_VALIDITY_BIN[@]}
  createdb
  dropdb
  pg_dump
  pg_dumpall
  pg_restore
  psql
)

POSTGRESQL_VALIDITY_DATA=( 
  ${POSTGRESQL_VALIDITY_DATA[@]}
  pg_hba.conf
  postgresql.conf
)


TOMCAT_DISCARD=( 
  ${TOMCAT_DISCARD[@]}
  webapps/examples
  webapps/host-manager
  webapps/manager
  webapps/ROOT
)

TOMCAT_RETAIN_BIN=( 
  ${TOMCAT_RETAIN_BIN[@]}
  bin/setenv.sh
  bin/start-tomcat.sh
  bin/stop-tomcat.sh
)

TOMCAT_RETAIN_CONF=( 
  ${TOMCAT_RETAIN_CONF[@]}
  conf/*.jks
  conf/*.pkcs12
  conf/apps-truststore.pkcs12
  conf/context.xml
  conf/daas-logging.xml
  conf/global.properties
  conf/idmrptclient_logging.xml
  conf/idmrptcore_logging.xml
  conf/ig-client-logging.xml
  conf/ig-dtp-logging.xml
  conf/ig-server-logging.xml
  conf/ig-wf-logging.xml
  conf/internal.properties
  conf/ism-configuration.properties
  conf/logging.properties
  conf/rpt_mgt_cfg_hibernate.cfg.xml
  conf/server.xml
)

TOMCAT_RETAIN_LIB=( 
  ${TOMCAT_RETAIN_LIB[@]}
  lib/activemq-all-5.15.1.jar
  lib/commons-codec.jar
  lib/commons-logging.properties
  lib/idm-datasource-factory-uber.jar
  lib/logging.properties
  lib/msjdbc.jar
  lib/ojdbc.jar
  lib/ojdbc7.jar
  lib/osp-custom-resource.jar
  lib/postgresql-42.1.4.jar
  lib/sqljdbc42.jar
)

TOMCAT_RETAIN_WEBAPPS=( 
  ${TOMCAT_RETAIN_WEBAPPS[@]}
  webapps/api.war
  webapps/cx.war
  webapps/daas.war
  webapps/doc.war
  webapps/dtp.war
  webapps/IDMRPT.war
  webapps/IDMRPT-CORE.war
  webapps/osp.war
  webapps/ROOT.war
  webapps/rptdoc.war
  webapps/workflow-api.war
)

TOMCAT_VALIDITY=( 
  ${TOMCAT_VALIDITY[@]}
  bin
  conf
  LICENSE
  RELEASE-NOTES
  webapps
)

