. ${PSScriptRoot}\def_upgrade.ps1

${active_mq_loc_final} = "${ACTIVE_MQ_DEFAULT}"
${java_loc_final} = "${JAVA_DEFAULT}"
${postgresql_loc_final} = "${POSTGRESQL_PATH_DEFAULT}"
${tomcat_loc_final} = "${TOMCAT_DEFAULT}"

${postgresql_admin} = "${POSTGRESQL_ADMIN_DEFAULT}"
${postgresql_port} = "${POSTGRESQL_PORT_DEFAULT}"
${postgresql_server} = "${POSTGRESQL_SERVER_DEFAULT}"

${active_mq_summary_code} = ${SUMMARY_CODE_FAILED}
${java_summary_code} = ${SUMMARY_CODE_FAILED}
${postgresql_summary_code} = ${SUMMARY_CODE_FAILED}
${tomcat_summary_code} = ${SUMMARY_CODE_FAILED}


If (Test-Path ${FILE_TOMCAT}) {
  ${tomcat_summary_code} = ${SUMMARY_CODE_SKIPPED}
  ${do_please} = Read-Host "It appears you are ready to upgrade Tomcat. Shall we proceed? [y/N]"
  If ("${do_please}" -eq "y" -Or "${do_please}" -eq "Y") {
    ${tomcat_summary_code} = ${SUMMARY_CODE_FAILED}
    ${input_invalid} = ${TRUE}
    while (${input_invalid}) {
      ${tomcat_loc} = Read-Host "  Where is your Tomcat located? [${tomcat_loc_final}]"
      If ("${tomcat_loc}" -ne "") { ${tomcat_loc_final} = ${tomcat_loc} }
      ${result} = (Get-PathValidity ${tomcat_loc_final} ${TOMCAT_VALIDITY})
      If ($result -eq ${TRUE} ) {
        ${input_invalid} = ${FALSE}
        Wait-StopProcesses "Tomcat" "tomcat"

        # Rename older tomcat parent folder
        ${tomcat_loc_rename} = "${tomcat_loc_final}-${TIMESTAMP}"
        Write-Host "    Renaming existing Tomcat location as `"${tomcat_loc_rename}`""
        Move-Item -Path ${tomcat_loc_final} -Destination ${tomcat_loc_rename} -Force

        # Unpack the new Tomcat tar where the old Tomcat was
        Unzip ${FILE_TOMCAT} ${tomcat_loc_final}

        Discard-SpecificFiles "Tomcat" ${tomcat_loc_final} ${TOMCAT_DISCARD}
        Copy-OldFiles "Tomcat" ${tomcat_loc_rename} ${tomcat_loc_final} ${TOMCAT_RETAIN}
        Disable-AJPConnector ${tomcat_loc_final}

        ${tomcat_summary_code} = ${SUMMARY_CODE_COMPLETED}
        Show-Differences ${tomcat_loc_final} ${tomcat_loc_rename}
      }
    }
  }
} Else {
  Write-Host "  You need to supply '${FILE_TOMCAT}' before Tomcat can be upgraded"
  ${tomcat_summary_code} = ${SUMMARY_CODE_MISSED}
}


If (Test-Path ${FILE_ACTIVE_MQ}) {
  ${active_mq_summary_code} = ${SUMMARY_CODE_SKIPPED}
  ${do_please} = Read-Host "It appears you are ready to upgrade ActiveMQ. Shall we proceed? [y/N]"
  If ("${do_please}" -eq "y" -Or "${do_please}" -eq "Y") {
    ${active_mq_summary_code} = ${SUMMARY_CODE_FAILED}
    ${input_invalid} = ${TRUE}
    while (${input_invalid}) {
      ${active_mq_loc} = Read-Host "  Where is your ActiveMQ located? [${active_mq_loc_final}]"
      If ("${active_mq_loc}" -ne "") { ${active_mq_loc_final} = ${active_mq_loc} }
      ${result} = (Get-PathValidity ${active_mq_loc_final} ${ACTIVE_MQ_VALIDITY})
      If ($result -eq ${TRUE} ) {
        ${input_invalid} = ${FALSE}
        Get-ValidJavaPath
        Wait-StopProcesses "ActiveMQ" "activemq"

        # Rename older ActiveMQ parent folder
        ${active_mq_loc_rename} = "${active_mq_loc_final}-${TIMESTAMP}"
        Write-Host "    Renaming existing ActiveMQ location as `"${active_mq_loc_rename}`""
        Move-Item -Path ${active_mq_loc_final} -Destination ${active_mq_loc_rename} -Force

        # Unpack the new ActiveMQ tar where the old ActiveMQ was
        Unzip ${FILE_ACTIVE_MQ} ${active_mq_loc_final}

        # Store Java location within activemq.bat
        ((Get-Content -path "${active_mq_loc_final}\bin\activemq.bat" -Raw) -replace
          "if `"%JAVA_HOME%`" == `"`" goto noJavaHome",
          "if `"%JAVA_HOME%`" == `"`" set JAVA_HOME=${java_loc_final}") |
          Set-Content -Path "${active_mq_loc_final}\bin\activemq.bat"

        Copy-OldFiles "ActiveMQ" ${active_mq_loc_rename} ${active_mq_loc_final} ${ACTIVE_MQ_RETAIN}

        ${active_mq_summary_code} = ${SUMMARY_CODE_COMPLETED}
        Show-Differences ${active_mq_loc_final} ${active_mq_loc_rename}
      }
    }
  }
} Else {
  Write-Host "  You need to supply '${FILE_ACTIVE_MQ}' before ActiveMQ can be upgraded"
  ${active_mq_summary_code} = ${SUMMARY_CODE_MISSED}
}


If (Test-Path ${FILE_JAVA}) {
  ${java_summary_code} = ${SUMMARY_CODE_SKIPPED}
  ${do_please} = Read-Host "It appears you are ready to upgrade Java. Shall we proceed? [y/N]"
  If ("${do_please}" -eq "y" -Or "${do_please}" -eq "Y") {
    ${java_summary_code} = ${SUMMARY_CODE_FAILED}
    Get-ValidJavaPath

    Wait-StopProcesses "Tomcat" "tomcat"
    Wait-StopProcesses "ActiveMQ" "activemq"

    # Make a link for copying files
    ${parent} = "$(Split-Path -Path ${java_loc_final} -Parent)"
    ${copy_link} = "${parent}\copier-${TIMESTAMP}"

    # Create a symbolic link for copying files
    ${item} = (Get-Item -Path ${java_loc_final})
    If (${item}.Attributes -match "ReparsePoint") {
      # A link will ultimately point to the new location
      ${copy_item} = (New-Item -ItemType SymbolicLink -Path "${copy_link}" -Target "$(Get-ResolvedPath ${item}.FullName)")
      ${item}.Delete()
    } Else {
      # A directory will need to be renamed since a link will replace it
      ${java_loc_rename} = "${java_loc_final}-${TIMESTAMP}"
      Rename-Item -Path ${java_loc_final} -NewName ${java_loc_rename} -Force
      ${copy_item} = (New-Item -ItemType SymbolicLink -Path "${copy_link}" -Target "${java_loc_rename}")
    }

    # Unpack Java into unique destination name (same path; jdk-timestamp)
    ${java_loc_jdk} = "${parent}\jdk"
    If (Test-Path ${java_loc_jdk}) {
      ${java_loc_jdk} = "${java_loc_jdk}-${TIMESTAMP}"
    }

    # Unpack the new Java tar where the old Java was
    Unzip ${FILE_JAVA} ${java_loc_jdk}

    # Create a symbolic link with the old name but new destination
    $null = (New-Item -ItemType SymbolicLink -Path "${java_loc_final}" -Target "${java_loc_jdk}\jre")
    Copy-OldFiles "Java" ${copy_link} ${java_loc_final} ${JAVA_RETAIN}

    ${java_summary_code} = ${SUMMARY_CODE_COMPLETED}
    Show-Differences "${java_loc_final}" "$(${copy_item}.Target)"

    # Remove copy-link
    ${copy_item}.Delete()
  }
} Else {
  Write-Host "  You need to supply '${FILE_JAVA}' before Java can be upgraded"
  ${java_summary_code} = ${SUMMARY_CODE_MISSED}
}


If (Test-Path ${FILE_POSTGRESQL}) {
  ${postgresql_summary_code} = ${SUMMARY_CODE_SKIPPED}
  ${do_please} = Read-Host "It appears you are ready to upgrade PostgreSQL. Shall we proceed? [y/N]"
  If ("${do_please}" -eq "y" -Or "${do_please}" -eq "Y") {
    ${postgresql_summary_code} = ${SUMMARY_CODE_FAILED}
    ${input_invalid} = ${TRUE}
    while (${input_invalid}) {
      ${postgresql_loc} = Read-Host "  Where is your PostgreSQL located? [${postgresql_loc_final}]"
      If ("${postgresql_loc}" -ne "") { ${postgresql_loc_final} = ${postgresql_loc} }
      ${result} = (Get-PathValidity ${postgresql_loc_final} ${POSTGRESQL_VALIDITY})
      If ($result -eq ${TRUE} ) {
        ${input_invalid} = ${FALSE}

        # Back up existing PostgreSQL data
        ${admin_temp} = Read-Host -Prompt "  Specify PostgreSQL admin username [${postgresql_admin}]"
        If ((${admin_temp} -ne ${null}) -and (${admin_temp}) -ne "") { ${postgresql_admin} = ${admin_temp} }

        ${private:PG_PWD_NEEDS_REMOVAL} = ${false}
        If (${env:PGPASSWORD} -eq ${null}) {
          ${private:PG_PWD_NEEDS_REMOVAL} = ${true}
          ${env:PGPASSWORD} = [System.Runtime.InteropServices.Marshal]::PtrToStringAuto(
            [System.Runtime.InteropServices.Marshal]::SecureStringToBSTR(
              $(Read-Host -Prompt "  Specify PostgreSQL admin password" -AsSecureString)
            )
          )
        } Else {
          Write-Host "  Reading PostgreSQL admin password from `"PGPASSWORD`" environment variable"
        }

        ${server_temp} = Read-Host -Prompt "  Specify PostgreSQL server [${postgresql_server}]"
        If ((${server_temp} -ne ${null}) -and (${server_temp}) -ne "") { ${postgresql_server} = ${server_temp} }

        ${port_temp} = Read-Host -Prompt "  Specify PostgreSQL port [${postgresql_port}]"
        If ((${port_temp} -ne ${null}) -and (${port_temp}) -ne "") { ${postgresql_port} = ${port_temp} }

        ${destination_files} = "${PSScriptRoot}\sql-${TIMESTAMP}"

        Backup-Databases `
          ${postgresql_admin} `
          ${postgresql_server} `
          ${postgresql_port} `
          ${postgresql_loc_final} `
          ${destination_files} `
          ${POSTGRESQL_DATABASES}

        # Stop and disable old PostgreSQL service
        Wait-StopServices "PostgreSQL" "postgres"
        Wait-DisableServices "PostgreSQL" "postgres"

        # Rename old PostgreSQL folder
        ${postgresql_loc_rename} = "${postgresql_loc_final}-${TIMESTAMP}"
        Write-Host "    Renaming existing PostgreSQL location as `"${postgresql_loc_rename}`""
        Move-Item -Path ${postgresql_loc_final} -Destination ${postgresql_loc_rename} -Force

        # Install PostgreSQL
        Write-Host "    Installing PostgreSQL using `"${FILE_POSTGRESQL}`""
        Write-Host (
          "    ",
          "Start-Process",
            "-FilePath ${FILE_POSTGRESQL}",
            "-Wait",
            "-NoNewWindow",
            "-ArgumentList",
              "`"--unattendedmodeui none`",",
              "`"--mode unattended`",",
              "`"--superaccount ${postgresql_admin}`",",
              "`"--superpassword *******`",",
              "`"--serverport ${postgresql_port}`",",
              "`"--prefix ${postgresql_loc_final}`",",
              "`"--datadir ${postgresql_loc_final}\data`""
        )
        Start-Process `
          -FilePath ${FILE_POSTGRESQL} `
          -Wait `
          -NoNewWindow `
          -ArgumentList `
            "--unattendedmodeui none", `
            "--mode unattended", `
            "--superaccount ${postgresql_admin}", `
            "--superpassword ${env:PGPASSWORD}", `
            "--serverport ${postgresql_port}", `
            "--prefix ${postgresql_loc_final}", `
            "--datadir ${postgresql_loc_final}\data"

        # Restore PostgreSQL data and files
        Copy-OldFiles "PostgreSQL" ${postgresql_loc_rename} ${postgresql_loc_final} ${POSTGRESQL_RETAIN_BIN}

        # Restart PostgreSQL service
        Get-Service -DisplayName "*postgres*" | Where-Object {($_.StartType -ne "Disable")} | Restart-Service -Force

        # Restore databases
        Restore-Databases `
          ${postgresql_admin} `
          ${postgresql_server} `
          ${postgresql_port} `
          ${postgresql_loc_final} `
          ${destination_files} `
          ${POSTGRESQL_DATABASES}

        # Remove PostgreSQL admin password if we set it
        If (${PG_PWD_NEEDS_REMOVAL}) {
          [System.Environment]::SetEnvironmentVariable("PGPASSWORD", $null)
        }

        ${postgresql_summary_code} = ${SUMMARY_CODE_COMPLETED}
        Show-Differences ${postgresql_loc_final} ${postgresql_loc_rename}
      }
    }
  }
} Else {
  Write-Host "  You need to supply '${FILE_POSTGRESQL}' before PostgreSQL can be upgraded"
  ${postgresql_summary_code} = ${SUMMARY_CODE_MISSED}
}


Summary-Register @("activemq", "java", "tomcat", "postgresql")
Summary-Print


# SIG # Begin signature block
# MIIdcwYJKoZIhvcNAQcCoIIdZDCCHWACAQExDzANBglghkgBZQMEAgEFADB5Bgor
# BgEEAYI3AgEEoGswaTA0BgorBgEEAYI3AgEeMCYCAwEAAAQQH8w7YFlLCE63JNLG
# KX7zUQIBAAIBAAIBAAIBAAIBADAxMA0GCWCGSAFlAwQCAQUABCAqOg7w9Q75KqzL
# InQvaHxvI2DrU7e3nuq1ZuG59r+eD6CCGFwwggO3MIICn6ADAgECAhAM5+DlF9hG
# /o/lYPwb8DA5MA0GCSqGSIb3DQEBBQUAMGUxCzAJBgNVBAYTAlVTMRUwEwYDVQQK
# EwxEaWdpQ2VydCBJbmMxGTAXBgNVBAsTEHd3dy5kaWdpY2VydC5jb20xJDAiBgNV
# BAMTG0RpZ2lDZXJ0IEFzc3VyZWQgSUQgUm9vdCBDQTAeFw0wNjExMTAwMDAwMDBa
# Fw0zMTExMTAwMDAwMDBaMGUxCzAJBgNVBAYTAlVTMRUwEwYDVQQKEwxEaWdpQ2Vy
# dCBJbmMxGTAXBgNVBAsTEHd3dy5kaWdpY2VydC5jb20xJDAiBgNVBAMTG0RpZ2lD
# ZXJ0IEFzc3VyZWQgSUQgUm9vdCBDQTCCASIwDQYJKoZIhvcNAQEBBQADggEPADCC
# AQoCggEBAK0OFc7kQ4BcsYfzt2D5cRKlrtwmlIiq9M71IDkoWGAM+IDaqRWVMmE8
# tbEohIqK3J8KDIMXeo+QrIrneVNcMYQq9g+YMjZ2zN7dPKii72r7IfJSYd+fINcf
# 4rHZ/hhk0hJbX/lYGDW8R82hNvlrf9SwOD7BG8OMM9nYLxj+KA+zp4PWw25EwGE1
# lhb+WZyLdm3X8aJLDSv/C3LanmDQjpA1xnhVhyChz+VtCshJfDGYM2wi6YfQMlqi
# uhOCEe05F52ZOnKh5vqk2dUXMXWuhX0irj8BRob2KHnIsdrkVxfEfhwOsLSSplaz
# vbKX7aqn8LfFqD+VFtD/oZbrCF8Yd08CAwEAAaNjMGEwDgYDVR0PAQH/BAQDAgGG
# MA8GA1UdEwEB/wQFMAMBAf8wHQYDVR0OBBYEFEXroq/0ksuCMS1Ri6enIZ3zbcgP
# MB8GA1UdIwQYMBaAFEXroq/0ksuCMS1Ri6enIZ3zbcgPMA0GCSqGSIb3DQEBBQUA
# A4IBAQCiDrzf4u3w43JzemSUv/dyZtgy5EJ1Yq6H6/LV2d5Ws5/MzhQouQ2XYFwS
# TFjk0z2DSUVYlzVpGqhH6lbGeasS2GeBhN9/CTyU5rgmLCC9PbMoifdf/yLil4Qf
# 6WXvh+DfwWdJs13rsgkq6ybteL59PyvztyY1bV+JAbZJW58BBZurPSXBzLZ/wvFv
# hsb6ZGjrgS2U60K3+owe3WLxvlBnt2y98/Efaww2BxZ/N3ypW2168RJGYIPXJwS+
# S86XvsNnKmgR34DnDDNmvxMNFG7zfx9jEB76jRslbWyPpbdhAbHSoyahEHGdreLD
# +cOZUbcrBwjOLuZQsqf6CkUvovDyMIIE/jCCA+agAwIBAgIQDUJK4L46iP9gQCHO
# FADw3TANBgkqhkiG9w0BAQsFADByMQswCQYDVQQGEwJVUzEVMBMGA1UEChMMRGln
# aUNlcnQgSW5jMRkwFwYDVQQLExB3d3cuZGlnaWNlcnQuY29tMTEwLwYDVQQDEyhE
# aWdpQ2VydCBTSEEyIEFzc3VyZWQgSUQgVGltZXN0YW1waW5nIENBMB4XDTIxMDEw
# MTAwMDAwMFoXDTMxMDEwNjAwMDAwMFowSDELMAkGA1UEBhMCVVMxFzAVBgNVBAoT
# DkRpZ2lDZXJ0LCBJbmMuMSAwHgYDVQQDExdEaWdpQ2VydCBUaW1lc3RhbXAgMjAy
# MTCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAMLmYYRnxYr1DQikRcpj
# a1HXOhFCvQp1dU2UtAxQtSYQ/h3Ib5FrDJbnGlxI70Tlv5thzRWRYlq4/2cLnGP9
# NmqB+in43Stwhd4CGPN4bbx9+cdtCT2+anaH6Yq9+IRdHnbJ5MZ2djpT0dHTWjaP
# xqPhLxs6t2HWc+xObTOKfF1FLUuxUOZBOjdWhtyTI433UCXoZObd048vV7WHIOsO
# jizVI9r0TXhG4wODMSlKXAwxikqMiMX3MFr5FK8VX2xDSQn9JiNT9o1j6BqrW7Ed
# MMKbaYK02/xWVLwfoYervnpbCiAvSwnJlaeNsvrWY4tOpXIc7p96AXP4Gdb+DUmE
# vQECAwEAAaOCAbgwggG0MA4GA1UdDwEB/wQEAwIHgDAMBgNVHRMBAf8EAjAAMBYG
# A1UdJQEB/wQMMAoGCCsGAQUFBwMIMEEGA1UdIAQ6MDgwNgYJYIZIAYb9bAcBMCkw
# JwYIKwYBBQUHAgEWG2h0dHA6Ly93d3cuZGlnaWNlcnQuY29tL0NQUzAfBgNVHSME
# GDAWgBT0tuEgHf4prtLkYaWyoiWyyBc1bjAdBgNVHQ4EFgQUNkSGjqS6sGa+vCgt
# HUQ23eNqerwwcQYDVR0fBGowaDAyoDCgLoYsaHR0cDovL2NybDMuZGlnaWNlcnQu
# Y29tL3NoYTItYXNzdXJlZC10cy5jcmwwMqAwoC6GLGh0dHA6Ly9jcmw0LmRpZ2lj
# ZXJ0LmNvbS9zaGEyLWFzc3VyZWQtdHMuY3JsMIGFBggrBgEFBQcBAQR5MHcwJAYI
# KwYBBQUHMAGGGGh0dHA6Ly9vY3NwLmRpZ2ljZXJ0LmNvbTBPBggrBgEFBQcwAoZD
# aHR0cDovL2NhY2VydHMuZGlnaWNlcnQuY29tL0RpZ2lDZXJ0U0hBMkFzc3VyZWRJ
# RFRpbWVzdGFtcGluZ0NBLmNydDANBgkqhkiG9w0BAQsFAAOCAQEASBzctemaI7zn
# GucgDo5nRv1CclF0CiNHo6uS0iXEcFm+FKDlJ4GlTRQVGQd58NEEw4bZO73+RAJm
# Te1ppA/2uHDPYuj1UUp4eTZ6J7fz51Kfk6ftQ55757TdQSKJ+4eiRgNO/PT+t2R3
# Y18jUmmDgvoaU+2QzI2hF3MN9PNlOXBL85zWenvaDLw9MtAby/Vh/HUIAHa8gQ74
# wOFcz8QRcucbZEnYIpp1FUL1LTI4gdr0YKK6tFL7XOBhJCVPst/JKahzQ1HavWPW
# H1ub9y4bTxMd90oNcX6Xt/Q/hOvB46NJofrOp79Wz7pZdmGJX36ntI5nePk2mOHL
# KNpbh6aKLzCCBTAwggQYoAMCAQICEAQJGBtf1btmdVNDtW+VUAgwDQYJKoZIhvcN
# AQELBQAwZTELMAkGA1UEBhMCVVMxFTATBgNVBAoTDERpZ2lDZXJ0IEluYzEZMBcG
# A1UECxMQd3d3LmRpZ2ljZXJ0LmNvbTEkMCIGA1UEAxMbRGlnaUNlcnQgQXNzdXJl
# ZCBJRCBSb290IENBMB4XDTEzMTAyMjEyMDAwMFoXDTI4MTAyMjEyMDAwMFowcjEL
# MAkGA1UEBhMCVVMxFTATBgNVBAoTDERpZ2lDZXJ0IEluYzEZMBcGA1UECxMQd3d3
# LmRpZ2ljZXJ0LmNvbTExMC8GA1UEAxMoRGlnaUNlcnQgU0hBMiBBc3N1cmVkIElE
# IENvZGUgU2lnbmluZyBDQTCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEB
# APjTsxx/DhGvZ3cH0wsxSRnP0PtFmbE620T1f+Wondsy13Hqdp0FLreP+pJDwKX5
# idQ3Gde2qvCchqXYJawOeSg6funRZ9PG+yknx9N7I5TkkSOWkHeC+aGEI2YSVDNQ
# dLEoJrskacLCUvIUZ4qJRdQtoaPpiCwgla4cSocI3wz14k1gGL6qxLKucDFmM3E+
# rHCiq85/6XzLkqHlOzEcz+ryCuRXu0q16XTmK/5sy350OTYNkO/ktU6kqepqCquE
# 86xnTrXE94zRICUj6whkPlKWwfIPEvTFjg/BougsUfdzvL2FsWKDc0GCB+Q4i2pz
# INAPZHM8np+mM6n9Gd8lk9ECAwEAAaOCAc0wggHJMBIGA1UdEwEB/wQIMAYBAf8C
# AQAwDgYDVR0PAQH/BAQDAgGGMBMGA1UdJQQMMAoGCCsGAQUFBwMDMHkGCCsGAQUF
# BwEBBG0wazAkBggrBgEFBQcwAYYYaHR0cDovL29jc3AuZGlnaWNlcnQuY29tMEMG
# CCsGAQUFBzAChjdodHRwOi8vY2FjZXJ0cy5kaWdpY2VydC5jb20vRGlnaUNlcnRB
# c3N1cmVkSURSb290Q0EuY3J0MIGBBgNVHR8EejB4MDqgOKA2hjRodHRwOi8vY3Js
# NC5kaWdpY2VydC5jb20vRGlnaUNlcnRBc3N1cmVkSURSb290Q0EuY3JsMDqgOKA2
# hjRodHRwOi8vY3JsMy5kaWdpY2VydC5jb20vRGlnaUNlcnRBc3N1cmVkSURSb290
# Q0EuY3JsME8GA1UdIARIMEYwOAYKYIZIAYb9bAACBDAqMCgGCCsGAQUFBwIBFhxo
# dHRwczovL3d3dy5kaWdpY2VydC5jb20vQ1BTMAoGCGCGSAGG/WwDMB0GA1UdDgQW
# BBRaxLl7KgqjpepxA8Bg+S32ZXUOWDAfBgNVHSMEGDAWgBRF66Kv9JLLgjEtUYun
# pyGd823IDzANBgkqhkiG9w0BAQsFAAOCAQEAPuwNWiSz8yLRFcgsfCUpdqgdXRwt
# OhrE7zBh134LYP3DPQ/Er4v97yrfIFU3sOH20ZJ1D1G0bqWOWuJeJIFOEKTuP3GO
# Yw4TS63XX0R58zYUBor3nEZOXP+QsRsHDpEV+7qvtVHCjSSuJMbHJyqhKSgaOnEo
# AjwukaPAJRHinBRHoXpoaK+bp1wgXNlxsQyPu6j4xRJon89Ay0BEpRPw5mQMJQhC
# MrI2iiQC/i9yfhzXSUWW6Fkd6fp0ZGuy62ZD2rOwjNXpDd32ASDOmTFjPQgaGLOB
# m0/GkxAG/AeB+ova+YJJ92JuoVP6EpQYhS6SkepobEQysmah5xikmmRR7zCCBTEw
# ggQZoAMCAQICEAqhJdbWMht+QeQF2jaXwhUwDQYJKoZIhvcNAQELBQAwZTELMAkG
# A1UEBhMCVVMxFTATBgNVBAoTDERpZ2lDZXJ0IEluYzEZMBcGA1UECxMQd3d3LmRp
# Z2ljZXJ0LmNvbTEkMCIGA1UEAxMbRGlnaUNlcnQgQXNzdXJlZCBJRCBSb290IENB
# MB4XDTE2MDEwNzEyMDAwMFoXDTMxMDEwNzEyMDAwMFowcjELMAkGA1UEBhMCVVMx
# FTATBgNVBAoTDERpZ2lDZXJ0IEluYzEZMBcGA1UECxMQd3d3LmRpZ2ljZXJ0LmNv
# bTExMC8GA1UEAxMoRGlnaUNlcnQgU0hBMiBBc3N1cmVkIElEIFRpbWVzdGFtcGlu
# ZyBDQTCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAL3QMu5LzY9/3am6
# gpnFOVQoV7YjSsQOB0UzURB90Pl9TWh+57ag9I2ziOSXv2MhkJi/E7xX08PhfgjW
# ahQAOPcuHjvuzKb2Mln+X2U/4Jvr40ZHBhpVfgsnfsCi9aDg3iI/Dv9+lfvzo7oi
# PhisEeTwmQNtO4V8CdPuXciaC1TjqAlxa+DPIhAPdc9xck4Krd9AOly3UeGheRTG
# TSQjMF287DxgaqwvB8z98OpH2YhQXv1mblZhJymJhFHmgudGUP2UKiyn5HU+upgP
# hH+fMRTWrdXyZMt7HgXQhBlyF/EXBu89zdZN7wZC/aJTKk+FHcQdPK/P2qwQ9d2s
# rOlW/5MCAwEAAaOCAc4wggHKMB0GA1UdDgQWBBT0tuEgHf4prtLkYaWyoiWyyBc1
# bjAfBgNVHSMEGDAWgBRF66Kv9JLLgjEtUYunpyGd823IDzASBgNVHRMBAf8ECDAG
# AQH/AgEAMA4GA1UdDwEB/wQEAwIBhjATBgNVHSUEDDAKBggrBgEFBQcDCDB5Bggr
# BgEFBQcBAQRtMGswJAYIKwYBBQUHMAGGGGh0dHA6Ly9vY3NwLmRpZ2ljZXJ0LmNv
# bTBDBggrBgEFBQcwAoY3aHR0cDovL2NhY2VydHMuZGlnaWNlcnQuY29tL0RpZ2lD
# ZXJ0QXNzdXJlZElEUm9vdENBLmNydDCBgQYDVR0fBHoweDA6oDigNoY0aHR0cDov
# L2NybDQuZGlnaWNlcnQuY29tL0RpZ2lDZXJ0QXNzdXJlZElEUm9vdENBLmNybDA6
# oDigNoY0aHR0cDovL2NybDMuZGlnaWNlcnQuY29tL0RpZ2lDZXJ0QXNzdXJlZElE
# Um9vdENBLmNybDBQBgNVHSAESTBHMDgGCmCGSAGG/WwAAgQwKjAoBggrBgEFBQcC
# ARYcaHR0cHM6Ly93d3cuZGlnaWNlcnQuY29tL0NQUzALBglghkgBhv1sBwEwDQYJ
# KoZIhvcNAQELBQADggEBAHGVEulRh1Zpze/d2nyqY3qzeM8GN0CE70uEv8rPAwL9
# xafDDiBCLK938ysfDCFaKrcFNB1qrpn4J6JmvwmqYN92pDqTD/iy0dh8GWLoXoIl
# HsS6HHssIeLWWywUNUMEaLLbdQLgcseY1jxk5R9IEBhfiThhTWJGJIdjjJFSLK8p
# ieV4H9YLFKWA1xJHcLN11ZOFk362kmf7U2GJqPVrlsD0WGkNfMgBsbkodbeZY4Ui
# jGHKeZR+WfyMD+NvtQEmtmyl7odRIeRYYJu6DC0rbaLEfrvEJStHAgh8Sa4TtuF8
# QkIoxhhWz0E0tmZdtnR79VYzIi8iNrJLokqV2PWmjlIwggUyMIIEGqADAgECAhAB
# Pe4iVgqMX6vbiX1xPVYPMA0GCSqGSIb3DQEBCwUAMHIxCzAJBgNVBAYTAlVTMRUw
# EwYDVQQKEwxEaWdpQ2VydCBJbmMxGTAXBgNVBAsTEHd3dy5kaWdpY2VydC5jb20x
# MTAvBgNVBAMTKERpZ2lDZXJ0IFNIQTIgQXNzdXJlZCBJRCBDb2RlIFNpZ25pbmcg
# Q0EwHhcNMTgwNjExMDAwMDAwWhcNMjEwODIxMTIwMDAwWjBvMQswCQYDVQQGEwJH
# QjEQMA4GA1UEBxMHTmV3YnVyeTEmMCQGA1UEChMdTWljcm8gRm9jdXMgSW50ZXJu
# YXRpb25hbCBwbGMxJjAkBgNVBAMTHU1pY3JvIEZvY3VzIEludGVybmF0aW9uYWwg
# cGxjMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA2Vb7QjccsV83UO3b
# YCw/nTB6Bl3tGX0eSCCPsBtPTspWKz2GXWK7/1KeDUNPLnNBT1InLwNcaDxiX1TG
# SC5+gBfJiaTWB03ll7FpDbayyQ532smNvlQop2v5rgDkXQLu4Jg1JE3OLrppxBfP
# tBsjHw76kCqePA8cvTMWxUc6b7loX26dQe8v7+SeOI0qZ0tXCNwtgTu2513frUxj
# d/fY2F/toc9OjateJZQ5v5+WV7dOG/89bkvMAEHXegLcPZw7PT4aZP/ZVOYtoflS
# g6oT0m0N1LdsjyTEDbqmRm6/dt5sI9akmdln7hpOp1y9EMCgkGiNAwf9u4Lw2iUj
# NvoT5QIDAQABo4IBxTCCAcEwHwYDVR0jBBgwFoAUWsS5eyoKo6XqcQPAYPkt9mV1
# DlgwHQYDVR0OBBYEFLyS6yL4fTRV+hftOctsNinkVorLMA4GA1UdDwEB/wQEAwIH
# gDATBgNVHSUEDDAKBggrBgEFBQcDAzB3BgNVHR8EcDBuMDWgM6Axhi9odHRwOi8v
# Y3JsMy5kaWdpY2VydC5jb20vc2hhMi1hc3N1cmVkLWNzLWcxLmNybDA1oDOgMYYv
# aHR0cDovL2NybDQuZGlnaWNlcnQuY29tL3NoYTItYXNzdXJlZC1jcy1nMS5jcmww
# TAYDVR0gBEUwQzA3BglghkgBhv1sAwEwKjAoBggrBgEFBQcCARYcaHR0cHM6Ly93
# d3cuZGlnaWNlcnQuY29tL0NQUzAIBgZngQwBBAEwgYQGCCsGAQUFBwEBBHgwdjAk
# BggrBgEFBQcwAYYYaHR0cDovL29jc3AuZGlnaWNlcnQuY29tME4GCCsGAQUFBzAC
# hkJodHRwOi8vY2FjZXJ0cy5kaWdpY2VydC5jb20vRGlnaUNlcnRTSEEyQXNzdXJl
# ZElEQ29kZVNpZ25pbmdDQS5jcnQwDAYDVR0TAQH/BAIwADANBgkqhkiG9w0BAQsF
# AAOCAQEAZllSiMymdGRhqGhTP8p8Xdjmu1IZu6wg09n7oKLaH7qg3TfjqX+jjaQ2
# CTTyr2cwblYPa1Dp2sOqjGUNyrUvg22cfaSJAtbTNkpb8VtU8nEMjc3IaTdAw0hM
# +qHgYUaX1he6HrP8x51xJW67Z+Q6junwCPjo4fhEonJ4D9PBqQpRzpHtHy3D9rI6
# sgTSX3uWHqUet4Ehq49dSb2GZB8qAweUeM8ntCsEe2Trrei+HbrWn2F6DjpFCRA8
# VjhNvIsqOyltdsGT1HOGHz3hIi2G1Xr/T43sBmeqndopqavoj9GZsUMVp6RPRohn
# yGDTxINU2+Cs981b0UUjO5BQkkQfrzGCBG0wggRpAgEBMIGGMHIxCzAJBgNVBAYT
# AlVTMRUwEwYDVQQKEwxEaWdpQ2VydCBJbmMxGTAXBgNVBAsTEHd3dy5kaWdpY2Vy
# dC5jb20xMTAvBgNVBAMTKERpZ2lDZXJ0IFNIQTIgQXNzdXJlZCBJRCBDb2RlIFNp
# Z25pbmcgQ0ECEAE97iJWCoxfq9uJfXE9Vg8wDQYJYIZIAWUDBAIBBQCggYQwGAYK
# KwYBBAGCNwIBDDEKMAigAoAAoQKAADAZBgkqhkiG9w0BCQMxDAYKKwYBBAGCNwIB
# BDAcBgorBgEEAYI3AgELMQ4wDAYKKwYBBAGCNwIBFTAvBgkqhkiG9w0BCQQxIgQg
# mkMJ+dTTXNAXSPTbLGUG/8eGMMWQkKGLRai+c6uXdUcwDQYJKoZIhvcNAQEBBQAE
# ggEAUfM9ZLVYeLAu3twfCZutwB5berj1mZRDCVoHv478JkTDTRLLSuczjmNoQx0R
# /vE9Xmnpdn36BQkiHUUHSRqE1z81YRkESK+UwWfCGflxA3EnGg4d3uSsL6LWQw76
# ngShmXMM5FBt0vbKhcQLc6zr3yFbmevmRFOGOiZoSeAB5UlBtiBjVgkm7ScAeRQY
# 89MwWTUR9VhE1oc/eVXsnDxYAFvs1nQNkcCkL5XZxviPAyR+kGhM6EYzdTI/qqn6
# /gg09UAI9P6pkPaO7rJvJx0mT9gXNhVn6BFL3IQ44OvNdG/X3fPq8mVV+FtbasZ1
# fPFefRZ4LM3DzwhdlHg66XmAUaGCAjAwggIsBgkqhkiG9w0BCQYxggIdMIICGQIB
# ATCBhjByMQswCQYDVQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYD
# VQQLExB3d3cuZGlnaWNlcnQuY29tMTEwLwYDVQQDEyhEaWdpQ2VydCBTSEEyIEFz
# c3VyZWQgSUQgVGltZXN0YW1waW5nIENBAhANQkrgvjqI/2BAIc4UAPDdMA0GCWCG
# SAFlAwQCAQUAoGkwGAYJKoZIhvcNAQkDMQsGCSqGSIb3DQEHATAcBgkqhkiG9w0B
# CQUxDxcNMjEwMzAyMTgxMjUxWjAvBgkqhkiG9w0BCQQxIgQgmJGTAJ2uxWLUkvmS
# 5+Dv/FoGsEL0yy7SdCffpyU4uLcwDQYJKoZIhvcNAQEBBQAEggEAqvRoH6XMf6OL
# 5dIaMnoCJxCiqbM04woWZVV8NeDHza5Exp0Cc3KBAxqLRK26ARYD9/CMAA2xbBJf
# wPXxb2h2d+uBElh9B0hJ4e1MhNlrvvknMguqoZDIVK2dB0S0N7GXPRBvi4Gu5wwv
# rDZWBfjhMvhgKADrg020pKbM3qySVBu7xIvUWEv8OJGQub0vDg0U6uzdkI39RTWo
# uKS+YjGccKvpG6D+VSo2Em9mAu4yA+YKAV1shzpHpxCB880CWTqFYgNmbptrILjD
# eF4GygKZMp9YK+pN+kMHEgRKkD9IqnBPEsQhdqum/03SR/iGIvJ4zLtYwT8L1MTF
# j7L4SU4y5w==
# SIG # End signature block
